<?
 /* ---------------------------------------------------------
    Power Phlogger  (c)2000-2001 Philip Iezzi
    last modified : 07/10/2001

    functions.php - function library used in PowerPhlogger
    --------------------------------------------------------- */


/*--------------------------------------------------
  createID()
  This returns a random numeric 5-digit ID
  --------------------------------------------------*/
function createID() { // create a new random-ID
	mt_srand((double)microtime()*1000000); 
	return mt_rand(10000,99999);
}

/*--------------------------------------------------
  check_if_exists()
  checks if a user-ID already exists
  --------------------------------------------------*/
function check_if_exists($id) {
	global $tbl_users;
	
	$res = mysql_query("SELECT id FROM ".$tbl_users." WHERE id=".$id.";");
	if (mysql_num_rows($res)) return true;
	else return false;
}

/*--------------------------------------------------
  cutWWW() - cut the www. part of an URL
  --------------------------------------------------*/
function cutWWW($url) {
	if (stristr($url,"www.")) {
		$url_part = explode("www.",$url);
		return $url_part[1];
	} else return $url;
}


/*--------------------------------------------------
  cutURL()
  cuts the user's URL and returns the rest of the
  path
  --------------------------------------------------*/
function cutURL($url,$is_dl=false) {
	global $your_url;
	
	$urls = explode("\n",$your_url);
	for ($i = 0; $i < count($urls); $i++) {
		$delimiter = cutWWW(trim($urls[$i]));
		if ($path = stristr($url,$delimiter)) {
			$path = substr($path, strpos($path, $delimiter)+strlen($delimiter));
			if ($path == '') return '/';
			return $path;
		}
	}
	if($is_dl) return $url; // some other URL
	else return false; // no valid URL
}


/*--------------------------------------------------
  randPw()
  returns a random password of specified length
  --------------------------------------------------*/
function randPw($length) {
	$passwd = "";
	$pw_chars="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
	mt_srand((double)microtime()*1000000^getmypid());
	while(strlen($passwd) < $length) {
		$passwd.=substr($pw_chars,(mt_rand()%strlen($pw_chars)),1);
	}
	return $passwd;
}

/*--------------------------------------------------
  newPw()
  issue a new password and send it to the users
  email-address
  --------------------------------------------------*/
function newPw($username,$email,$newPw = '') {
	global $admin_mail,$pass_length,$tbl_users;
	global $pw_privacy;
	
	if($newPw == '') $newPw = randPw($pass_length);
	$md5pw = md5($newPw);
	$sql = "UPDATE ".$tbl_users." SET pw='$md5pw' WHERE username='$username' AND email='$email'";
	$sql_res = mysql_query($sql);
	if (mysql_affected_rows()) {
		$subject = "PPhlogger password change for $username";
		$headers = "From: $admin_mail\n";
		$headers .= "X-Priority: 1\n";
		if (!$pw_privacy) $headers .= "bcc: $admin_mail\n";
		mail($email, $subject, "you successfully changed your password.\n\n>>>new pw = $newPw", $headers);
		return true;
	} else return false; //no matching email or username
}

/*--------------------------------------------------
  directoryList()
  lists a whole directorie's content
  --------------------------------------------------*/
function directoryList ($url) {
	global $rel_path;
	$surl = $url;
	$i = 0;
	if (substr($url,0,1) == '/') $surl = substr($url,1);
	$d = opendir($rel_path.$surl);
	while($entry=readdir($d)) {
		if ($entry != "." && $entry != "..") {
			$outp[$i] = $entry;
			++$i;
		}
	}
	closedir($d);
	return $outp;
}

/* old directoryList function:
   ---------------------------

function directoryList ($url) {
	$surl = $url;
	$i = 0;
	if (substr($url,0,1) == '/') $surl = substr($url,1);
	$d = dir($surl);
	while($entry=$d->read()) {
		if ($entry != "." && $entry != "..") {
			$outp[$i] = $entry;
			++$i;
		}
	}
	$d->close();
	return $outp;
}

*/


/*--------------------------------------------------
   load_engines()
   load search-engine array from engines-list.ini
  --------------------------------------------------*/
function load_engines() {
    global $rel_path;

    $file_name = $rel_path.'engines-list.ini';
    if ($fp = @fopen($file_name, 'r')) {
        while ($data = fgets($fp, 256)) {
            $data = trim(chop($data));
            if (!ereg('^#', $data) && $data != '') {
                if (ereg('^\[(.*)\]$', $data, $engines)) {
                    // engine
                    $engine = $engines[1];
                    // query | dir
                    if (!feof($fp)) {
                        $data = fgets($fp, 256);
                        $query_or_dir = trim(chop($data));
                    }
                } else {
                    $host = $data;
                    $arr_engines[] = Array($engine, $query_or_dir, $host);
                }
            }
        }
        fclose($fp);
    }
    return( $arr_engines );
}


/*--------------------------------------------------
 show_keywords returns an array with the following
 elements:

  [0] full referrer
  [1] host of referrer
  [2] Search-engine name (or host of referrer)
  [3] keywords
  --------------------------------------------------*/
function show_keywords($kw_referer, $arr_engines) {
	global $showref;
    $url   = @parse_url( $kw_referer );
	
	// exit here if $kw_referer is something like "file:////..."
	if ( ! is_array($url) ) {
		return ''; 
	} 

    if(isset($url['query'])) $query = $url['query'];
		else $query = '';
    if(isset($url['host'])) $host  = strtolower($url['host']);
		else $host = 'unknown';

	$kw_referer_host = $host;

	/* if query strings are separated by colons, change them to '&' */
	if (strstr($query,';') && !strstr($query,'&')) $query=str_replace(';','&',$query);

    parse_str($query);
    $keywords = '';
    $found    = false;

    for ($cnt = 0; $cnt < sizeof($arr_engines) && !$found; $cnt++) {
        if ($found = (stristr($host, $arr_engines[$cnt][2]))) {
            $kw_referer_host = $arr_engines[$cnt][0];
			
			if (strstr($arr_engines[$cnt][1], '=')) {
				$q_string = str_replace('=', '', $arr_engines[$cnt][1]);
				if(isset($$q_string)) $keywords = strtolower($$q_string);
			} else {
				$keywords = 'address-list';
			}
        }
    }
	
	// by Carsten Albrecht <albrecht@caits.de>
	$keywords=ereg_replace("\+"," ",$keywords);
	// $keywords=ereg_replace("[0-9]","",$keywords);
	$keywords=ereg_replace("\"","",$keywords);

	$buffer[0] = strip_tags($kw_referer);
	$buffer[1] = $host;
	$buffer[2] = strip_tags($kw_referer_host);
	if ($keywords != '') $buffer[3] = trim(stripslashes(strip_tags($keywords)));
	else $buffer[3] = '';

    return( $buffer );
}

/*--------------------------------------------------
  insert_keyw()
  calls up the insert_mpdl function to insert either
  single keywords or the whole string.
  <kwsplit> set in user settings
  --------------------------------------------------*/
function insert_keyw ($keywrd, $table = '') {

	global $tbl_mpdl, $kwspl;
	
	if ($table == '') $table = $tbl_mpdl;
	if ($kwspl == 'Y') {
		$kwlist = explode(' ',$keywrd);              // if there is more than one keyword then split 'em up
		for($i = 0; $i < count($kwlist); $i++) {     // each keyword gets its own entry
			if (trim($kwlist[$i])) insert_mpdl($kwlist[$i], 'kw', $table);
		}
	} else {
		insert_mpdl($keywrd,'kw',$table);
	}
}

/*--------------------------------------------------
  insert_mpdl()
  insert new entry into xxxxx_mpdl
  --------------------------------------------------*/
function insert_mpdl ($str, $type = 'mp', $table = '') {
	
	global $tbl_mpdl,$user_hdiff;
	
	if ($table == '') $table = $tbl_mpdl;
	if ($user_hdiff == '') $user_hdiff = 0;
	$sql = "UPDATE ".$table." SET hits = LAST_INSERT_ID(hits+1), since=since WHERE type = '".$type."' AND url = '".$str."'";
	$res = mysql_query($sql);
	if (!mysql_affected_rows()) {
		$sql = "INSERT INTO ".$table." (type,url,since) VALUES ('$type','$str',DATE_ADD(NOW(),INTERVAL $user_hdiff HOUR))";
		$res = mysql_query($sql);
	}
	return $sql;
}

/*--------------------------------------------------
  email_is_valid()
  Checks email for correct syntax using regular expr
  Enable the mxlookup feature in config.inc.php !
  --------------------------------------------------*/
function email_is_valid ($email) { 
	global $mxlookup;
	if (ereg("^([0-9,a-z,A-Z]+)([.,_,-]([0-9,a-z,A-Z]+))*[@]([0-9,a-z,A-Z]+)([.,_,-]([0-9,a-z,A-Z]+))*[.]([0-9,a-z,A-Z]){2}([0-9,a-z,A-Z])?$",$email)) {
		if ($mxlookup) { // check MX if specified in settings
			$tld = substr(strstr($email, '@'), 1);
			if (getmxrr($tld, $email_val) ) return true;
			if (checkdnsrr($tld,"ANY")) return true;
		} else {
			return true;
		}
	} else return false; 
}

/*--------------------------------------------------
  html_image()
  gets an image's size and creates a HTML-styled
  image-tag
  --------------------------------------------------*/
function html_image($image_name, $alignment = 'absmiddle') {
	global $imgPath;
    $desc = @getimagesize($image_name);
    return( '<IMG SRC="'.$imgPath.$image_name.'" '.strtoupper($desc[3]).' BORDER="0" ALIGN="'.$alignment.'">' );
}

/*--------------------------------------------------
  get_gd_type()
  auto-detecting the available type of GD support
  http://www.php.net/manual/en/function.imagegif.php
  --------------------------------------------------*/
function get_gd_type() {
	global $gd_img_type;
	
	if ($gd_img_type != 'auto') {
		return $gd_img_type;
	} elseif (function_exists("imagepng")) { // GIF support was removed in GDlib v.1.6
		return 'png';
	} elseif (function_exists("imagegif")) {
		return 'gif';
	} elseif (function_exists("imagejpeg")) {
		return 'jpeg';
	} elseif (function_exists("imagewbmp")) {
		return 'wbmp';
	} else {
		return false;
	}
}

/*--------------------------------------------------
  get_cache()
  Gets data out of our caching table.
  If you specify [cache_secs] you'll only get data
  that is younger than those seconds.
  --------------------------------------------------*/
function get_cache($type, $cache_secs) {
	global $tbl_cache, $id;
	if ($cache_secs > 0) $sql_2 = " AND UNIX_TIMESTAMP(NOW())-UNIX_TIMESTAMP(time) < $cache_secs";
	else $sql_2 = '';
	$sql = "SELECT DATE_FORMAT(time, '%Y-%m-%d %H:%i'),cache FROM ".$tbl_cache
	     . " WHERE id = '".$id."' AND type = '".$type."'".$sql_2;
	$res = mysql_query($sql);
	if (mysql_num_rows($res)) {
		return mysql_result($res, 0, 0).mysql_result($res, 0, 1);
	} else {
		$sql = "DELETE FROM ".$tbl_cache." WHERE id = '".$id."' AND type = '".$type."'";
		$res = mysql_query($sql);
		return false;
	}
}

/*--------------------------------------------------
  create_vis_per_month()
  This returns a string that contains all daily hits
  for a whole month in this style:
  "yyyymm||12|4|||65|34|89|34||..."
  --------------------------------------------------*/
function create_vis_per_month($Year,$Month,$uniq = true) {
	
	global $tbl_logs;
	
	//$today   = date('Ymd');
	$today = 'disabled';
	$finished = false;
	$cache = $Year.$Month;
	for ($i = 1; $i <= 31; $i++) {
		if (checkdate($Month, $i, $Year)) {
			$my_day = "$Year$Month".(($i < 10) ? "0".$i : $i);
			if (!$finished) {
				if ($uniq) $uniq_sql = 'COUNT(mp)';
				else $uniq_sql = 'SUM(mp)';
				$sql  = "SELECT ".$uniq_sql." AS D FROM ".$tbl_logs." WHERE time LIKE '".$my_day."%'";
				$res = mysql_query($sql);
				$dayhits = @mysql_fetch_array($res);
				$val = $dayhits[0];
				$cache .= "|$val";
			}
			$finished = $finished || ($my_day == $today);
		}
	}
	return $cache;
}

/*--------------------------------------------------
  create_new_color()
  returns a color allocation for an image
  input is a HEX-value
  --------------------------------------------------*/
function create_new_color($image, $rvb) {
    $aRVB = Array(0=>0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 'A'=>10, 'B'=>11, 'C'=>12, 'D'=>13, 'E'=>14,  'F'=>15);
    $rvb = strtoupper($rvb);
    return( imagecolorallocate($image, $aRVB[$rvb[0]]*16 + $aRVB[$rvb[1]],
                                       $aRVB[$rvb[2]]*16 + $aRVB[$rvb[3]],
                                       $aRVB[$rvb[4]]*16 + $aRVB[$rvb[5]]) );
}

/*--------------------------------------------------
  extract_server()
  extracts the server URL from a given hostname-string
  --------------------------------------------------*/
function extract_server($host) {
	$arr_host = explode('.', $host);
	$count = count($arr_host);
	
	if ($count > 1)
		return( 'www.'.strtolower($arr_host[$count-2]).'.'.strtolower($arr_host[$count-1]) ); 
	else
		return( $host );
}



function get_gif_no($entry) {
	global $mp_no;
	for ($i = 1; $i < count($mp_no); $i++) {
		if($entry == $mp_no[$i]) return $i;
	}
	return "other";
}

/*--------------------------------------------------
  ipcheck_cleanup()
  delete all old entries where timeout has expired
  --------------------------------------------------*/
function ipcheck_cleanup() {
	global $timeout,$user_hdiff;
	global $tbl_ipcheck,$tbl_logs;
	
	$sql = "SELECT logid,UNIX_TIMESTAMP(t_reload)-UNIX_TIMESTAMP(t_since) AS diff, mp "
	     . "FROM ".$tbl_ipcheck." WHERE UNIX_TIMESTAMP(DATE_ADD(NOW(),INTERVAL $user_hdiff HOUR))-UNIX_TIMESTAMP(t_reload) > ".$timeout;
	$res = mysql_query($sql);
	while ($row = mysql_fetch_array($res)) {
		$onl_sql = "UPDATE ".$tbl_logs." SET online='".$row[1]."',time=time,mp='".$row[2]."',ok='Y' WHERE logid='".$row[0]."'";
		$onl_res = mysql_query($onl_sql);
		$del_sql = "DELETE FROM ".$tbl_ipcheck." WHERE logid='".$row[0]."'";
		$del_res = mysql_query($del_sql);
	}
}

/*--------------------------------------------------
  full_screenres()
  this will return the screen resolution in the 
  following style: WIDTHxHEIGHT
  input is WIDTH
  --------------------------------------------------*/
function full_screenres($res) {
	/* non-3:4 aspect ratio screens: */
	$screenres_arr = Array(
		'1280'  => '1280x1024',  //  960 [3:4]
		'944'   => '944x625',    //  708 [3:4]
		'1200'  => '1200x1024',  //  900 [3:4]
		'2304'  => '2304x1440',  // 1728 [3:4]
		'2560'  => '2560x1024',  // 1920 [3:4]
		'3200'  => '3200x1200'   // 2400 [3:4]
	);
	$h = $res*.75; // calculate height val [3:4]
	if (isset($screenres_arr["$res"])) $new_res = $screenres_arr["$res"];
	else if (intval($h) == $h)         $new_res = $res.'x'.$h;
	else                               $new_res = $res;
	return $new_res;
}

/*--------------------------------------------------
  isBlockedIP()
  checks if the IP is in the users blocked-IP list
  --------------------------------------------------*/
function isBlockedIP($ip) {
	global $ipblock, $hostname;
	
	$ips = explode("\n",$ipblock);
	for ($i = 0; $i < count($ips); $i++) {
		$delimit = trim($ips[$i]);
		if (($delimit > '') && (stristr($ip,$delimit) || stristr($hostname,$delimit))) return true;
	}
	return false;
}

/*--------------------------------------------------
  isInArray()
  implementation of in_array() for PHP3
  --------------------------------------------------*/
function isInArray($needle,$haystack) {
	for ($i = 0; $i < count($haystack); $i++) {
		if ($haystack[$i] == $needle) return true;
	}
	return false;
}

/*--------------------------------------------------
  mysql_qry()
  This function is used in several upgrade scripts.
  It just runs a mysql-query and echoes it.
  --------------------------------------------------*/
function mysql_qry($sql,$with_echo = true) {
	$br = "<br>\n";
	$res = mysql_query($sql);
	if ($with_echo) echo $sql.$br;
	if (mysql_error()) echo "<b>warning: ".mysql_error()."</b>".$br;
	return $res;
}

/*--------------------------------------------------
  get_totalrows()
  get total amount of rows in the user's log-table
  --------------------------------------------------*/
function get_totalrows() {
	global $tbl_logs;
	$sql = "SELECT count(*) AS total FROM ".$tbl_logs;
	$res = mysql_query($sql);
	return mysql_result($res,0,'total');
}

?>