<?
 /* ---------------------------------------------------------------
    YABD 0.2 - Yet Another Browser Detector
	***************************************
    (c)2001 Philip Iezzi <philippo@iezzi.ch>, http://www.iezzi.ch
    
    last modified : 06/17/2001
    function extract_agent returns browser, version, and system
    in an array. If there is no matching browser return the original
    string instead of an array.
    
    ---------------------------------------------------------------
    ported from StatIt 2.3d by Helge Orthmann [www.otterware.de]
    added some more browsers/systems.
    --------------------------------------------------------------- */

    $arr_brows = Array (
      'IE'   => 'Internet Explorer',
      'NS'   => 'Netscape',
      'OP'   => 'Opera',
      'KONQ' => 'Konqueror',
      'OMNI' => 'OmniWeb',
      'LX'   => 'Lynx'
    );

    $arr_sys = Array (
      'Win'       => 'Windows',
      'Win2000'   => 'Windows 2000',
      'WinXP'     => 'Windows XP',
      'WinNT'     => 'Windows NT',
      'WinNT4.0'  => 'Windows NT4',
      'Mac'       => 'Mac OS'
    );

// extract agent from $HTTP_USER_AGENT ($agt)
function extract_agent($AGT) {
	$st_sys = '';
	$st_ver = '';
	$st_sysver = '';

	/* Browser detection */
	if     (eregi("(opera) ([0-9]{1,2}.[0-9]{1,3}){0,1}",$AGT,$st_regs) ||
	        eregi("(opera/)([0-9]{1,2}.[0-9]{1,3}){0,1}",$AGT,$st_regs))       {$st_brows = "OP";      $st_ver = $st_regs[2];}
	else if(eregi("(konqueror)/([0-9]{1,2}.[0-9]{1,3})",$AGT,$st_regs))        {$st_brows = "KONQ";    $st_ver = $st_regs[2]; $st_sys = "Linux";}
	else if(eregi("(lynx)/([0-9]{1,2}.[0-9]{1,2}.[0-9]{1,2})",$AGT,$st_regs) ) {$st_brows = "Lynx";    $st_ver = $st_regs[2];}
	else if(eregi("(links) \(([0-9]{1,2}.[0-9]{1,3})",$AGT,$st_regs))          {$st_brows = "Links";   $st_ver = $st_regs[2];}
	else if(eregi("(omniweb/)([0-9]{1,2}.[0-9]{1,3})",$AGT,$st_regs))          {$st_brows = "OmniWeb"; $st_ver = $st_regs[2];}
	else if(eregi("(webtv/)([0-9]{1,2}.[0-9]{1,3})",$AGT,$st_regs))            {$st_brows = "WebTV";   $st_ver = $st_regs[2];}
	else if(eregi("(msie) ([0-9]{1,2}.[0-9]{1,3})",$AGT,$st_regs))             {$st_brows = "IE";      $st_ver = $st_regs[2];}
	else if(eregi("(netscape6)/(6.[0-9]{1,3})",$AGT,$st_regs))                 {$st_brows = "NS";      $st_ver = $st_regs[2];}
	else if(eregi("mozilla/5",$AGT))                                           {$st_brows = "NS";      $st_ver = '6';        }
	else if(eregi("(mozilla)/([0-9]{1,2}.[0-9]{1,3})",$AGT,$st_regs))          {$st_brows = "NS";      $st_ver = $st_regs[2];}
	else if(eregi("w3m",$AGT))                                                 {$st_brows = "w3m";                           }
	else if(eregi("(scooter)-([0-9]{1,2}.[0-9]{1,3})",$AGT,$st_regs))          {$st_brows = "Scooter"; $st_ver = $st_regs[2];}
	else if(eregi("(w3c_validator)/([0-9]{1,2}.[0-9]{1,3})",$AGT,$st_regs))    {$st_brows = "W3C";     $st_ver = $st_regs[2];}
	else if(eregi("(googlebot)/([0-9]{1,2}.[0-9]{1,3})",$AGT,$st_regs))        {$st_brows = "Google";  $st_ver = $st_regs[2];}
	else {$st_brows = ""; $st_ver = "";}


	/* System detection */
	if     (eregi("linux",$AGT))                                                     {$st_sys = "Linux";}
	else if(eregi("Win 9x 4.90",$AGT))                                               {$st_sys = "WinMe";}
	else if(eregi("win32",$AGT))                                                     {$st_sys = "Win";}
	else if(eregi("windows 2000",$AGT))                                              {$st_sys = "Win2000";}
	else if((eregi("(win)([0-9]{2})",$AGT,$st_regs)) || 
	        (eregi("(windows) ([0-9]{2})",$AGT,$st_regs)))                           {$st_sys = "Win".$st_regs[2];}
	else if(eregi("(windows nt)( ){0,1}(5.0)",$AGT,$st_regs))                        {$st_sys = "Win2000";}
	else if(eregi("(windows nt)( ){0,1}(5.1)",$AGT,$st_regs))                        {$st_sys = "WinXP";}
	else if(eregi("(winnt)([0-9]{1,2}.[0-9]{1,2}){0,1}",$AGT,$st_regs))              {$st_sys = "WinNT".$st_regs[2];}
	else if(eregi("(windows nt)( ){0,1}([0-9]{1,2}.[0-9]{1,2}){0,1}",$AGT,$st_regs)) {$st_sys = "WinNT".$st_regs[3];}
	else if(eregi("PPC",$AGT) || eregi("Mac_PowerPC",$AGT))                          {$st_sys = "MacPPC";}
	else if(eregi("mac",$AGT))                                                       {$st_sys = "Mac";}
	else if(eregi("(sunos) ([0-9]{1,2}.[0-9]{1,2}){0,1}",$AGT,$st_regs))             {$st_sys = "SunOS"; $st_sysver = $st_regs[2];}
	else if(eregi("(beos) r([0-9]{1,2}.[0-9]{1,2}){0,1}",$AGT,$st_regs))             {$st_sys = "BeOS"; $st_sysver = $st_regs[2];}
	else if(eregi("freebsd",$AGT))                                                   {$st_sys = "FreeBSD";}
	else if(eregi("openbsd",$AGT))                                                   {$st_sys = "OpenBSD";}
	else if(eregi("irix",$AGT))                                                      {$st_sys = "IRIX";}
	else if(eregi("os/2",$AGT))                                                      {$st_sys = "OS/2";}
	else if(eregi("plan9",$AGT))                                                     {$st_sys = "Plan9";}
	else if(eregi("unix",$AGT) || eregi("hp-ux",$AGT) )                              {$st_sys = "Unix";}
	else if(eregi("osf",$AGT))                                                       {$st_sys = "OSF";}
	else if(eregi("X11",$AGT) && !isset($st_sys))                                    {$st_sys = "Unix";}

	if ($st_brows != '' || $st_sys != '') {
		$new_agt[0] = $st_brows; // browser
		$new_agt[1] = $st_ver;   // version
		$new_agt[2] = $st_sys;   // system
	} else {
		$new_agt    = $AGT;
	}
	
	return($new_agt);
}
?>
