<?

if(!defined("_STDLIB")):

define("_STDLIB",TRUE); 

if (!isset($DEBUG)) { $DEBUG = false; }

function debug($strdebug) {
// print debug info if DEBUG is TRUE
	global $DEBUG;
	
	if($DEBUG)
		echo $strdebug."<br>";
}
	

function setdefault(&$var, $default="") {
/* if $var is undefined, set it to $default.  otherwise leave it alone */

        if (! isset($var)) {
                $var = $default;
        }
}

function nvl(&$var, $default="") {
/* if $var is undefined, return $default, otherwise return $var */

        return isset($var) ? $var : $default;
}

function ov(&$var) {
/* returns $var with the HTML characters (like "<", ">", etc.) properly quoted,
 * or if $var is undefined, will return an empty string.  note this function
 * must be called with a variable, for normal strings or functions use o() */

        return isset($var) ? htmlSpecialChars(stripslashes($var)) : "";
}

function pv(&$var) {
/* prints $var with the HTML characters (like "<", ">", etc.) properly quoted,
 * or if $var is undefined, will print an empty string.  note this function
 * must be called with a variable, for normal strings or functions use p() */

        echo isset($var) ? nl2br(htmlSpecialChars(stripslashes($var))) : "";
}

function o($var) {
/* returns $var with HTML characters (like "<", ">", etc.) properly quoted,
 * or if $var is empty, will return an empty string. */

        return empty($var) ? "" : htmlSpecialChars(stripslashes($var));
}

function p($var) {
/* prints $var with HTML characters (like "<", ">", etc.) properly quoted,
 * or if $var is empty, will print an empty string. */

        echo empty($var) ? "" : htmlSpecialChars(stripslashes($var));
}

function db_query_loop($query, $prefix, $suffix, $found_str, $default="") {
/* this is an internal function and normally isn't called by the user.  it
 * loops through the results of a select query $query and prints HTML
 * around it, for use by things like listboxes and radio selections
 *
 * NOTE: this function uses dblib.php */

        $output = "";
        $result = db_query($query);
        while (list($val, $label) = db_fetch_row($result)) {
                if (is_array($default))
                        $selected = empty($default[$val]) ? "" : $found_str;
                else
                        $selected = $val == $default ? $found_str : "";

                $output .= "$prefix value='$val'$selected>$label$suffix";
        }

        return $output;
}

function limit_text($text , $maxlength , $end="...")
{
// function from emmanuel vanneau (phpMyAgenda)
// $Id: dblib.php3, v2.0 2001/01/06 
// return first "maxlength" characters of "text". Add $end at the end if truncated

    if(strlen($text) > $maxlength)
    {
       $text = substr($text , 0 , $maxlength);
       $text .= $end;
    }
    return $text;
}

function db_listbox($query, $default="", $suffix="\n") {
/* generate the <option> statements for a <select> listbox, based on the
 * results of a SELECT query ($query).  any results that match $default
 * are pre-selected, $default can be a string or an array in the case of
 * multi-select listboxes.  $suffix is printed at the end of each <option>
 * statement, and normally is just a line break */

        return db_query_loop($query, "<option", "</option>".$suffix, " selected", $default);
}

function openwindow($url , $windowname , $windowparam)
{
// function from emmanuel vanneau (phpMyAgenda)
// $Id: dblib.php3, v2.0 2001/01/06 
// Open a window in the speficied location
    print("<SCRIPT language=javascript>
    newwindow=open( '$url', '$windowname' ,'$windowparam');
    </SCRIPT>");
}

function geturl($url , $windowparam="")
{
// function from emmanuel vanneau (phpMyAgenda)
// $Id: dblib.php3, v2.0 2001/01/06 
// Open a window in the speficied location
    $url2 = $url;
    if(!empty($windowparam))
      $url2 .= "?".$windowparam;
    print("<SCRIPT language=javascript>
    window.document.location = '$url2';
    </SCRIPT>");
}

function closewindow()
{
// function from emmanuel vanneau (phpMyAgenda)
// $Id: dblib.php3, v2.0 2001/01/06 
// close this window
    print("<SCRIPT language=javascript>
    window.close();
    </SCRIPT>");
}

function formatSQLdate($year="" , $month="" , $day="" , $hour="" , $minute="")
{
// function from emmanuel vanneau (phpMyAgenda)
// $Id: dblib.php3, v2.0 2001/01/06 
   // format date and time in SQL format
   // if year, month, day not filled or not valid => put date of today
   // use manual check cause checkdate function doesn't work properly

	debug("format sql date : $year/$month/$day/$hour/$minute");
   $time = time();

   if(empty($year) || $year+1-1 < 1) // year must be > 0
     $year = date("Y" , $time);

   if(empty($month) || $month+1-1 < 1 || $month+1-1 > 12)   // month range = 1==>12
     $month = date("m" , $time);

   if(empty($day) || $day+1-1 < 1 || $day+1-1 > 31) // day valid range = 1==>31, no 30days months check.
     $day = date("d" , $time);

   if(empty($hour))
     $hour = "00";

   if(empty($minute))
     $minute = "00";

   return $year."-".$month."-".$day." ".$hour.":".$minute.":00";
}


function format_date_end_as_date(&$frm)
{
// function from emmanuel vanneau (phpMyAgenda)
// $Id: dblib.php3, v2.0 2001/01/06 
  // this function checks that date_end is not empty and is fill it with date.
	debug("format_end_date (1):".$frm["endyear"].$frm["endmonth"].$frm["endday"].$frm["endhour"].$frm["endmin"]);
  if(empty($frm["endyear"]))
    $frm["endyear"] = $frm["startyear"];

  if(empty($frm["endmonth"]))
     $frm["endmonth"] = $frm["startmonth"];

  if(empty($frm["endday"]))
     $frm["endday"] = $frm["startday"];

  if(empty($frm["endhour"]))
     $frm["endhour"] = $frm["starthour"];

  if(empty($frm["endmin"]))
     $frm["endmin"] = $frm["startmin"];
	debug("format_end_date (2):".$frm["endyear"].$frm["endmonth"].$frm["endday"].$frm["endhour"].$frm["endmin"]);
}

function replace_in_table($table , $field , $value , $newvalue)
{
// function from emmanuel vanneau (phpMyAgenda)
// $Id: dblib.php3, v2.0 2001/01/06 
  // replace each item's $field of $table table where $field=$value with $newvalue
  $qid = db_query("SELECT id FROM $table WHERE $field='$value'");
  $replaced = 0;
  while ($r = db_fetch_object($qid))
  {
    db_query("UPDATE $table SET $field='$newvalue' WHERE id=".$r->id);
    $replaced++;
  }
  return $replaced;
}

function dispdate($datestart , $dateend , $lang = ""){
// function from emmanuel vanneau (phpMyAgenda)
// $Id: stdlib.php3, v2.0 2001/01/06 
// format date to display it properly
// datestart : date of beginning in YYYY-MM-DD HH:MM format
// dateend   : date of end in YYYY-MM-DD HH:MM format
// return    : formatted date
// see lang files for definitions of options

	global $instlang , $defaultlang , $dateformat , $timeformat , $datesamestartend , $datesameday , $dateother;
	if(!isset($instlang))
		$instlang = array(1=>"francais" , "english");
	if(!isset($defaultlang))
	{
		$defaultlang = "english";
		debug("unknown language : setting to english");
	}
	if(!isset($dateformat))
		$dateformat = "%m, %D %Y";
	if(!isset($timeformat))
		$timeformat = "%h:%mi";
	if(!isset($datesamestartend))
		$datesamestartend = "<b>%startdate</b> at <b>%starttime</b>";
	if(!isset($datesameday))
		$datesameday = "<b>%startdate</b> from <b>%starttime</b> to <b>%endtime</b>";
	if(!isset($dateother))
		$dateother = "From <b>%startdate</b> at <b>%starttime</b> to <b>%enddate</b> at <b>%endtime</b>";
	
	if(empty($lang))
		$lang = $defaultlang;

  $start			= "";
  $starttime  = "";
	format_date($datestart , $start , $starttime , $dateformat , $timeformat); 
  $end				= "";
  $endtime  	= "";
	format_date($dateend , $end , $endtime , $dateformat , $timeformat); 
	
	$disp = $dateother;   // datestart and dateend are not the same day

  if(!strcmp($datestart , $dateend))        //    datestart and dateend are the same day/same hour
  	$disp = $datesamestartend;
	elseif($start == $end)   // datestart and dateend are the same day
  	$disp = $datesameday;

	$disp = ereg_replace ("%startdate" , $start , $disp);
	$disp = ereg_replace ("%starttime" , $starttime , $disp);
	$disp = ereg_replace ("%enddate" 	 , $end , $disp);
	$disp = ereg_replace ("%endtime"   , $endtime , $disp);
	
	return $disp;
}

function explode_date($date , &$year , &$month , &$day , &$hour , &$min)
{
// function from emmanuel vanneau (phpMyAgenda)
// $Id: dblib.php3, v2.0 2001/01/06 
	$date = ereg_replace(" " , "-" , $date);
  $date = ereg_replace(":" , "-" , $date);
  list ($year , $month, $day , $hour , $min) = split ('[/.-]', $date);
}

function format_date($date_in , &$date_out , &$time , $formatdate = "%m, %D %Y" , $formattime = "%h:%mi" )
{
// function from emmanuel vanneau (phpMyAgenda)
// $Id: dblib.php3, v2.0 2001/01/06 
	global $monthlist;
	if(!isset($monthlist))
		$monthlist = array(1=>"january" , "february" , "march" , "april" , "may" , "june" , "july" , "august" , "september" , "october" , "november" , "december");
	global $am,$pm;
	if(!isset($am))
		$am = "AM";
	if(!isset($pm))
		$pm = "PM";
	
	$year 	= "";
	$month 	= "";
	$day 		= "";
	$hour 	= "";
	$min 		= "";
	explode_date($date_in , $year , $month , $day , $hour, $min);
	
	if(strpos($formattime , 'h'))
	{
		if($hour > 12)
		{
			$hour  = $hour-12;
			$min  .= " $pm";
		}
		else
			$min .= " $am";
	}
	

	$formattime = ereg_replace ("%H" , $hour , $formattime);
	$formattime = ereg_replace ("%h" , "$hour" , $formattime);
	$formattime = ereg_replace ("%mi" , $min , $formattime);
	$formatdate = ereg_replace ("%M" , $month , $formatdate);
	$formatdate = ereg_replace ("%D" , $day , $formatdate);
	$formatdate = ereg_replace ("%Y" , $year , $formatdate);
	$formatdate = ereg_replace ("%m" , $monthlist[$month+1-1] , $formatdate);
	

	$date_out = $formatdate;
	$time 		= $formattime;
			
/*
	if($DDMMYYY)
	{
   	$date_out = "$year-$month-$day";
		if($hour > 12)
		{
			$hour = $hour-12;
			$time = $hour.":".$min." PM";
		}
		else
			$time = $hour.":".$min." AM";
	}
	else
	{
    $date_out = "$day-$month-$year";
		$time 		= $hour.":".$min;
	}*/
	return $date_out." ".$time;
}

function option_month($selected)
{
// function from emmanuel vanneau (phpMyAgenda)
// $Id: dblib.php3, v2.0 2001/01/06 
	//fill up option box with months
	// month list is defined in .lang.php3 files.
	
	
	global $monthlist;
	if(!isset($monthlist))
		$monthlist = array(1=>"january" , "february" , "march" , "april" , "may" , "june" , "july" , "august" , "september" , "october" , "november" , "december");
	
	$select= "";
	
	for($i=1 ; $i<=12 ;$i++)
	{
	  $select .= "<option value=$i";
	  if($i == $selected)
	    $select .= " selected";
	  $select  .= ">".$monthlist[$i]."</option>";
	}
	return $select;
}

function option_language($selected = "")
{
// function from emmanuel vanneau (phpMyAgenda)
// $Id: dblib.php3, v2.0 2001/01/06 
	//fill up option box with installed languges defined in application.php3
	
	global $instlang , $defaultlang;
	if(!isset($instlang))
		$instlang = array(1=>"francais" , "english");
	if(!isset($defaultlang))
		$defaultlang = "english";
	
	debug("option_language : selected = $selected");
	$nblang = count($instlang);
	if(!$nblang)
		return "";
		
	if(empty($selected))
		$selected = $defaultlang;

	$select= "";
	
	for($i=1 ; $i<=$nblang ;$i++)
	{
	  $select .= "<option value='$instlang[$i]'";
	  if($instlang[$i] == $selected)
	    $select .= " selected";
	  $select  .= ">".$instlang[$i]."</option>";
	}
	return $select;
}

function option_year($selected , $start , $end)
{
// function from emmanuel vanneau (phpMyAgenda)
// $Id: dblib.php3, v2.0 2001/01/06 
	//fill up option box with months
	$select= "";
	
	for($i=$start ; $i<=$end ;$i++)
	{
	  $select .= "<option value=$i";
	  if($i == $selected)
	    $select .= " selected";
	  $select  .= ">".$i."</option>";
	}
	return $select;
}

endif; // define
?>
