<?php
// script from emmanuel vanneau (phpMyAgenda)
// $Id: events.inc.php3, v2.0 2001/01/06 
/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

if(!isset($EVENTINCLUDE)):
	$EVENTINCLUDE = 1;

function validate($idevent)
{
	global $CFG;
	// event validation 
 	$qid 		= db_query("UPDATE $CFG->table_event SET valid = 1 WHERE id = $idevent");
	$qide 	= db_query("SELECT contact1, contact2, contact3, contact4, contact5 FROM $CFG->table_event WHERE id=$idevent");
	$result = db_fetch_array($qide);
	for($i=1 ; $i<=5 ; $i++)
	{
		if($result["contact".$i] != 0)
		{
			db_query("UPDATE $CFG->table_contact  SET valid = 1 WHERE id =".$result["contact".$i]);
	 		debug("validating contact ".$result["contact".$i]);
		}
	}
	db_free_result($qide);
	
	// date and event validation
	$query 	= "SELECT id , place FROM $CFG->table_date WHERE event=$idevent";
	debug("validating date and place for event $idevent");
	$qid 		= db_query($query);
	while ($r = db_fetch_object($qid))
	{
	 	db_query("UPDATE $CFG->table_date  SET valid = 1 WHERE id =".$r->id);
	 	debug("validating date ".$r->id);
	 	db_query("UPDATE $CFG->table_place SET valid = 1 WHERE id =".$r->place);
	 	debug("validating place ".$r->place);
	 	$qidpc = db_query("SELECT contact1, contact2 , contact3, contact4, contact5 FROM $CFG->table_place WHERE id=".$r->place);
		$res = db_fetch_array($qidpc);
		for($i=1 ; $i<=5 ; $i++)
		{
			db_query("UPDATE $CFG->table_contact SET valid=1 WHERE id=".$res["contact".$i]);
		}
 		db_free_result($qidpc);
	}	 
	
	remove_nonvalid_contacts();
	remove_nonvalid_events();
	remove_nonvalid_dates();
	remove_nonvalid_places();
	
	return 0;
}

function remove_nonvalid_events()
{
	global $Auth,$CFG;
 	db_query("DELETE FROM $CFG->table_event WHERE valid=0 AND owner=$Auth->id");
	debug("removing non valid events");
}

function print_confirmation($idevent)
{
	GetUrl("events.php3" , "mode=add&step=valid&idevent=$idevent");
}

function validate_event_form($frm)
{
  global $CFG,$ME;
 	if(empty($frm["title"]) || empty($frm["description"]))
 	{
	  $frm["type"]    = "<select name=\"type\">"
	          . db_listbox("SELECT id, type FROM $CFG->table_eventtype ORDER BY type", $frm["type"])
	          . "</select>";
	  $frm["url"]    = "<select name=\"url\">"
	          . "<option value=0> </option>"
	          . db_listbox("SELECT id, url FROM $CFG->table_url ORDER BY url", $frm["url"])
	          . "</select>";
	  $validation = true;
	  $id = $frm["id"];
 		include("templates/event_form.php3");
 		return false;
 	}
 	return true; 	  
}	

function print_add_events_form()
{
  global $CFG,$ME, $Auth;
  $frm["newmode"] 			= "add";
  $frm["nextstep"] 			= "";
  $frm["type"]      		= "<select name=\"type\">"
                				. db_listbox("SELECT id, type FROM $CFG->table_eventtype ORDER BY type", "0")
                				. "</select>";
  $frm["title"]       	= "";
  $frm["description"] 	= "";
  $frm["url"]         	= "<select name=\"url\">"
									     . "<option value=0> </option>"
									     . db_listbox("SELECT id, url FROM $CFG->table_url ORDER BY url ", "0")
									     . "</select>";
  $frm["newurl"]     	 	= "";
  $frm["contact1"]			=	0;
  $frm["contact2"]			=	0;
  $frm["contact3"]			=	0;
  $frm["contact4"]			=	0;
  $frm["contact5"]			=	0;
  $frm["contactname1"]	=	"";
  $frm["contactname2"]	=	"";
  $frm["contactname3"]	=	"";
  $frm["contactname4"]	=	"";
  $frm["contactname5"]	=	"";
  $frm["image"]					= "";
  
  $frm["valid"]					= 0;
  $frm["submit_place"] 	= "Add new date/place";
  $frm["submit_contact"]= "Add Organizer";
  $frm["submit_caption"]= "Validate";
  $frm["nbdate"]				= 0;
  $frm["owner"]					= $Auth->id;
  include("templates/event_form.php3");
}

function limit_image_size($size , $limitx , $limity)
{
	$x = $size[0];
	$y = $size[1];
	if($y != 0)
		$ratio = $x/$y;
	else
		$ratio = 1;
	if($x > $limitx)
	{
		$x = $limitx;
		$y = (int)($x / $ratio);
	}
	if($y > $limity)
	{
		$y = $limity;
		$x = (int)($y * $ratio);
	}
	$sizeret[0] = $x;
	$sizeret[1] = $y;
	return $sizeret;
}

function print_edit_events_form($id) {
/* print a events form so we can add a edit the selected events */

  global $CFG, $ME;

  /* load up the information for the events */
  $qid = db_query("SELECT * FROM $CFG->table_event WHERE  id = $id");
  $frm = db_fetch_array($qid);

  /* set values for the form */
  $frm["newmode"] = "update";
  $frm["type"]    = "<select name=\"type\">"
          . db_listbox("SELECT id, type FROM $CFG->table_eventtype ORDER BY type", $frm["type"])
          . "</select>";
  $frm["url"]    = "<select name=\"url\">"
          . "<option value=0> </option>"
          . db_listbox("SELECT id, url FROM $CFG->table_url ORDER BY url", $frm["url"])
          . "</select>";

  $frm["submit_caption"] 	= "validate";
  $frm["submit_place"] 		= "Add new date/place";
  $frm["submit_contact"] 	= "Add Organizer";
  $frm["submit_caption"] 	= "Validate";
  if($frm["image"] <> "")
  {
  	$frm["image"] = "../".$CFG->image_event_dir."/".$frm["image"];
  	debug("filename ".$frm["image"]);
  	if(is_file($frm["image"]))
  	{
  		debug("filename exists");
  		$size 	 = getimagesize($frm["image"]);
	  	debug("size x = ".$size[0]);
	  	debug("size y = ".$size[1]);
	  	$size = limit_image_size($size , $CFG->limit_image_display_x , $CFG->limit_image_display_y);
	  	debug("trans size x = ".$size[0]);
	  	debug("trans size y = ".$size[1]);
	  	$frm["imagex"] = $size[0];
	  	$frm["imagey"] = $size[1];
	  }
	  else
	  {
	  	$frm["imagex"] = $CFG->limit_image_display_x;
	  	$frm["imagey"] = $CFG->limit_image_display_y;
	  }
  }
  	
  
  for($i=1 ; $i<=5 ; $i++)
	{
		$idc 	= $frm["contact".$i];
		$qidc = db_query("SELECT id,name FROM $CFG->table_contact WHERE id = $idc");
		if(db_num_rows($qidc))
		{
			$r = db_fetch_object($qidc);
   		$frm["contactname".$i]	=	$r->name;
   	}
   	else
   		$frm["contactname".$i]	=	"";
  	db_free_result($qidc);
	}
	
  db_free_result($qid);
  $qid = db_query("SELECT * FROM $CFG->table_date WHERE event=$id");
  $frm["nbdate"]					= db_num_rows($qid);
  $i=0;
	debug("Editing event $id");
	while ($r = db_fetch_object($qid))
  {
  	$frm["date".$i] 	= dispdate($r->start , $r->end);
  	$frm["dateid".$i] = $r->id;
  	$qid2 = db_query("SELECT name FROM $CFG->table_place WHERE id=$r->place");
  	$r2 = db_fetch_object($qid2);
  	$frm["placeid".$i] = $r->place;
  	$frm["place".$i++] = $r2->name;
  }

  include("templates/event_form.php3");
}

function duplicate_events($id)
{
	global $CFG;
	$qid = db_query("SELECT * FROM $CFG->table_event WHERE  id = $id");
	$frm = db_fetch_array($qid);
	$frm["valid"] = 0;
	$id2 = insert_events($frm , 0);
	db_free_result($qid);
	$qid = db_query("SELECT * FROM $CFG->table_date WHERE event = $id");
	while ($frm = db_fetch_array($qid))
	{
		$frm["idevent"] = $id2;
		$frm["idplace"] = $frm["place"];
		$frm["valid"] = 0;
		insert_date($frm);
	}	
	print_edit_events_form($id2);
}


function delete_events($id) {
	
	global $CFG, $ME;
		
	// remove all dates refering to this event
	delete_date_from_event($id);
	
	$qid = db_query("SELECT image FROM $CFG->table_event WHERE  id = $id");
	$frm = db_fetch_array($qid);
	if($frm["image"] <> "")
		unlink("$CFG->image_event_dir/$frm[image]");
	/* delete this events */
	$qid = db_query("DELETE FROM $CFG->table_event WHERE id = $id");
}

function check_unique_event($frm)
{
//Check that place with fields in $frm is not present in the table
//return : 0 if not present in table
//         place.id if present
	
	global $CFG;
	$query = "SELECT id FROM $CFG->table_event WHERE ";
	$query .= "title='$frm[title]' AND ";
	$query .= "description='$frm[description]' AND ";
	$query .= "url='$frm[url]' AND ";
	$query .= "type='$frm[type]'";
	$qid = db_query($query);
	if($row = mysql_fetch_array ($qid))
	 return $row["id"];
	return 0;
}

function insert_events($frm , $check=1) 
{
/* add a new subevents under the parent $id.  all the fields that we want are
 * going to in the variable $frm */

  global $CFG, $ME;

  if($check == 1)
  {
    $id = check_unique_event($frm);
    if($id)
    {
      echo "<div class=normal>The event <b>".$frm["title"]."</b> already exists in the database. Using the existing.</div>";
      return $id;
    }
  }
  
  if($frm["url"] == 0 && !empty($frm["newurl"]))
 	{
 		debug("inserting url ".$frm["newurl"]." as id=".$frm["url"]);
 		$frm["url"] = insert_url($frm);
 	}
  $frm["description"]    = addslashes ($frm["description"]);
  $frm["title"]          = addslashes ($frm["title"]);
  $qid = db_query("INSERT INTO $CFG->table_event
          (id, title, description, url, type , contact1 , contact2 , contact3 , contact4, contact5 , owner , image)
          VALUES ('', '$frm[title]', '$frm[description]','$frm[url]', '$frm[type]' , '$frm[contact1]', '$frm[contact2]', '$frm[contact3]', '$frm[contact4]', '$frm[contact5]' , '$frm[owner]', '$frm[image]')");
  return db_insert_id();
}

function update_events($id, $frm) {
/* update the events $id with new values.  all the fields that we want are
 * going to in the variable $frm */

  global $CFG, $ME;
  
  $frm["description"]    = addslashes ($frm["description"]);
  $frm["title"]          = addslashes ($frm["title"]);

  if($frm["url"] == 0 && !empty($frm["newurl"]))
 	{
 		debug("inserting url ".$frm["newurl"]." as id=".$frm["url"]);
 		$frm["url"] = insert_url($frm);
 	}

  $qid = db_query("
  UPDATE $CFG->table_event SET
          title 				= '$frm[title]'
          ,description 	= '$frm[description]'
          ,url 					= '$frm[url]'
          ,type 				= '$frm[type]'
          ,contact1			= '$frm[contact1]'
          ,contact2			= '$frm[contact2]'
          ,contact3			= '$frm[contact3]'
          ,contact4			= '$frm[contact4]'
          ,contact5			= '$frm[contact5]'
  WHERE id = $id
  ");
}

function print_events_list($orderby="" , $selecttype="" , $selectmonth="" , $selectyear="" , $selectmonthend ="", $selectyearend="" , $selectplace="" , $selectcontact="", $edge=0)
{
/* read events from the database with filter and order and print them into a table.  we
 * will use a template to display the listings to keep this main script clean */

	global $CFG, $ME, $Auth;
	
	if(empty($edge))
	{
	  $edge = 0;
	}
	$limit = 20;
	
	if(!empty($selectmonth))
	 $monthstart = $selectmonth;
	else
	 $monthstart = 1;
	
	if(!empty($selectyear))
	 $yearstart = $selectyear;
	else
	 $yearstart = "";

	if(!empty($selectmonthend))
	 $monthend = $selectmonthend;
	else
	 $monthend = 12;
	
	if(!empty($selectyearend))
	 $yearend = $selectyearend;
	else
	 $yearend = "";

	$selectdate = !empty($selectyear) || !empty($selectmonth) || !empty($selectyearend) || !empty($selectmonthend);
	
	// format the query
	$req_listevents 		 = "SELECT e.id , e.title, e.description, e.owner , t.type ";
	if($selectdate)
		$req_listevents 	.= ", d.start ";
	if($selectplace)
		$req_listevents 	.= ", p.name ";
	$req_listevents			.= "FROM   $CFG->table_event e, $CFG->table_eventtype t ";
	if($selectdate || $selectplace)
		$req_listevents 	.= ", $CFG->table_date d ";
	if($selectplace)
		$req_listevents 	.= ", $CFG->table_place p ";
	$req_listevents 		.= "WHERE  t.id = e.type ";
	        	 
	if(!empty($selecttype))
	  $req_listevents .= " AND e.type=$selecttype ";
	  
	if(!$Auth->can_read_all())  // user doesn't have right access for reading all events
	{
		debug("can't read all");
		debug("read =".$Auth->can_read_own());
		debug("edit =".$Auth->can_edit_own());
		if($Auth->can_read_own() || $Auth->can_edit_own()) // user can read or edit its own events
		{
			debug("own ok");
			$req_listevents .= "AND e.owner = $Auth->id";
		}
		else
			$req_listevents .= "AND e.id = 0"; // avoid displaying any event (to be improved)
	}		
	
	if($selectdate)
	{
	    $date    = formatSQLdate($yearstart , $monthstart , 1);
	    $dateend = formatSQLdate($yearend , $monthend , 31);
	    $req_listevents .= " AND d.event = e.id AND d.start >='$date' AND d.start <='$dateend'";
	}
	
	if(!empty($selectplace))
	 $req_listevents .= " AND p.id = $selectplace AND d.place = $selectplace AND d.event = e.id ";

	if(!empty($selectcontact))
	 $req_listevents .= " AND (	e.contact1=$selectcontact OR 
	 														e.contact2=$selectcontact OR 
	 														e.contact3=$selectcontact OR 
	 														e.contact4=$selectcontact OR 
	 														e.contact5=$selectcontact) ";
	 
	if($orderby)
	 $req_listevents .= " ORDER BY ".$orderby." ASC";
	
	debug("listing request = $req_listevents");
	// do the query
	$qidnum    = db_query($req_listevents);
	$numevents = db_num_rows($qidnum);
	db_free_result($qidnum);
	$qid       = db_query($req_listevents." LIMIT $edge, $limit");
	
	// formatting filter selectors
	$frm["selecttype"]    = "<select name=\"selecttype\">"
	        . "<option value=''> </option>"
	        . db_listbox("SELECT id, type FROM $CFG->table_eventtype ORDER BY type",$selecttype)
	        . "</select>";

	$frm["selectmonth"]   = "<select name=\"selectmonth\">"
	                      . "<option value=''></option>"
												. option_month($selectmonth)
												. "</select>";
	
	$frm["selectmonthend"]= "<select name=\"selectmonthend\">"
	                      . "<option value=''></option>"
												. option_month($selectmonthend)
												. "</select>";
	
	
	$frm["selectyear"]   = "<select name=\"selectyear\">"
	                      . "<option value=''></option>"
												.	option_year($selectyear , 2000 , 2010)
												. "</select>";
	
	$frm["selectyearend"] = "<select name=\"selectyearend\">"
	                      . "<option value=''></option>"
												.	option_year($selectyearend , 2000 , 2010)
												. "</select>";
												
	$frm["selectplace"]		= "<select name=\"selectplace\">"
	                      . "<option value=''></option>"
												.	db_listbox("SELECT id , name FROM $CFG->table_place ORDER BY name" , $selectplace)
												. "</select>";

	$frm["selectcontact"]	= "<select name=\"selectcontact\">"
	                      . "<option value=''></option>"
												.	db_listbox("SELECT id, name FROM $CFG->table_contact ORDER BY name" , $selectcontact)
												. "</select>";
	
	include("templates/events_list.php3");
}

function	add_contact_to_event($idevent , $idcontact)
{
	// Add a contact reference to the event
	global $CFG;
	$qid = db_query("SELECT * FROM $CFG->table_event WHERE id=$idevent");
  $r 	 = db_fetch_array($qid);
  $done= false;
  for($i=1 ; $i<=5 && !$done ; $i++)
	{
		$cid = "contact".$i;
		if($r[$cid] == 0)
		{
			db_query("UPDATE $CFG->table_event SET $cid = $idcontact WHERE id=$idevent");
			debug("contact event # $i added");
			$done = true;
		}
  }
	db_free_result($qid);
}

function update_contact_to_event($idevent , $idcontact , $idcontactnumber=0)
{
	global $CFG;
	$cid = "contact".$idcontactnumber;
	debug("updating $cid");
	db_query("UPDATE $CFG->table_event SET $cid = $idcontact WHERE id=$idevent");
	debug("contact event # $idcontactnumber updated");
}

function	remove_contact_from_event($idevent , $idcontact)
{
	// remove a contact reference from the event
	global $CFG;
	$cid = "contact".$idcontact;
	db_query("UPDATE $CFG->table_event SET $cid = 0 WHERE id=$idevent");
}

function get_random_string($limit = 8)
{
	srand(time());
	$random = md5(time() + rand(0,10000));
  $random = substr($random , 0 , $limit);
	return $random;
}

function generate_filename($path , $extension)
{
	// generate a random file name
	for($i=0 ; $i<100 ; $i++) // try 100 times to get a random file name that doesn't exist
	{
		$filename = get_random_string();
		$file["filename"] = $filename.".".$extension;
		$file["path"]		  = "$path/$filename.$extension";
		if(!file_exists($file["path"]))
			return $file;
	}
	return "";
}

function	upload_image($idevent , $uploadedfile , $uploadedfile_name)
{
	// upload an image for the event
	global $CFG;
	debug("image upload : $uploadedfile_name");
  $uploadedfilename = "";
  if(isset($uploadedfile) && $uploadedfile<>"none" && $uploadedfile_name != "")
  {
  	$path   = basename($uploadedfile_name); // does not use pathinfo function for compatibility with PHP3
  	$pathex = explode("." , $path);
  	$uploadedfilename = generate_filename("../".$CFG->image_event_dir , $pathex[1]);
  	if($uploadedfilename["filename"] <> "")
  	{
  		debug("uploadedfilename = ".$uploadedfilename["path"]);
  		if(!copy($uploadedfile,$uploadedfilename["path"]))//"$CFG->image_event_dir/".$uploadedfilename))
    	{
    		echo("Sorry, Your file failed to upload.<br>");
    	  echo("Either your file doesn't exist or it was too large.");
    	  return "";
   		}
    	else
				db_query("UPDATE $CFG->table_event SET image = '$uploadedfilename[filename]' WHERE id=$idevent");
		}
		else
    	echo("Sorry, Your file failed to upload.(filename generation failed)<br>");
	}
   return $uploadedfilename;
}

function	remove_image($idevent)
{
	// remove the image associated with the event
	global $CFG;
	debug("remove image");
	$qid = db_query("SELECT image FROM $CFG->table_event WHERE id=$idevent");
	db_query("UPDATE $CFG->table_event SET image = '' WHERE id=$idevent");
	$frm = db_fetch_row($qid);	
	if(isset($frm["image"]))
	{
		$frm["image"] = "../".$CFG->image_event_dir."/".$frm["image"];
  	if(is_file($frm["image"]))
			unlink($frm["image"]);
	}
}

function get_first_events($limit = 5)
{
	global $CFG;
	$req_listevents 		 = "SELECT e.id , e.title, e.description, e.image, t.type , d.start 
													FROM   $CFG->table_event e, $CFG->table_eventtype t , $CFG->table_date d 
													WHERE  t.id = e.type 
													AND d.event = e.id 
													AND d.start >= NOW() 
													ORDER BY d.start ASC
													LIMIT 0 , $limit";
	
	debug("listing request = $req_listevents");
	// do the query
	$qidnum    = db_query($req_listevents);
	return $qidnum;
}
endif;
?>