<?php 
// phpMyAgenda Visitor interface library
// This file contains all functions needed to link user interfaces to phpMyAgenda Engine.
//
// creation : 26/03/2001 Manu Vanneau

// UI interface is mainly composed of a left menu and various display pages.
if(!isset($VISITORUIINCLUDE)):
	$VISITORUIINCLUDE = 1;

class CSingleEvent
{
	// this class manage calendar display
  // 09/04/2001 Manu vanneau mvanneau@hotmail.com
	
	var $id			 		= 0;					// the event id to display
	var $place 	 		= 0;					// the event's place id to display
	var $contact 		= 0;					// the event's contact to display
	var $language		= "english";	// Display language
	
	function Init($language)
	{
		// Initialize the single event display
		global $placesel, $contactsel,$id;

		if(!isset($id))
			$id=0;
		if(!isset($placesel))
			$placesel=0;
		if(!isset($contactsel))
			$contactsel=0;
		
		$this->id 			= $id;
		$this->place 		= $placesel;
		$this->contact 	= $contactsel;
		$this->language = $language;
	}
	
	function DisplayEvent()
	{
		// do the query
		
		global $rootagenda, $CFG, $strOrganizer, $strMoreInfo, $ME, $strMorePlace, $strMoreOrga;
		include("admin/include/events.inc.php3");

		$query 			= "SELECT e.* , t.type typevent FROM $CFG->table_event e, $CFG->table_eventtype t WHERE e.id=$this->id AND e.type = t.id";
		debug($query);
		$qidevent   = db_query($query);
		$r   		= db_fetch_object($qidevent);
	  if($r->image != "")
	  {
	  	$r->image = $CFG->image_event_dir."/".$r->image;
	  	if(is_file($r->image))
	  	{
	  		$size = getimagesize($r->image);
		  	$size = limit_image_size($size , $CFG->limit_image_display_x , $CFG->limit_image_display_y);
		  	$r->imagex = $size[0];
		  	$r->imagey = $size[1];
		  }
		  else
		  {
		  	$r->imagex = $CFG->limit_image_display_x;
		  	$r->imagey = $CFG->limit_image_display_y;
		  }
	  }
    echo " <table border='0' cellspacing='0' cellpadding='1' width='100%'>";
		echo "  <tr>";
		echo "    <td valign='top' width='".$CFG->limit_image_display_x."'>";
		if($r->image != "")
			echo "<a href='".$r->image."' target='_blank'><img alt=' ' src='".$r->image."' width='".$r->imagex."' height='".$r->imagey."' border=0></a>";
		else
			echo "&nbsp;";
		echo "	</td>";
		echo "  <td>";
    echo " 	<table border='0' cellspacing='0' cellpadding='1' width='100%'>";
    echo "   	<tr class=result_title> ";
    echo "      <td colspan='2'>";
    echo pv($r->title)."&nbsp;</td>";
    echo "    </tr>";
    echo "    <tr class=result_type> ";
    echo "    	<td colspan='2'>";
    echo pv($r->typevent)."&nbsp;</td>";
    echo "    </tr>";
    echo "    <tr class=normal> ";
    echo "    	<td height='15' colspan='2'>";
    echo pv($r->description)."&nbsp;</td>";
    echo "    </tr>";
    $qidate = db_query("SELECT start, end, place.name, place.id  FROM $CFG->table_date,$CFG->table_place WHERE date.place = place.id AND date.event = '$r->id' GROUP BY date.start ORDER BY date.start");
		echo "    <tr>";
    echo "    	<td colspan='2'> ";
    echo "    		<table width='100%' border='0' cellspacing='0' cellpadding='0'>";
    echo "        	<tr>";
		if(db_num_rows($qidate) > 0)
		{
      echo "        	<td colspan='2' height='19'>";
      echo "          	<table width='100%' border='0' cellspacing='0' cellpadding='0'>";
      echo "							<tr><td class=result_description><br>$strMorePlace</td></tr>";
      while($dates  = db_fetch_object($qidate))
      {
				echo "<tr><td class=normal width='50%' nowrap>".dispdate($dates->start , $dates->end , $this->language)."&nbsp;</td>";
    		echo "<td class=normal> at &nbsp;&nbsp;&nbsp;<a href=\"$ME?id=$this->id&placesel=$dates->id&contactsel=$this->contact\">$dates->name</a></td></tr>";
    	}
    	db_free_result($qidate);
      
      echo "            </table>";
      echo "          </td>";
    }
    //echo "        </td>";
    echo "      </tr>";
    echo "      </table>";
    echo "      </td>";
    echo "      </tr>";
    echo "			<tr><td class=result_description><br>$strMoreOrga</td></tr>";
    echo "    	<tr>";
    echo "      	<td class=normal width='89%'>"; 
    $query = "SELECT id, name FROM $CFG->table_contact WHERE ";
    $contact = array(1=>$r->contact1 , $r->contact2 , $r->contact3 , $r->contact4 , $r->contact5);
		$i = 0;
		for($n=1 ; $n<=5 ; $n++)
		{
			if($contact[$n])
			{
				$i++;
				$query .= "id = '$contact[$n]' ";
				if($n<5 && $contact[$n+1])
					$query .= " OR ";
			}
		}
		if($i)
		{
			$qicon = db_query($query);
			echo $strOrganizer." : ";
			for($z=0 ; $z<$i ; $z++)
			{
				$con = db_fetch_array($qicon);
				echo "<a href=\"$ME?id=$this->id&placesel=$dates->id&contactsel=$con[id]\">".$con["name"]."</a>";
				if($z<$i-1)
					echo " | ";
			}	
			db_free_result($qicon);
		}
		echo "          </td>";
    echo "        </tr>";
    echo "      </table>";
    echo "    </td>";
    echo "  </tr>";
    echo "</table>";
		echo "</td>";
		echo "</tr>";
		echo "</table>";
		db_free_result($qidevent);
	}
	
	function DisplayPeopleContact($contactdisp , $index)
	{
		// Display information about people on the contact
		
		global $strName, $strSurname, $strFunction, $strPhone, $strFax, $strEmail;
    echo "<table width='100%' border='0' cellspacing='0' cellpadding='0'>";
    echo "	<tr>"; 
    echo "  	<td width='2' align='center'>&nbsp;</td>";
    echo "  	<td colspan='3' valign='top'>"; 
    echo "   		<table width='100%' border='0' cellspacing='0' cellpadding='0'>";
    echo "   	  	<tr>"; 
    echo "        	<td width='80'  class=normal_search nowrap> $strName &nbsp;</td>";
    echo "        	<td width='110' class=normal_search nowrap>";
    echo pv($contactdisp["name$index"])."</td>";
    echo "        	<td width='80'  class=normal_search nowrap>&nbsp;&nbsp;&nbsp;$strSurname &nbsp;</td>";
    echo "        	<td width='110' class=normal_search nowrap>";
    echo pv($contactdisp["surname$index"])."</td>";
    echo "        	<td width='266' class=normal_search nowrap>&nbsp;&nbsp;&nbsp;  $strFunction ";
    echo pv($contactdisp["function$index"])."</td>";
    echo "      	</tr>";
    echo "      	<tr>"; 
    echo "        	<td width='80' class=normal_search nowrap>$strPhone &nbsp;</td>";
    echo "        	<td width='110' class=normal_search nowrap>";
    echo pv($contactdisp["phone$index"])."</td>";
    echo "        	<td width='80' class=normal_search nowrap>&nbsp;&nbsp;&nbsp;$strFax </td>";
    echo "        	<td width='110' class=normal_search nowrap>";
    echo pv($contactdisp["fax$index"])."</td>";
    echo "        	<td width='266' class=normal_search> &nbsp;</td>";
    echo "      	</tr>";
    echo "      	<tr>"; 
    echo "        	<td nowrap width='80' class=normal_search>   $strEmail  &nbsp; </td>";
    echo "        	<td colspan='4' class=normal_search nowrap><a href='mailto:";
    echo pv($contactdisp["email$index"])."'>";
    echo pv($contactdisp["email$index"])."</a></td>";
    echo "      	</tr>";
    echo "    	</table>";
    echo "  	</td>";
    echo "	</tr>";
		echo "</table>";
	}

	function DisplayContact()
	{
		// Display the selected contact ($this->contact)
		if(!$this->contact)
		{
			debug("No contact selected");
			return;
		}
	
		global $strContacts , $strName , $strAddress , $strZipcode , $strTown, $strCountry, $strPhone, $strFax, $strEmail, $strURL;
		include ("admin/include/contacts.inc.php3");
		include ("admin/include/url.inc.php3");
		debug("display contact = $this->contact");
		$contactdisp = get_contact($this->contact);
		if($contactdisp["url"])
		{
			$contact = get_url($contactdisp["url"]);
			$contactdisp["url"] = $contact["url"];
		}
			
		echo "<table width='575' border='0' cellspacing='0' cellpadding='0' align='left'>";
  	echo "	<tr>"; 
    echo "		<td width='10'>&nbsp;</td>";
    echo "		<td colspan='3' valign='top' nowrap>"; 
    echo "		  <table width='100%' border='0' cellspacing='0' cellpadding='2'>";
    echo "		    <tr>";
    echo "					<td class=tdsingletitle>";
    echo pv($contactdisp["name"])."</td>";
    echo "				</tr>";
    echo "		    <tr>"; 
    echo "					<td>";
    echo "						<table width='100%' border='0' cellspacing='0' cellpadding='0' align='center'>";
		echo "              <tr>";
		echo "                <td width='2' align='center'>&nbsp;</td>";
    echo "		            <td colspan='3' valign='top'>";
    echo "		              <table cellpadding='0' cellspacing='1' width='100%'>";
    echo "		                <tr>";
    echo "		                  <td class=normal nowrap width='15%'>$strName &nbsp;</td>";
    echo "		                  <td class=normal colspan='2' width='85%'>";
		echo                        pv($contactdisp["name"])."</td>";
    echo "										</tr>";
    echo "		                <tr>";
    echo "		                  <td class=normal nowrap width='15%'>$strAddress &nbsp;</td>";
    echo "		                  <td class=normal colspan='2' width='85%'>";
		echo                        pv($contactdisp["address"])."</td>";
    echo "										</tr>";
    echo "		                <tr>";
    echo "		                  <td class=normal nowrap width='15%'>$strZipcode &nbsp;</td>";
    echo "		                  <td class=normal colspan='2' width='85%'>";
		echo                        pv($contactdisp["zipcode"])."</td>";
    echo "										</tr>";
    echo "		                <tr>";
    echo "		                  <td class=normal nowrap width='15%'>$strTown &nbsp;</td>";
    echo "		                  <td class=normal colspan='2' width='85%'>";
		echo                        pv($contactdisp["town"])."</td>";
    echo "										</tr>";
    echo "		                <tr>";
    echo "		                  <td class=normal nowrap width='15%'>$strCountry &nbsp;</td>";
    echo "		                  <td class=normal colspan='2' width='85%'>";
		echo                        pv($contactdisp["country"])."</td>";
    echo "										</tr>";
    echo "		                <tr>";
    echo "		                  <td class=normal nowrap width='15%'>$strPhone / $strFax &nbsp;</td>";
    echo "		                  <td class=normal colspan='2' width='85%'>";
		echo                        pv($contactdisp["phone"])." / ";
		echo												pv($contactdisp["fax"])."</td>";
    echo "										</tr>";
    echo "		                <tr>";
    echo "		                  <td class=normal nowrap width='15%'>$strEmail &nbsp;</td>";
    echo "		                  <td class=normal colspan='2' width='85%'><a href='mailto:";
		echo                        pv($contactdisp["email"])."'>";
		echo												pv($contactdisp["email"])."</a></td>";
    echo "										</tr>";
    echo "		                <tr>";
    echo "		                  <td class=normal nowrap width='15%'>$strURL &nbsp;</td>";
    echo "		                  <td class=normal colspan='2' width='85%'>";
		echo "												<a href='http://";
		echo                        		pv($contactdisp["url"])."' target='_blank'>";
		echo                        		pv($contactdisp["url"])."</a></td>";
    echo "										</tr>";
		echo "                  </table>";
    echo "								</td>";
		echo "              </tr>";
		echo "            </table>";
    echo "		      </td>";
    echo "				</tr>";
    echo "			<tr>";
    echo "		<td>&nbsp;</td>";
    echo "	</tr>";
    echo "	<tr> ";
    echo "		<td>";
		echo "	  	<table cellpadding='0' cellspacing='1' width='100%'>";
		echo "	    	<tr>"; 
		echo "	      	<td class=tdsingletitle2 valign='top'>&nbsp;$strContacts</td>";
		echo "	        <td valign='top'>";
		for($i=0;$i<5;$i++)
		{
			$this->DisplayPeopleContact($contactdisp , $i+1);
			echo "<br>";
		}
		echo "					</td>";
		echo " 	      </tr>";
		echo "			</table>";
		echo "		</td>";
		echo "	</tr>";
		echo "</table>";		
	}
	
	function DisplayPlace()
	{
		// Display the selected place ($this->place)
		if(!$this->place)
		{
			debug("No place selected");
			return;
		}
	
		debug("display place = $this->place");
		global $ME, $strContact, $strName , $strAddress , $strZipcode , $strTown, $strCountry, $strPhone, $strFax, $strURL, $URLINCLUDE, $CONTACTINCLUDE;
		include ("admin/include/place.inc.php3");
		debug("url include = a".$URLINCLUDE."b");
		include ("admin/include/url.inc.php3");
		include ("admin/include/contacts.inc.php3");
		$placedisp = get_places($this->place);
		if($placedisp["url"])
		{
			$contact = get_url($placedisp["url"]);
			$placedisp["url"] = $contact["url"];
		}

		echo "<table width='575' border='0' cellspacing='0' cellpadding='0' align='left'>";
  	echo "	<tr>";
    echo "		<td width='10'>&nbsp;</td>";
    echo "		<td  colspan='3' valign='top' nowrap>";
    echo "			<table width='100%' border='0' cellspacing='0' cellpadding='2'>";
    echo "		    <tr>";
		echo "          <td class=tdsingletitle>";
    echo pv($placedisp["name"])."</td>";
    echo "				</tr>";
    echo "				<tr>";
    echo "					<td>";
    echo "						<table width='100%' border='0' cellspacing='0' cellpadding='0' align='center'>";
		echo "              <tr>";
		echo "                <td width='2' align='center'>&nbsp;</td>";
    echo "		            <td colspan='3' valign='top'>";
		echo "		              <table cellpadding='0' cellspacing='1' width='100%'>";
		echo "	                  <tr>";
		echo "                      <td class=normal nowrap width='15%'>$strName &nbsp;</td>";
		echo "	                    <td class=normal colspan='2' width='85%'>";
    echo 												pv($placedisp["name"])."</td>";
    echo "										</tr>";
		echo "	                  <tr>";
		echo "                      <td class=normal nowrap width='15%'>$strAddress &nbsp;</td>";
		echo "	                    <td class=normal colspan='2' width='85%'>";
    echo 												pv($placedisp["address"])."</td>";
    echo "										</tr>";
		echo "	                  <tr>";
		echo "                      <td class=normal nowrap width='15%'>$strZipcode &nbsp;</td>";
		echo "	                    <td class=normal colspan='2' width='85%'>";
    echo 												pv($placedisp["zipcode"])."</td>";
    echo "										</tr>";
		echo "	                  <tr>";
		echo "                      <td class=normal nowrap width='15%'>$strTown &nbsp;</td>";
		echo "	                    <td class=normal colspan='2' width='85%'>";
    echo 												pv($placedisp["town"])."</td>";
    echo "										</tr>";
		echo "	                  <tr>";
		echo "                      <td class=normal nowrap width='15%'>$strCountry &nbsp;</td>";
		echo "	                    <td class=normal colspan='2' width='85%'>";
    echo 												pv($placedisp["country"])."</td>";
    echo "										</tr>";
    echo "		                <tr>";
    echo "		                  <td class=normal nowrap width='15%'>$strPhone / $strFax &nbsp;</td>";
    echo "		                  <td class=normal colspan='2' width='85%'>";
		echo                        pv($placedisp["phone"])." / ";
		echo												pv($placedisp["fax"])."</td>";
    echo "										</tr>";
		echo "	                  <tr>";
		echo "                      <td class=normal nowrap width='15%'>$strURL &nbsp;</td>";
		echo "	                    <td class=normal colspan='2' width='85%'>";
    echo "												<a href='http://";
    echo 												pv($placedisp["url"])."' target='_blank'>";
   	echo 												pv($placedisp["url"])."</a></td>";
    echo "										</tr>";
	  for($i=1 ; $i<=5 ; $i++)
	  {
	  	if($placedisp["contact".$i])
	  	{
	  		echo "<tr><td class=normal nowrap width='15%'>$strContact </td>";
	  		$DispContact = get_contact($placedisp["contact".$i]);
	  		echo "<td class=normal colspan='2' width='85%'><a href=\"$ME?id=$this->id&placesel=$this->place&contactsel=$i\">".$DispContact["name"]."</a></tr>";
	  	}
	  }
		echo "                  </table>";
    echo "		            </td>";
		echo "              </tr>";
    echo "		        </table>";
    echo "					</td>";
    echo "				</tr>";
    echo "			</table>";
    echo "		</td>";
    echo "	</tr>";
		echo "</table>";
	}
}

class CVisitorUI
{
	var $includepage	= ""; 					// page included (function of the mode selected)
	var $modeagenda   = "search";			// display mode
	var $language;										// language display
	var $placeid;											// specific place to search
	
	var $Calendar;										// Calendar object
	var $Search;                      // Search object
	var $Single;											// Single event object
	
	function Init($pagesuffix = "")
	{
		// Initialiaze left menu and language list box
		// Set cookie with language
		// Set include page
		
		
		global $langCookie;							// var from cookie
		global $formlang;								// var from form
		global $defaultlang;						// default language from application.php3
		global $modeagenda;							// Agenda display mode
		global $uisetplace;							// Agenda Specific place
		
		if(!isset($this->language) || empty($this->language))			
			$this->language = $defaultlang;
		
		if(isset($langCookie))					// check if language var comes from cookie
			$this->language = $langCookie;

		if(isset($formlang))
		{
			$this->language = $formlang;	// check if language comes from form
			@setcookie("langCookie" , $this->language);
			unset($formlang); // to avoid calling setcookie twice
		}
		
		if(!isset($uisetplace))
					$this->placeid = 0;
		else	$this->placeid = $uisetplace;

		if(!isset($modeagenda))
					$this->modeagenda = "search";
		else	$this->modeagenda = $modeagenda;
			
		debug("modeagenda = ".$this->modeagenda);
		switch($this->modeagenda)
		{
			case	"search" : 	$this->includepage = "agenda".$pagesuffix."2.php3"; break;
			case	"about" : 	$this->includepage = "about.".$this->language.".php3"; break;
			case	"calendar":	$this->includepage = "calendar.php3"; break;
			
			default :  $this->includepage = $pageprefix."agenda2.php3"; break;
		}
	}
	
	function DisplayLangSelect()
	{
		// Display Language selection list box
		global $strSelectLang , $langCookie;
		echo $strSelectLang;
		echo "  <select name='formlang' onChange='OnSubmit()'>";
		echo option_language($this->language);
		echo "</select>";		
	}
	
	function DisplayLeftMenu()
	{
		// Display Left Menu
		
		global $ME, $strAbout, $strSearch, $strSoon, $strCalendar;
		
		echo "<table width='100%' border='0' cellspacing='0' cellpadding='2'>\n";
		echo "  <tr>\n";
    echo "    <td class=tdmenu nowrap><a href='$ME?modeagenda=about'>$strAbout</a></td>\n";
		echo "	</tr>\n";
		echo "  <tr>\n";
    echo "    <td class=tdmenu nowrap><a href='$ME?modeagenda=search'>$strSearch</a></td>\n";
		echo "	</tr>\n";
		echo "  <tr>\n";
    echo "    <td class=tdmenu nowrap><a href='$ME?modeagenda=soon'>$strSoon</a></td>\n";
		echo "	</tr>\n";
		echo "  <tr>\n";
    echo "    <td class=tdmenu nowrap><a href='$ME?modeagenda=calendar'>$strCalendar</a></td>\n";
		echo "	</tr>\n";
		echo "</table>\n";
	}
	
	function InitCalendar()
	{
		$this->Calendar = new CCalendar;
		$this->Calendar->Init($this->language);
		$this->Calendar->SetPlace($this->placeid);
	}
	
	function InitSearch($mode = "search")
	{
		$this->Search = new CSearch;
		$this->Search->Init($mode);
		$this->Search->SetPlace($this->placeid);
	}
	
	function InitSingleEvent()
	{
		$this->Single = new CSingleEvent;
		$this->Single->Init($this->language);
	}
}

class CSearch
{
  // this class manage search over the database
  // 05/04/2001 Manu vanneau mvanneau@hotmail.com
  
	var $language			       = "english";	// Display language
	var $recherche           = 0;         // doing some search ? 0=false, 1=true
	var $edge                = 0;         // current display starts at $edge
	var $numevents           = 0;         // number of events founds
	var $result              = "";        // search results
	var $mode                = "search";    // search mode ("soon": retrieve next events since today, 
																				//							"search" : display search engine
	var $placeid						 = 0;					// specific place to search
	var $orgaid							 = 0;					// specific orga to search

  // list boxes
  var $limit_option        = "";  // limit result listbox
  var $orderby_option      = "";  // orderby listbox
  var $contact_option      = "";  // contact listbox
  var $place_option        = "";  // place listbox
  var $year_end_option     = "";  // year end listbox
  var $year_option         = "";  // year listbox
  var $month_end_option    = "";  // month end listbox
  var $month_option        = "";  // month listbox
  var $type_option         = "";  // event type listbox
  
  // filter variables
  var $orderby             = "";  // orderby filter
  var $limit               = 10;  // limit result
  var $selectyear          = "";  // year filter
  var $selectyearend       = "";  // yearend filter
  var $selectcontact       = "";  // contact filter
  var $selectplace         = "";  // place filter
  var $selectmonth         = "";  // month filter
  var $selectmonthend      = "";  // month end filter
  var $selecttype          = "";  // event type filter

  function Init()
  {
    // Init search class with variables passed thru the form
    
    // Get global variable from form
    global $limit, $recherche, $edge, $orderby,$selectmonth, $selectyear, $selectmonthend, $selectyearend;
    global $selecttype, $selectplace, $selectcontact, $modeagenda, $language;
    
  	
	  if(isset($modeagenda))
  	  $this->mode = $modeagenda;

	  if(isset($language))
  	  $this->language = $language;
  
    if(!isset($limit))
		  $this->limit = 10;
		else
		  $this->limit = $limit;
	
  	if(!isset($recherche))
  	{
  		// if recherche is NOT defined, we initialize object with default value
  		$this->recherche			= 0;
  	  $this->edge           = "";
  	  $this->orderby        = "";
  	  $this->selectmonth    = "";
  	  $this->selectyear     = "";
  	  $this->selectmonthend = "";
  	  $this->selectyearend  = "";
  	  $this->selecttype     = "";
  	  $this->selectplace    = "";
  	  $this->selectcontact  = "";
  	  $this->limit					= 10;
  		debug   ("recherche NOT defined");
  	}
  	else
  	{
  		// if recherche is defined, we initialize object with global values
  		$this->recherche			= $recherche;
  	  $this->edge           = $edge;
  	  $this->orderby        = $orderby;
  	  $this->selectmonth    = $selectmonth;
  	  $this->selectyear     = $selectyear;
  	  $this->selectmonthend = $selectyear;
  	  $this->selectyearend  = $selectyearend;
  	  $this->selecttype     = $selectyearend;
  	  $this->selectplace    = $selectyearend;
  	  $this->selectcontact  = $selectyearend;
  	  $this->limit					= $limit;
  		debug   ("recherche defined");
  	}  
  }

	function SetPlace($placeid = 0)
	{
		$this->placeid = $placeid; 
		$this->selectplace	= $this->placeid;
	}

	function SetOrganizer($orgaid = 0)
	{
		$this->orgaid = $orgaid; 
		$this->selectcontact	= $this->orgaid;
	}
  
	function DisplaySearchEngine()
	{
		// Display Search Engine
		// written in a table 
		// uses form 'entryform' that must be present in the template page
		
		global $ME, $CFG, $selecttype;
    global $strSearch , $strType , $strBetween, $strAnd , $strPlace, $strOrganizer , $strOrder, $strDisplay, $strResultBy;
    global $strExplain, $strSearch2, $strHelp, $strTitle, $strDate;

  	// Get eventtypes from db and put them into a listbox
  	$this->type_option    = "<select name=\"selecttype\">"
  	                    . "<option value=''> </option>"
  	                    . db_listbox("SELECT id, type FROM $CFG->table_eventtype ORDER BY type",$this->selecttype)
  	                    . "</select>";
  
  	// format month select and put them into a listbox
   	$this->month_option   = "<select name=\"selectmonth\">"
  	                      . "<option value=''></option>"
  												. option_month($this->selectmonth , $this->language)
  												. "</select>";
  	
  	// format month select for end of date and put them into a listbox
  	$this->month_end_option= "<select name=\"selectmonthend\">"
  	                      . "<option value=''></option>"
  												. option_month($this->selectmonthend , $this->language)
  												. "</select>";
  	
  	
  	// format year select and put them into a listbox
  	$this->year_option    = "<select name=\"selectyear\">"
  	                      . "<option value=''></option>"
  												.	option_year($this->selectyear , 2000 , 2010)
  												. "</select>";
  	
  	// format year select for end of date and put them into a listbox
  	$this->year_end_option = "<select name=\"selectyearend\">"
  	                      . "<option value=''></option>"
  												.	option_year($this->selectyearend , 2000 , 2010)
  												. "</select>";
  												
  	// Get places from db and put them into a listbox
  	$this->place_option		= "<select name=\"selectplace\">"
  	                      . "<option value=''></option>";
		if($this->placeid)	  	
			$this->place_option	.=	db_listbox("SELECT id, name FROM $CFG->table_place WHERE id='$this->placeid' ORDER BY name" , $this->placeid). "</select>";
		else
			$this->place_option	.=	db_listbox("SELECT id , name FROM $CFG->table_place ORDER BY name" , $this->selectplace). "</select>";
  												
  
  	// Get contacts from db and put them into a listbox
  	$this->contact_option	= "<select name=\"selectcontact\">"
  	                      . "<option value=''></option>";
		if($this->orgaid)	  	
  		$this->contact_option .=	db_listbox("SELECT id, name FROM $CFG->table_contact WHERE id='$this->orgaid' ORDER BY name" , $this->orgaid). "</select>";
		else
  		$this->contact_option .=	db_listbox("SELECT id, name FROM $CFG->table_contact ORDER BY name" , $this->selectcontact). "</select>";
  												
    // Fill "order by" listbox 
    $this->orderby_option        = "<select name='orderby'><option value=''";
  	if($this->orderby == "") 		
  				$this->orderby_option .= " selected ";
  	$this->orderby_option 			.=  "> &nbsp;</option><option value='type'";
   	if($this->orderby == "type") 
  				$this->orderby_option .= " selected ";
    $this->orderby_option 			.= ">$strType</option><option value='title'";
   	if($this->orderby == "title") 
  				$this->orderby_option .= " selected ";
    $this->orderby_option 			.= ">$strTitle</option><option value='start'";
     	if($this->orderby == "start") 
  				$this->orderby_option .= " selected ";
    $this->orderby_option 			.= ">$strDate</option></select>";
    
   	// Fill "limit" list box
   	debug ("limit = ".$this->limit);
    $this->limit_option       	 = "<select name='limit'><option value='5'";
  	if($this->limit == 5) 		
  				$this->limit_option   .= " selected ";
  	$this->limit_option 				.=  ">5</option><option value='10'";
   	if($this->limit == 10) 
  				$this->limit_option 	.= " selected ";
    $this->limit_option 				.= ">10</option><option value='20'";
   	if($this->limit == 20) 
  				$this->limit_option 	.= " selected ";
    $this->limit_option 				.= ">20</option></select>";		
    

    // Display all this information into a table
    echo "<table class=border width='100%' border='0' cellspacing='3' cellpadding='2'>";
    echo "<tr><td><table width='100%' border='0' cellspacing='0' cellpadding='2'>";
    echo "  <tr class=tdsearch>";
    echo "    <td width='2%' valign='top'>$strSearch</td>";
    echo "    <td>";
    echo "      <table border='0' cellspacing='0' cellpadding='0' width='100%'>";
    echo "        <tr>";
    echo "          <td height='106'>"; 
    echo "            <table border='0' cellspacing='0' cellpadding='1' width='100%'>";
    echo "              <tr class=calendar_today>";
    echo "                <td>";
    echo "                  <table border='0' cellspacing='0' cellpadding='1' width='100%'>";
    echo "                    <tr>"; 
    echo "                      <td class=normal_search width='100' nowrap><div align='right'>$strType</div></td>";
    echo "                      <td class=normal_search nowrap>&nbsp;&nbsp;$this->type_option</td>";
    echo "                    </tr>";
    echo "                    <tr>";
    echo "                      <td class=normal_search width='100' nowrap><div align='right'>$strBetween</div></td>";
    echo "                      <td class=normal_search nowrap>&nbsp;&nbsp;$this->month_option $this->year_option $strAnd $this->month_end_option $this->year_end_option &nbsp;</td>";
    echo "                    </tr>";
    echo "                    <tr> ";
    echo "                      <td class=normal_search width='100' nowrap><div align='right'>$strPlace</div></td>";
    echo "                      <td class=normal_search nowrap>&nbsp;&nbsp;$this->place_option</td>";
    echo "                    </tr>";
    echo "                    <tr>";
    echo "                      <td class=normal_search width='100' nowrap><div align='right'>$strOrganizer</div></td>";
    echo "                      <td class=normal_search nowrap>&nbsp;&nbsp;$this->contact_option</td>";
    echo "                    </tr>";
    echo "                    <tr> ";
    echo "                      <td class=normal_search width='100' nowrap><div align='right'>$strOrder</div></td>";
    echo "                      <td class=normal_search nowrap valign='middle'>&nbsp;";
    echo "                        $this->orderby_option &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    echo "                        $strDisplay $this->limit_option $strResultBy</td>";
    echo "                    </tr>";
    echo "                  </table>";
    echo "                </td>";
    echo "              </tr>";
    echo "            </table>";
    echo "          </td>";
    echo "        </tr>";
    echo "      </table>";
    echo "    </td>";
    echo "    <td class=tdsearch valign='top'>";
    echo "      <p>$strExplain</p>";
    echo "      <p align='center'>";
    echo "        <a href='javascript:Submitedge(0);'> ";
    echo "        <img alt='Search'  src='images/search2.gif' width='37' height='37' border='0' align='absmiddle'>&nbsp;$strSearch2</a><br>";
    echo "        <a href='$ME?modeagenda=about#moteur'><img alt='Help' src='images/helpagenda2.gif' width='27' height='28' border='0' align='absmiddle'> ";
    echo "        $strHelp</a>";
    echo "      </p>";
    echo "    </td>";
    echo "  </tr>";
    echo "</table></td></tr></table>";
	}
	
	function DisplayNumEvent()
	{
	  // Display number of events found
    global $strResult, $strEventsFound, $strEventFound, $strDisp, $strTo, $strPrevPage, $strNextPage, $strNotFound, $rootagenda; 
    if($this->recherche)
    {
      if($this->numevents)
  		{
  			echo $strResult." : "; 
  			echo "<b>$this->numevents</b> ";
  			if($this->numevents > 1)
          echo $strEventsFound;
        else
        	echo $strEventFound;
  
        echo "<br>$strDisp <b>";
        echo $this->edge+1;
        echo "</b> $strTo <b>";
        if($this->numevents > $this->edge+$this->limit)
          echo $this->edge+$this->limit;
        else
          echo $this->numevents;
        echo "</b><br>";
        
        echo "<div align='center'>";
        if($this->edge >= $this->limit)
        {
            $newedge = $this->edge - $this->limit;
            echo "<a href='javascript:Submitedge($newedge);'>$strPrevPage</a> ";
        }
        $total_page = $this->numevents / $this->limit;
        if($total_page >= 1)
        	for($i=1 ; $i<=$total_page+1 ; $i++)
	        {
	            $newedge = ($i-1) * $this->limit;
	            if($newedge != $this->edge) 
	            	echo "<a href='javascript:Submitedge($newedge);'>$i</a> ";
	            else echo "$i ";
	        }
        if($this->numevents > ($this->edge + $this->limit))
        {
            $newedge = $this->edge + $this->limit;
            echo " <a href='javascript:Submitedge($newedge);'>$strNextPage</a>";
        }
        echo "</div>";
      }
      else
       echo $strNotFound;
    }
    else
      echo "&nbsp;";
	}
	
	function DisplayResults()
	{
	  global $strSoon, $rootagenda, $CFG, $strOrganizer, $strMoreInfo  ;
	  if($this->mode == "soon")
      echo "<td class=comingsoon>$strSoon<br>&nbsp;</td>";
    
		include("admin/include/events.inc.php3");
		// main table
    echo "<table width='100%' border='0' cellspacing='0' cellpadding='0'>";
    echo "  <tr align='center'>"; 
    echo "    <td>";
    if($this->edge != "")
    	$index = $this->edge;
    else
    	$index = 0;
    while ($r = db_fetch_object($this->result))
    {
			  if($r->image != "")
			  {
			  	$r->image = $CFG->image_event_dir."/".$r->image;
			  	if(is_file($r->image))
			  	{
			  		$size = getimagesize($r->image);
				  	$size = limit_image_size($size , $CFG->limit_image_display_x , $CFG->limit_image_display_y);
				  	$r->imagex = $size[0];
				  	$r->imagey = $size[1];
				  }
				  else
				  {
				  	$r->imagex = $CFG->limit_image_display_x;
				  	$r->imagey = $CFG->limit_image_display_y;
				  }
			  }
 
    	$index++;
      echo " <table border='0' cellspacing='0' cellpadding='1' width='100%'>";
			echo "  <tr>";
			echo "    <td width='".$CFG->limit_image_display_x."'>";
			if($r->image != "")
				echo "<a href='".$r->image."' target='_blank'><img alt=' ' src='".$r->image."' width='".$r->imagex."' height='".$r->imagey."' border=0></a>";
			else
				echo "&nbsp;";
			echo "	</td>";
			echo "  <td>";
      echo " 	<table border='0' cellspacing='0' cellpadding='1' width='100%'>";
      echo "   	<tr class=result_title> ";
      echo "      <td colspan='2'>$index. <a href='javascript:Open(\"".$rootagenda."infoevent.php3?id=$r->id&language=$this->language\")'>";
      echo pv($r->title)."</a>&nbsp;</td>";
      echo "    </tr>";
      echo "    <tr class=result_type> ";
      echo "    	<td colspan='2'>";
      echo pv($r->type)."&nbsp;</td>";
      echo "    </tr>";
      echo "    <tr class=result_description> ";
      echo "    	<td height='15' colspan='2'>";
      echo pv($r->description)."&nbsp;</td>";
      echo "    </tr>";
      $qidate = db_query("SELECT start, end, place.name FROM $CFG->table_date,$CFG->table_place WHERE date.place = place.id AND date.event = '$r->id' GROUP BY date.start ORDER BY date.start");
			echo "    <tr>";
      echo "    	<td colspan='2'> ";
      echo "    		<table width='100%' border='0' cellspacing='0' cellpadding='0'>";
      echo "        	<tr>";
 			if(db_num_rows($qidate) > 0)
 			{
	      echo "        	<td colspan='2' height='19'>";
	      echo "          	<table width='100%' border='0' cellspacing='0' cellpadding='0'>";
	      while($dates  = db_fetch_object($qidate))
	      {
					echo "<tr><td class=result_description width='50%' nowrap>".dispdate($dates->start , $dates->end , $this->language)."&nbsp;</td>";
	    		echo "<td class=result_description> at &nbsp;&nbsp;&nbsp;$dates->name</td></tr>";
	    	}
	    	db_free_result($qidate);
	      
	      echo "            </table>";
	      echo "          </td>";
      }
      echo "        </td>";
      echo "      </tr>";
      echo "    	<tr>";
      echo "      	<td class=result_description width='89%'>"; 
      $query = "SELECT name FROM $CFG->table_contact WHERE ";
      $contact = array(1=>$r->contact1 , $r->contact2 , $r->contact3 , $r->contact4 , $r->contact5);
			$i = 0;
			for($n=1 ; $n<=5 ; $n++)
			{
				if($contact[$n])
				{
					$i++;
					$query .= "id = '$contact[$n]' ";
					if($n<5 && $contact[$n+1])
						$query .= " OR ";
				}
			}
			if($i)
			{
				$qicon = db_query($query);
				echo $strOrganizer." : ";
				for($z=0 ; $z<$i ; $z++)
				{
					$con = db_fetch_array($qicon);
					echo $con["name"];
					if($z<$i-1)
						echo " | ";
				}	
				db_free_result($qicon);
			}
			echo "          </td>";
      echo "          <td class=result_description width='11%'>";
      echo "          	<div align='right'><a href='javascript:Open(\"".$rootagenda."infoevent.php3?id=$r->id&language=$this->language\")'>$strMoreInfo</a></div>";
      echo "          </td>";
      echo "        </tr>";
      echo "      </table>";
      echo "    </td>";
      echo "  </tr>";
      echo "  <tr><td height='20' colspan='2' valign='top'><hr  size='1'></td></tr>";
      echo "  </tr>";
      echo "</table>";
			echo "</tr>";
    }
    echo "    </td>";
    echo "  </tr>";
    echo "</table>";
    db_free_result($this->result);
	}
	
	function DoSearchSoon()
	{
		global $CFG;
	  $req_listevents  = "SELECT e.id , e.title, e.image, e.description, e.contact1, e.contact2, e.contact3, e.contact4, e.contact5 , t.type , d.start 
													FROM   $CFG->table_event e, $CFG->table_eventtype t , $CFG->table_date d 
													WHERE  t.id = e.type 
													AND d.event = e.id 
													AND d.start >= NOW() ";
		if($this->placeid)
			$req_listevents .= "AND d.place = $this->placeid ";
		$req_listevents 	.= "GROUP BY e.id ORDER BY d.start ASC
													LIMIT 0 , 5 ";
		debug("listing request = $req_listevents");
		$this->result  = db_query($req_listevents);
  }

	function DoSearchAgenda()
	{
	  debug   ("modeagenda = search");
	
		global $CFG;
		if(empty($this->edge))
		{
		  $this->edge = 0;
		}
		
		if(!empty($this->selectmonth))
		 $monthstart = $this->selectmonth;
		else
		 $monthstart = 1;
		
		if(!empty($this->selectyear))
		 $yearstart = $this->selectyear;
		else
		 $yearstart = "1900";
	
		if(!empty($this->selectmonthend))
		 $monthend = $this->selectmonthend;
		else
		 $monthend = 12;
		
		if(!empty($this->selectyearend))
		 $yearend = $this->selectyearend;
		else
		 $yearend = "2100";
	
		$selectdate = !empty($this->selectyear) || !empty($this->selectmonth) || !empty($this->selectyearend) || !empty($this->selectmonthend);
		
		// format the query
		$req_listevents 		 = "SELECT e.id , e.image , e.title, e.description, e.contact1, e.contact2, e.contact3, e.contact4, e.contact5, t.type ";
		if($selectdate || $this->orderby == "start")
			$req_listevents 	.= ", d.start ";
		if($this->selectplace)
			$req_listevents 	.= ", p.name ";
		$req_listevents			.= "FROM   $CFG->table_event e, $CFG->table_eventtype t ";
		if($selectdate || $this->orderby == "start" || $this->selectplace)
			$req_listevents 	.= ", $CFG->table_date d ";
		if($this->selectplace)
			$req_listevents 	.= ", $CFG->table_place p ";
		$req_listevents 		.= "WHERE  t.id = e.type ";
		        	 
		if(!empty($this->selecttype))
		  $req_listevents .= " AND e.type=$this->selecttype ";
		
		
		if($selectdate || $this->orderby == "start")
		{
		    $date    = formatSQLdate($yearstart , $monthstart , 1);
		    $dateend = formatSQLdate($yearend , $monthend , 31);
		    $req_listevents .= " AND d.event = e.id AND d.start >='$date' AND d.start <='$dateend'";
		}
		
		if(!empty($this->selectplace))
		 $req_listevents .= " AND p.id = $this->selectplace AND d.place = $this->selectplace AND d.event = e.id ";
	
		if(!empty($this->selectcontact))
		 $req_listevents .= " AND (	e.contact1=$this->selectcontact OR 
		 														e.contact2=$this->selectcontact OR 
		 														e.contact3=$this->selectcontact OR 
		 														e.contact4=$this->selectcontact OR 
		 														e.contact5=$this->selectcontact) ";
		 
		$req_listevents .= " GROUP BY e.id ";

		if($this->orderby)
		{
		 	$req_listevents .= " ORDER BY ".$this->orderby." ASC";
		}
		debug("listing request = $req_listevents");
		// do the query
		$qidnum    = db_query($req_listevents);
		$this->numevents = db_num_rows($qidnum);
		db_free_result($qidnum);
		$this->result       = db_query($req_listevents." LIMIT $this->edge, $this->limit");
	}
	
  function DoSearch()
  {
    debug("modeagenda(Dosearch) = ".$this->mode);
    switch($this->mode)
    {
      case "search" : if($this->recherche == 1)
                        $this->DoSearchAgenda(); 
                      break;
      case "soon"   : $this->DoSearchSoon(); break;
			default : break;
    }
  }

	function DoSoon()
	{
	  $req_listevents 		 = "SELECT e.id , e.title, e.description, e.contact1, e.contact2, e.contact3, e.contact4, e.contact5 , t.type , d.start 
													FROM   events e, eventtype t , date d 
													WHERE  t.id = e.type 
													AND d.event = e.id 
													AND d.start >= NOW() 
													ORDER BY d.start ASC
													LIMIT 0 , 5";
    $soon = 1;
		debug("listing request = $req_listevents");
		$qid  = db_query($req_listevents);

	}
}

class CCalendar
{
  // this class manage calendar display
  // 05/04/2001 Manu vanneau mvanneau@hotmail.com


	var $today 				= 0;					// Today index
	var $month 				= 1;					// Month (january by default)
	var $year  				= 2001;				// Year (2001 by default)
	var $days	 				= 31;					// number of day in $month;
	var $dayone				= 1;					// first day index (Sunday = 0, ...)
	var $daylast			= 7;					// last day index (Sunday = 0,...)
	var	$size 				= "reduced"; 	// select 'reduced' / 'expanded' calendar display
	var $selectedday 	= 0;					// current selected day
	var $language			= "english";	// Display language
	var $eventtext 		= "";					// Event text for reduced calendar
	var $datetext			= "";					// Date text for reduced calendar
	var $placeid			= 0;					// specific place to search

	function Init($language = "english")
	{
		// Initialize calendar 
		global $selectedday , $month , $year , $size;

		if(!isset($selectedday))
			$selectedday = 0;

	  if(isset($month) && isset($year))
	   $datime = mktime(1,1,1,$month,1,$year);
	  else
	   $datime = time();
	
	  if(!isset($month))
	    $month = date("n",$datime);
	  if(!isset($year))
	    $year = date("Y",$datime);
	
		$this->month 		 = $month;
		$this->year  		 = $year;
		$this->selectedday = $selectedday;
		$this->language	 = $language;
			
	  $time  = time();
	  if($this->month != date("n",$time) || $this->year != date("Y",$time))
	   $this->today = 0;
	  else
	   $this->today = date("j", $time);
	
	  if ( (($this->month < 8) && ($this->month % 2 == 1)) || (($this->month > 7) && ($this->month % 2 == 0)) )
	    $this->days = 31;
	  if ( (($this->month < 8) && ($this->month % 2 == 0)) || (($this->month > 7) && ($this->month % 2 == 1)) )
	    $this->days = 30;
	  if ($this->month == 2)
	    $this->days = (date("L",$datime)) ? 29 : 28;
	
	  $this->dayone = date("w",mktime(1,1,1,$this->month,1,$this->year));
	  $this->daylast = date("w",mktime(1,1,1,$this->month,$this->days,$this->year));
	
		if(!isset($size))
			$this->size = "reduced";
		else
			$this->size = $size;
	}
		
	function SetPlace($placeid = 0)
	{
		$this->placeid = $placeid; 
	}

	function DisplayMonthOption()
	{
		// Display option box filled with months. this->month is selected			
		global $defaultbgcolor;
  	echo "<select name=\"month\" onChange='OnSubmit2()' bgcolor='$defaultbgcolor'>
	       <option value=''></option>".
				 option_month($this->month)."
				 </select>";
	}
	
	function DisplayYearOption()
	{
		// Display option box filled with years. this->year is selected			
  	echo "<select name=\"year\" onChange='OnSubmit2()'>
	        <option value=''></option>".
					option_year($this->year , $this->year-5 , $this->year+5)."
					</select>";
	}	
	
	function DisplayReducedCalendar($language)
	{
		// display reduced calendar
		// generate a table with day organized by weeks
		
		// global variables
		global $daylist , $monthlist , $ME, $CFG;
		
		// display month and year list box + day labels
		echo "<table border='0' cellpadding='0' cellspacing='0' width='200' height='115'>\n";
    echo "	<tr>\n";
		echo "		<td colspan='7' valign='middle' align='center'>\n";
		$this->DisplayMonthOption(); 
		$this->DisplayYearOption();
		echo "		</td>\n";
    echo "	</tr>\n";
    echo "	<tr>\n";
    echo "		<td class=Calendar_title width='15%'>".limit_text($daylist[1] , 3 , '')."</td>";
    echo "		<td class=Calendar_title width='15%'>".limit_text($daylist[2] , 3 , '')."</td>";
    echo "		<td class=Calendar_title width='15%'>".limit_text($daylist[3] , 3 , '')."</td>";
    echo "		<td class=Calendar_title width='15%'>".limit_text($daylist[4] , 3 , '')."</td>";
    echo "		<td class=Calendar_title width='15%'>".limit_text($daylist[5] , 3 , '')."</td>";
    echo "		<td class=Calendar_title width='15%'>".limit_text($daylist[6] , 3 , '')."</td>";
    echo "		<td class=Calendar_title width='15%'>".limit_text($daylist[7] , 3 , '')."</td>";
   
    // calculate the span for the first day
    $span1 = 0;
  	$span2 = 0;
  	if($this->dayone != 0)
  	  $span1 = $this->dayone;
	  if(6 - $this->daylast != 0)
	    $span2 = 6 - $this->daylast;
	
		$this->eventtext = "";
	
	  // for each day of this month
	  for($i = 1; $i <= $this->days; $i++)
	  {
	    // get the day index for this date
	    $dayofweek = date("w",mktime(1,1,1,$this->month,$i,$this->year));
	    $width = "14%";
	
	    if($dayofweek == 0 || $dayofweek == 6)
	      $width = "15%";
	
			// format date using formatSQLdate in stdlib.php3
			$date    = formatSQLdate($this->year , $this->month , $i , 23 , 59);
			$dateend = formatSQLdate($this->year , $this->month , $i);
			$req_listevents = "SELECT e.id ,e.title, t.type,d.start,d.end
    									 FROM   $CFG->table_event e, $CFG->table_eventtype t , $CFG->table_date d 
											 WHERE  t.id = e.type 
											 AND 		d.event = e.id AND d.start<='$date' AND d.end >='$dateend'";
			if($this->placeid)
				$req_listevents .= " AND d.place = $this->placeid ";
	  	
	  	$qid = db_query($req_listevents);
			$eventonday = db_num_rows($qid);
	
	    // Select the class style to display this day
	    $class = "td_calendar";
	    if($i == $this->today)
	  	  $class = "calendar_today";
	    
	    if($eventonday)
	  	  $class = "calendar_usedday";

	    if($i == $this->selectedday)
	    {
	      // if this day has been selected by user, retrieve events for this day
	  	  $class = "calendar_selday";
				$num=0; 
				while ($r = db_fetch_object($qid)) 
				{
					if($num)
						$this->eventtext .= "<hr size=1>";
					$this->eventtext .= "$r->type : <a href='infoevent.php3?id=$r->id' target='_blank'>$r->title</a>"; 
					$num++;
				}
				$this->datetext = $daylist[$dayofweek+1]." $i ".$monthlist[$this->month]." $this->year";  		
	    }
	
	    if($i == 1 || $dayofweek == 0)
	    {
	      echo " <tr>\n";
	      if($span1 > 0 && $i == 1)
	        echo "  <td colspan=\"$span1\"><font face=\"null\"></td>\n";
	    }
	
	    if($this->selectedday == $i)
	     $nextselect = 0;
	    else
	     $nextselect = $i;
	     
	
      echo "<td class=$class width='$width' align='center'>";
      echo "<a href=$ME?modeagenda=calendar&selectedday=$nextselect&month=$this->month&year=$this->year>";
      echo $i."</td>";

	    if($i == $this->days)
      {
      	if($span2 > 0)
        	echo "  <td colspan=\"$span1\"></td>\n";
	    }
	    if($dayofweek == 6 || $i == $this->days)
	      echo " </tr>\n";
	  }
		echo "</table>";   
	}
	
	function DisplayLegend()
	{
    // display calendar legend
		// generate a table
		
		global $strToday , $strSelDay ,$strEventDay;
		
		echo "<table width='100%' border='0' cellspacing='0' cellpadding='2'>";
    echo "	<tr>";
    echo "		<td class=calendar_today width='8%'>&nbsp;</td>";
    echo "		<td class=normal width='92%' >$strToday</td>";
    echo "	</tr>";
    echo "	<tr>";
		echo "		<td class=calendar_selday width='8%'>&nbsp; </td>";
		echo "		<td class=normal width='92%' >$strSelDay</td>";
    echo "  </tr>";
		echo "	<tr>";
		echo "		<td class=calendar_usedday width='8%'>&nbsp; </td>";
		echo "		<td class=normal width='92%' >$strEventDay</td>";
		echo "	</tr>";
		echo "</table>";
	}
	
	function DisplayExpandedCalendar()
	{
    // display expanded calendar
		// generate a table with day as a list
		
		global $daylist , $monthlist, $ME, $CFG;
		
		// display month and year list box + day labels
    echo "<table border='0' cellpadding='0' cellspacing='2' width='100%'>";
    echo "<tr>";
    echo "	<td colspan='9' valign='middle' align='center' height='12'>";
    echo "		<font face='Arial, Helvetica, sans-serif' size='3'><b>";
 		$this->DisplayMonthOption(); 
		$this->DisplayYearOption();
		echo "</b></td>";
    echo "</tr>";

    // for each day of the selected month
	  for($i = 1; $i <= $this->days; $i++)
	  {
	    // get the day index for this date
  	  $dayofweek = date('w',mktime(1,1,1,$this->month,$i,$this->year));
    	$width = '14%';

    	if($dayofweek == 0 || $dayofweek == 6)
      	$width = '15%';

	    // Select the class style to display this day
	    $class = "Calendar_title";
	    if($i == $this->today)
	  	  $class = "calendar_today";
	    
		  if($this->selectedday == $i)
	     $nextselect = 0;
	    else
	     $nextselect = $i;
	     
			// format date using formatSQLdate in stdlib.php3
			$date    = formatSQLdate($this->year , $this->month , $i , 23 , 59);
			$dateend = formatSQLdate($this->year , $this->month , $i);
	    $req_listevents = "SELECT e.id , e.title, t.type,d.start,d.end
	    									FROM   $CFG->table_event e, $CFG->table_eventtype t , $CFG->table_date d 
  										  WHERE  t.id = e.type AND 	d.event = e.id AND d.start<='$date' AND d.end >='$dateend'";
 			if($this->placeid)
				$req_listevents .= " AND d.place = $this->placeid ";
	    $qid = db_query($req_listevents);
   									 
		
      // display day + eventtext if some
      echo "  <tr> ";
      echo "		<td class=Calendar_title width='5%'>".limit_text($daylist[$dayofweek+1] , 3 , '')."</td>";
      echo "    <td class=$class width='5%'>$i</td>";
      echo "    <td class=tdCalendar_text width='90%'>";
      $num=0; 
      while ($r = db_fetch_object($qid)) 
      {
      	if($num)
      		echo "<hr size=1>";
      	echo "$r->type : <a href='infoevent.php3?id=$r->id' target='_blank'>";
      	echo pv($r->title);
      	echo "</a>"; 
      	$num++;
      }
			echo "    </td>";
			echo "  </tr>";
		}
		echo "</table>";

	}
}


endif;

$agendauser = 1;								// set phpMyAgenda to user mode
include ("application.php3");		// phpMyAgenda configuration vars
$UI = new CVisitorUI;
if(!isset($pagesuffix))
	$pagesuffix = "";
$UI->Init($pagesuffix);
include("lang/$UI->language.lang.php3");	// language definition


?>


