<?php
######################################################
# PPN Software
# PPN Topsites Freeware 2.0
#
# This script can be freely modified at owners risk
# we will not provide support for modified versions.
# The copyright must remain intact at all time.
# This script may not be re-distributed via any
# meduim electronic or physical.
# Violations will result in immediate termination
# of the license.
#
##### [freeware] #####
#
# Scott MacVicar
# software@pp-network.com
# (c) 2000-2002
######################################################

unset($db);
unset($content);
require("./modules/config.php");
require("./db.php");

//first lets chose the type of variables
//lets load query string
$get = explode(";", $HTTP_SERVER_VARS["QUERY_STRING"]);
foreach($get as $var => $value) {
  $array = explode("=", $value);
  $get_vars["$array[0]"] = $array[1];
}
$post_vars = $HTTP_POST_VARS;
$cookie_vars = $HTTP_COOKIE_VARS;
$server_vars = $HTTP_SERVER_VARS;

//this is a stupid mistake by me o_O
$PHP_SELF = $server_vars["PHP_SELF"];

// Get the Users IP
if($server_vars['HTTP_CLIENT_IP']) {
  $local_address = $server_vars['HTTP_CLIENT_IP'];
}
elseif($server_vars['HTTP_X_FORWARDED_FOR']) {
  $local_address = $server_vars['HTTP_X_FORWARDED_FOR'];
}
else {
  $local_address = $server_vars['REMOTE_ADDR'];
}
//lets load the functions we need
require("./modules/functions.php");

//lets connect to the database
$db = new db;

$db->server=$config["server"];
$db->user=$config["user"];
$db->password=$config["pass"];
$db->database=$config["database"];
$db->user_table=$config["user_table"];
$db->config_table=$config["config_table"];
$db->ip_table=$config["ip_table"];
$db->connect();

//clear database array plus password in the class
$db->password="";
unset($config["user"]);
unset($config["pass"]);

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "DTD/xhtml1- transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<title>PPN Topsites Freeware 2.0 - Install</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<style type="text/css">
body {
  FONT-WEIGHT: normal;
  FONT-SIZE: 8pt;
  TEXT-TRANSFORM: none;
  COLOR: #ffffff;
  FONT-FAMILY: Verdana;
  SCROLLBAR-BASE-COLOR: #003964;
  background-color: navy;
  TEXT-DECORATION: none
}
input {
  BORDER-RIGHT: orange 1px solid;
  PADDING-RIGHT: 1px;
  BORDER-TOP: orange 1px solid;
  PADDING-LEFT: 1px;
  FONT-WEIGHT: normal;
  FONT-SIZE: 10pt;
  PADDING-BOTTOM: 1px;
  TEXT-TRANSFORM: none;
  BORDER-LEFT: orange 1px solid;
  COLOR: #ffffff;
  PADDING-TOP: 1px;
  BORDER-BOTTOM: orange 1px solid;
  FONT-STYLE: normal;
  FONT-FAMILY: Verdana;
  BACKGROUND-COLOR: transparent;
  FONT-VARIANT: normal;
  TEXT-DECORATION: none
}
A:hover {
  TEXT-TRANSFORM: none;
  COLOR: orange;
  FONT-STYLE: normal;
  FONT-FAMILY: Verdana;
  FONT-VARIANT: normal;
  TEXT-DECORATION: none
}
A {
  TEXT-TRANSFORM: none;
  COLOR: #FFFFFF;
  FONT-STYLE: normal;
  FONT-VARIANT: normal;
  TEXT-DECORATION: none
}
A:visited {
  FONT-FAMILY: Verdana
}
</style>
</head>
<?

if(empty($get_vars['step']) or $get_vars['step'] == "") {
  $get_vars['step'] = 1;
}

if($get_vars['step'] == 1) {
  $db->error_report=0;
  if($db->query_first("DESRIBE ".$db->config_table)) {
    echo "<p align=\"center\">The topsites is already installed.</p>\n";
    echo "<p align=\"center\">Exiting install.</p>";
  }
  else {
    echo "<p align=\"center\">This is the setup script for PPN Topsites, click the link below to install.</p>\n";
    echo "<p align=\"center\"><a href=\"$PHP_SELF?step=2\">Install</a></p>\n";
  }
}

if($get_vars['step'] == 2) {
  echo "<p>Beginning to create tables</p>";

  $query[]="CREATE TABLE `".$db->config_table."` (
  `varid` int(5) NOT NULL auto_increment,
  `varname` varchar(50) NOT NULL default '0',
  `varvalue` mediumtext NOT NULL,
  PRIMARY KEY  (`varid`)
  ) TYPE=MyISAM;";
  $action[]="Creating ".$db->config_table;

  $query[]="CREATE TABLE `".$db->user_table."` (
  `id` int(5) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `desc` varchar(200) NOT NULL default '',
  `url` varchar(100) NOT NULL default '',
  `email` varchar(100) NOT NULL default '',
  `banner` varchar(100) NOT NULL default '',
  `pass` varchar(32) NOT NULL default '',
  `rank` smallint(4) NOT NULL default '0',
  `lastrank` smallint(4) NOT NULL default '0',
  `joincycles` smallint(1) NOT NULL default '1',
  `newpasstime` int(10) NOT NULL default '0',
  `newpasshash` varchar(32) NOT NULL default '',
  `status` varchar(6) NOT NULL default '1',
  `av` int(5) NOT NULL default '0',
  `h1` smallint(5) NOT NULL default '0',
  `h2` smallint(5) NOT NULL default '0',
  `h3` smallint(5) NOT NULL default '0',
  `h4` smallint(5) NOT NULL default '0',
  `h5` smallint(5) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `id` (`id`)
) TYPE=MyISAM;";
  $action[]="Creating ".$db->user_table;
  
  doqueries();
  
  echo "<p align=\"center\">Verifying Table Creation</p>";
  $db->error_report=0;
  if($db->query_first("DESCRIBE ".$db->config_table)) {
    echo "<p align=\"center\">".$db->config_table." exists</p>\n";
  }
  else {
    $error = 1;
    echo "<p align=\"center\">".$db->config_table." <b>does not</b> exist</p>\n";
  }
  if($db->query_first("DESCRIBE ".$db->user_table)) {
    echo "<p align=\"center\">".$db->user_table." exists</p>\n";
  }
  else {
    $error = 1;
    echo "<p align=\"center\">".$db->user_table." <b>does not</b> exist</p>\n";
  }

  if($error) {
    echo "<p align=\"center\">Errors were detected please retry install.</p>\n";    
  } else {
    echo "<p align=\"center\"><a href=\"$PHP_SELF?step=3\">Next Step</a></p>";    
  }
  
}

if($get_vars['step'] == 3) {
  echo "<p align=\"center\">Populating Config Table</p>";
  $query[]="INSERT INTO `".$db->config_table."` VALUES (1, 'tname', 'PPN');";
  $query[]="INSERT INTO `".$db->config_table."` VALUES (2, 'tdesc', 'Dev');";
  $query[]="INSERT INTO `".$db->config_table."` VALUES (3, 'trank', '25');";
  $query[]="INSERT INTO `".$db->config_table."` VALUES (4, 'rerank', 'daily');";
  $query[]="INSERT INTO `".$db->config_table."` VALUES (5, 'mode', '3');";
  $query[]="INSERT INTO `".$db->config_table."` VALUES (6, 'gateway', '1');";
  $query[]="INSERT INTO `".$db->config_table."` VALUES (7, 'siteurl', 'http://$server_vars[HTTP_HOST]/');";
  $query[]="INSERT INTO `".$db->config_table."` VALUES (8, 'banner_url', 'http://vforest.hypermart.net/topsites/topimages');";
  $query[]="INSERT INTO `".$db->config_table."` VALUES (9, 'custom_banners', '20');";
  $query[]="INSERT INTO `".$db->config_table."` VALUES (10, 'buttonshow', '5');";
  $query[]="INSERT INTO `".$db->config_table."` VALUES (11, 'banner_ext', 'gif');";
  $query[]="INSERT INTO `".$db->config_table."` VALUES (12, 'mail_functions', '1');";
  $query[]="INSERT INTO `".$db->config_table."` VALUES (13, 'adminemail', 'admin@topsites.com');";
  $query[]="INSERT INTO `".$db->config_table."` VALUES (15, 'creation_time', '1');";
  $query[]="INSERT INTO `".$db->config_table."` VALUES (16, 'version', 'Freeware 2.0 RC 2');";
  $query[]="INSERT INTO `".$db->config_table."` VALUES (17, 'banip', '');";
  $query[]="INSERT INTO `".$db->config_table."` VALUES (19, 'mem_aproval', '1');";
  $query[]="INSERT INTO `".$db->config_table."` VALUES (21, 'status', '1');";
  $query[]="INSERT INTO `".$db->config_table."` VALUES (23, 'cron', '0');";
  $reset = time();
  $query[]="INSERT INTO `".$db->config_table."` VALUES (24, 'lastupdate', '$reset');";
  doqueries();
  echo "<p align=\"center\"><a href=\"$PHP_SELF?step=4\">Next Step</a></p>";
}

if($get_vars['step'] == 4) {
  echo "<p align=\"center\">Please provide an admin password:<br /><form action=\"$PHP_SELF?step=5\" method=\"post\">\n";
  echo "Admin Pass:<input type=\"password\" name=\"pass\" />\n";
  echo "<br /><input type=\"submit\" name=\"button\" value=\"Set Password\" /><input type=\"reset\" value=\"Reset Form\" />\n";
  echo "</form></p>";
}

if($get_vars['step'] == 5) {
  if(empty($post_vars['pass'])) {
    echo "<p align=\"center\">Please push the back button on your browser and fill in a password.</p>\n";
    exit;
  }
  $db->query("INSERT INTO `".$db->config_table."` VALUES (20, 'pass', '".md5(trim($post_vars['pass']))."');");
  echo "<p align=\"center\">Password entered, view your admin panel <a href=\"admin.php\">here</a></p>\n";
  echo "<p align=\"center\">Please now remove install.php and any upgradeX.php scripts.</p>\n";
  echo "<img src=\"http://software.pp-network.com/installed.php?license=freeware\" height=\"0\" width=\"0\" alt=\"\" />\n";
}

function doqueries() {
  global $query,$action,$db;
  while (list($key,$val)=each($query)) {
    echo"<p align=\"center\">$action[$key]</p>\n";
    flush();
    $db->query($val);
  }
  unset ($query);
  unset ($action);
}

?>