<?php
######################################################
# PPN Software
# PPN Topsites Freeware 2.0
#
# This script can be freely modified at owners risk
# we will not provide support for modified versions.
# The copyright must remain intact at all time.
# This script may not be re-distributed via any
# meduim electronic or physical.
# Violations will result in immediate termination
# of the licence.
#
##### [freeware] #####
#
# Scott MacVicar
# software@pp-network.com
# (c) 2000-2002
######################################################

class db {

  var $server   = "localhost";
  var $user     = "root";
  var $database = "database";
  var $password = "password";
  var $user_table = "ppn_topsites";
  var $config_table = "ppn_config";
  var $link_id  = 0;
  var $query_id = 0;
  var $error_report = 0;

  function connect() {
    if ( 0 == $this->link_id ) {
      if ($this->password=="") {
        $this->link_id=mysql_connect($this->server,$this->user);
      } else {
        $this->link_id=mysql_connect($this->server,$this->user,$this->password);
      }
      if (!$this->link_id) {
        $this->error("Link-ID == false, connect failed");
      }
      if ($this->database!="") {
        if(!mysql_select_db($this->database, $this->link_id)) {
          $this->error("cannot use database ".$this->database);
        }
      }
    }
  }

  function query($query_string) {
    global $query_count;
    $query_count++;
    $this->query_id = mysql_query($query_string,$this->link_id);
    if (!$this->query_id) {
      $this->error("Invalid SQL: ".$query_string);
    }
    return $this->query_id;
  }

  function fetch_array($query_id=-1,$query_string="") {
    // retrieve row
    if ($query_id!=-1) {
      $this->query_id=$query_id;
    }
    if ( isset($this->query_id) ) {
      $this->record = @mysql_fetch_array($this->query_id);
    } else {
      if ( !empty($query_string) ) {
        $this->error("Invalid query id (".$this->query_id.") on this query: $query_string");
      } else {
        $this->error("Invalid query id ".$this->query_id." specified");
      }
    }

    return $this->record;
  }

  function query_first($query_string) {
    // does a query and returns first row
    $query_id = $this->query($query_string);
    $returnarray=$this->fetch_array($query_id, $query_string);
    $this->free_result($query_id);
    return $returnarray;
  }

  function free_result($query_id) {
    return @mysql_free_result($query_id);
  }

  function num_rows($query_id) {
    return mysql_num_rows($query_id);
  }

  function insert_id($post_vars) {
    //mysql allows us to get the last auto inc column so we can ignore what was entered
    return mysql_insert_id();
  }

  function num_fields($query_id) {
    return mysql_num_fields($query_id);
  }

  function close() {
   if($this->link_id) {
     mysql_close($this->link_id);
   }
  }

  function error($error) {
    if($this->error_report == 1) {
      $error .= "<!-- ".mysql_error()."-->";
      error("database_problem, $error");
    }
  }
  ###############################
  # GLOBAL FUNCTIONS
  ###############################
  function load_vars() {
    return $this->query("SELECT * FROM ".$this->config_table." ORDER BY varid");
  }

  function totalmembers() {
    return $this->query_first("SELECT count(*) as members FROM ".$this->user_table);
  }

  function getrandomsite() {
    return $this->query_first("SELECT id, url FROM ".$this->user_table." ORDER BY RAND()");
  }

  function update_settings($key, $value) {
    return $this->query("UPDATE ".$this->config_table." SET varvalue='$value' WHERE varname='$key'");
  }
  ###############################
  # SINGLE MEMBER FUNCTIONS
  ###############################

  function getuserinfo($column, $value, $select="*") {
    return $this->query_first("SELECT $select FROM ".$this->user_table." WHERE `$column`='$value'");
  }

  function edituserinfo($id, $infoarray) {
    foreach ($infoarray as $key => $value) {
      $i++;
      if($i != 1) { $query .= ","; }
      $query .= "`$key`" . "='".addslashes($value)."'";
    }
    return $this->query("UPDATE ".$this->user_table." SET $query WHERE id='$id'");
  }

  function adduser($infoarray) {
    global $ppn_vars;
    return $this->query("INSERT INTO ".$this->user_table." (`id`, `name`, `desc`, `url`, `email`, `banner`, `pass`, `status`) VALUES (NULL, '$infoarray[name]', '$infoarray[desc]', '$infoarray[url]', '$infoarray[email]', '$infoarray[banner]', '$infoarray[pass]', '$ppn_vars[mem_aproval]')");
  }

  function remuser($id) {
    return $this->query("DELETE FROM ".$this->user_table." WHERE id='$id'");
  }

  function getuserid($id) {
    return mysql_insert_id($this->link_id);
  }

  function load_members ($sort, $column, $start="", $end="", $clause="") {
    if($start!='' and $end!='') {
      $limitsql = " LIMIT $start, $end";
    }
    return $this->query("SELECT $column FROM ".$this->user_table." $clause ORDER BY $sort DESC $limitsql");
  }

  function getuserid ($email) {
    return $this->query("SELECT * FROM ".$this->user_table." WHERE email='".addslashes($email)."' ORDER BY id ASC");
  }
  ###############################
  # Increment Hits
  ###############################
  function increasehit($id, $type) {
    return $this->query("UPDATE ".$this->user_table." SET $type=$type+1 WHERE id='$id'");
  }
  function update_stats() {
    return $this->query("UPDATE ".$this->user_table." SET av=(h1+h2+h3+h4+h5)/joincycles");
  }
  ###############################
  # Search
  ###############################
  function search_format($kw) {
    return " AND (INSTR(LCASE(`desc`),'$kw')>0 OR INSTR(LCASE(`name`),'$kw')>0)";
  }
  function do_search($querysql) {
    $query = $this->query("SELECT * FROM ".$this->user_table." WHERE 1=1$querysql ORDER BY rank ASC");
    while($result = $this->fetch_array($query)) {
      $results[] = $result;
    }
    return $results;
  }
  ###############################
  # Reset List
  ###############################
  function resetlist() {
    global $ppn_vars;
    switch($ppn_vars['rerank']) {
      case "weekly"; $update = $ppn_vars['lastupdate']+604800; break;

      case "monthly";
        $hours = date("G", $ppn_vars['lastupdate']);
        $month = date("n", $ppn_vars['lastupdate']);
        $year = date("Y", $ppn_vars['lastupdate']);
        $day = date("j", $ppn_vars['lastupdate']);
        $month++;
        if($day) {
          $day = "1";
        } else {
          $day = "0";
        }
        $update = date("U", mktime ($hours,0,0,$month, $day, $year));
      break;

      default: $update = $ppn_vars['lastupdate']+86400; break;
    }
    $this->update_settings("lastupdate",addslashes($update));
    $this->query("UPDATE ".$this->user_table." SET lastrank=rank,h5=h4, h4=h3, h3=h2, h2=h1, h1=0, uh5=uh4, uh4=uh3, uh3=uh2, uh2=uh1, uh1=0, oh5=oh4, oh4=oh3, oh3=oh2, oh2=oh1, oh1=0, joincycles=joincycles+1");
    $this->query("UPDATE ".$this->user_table." SET joincycles=5 WHERE joincycles>5");
  }
  ###############################
  # Backup
  ###############################
  function backup ($table) {
    $tabledump .= "#\n# Table structure for table `$table`\n#\n\n";

    $tabledump .= "DROP TABLE IF EXISTS $table;\n";
    $tabledump .= "CREATE TABLE $table (\n";

    $firstfield=1;

    // get columns and spec
    $fields = $this->query("SHOW FIELDS FROM $table");
    while ($field = $this->fetch_array($fields)) {
      if (!$firstfield) {
        $tabledump .= ",\n";
      } else {
        $firstfield=0;
      }
      $tabledump .= "   $field[Field] $field[Type]";
      if (!empty($field["Default"])) {
        // get default value
        $tabledump .= " DEFAULT '$field[Default]'";
      }
      if ($field[Null] != "YES") {
        // can field be null
        $tabledump .= " NOT NULL";
      }
      if ($field[Extra] != "") {
        // any extra info?
        $tabledump .= " $field[Extra]";
      }
    }
    $this->free_result($fields);

    // get keys list
    $keys = $this->query("SHOW KEYS FROM $table");
    while ($key = $this->fetch_array($keys)) {
      $kname=$key['Key_name'];
      if ($kname != "PRIMARY" and $key['Non_unique'] == 0) {
        $kname="UNIQUE|$kname";
      }
      if(!is_array($index[$kname])) {
        $index[$kname] = array();
      }
      $index[$kname][] = $key['Column_name'];
    }
    $this->free_result($keys);

    // get each key info
    while(list($kname, $columns) = @each($index)){
      $tabledump .= ",\n";
      $colnames=implode($columns,",");

      if($kname == "PRIMARY"){
        // do primary key
        $tabledump .= "   PRIMARY KEY ($colnames)";
      } else {
        // do standard key
        if (substr($kname,0,6) == "UNIQUE") {
          // key is unique
          $kname=substr($kname,7);
        }

        $tabledump .= "   KEY $kname ($colnames)";

      }
    }

    $tabledump .= "\n);\n\n";

    // get data
    $rows = $this->query("SELECT * FROM $table");
    $numfields=$this->num_fields($rows);
    $tabledump .="#\n# Dumping data for table `$table`\n#\n\n";

    while ($row = $this->fetch_array($rows)) {
      $tabledump .= "INSERT INTO $table VALUES(";

      $fieldcounter=-1;
      $firstfield=1;
      // get each field's data
      while (++$fieldcounter<$numfields) {
        if (!$firstfield) {
          $tabledump.=",";
        } else {
          $firstfield=0;
        }

        if (!isset($row[$fieldcounter])) {
          $tabledump .= "NULL";
        } else {
          $tabledump .= "'".addslashes($row[$fieldcounter])."'";
        }
      }

      $tabledump .= ");\n";
    }
    $tabledump .= "# --------------------------------------------------------\n\n";

    $this->free_result($rows);

    return $tabledump;
  }
}

?>