<?php

/*
** DGS Search
** config.php written by James M. Sella
** Copyright (c) 2000-2001 Digital Genesis Software, LLC. All Rights Reserved.
** Released under the GPL Version 2 License.
** http://www.digitalgenesis.com
*/

/* Change options below as needed. */

   /* General Options */

   $config['installBase']       = "$root"; /* Where the package was installed. */
   $config['searchModules']     = array('db');                          /* Modules to search for results. Available: fs and db. */
   $config['displayModules']    = array('title', 'query', 'stats', 'hr', 'nav', 'results', 'nav'); /* Modules to display results. */
   $config['language']          = 'turkish';                            /* Language pack to use. Set english, german, or spanish. */
   $config['fileSeparator']     = '/';                                  /* Would be '\\' for Win9x/NT/2000. */
   $config['target']            = '_self';                              /* The TARGET used for links on Result page. */
   $config['fonts']             = 'Verdana, Arial, Tahoma';       /* Fonts to be used on the Display Results page. */
   $config['headerColor']       = '666699';                             /* The color of the header on the Display Results page. */
   $config['navColor']          = '008000';                             /* The color of the Navigation sections on the Display Results page. */
   $config['infoBarColor']      = '008000';                             /* The color of the Info Bar sections on the Display Results page. */
   $config['infoBar']           = true;                                 /* Display Info Bar for search results on Display Results page. */
   $config['infoBarFormat']     = '@URL@ @DASH-SIZE@ @SIZE2@ @DASH-LASTMOD@ @LASTMOD@'; /* Format of Info Bar on Display Results page. */
   $config['dateFormat']        = 'M j, Y H:i:s';                       /* Date format for Last Modified on Display Results. */
   $config['results']           = 10;                                   /* Default results per page. 0 is unlimited. */
   $config['boldQuery']         = true;                                 /* Bold the query string in description. */
   $config['timed']             = true;                                 /* Displays search time to user. */
   $config['maxSearchTime']     = 25;                                   /* The max amount of time to spend within the fs module. Set 0 to disable. */
   $config['translate']         = true;                                 /* Displays a 'Translate' link for each result. */
   $config['translateFrom']     = 'en_de';                              /* Sets the default translation to be preformed. See INSTALL. */
   $config['verifyConfig']      = true;                                 /* Verifies config file. Set false for a small speed increase. */
   $config['warn']              = true;                                 /* Displays warnings (ie: SAFE MODE warnings). */
   $config['debug']             = false;                                /* Displays a lot of slightly useful or annoying information. */
   $config['remoteDebug']       = false;                                /* Allows debugging to be enabled via a browser. See INSTALL. */

   /* Filesystem Options -- Search module 'fs' */

   $config['urlBase']           = $root_url;                 /* The base URL for your site. */
   $config['siteBase']          = $root;           /* The directory that directly coresponds to 'urlBase'. */
   $config['fsBase']            = $root;           /* Where we should begin searching the filesystem. */
   $config['fsExclude']         = array('^\.ht', '^dgssearch$');        /* Files or directories in fsbase to exclude. Regex supported. */
   $config['cacheFile']         = '/tmp/dgssearch.cache';               /* Cache file for files to search. Speeds up searches. */
   $config['cacheTTL']          = 3600;                                 /* Cache file time to live (TTL) in second. Set 0 to disable. */
   $config['maxFileSize']       = 51200;                                /* The max file size to search in bytes. */
   $config['metaDesc']          = false;                                /* If true, prefer the META description over content descriptions. */
   $config['stripTags']         = true;                                 /* If HTML and PHP tags should be striped from fs searches. */
   $config['followLinks']       = true;                                 /* If SymLinks should be followed. Ignored on WinNT. */
   $config['frameSet']          = false;                                /* Handle auto-generated frameset layout schemes. See INSTALL. */
   $config['exts']              = array('s?html?', 'php3?', 'txt');     /* The extentions to inlcude in search. Set '' for all. Regex supported. */
   $config['docExts']           = array('pdf', 'doc', 'ps');            /* Doc extensions to link to instead of HTML/txt files, if avail. See INSTALL.  */
   $config['descWidth']         = 80;                                   /* The width of the desc on the results page. */
   $config['descHeight']        = 2;                                    /* The number of desc lines on the results page. */
   $config['descEnd']           = '...';                                /* Added to beginning and end of descriptions. */

   /* Database Options -- Search module 'db' */

   /* NOTE: Module 'db' must be specified in $config['searchModules'] to enable database searches. See INSTALL for documentation. */

   $database[0]['type']         = 'mysql';                              /* Supports mysql, pgsql, mssql, ibase and odbc. See INSTALL for special instructions. */
   $database[0]['server']       = $dbhost;                          /* The SQL Server. (Ignored by ODBC). */
   $database[0]['port']         = 0;                                    /* Database port. Set 0 for default port. */
   $database[0]['username']     = $dbuser;                           /* Username to connect to database. */
   $database[0]['password']     = $dbpass;                           /* Password to connect to database. */
   $database[0]['database']     = $dbname;                           /* The database or DSN you will be accessing. */
   $database[0]['persistent']   = true;                                 /* Use persistent database connections. */
   $database[0]['table']        = array('dcp_contents');                         /* The table in database to search. */
   $database[0]['tableAssoc']   = '';                                   /* If multiple tables listed, is used to join the tables. See INSTALL. */
   $database[0]['searchField']  = array('header', 'content', 'writer');             /* The fields to search. */
   $database[0]['returnField']  = array('id', 'header', 'content');       /* Fields returned from db. Can be used to sub into link, url and desc. */
   $database[0]['link']         = '@1@';                       /* The link used for results. */
   $database[0]['url']          = "$root_url/contents.php?id=@0@";/* The URL used for display the data from your database. */
   $database[0]['desc']         = array(' @2@.');    /* The description to display. */
   $database[0]['descWidth']    = 100;                                   /* The width of the desc for this entry. Set to 0 to disable. */
   $database[0]['wildcard']     = 'both';                               /* Wildcard support: none, left, right or both */
   $database[0]['orderByDepth'] = -1;                                   /* OrderBy Depth. Default of -1 is all. See INSTALL. */
   $database[0]['forceLower']   = false;                                /* Forces a case-insensitive search by lowercasing everything. */

/* Empty Database Template (For searching another table or database. You can add as many as you want.) */

   $database[1]['type']         = 'mysql';
   $database[1]['server']       = $dbhost;
   $database[1]['port']         = 0;
   $database[1]['username']     = $dbuser;
   $database[1]['password']     = $dbpass;
   $database[1]['database']     = $dbname;
   $database[1]['persistent']   = true;
   $database[1]['table']        = array('dcp_haberler');
   $database[1]['tableAssoc']   = '';
   $database[1]['searchField']  = array('baslik', 'icerik');
   $database[1]['returnField']  = array('id', 'baslik', 'icerik');
   $database[1]['link']         = '@1@';
   $database[1]['url']          = "$root_url/news.php?#@0@";
   $database[1]['desc']         = array(' @2@');
   $database[1]['descWidth']    = 80;
   $database[1]['wildcard']     = 'both';
   $database[1]['orderByDepth'] = -1;
   $database[1]['forceLower']   = false;

/* Constants - Usually no need to change options below.  */

   /* Generic */
   $config['program']           = 'Arama Sonular';
   $config['version']           = 'DCP-Portal v3.0';
   $config['maxResults']        = 65535;

   /* FindExt() - utils.php */
   $config['extSeparator']      = '.';
   $config['thisDir']           = '.';
   $config['parentDir']         = '..';

?>