<?php

/**
 * File: weblink_functions.php provides functions for weblink module
 *
 * These functions take care of everthing that does not have to do with
 * directly editing a link. They provide listings of links for the user
 * and admin, and other admin funtionality
 *
 * @author Steven Levin	<steven@tux.appstate.edu>
 * @module weblink
 * @modulegroup core
 * @package phpWebSite
 */



/**
 * Provides the layout for the main admin page
 *
 * @author Steven Levin <steven@tux.appstate.edu>
 * @param none
 * @return none
 */

function main_layout() {
	global $current_link;

	back_to_admin();
	$current_link = new weblink;
	$current_link->add_link();
	admin_buttons();
}


/**
 * List links by category for the admin side
 *
 * This function is called as a result of pressing the
 * view current links button.
 *
 * @author Steven Levin <steven@tux.appstate.edu>
 * @param none
 * @return none
 */

function list_links() {
	global $table_prefix;

	$link_result = mysql_query("SELECT lid FROM " . $table_prefix . "mod_weblink_data WHERE new='0'");
	$num_rows = mysql_num_rows($link_result);

	$box_title = "TRANSLATE[[Link(s) Currently In Database]]";

	if($num_rows == 0)	$content = "TRANSLATE[[There are no links in the database.]]<br /><br />";

	$cid_result = mysql_query("SELECT cid, cat FROM " . $table_prefix . "mod_weblink_cat WHERE cid=pid ORDER BY cat ASC");
	while(list($cid, $cat) = mysql_fetch_row($cid_result)) {	/* listing each main category(categories are defined as main if their cid and pid are equal) */
		$blockquote_open = "";
		$blockquote_closed = "";
		$content .= "<b>TRANSLATE[[Main Category]]:</b>&nbsp;$cat<br />";

		$cat = addslashes($cat);
		$link_result = mysql_query("SELECT * FROM " . $table_prefix . "mod_weblink_data WHERE new='0' AND category='$cat' ORDER BY title");
		if(mysql_num_rows($link_result)) {
			while($row = mysql_fetch_object($link_result)) {
				$content .= "TRANSLATE[[Page Title]]:
				<a href=\"./mod.php?mod=weblink&amp;op=view_link&amp;edit_link=$row->lid\">" . $row->title . "</a>
				TRANSLATE[[Page URL]]:" . $row->url . "<br />";
			} 
		} else $content .= "TRANSLATE[[There are no links in this category.]]<br />";
		$content .= $blockquote_closed;
		$content .= "<hr />";


		$result = mysql_query("SELECT cid, pid, cat FROM " . $table_prefix . "mod_weblink_cat WHERE pid='$cid' AND pid!=cid ORDER BY cat ASC");
		while(list($this_cid, $pid, $cat) = mysql_fetch_row($result)) {		/* listing subcategories(subcategories have thier pid set to the cid of their parent */
			$blockquote_open = "<blockquote>";
			$blockquote_closed = "</blockquote>";
			$content .= $blockquote_open . "<b>TRANSLATE[[Sub-Category]]:</b>&nbsp;$cat<br />";

			/* listing the links for the current category */
			$cat = addslashes($cat);
			$link_result = mysql_query("SELECT * FROM " . $table_prefix . "mod_weblink_data WHERE new='0' AND category='$cat' ORDER BY title");
			if(mysql_num_rows($link_result)) {
				while($row = mysql_fetch_object($link_result)) {
					$content .= "TRANSLATE[[Page Title]]:
					<a href=\"./mod.php?mod=weblink&amp;op=view_link&amp;edit_link=$row->lid\">" . $row->title . "</a>
					TRANSLATE[[Page URL]]:" . $row->url . "<br />";
				} 
			} else $content .= "TRANSLATE[[There are no links in this category.]]<br />";
			$content .= $blockquote_closed;
			$content .= "<hr />";		
		}
	}
	thememainbox($box_title, $content);

	echo "
	<form method=\"post\" action=\"mod.php\">
	<input type=\"hidden\" name=\"mod\" value=\"weblink\" />
	<input type=\"hidden\" name=\"op\" value=\"admin_buttons\" />
		<input type=\"submit\" name=\"back\" value=\"Voltar\" />
	</form>";
}


/**
 * Lists incoming links to be accepted or declined by admin
 *
 * @author Steven Levin <steven@tux.appstate.edu>
 * @param none
 * @return none
 */

function incoming_links() {
	global $table_prefix;

	$title = "TRANSLATE[[Incoming Links]]";

	$incoming_links = mysql_query("SELECT * FROM " . $table_prefix . "mod_weblink_data WHERE new='1'");

	if(mysql_num_rows($incoming_links)) {
		$i = 0;
		while($row = mysql_fetch_object($incoming_links)) {
			$i++;
			$weblink = "weblink" . $i;
			$$weblink = new weblink;
			$$weblink->set_all_data($row->lid, $row->title, $row->url, $row->description, $row->name, $row->email, $row->date, $row->category, $row->hits, $row->new);
			$content .= $$weblink->accept_weblink();
		}

	} else $content = "TRANSLATE[[There are no incoming links]].";

	thememainbox($title, $content);

	echo "
	<form method=\"post\" action=\"mod.php\">
	<input type=\"hidden\" name=\"mod\" value=\"weblink\" />
	<input type=\"hidden\" name=\"op\" value=\"admin_buttons\" />
		<input type=\"submit\" name=\"back\" value=\"Voltar\" />
	</form>";
}


/**
 * Provides the edit page for admins to edit or add categories
 *
 * @author Steven Levin <steven@tux.appstate.edu>
 * @param none
 * @return none
 */

function categories($back, $main_cat, $add_cat, $add_subcat, $description) {
	global $table_prefix;

	$title = "Adicionar uma Categoria Principal";
  
	$content = "
	<form method=\"post\" action=\"mod.php\">
	<input type=\"hidden\" name=\"mod\" value=\"weblink\" />
	<input type=\"hidden\" name=\"op\" value=\"categories\" />";

	if($back) 	$content .= "<input type=\"hidden\" name=\"back\" value=\"1\" />";

	$content .= "
		Nome: <input type=\"text\" name=\"add_cat\""; if(!$main_cat) $content .= " value=\"$add_cat\" ";
		$content .= "size=\"20\" maxlength=\"100\" /><br />
		Descrio:<br /> <textarea name=\"description\" rows=\"5\" cols=\"40\" wrap=\"virtual\">";
		if(!$main_cat)	$content .= $description;
		$content .= "</textarea>
		<input type=\"submit\" value=\"Adicionar\" />
	</form>";

	thememainbox($title, $content);

	$title = "Adicionar uma Sub-Categoria";
  
	$content = "
	<form method=\"post\" action=\"mod.php\">
	<input type=\"hidden\" name=\"mod\" value=\"weblink\" />
	<input type=\"hidden\" name=\"op\" value=\"categories\" />
		Nome: <input type=\"text\" name=\"add_subcat\""; if($main_cat) $content .= " value=\"$add_subcat\"";
		$content .= "size=\"20\" maxlength=\"100\" />
		TRANSLATE[[in]]
		<select name=\"main_cat\">\n";

	$result = mysql_query("SELECT cat FROM " . $table_prefix . "mod_weblink_cat WHERE cid=pid ORDER BY cat");
	while(list($cat) = mysql_fetch_row($result)) {
		$content .= "<option value=\"$cat\""; if($cat == $main_cat) $content .= " selected=\"selected\"";
		$content .= ">$cat</option>\n";
	}

	$content .= "
		</select><br />
		Descrio:<br /> <textarea name=\"description\" rows=\"5\" cols=\"40\" wrap=\"virtual\">";
		if($main_cat)	$content .= $description;
		$content .= "</textarea>
		<input type=\"submit\" value=\"Adicionar\" />
	</form>";

	thememainbox($title, $content);

	$title = "Modifica Categoria";
  
	$content = "
	<form method=\"post\" action=\"mod.php\">
	<input type=\"hidden\" name=\"mod\" value=\"weblink\" />
	<input type=\"hidden\" name=\"op\" value=\"categories\" />
		TRANSLATE[[Category]]: 
		<select name=\"mod_cat\">\n";

	$cid_result = mysql_query("SELECT cid, cat FROM " . $table_prefix . "mod_weblink_cat WHERE cid=pid ORDER BY cat ASC");
	while(list($cid, $cat) = mysql_fetch_row($cid_result)) {
	        $content .= "<option value=\"$cat\">$cat</option>\n";
		$main_cat = $cat;
		$result = mysql_query("SELECT cid, pid, cat FROM " . $table_prefix . "mod_weblink_cat WHERE pid='$cid' AND pid!=cid ORDER BY cat ASC");
		while(list($this_cid, $pid, $cat) = mysql_fetch_row($result)) {
		  $content .= "<option value=\"$cat\">$main_cat / $cat</option>\n";
		}
	}

	$content .= "
		</select>
		<input type=\"submit\" name=\"modify_category\" value=\"Modifica\" />
	</form>";

	thememainbox($title, $content);

	echo "
	<form method=\"post\" action=\"mod.php\">
	<input type=\"hidden\" name=\"mod\" value=\"weblink\" />
	<input type=\"hidden\" name=\"op\" value=\"admin_buttons\" />
		<input type=\"submit\" name=\"back\" value=\"Voltar\" />
	</form>";
}


/**
 * Adds a main category to the database
 *
 * @author Steven Levin <steven@tux.appstate.edu>
 * @param string the category that is being added
 * @param string the description of the category
 * @param int flag to go back to adding a link
 * @return none
 */

function add_category($add_cat, $description, $back) {
	global $table_prefix, $current_link;

	$add_cat = stripslashes(FixQuotes(strip_tags($add_cat)));
	$description = stripslashes(FixQuotes(strip_tags($description)));

	$result = mysql_query("SELECT * FROM " . $table_prefix . "mod_weblink_cat WHERE cat='$add_cat'");
	if(mysql_num_rows($result))	exists_error("category");
	else {
		mysql_query("INSERT INTO " . $table_prefix . "mod_weblink_cat (cat, description) VALUES ('$add_cat', '$description')");
		$max_result = mysql_query("SELECT max(cid) FROM " . $table_prefix . "mod_weblink_cat");
		list($pid) = mysql_fetch_row($max_result);
		mysql_query("UPDATE " . $table_prefix . "mod_weblink_cat SET pid='$pid' WHERE cid='$pid'");

		if($back)	$current_link->add_link($add_cat);		/* after add category go back to adding link */
	}
}


/**
 * Adds a sub-category to the database
 *
 * @author Steven Levin <steven@tux.appstate.edu>
 * @param string the main category the subcategory is being put under
 * @param string the subcategory being added
 * @param string the description of the subcategory
 * @return none
 */

function add_subcategory($main_cat, $add_subcat, $description) {
	global $table_prefix;

	$main_cat = stripslashes(FixQuotes(strip_tags($main_cat)));
	$add_subcat = stripslashes(FixQuotes(strip_tags($add_subcat)));
	$description = stripslashes(FixQuotes(strip_tags($description)));

	if($main_cat) {  /* if there is not main category you cannot make a subcategory */

		$result = mysql_query("SELECT * FROM " . $table_prefix . "mod_weblink_cat WHERE cat='$add_subcat'");
		if(mysql_num_rows($result))	exists_error("category");
		else {
			mysql_query("INSERT INTO " . $table_prefix . "mod_weblink_cat (cat, description) VALUES ('$add_subcat', '$description')");
			$pid_result = mysql_query("SELECT cid FROM " . $table_prefix . "mod_weblink_cat WHERE cat='$main_cat'");
			list($pid) = mysql_fetch_row($pid_result);
			$max_result = mysql_query("SELECT max(cid) FROM " . $table_prefix . "mod_weblink_cat");
			list($cid) = mysql_fetch_row($max_result);
			mysql_query("UPDATE " . $table_prefix . "mod_weblink_cat SET pid='$pid' WHERE cid='$cid'");
		}
	}
}


/**
 * Updates the information for a category
 *
 * Updates the information in the category table and in
 * the data table.
 *
 * @author Steven Levin <steven@tux.appstate.edu>
 * @param string the name of the old category
 * @param the new category name
 * @param the new description for the category
 * @return none
 */

function update_category($old_cat, $new_cat, $description) {
	global $table_prefix;

	$old_cat = stripslashes(FixQuotes(strip_tags($old_cat)));
	$new_cat = stripslashes(FixQuotes(strip_tags($new_cat)));
	$description = stripslashes(FixQuotes(strip_tags($description)));

	mysql_query("UPDATE " . $table_prefix . "mod_weblink_cat SET cat='$new_cat', description='$description' WHERE cat='$old_cat'");
	mysql_query("UPDATE " . $table_prefix . "mod_weblink_data SET category='$new_cat' WHERE category='$old_cat'");
}


/**
 * Deletes categories and all links associated
 *
 * @author Steven Levin <steven@tux.appstate.edu>
 * @param string the category to be deleted
 * @return none
 */

function delete_category($old_cat) {
	global $table_prefix;

	$old_cat = stripslashes(FixQuotes(strip_tags($old_cat)));

	$result = mysql_query("SELECT cid FROM " . $table_prefix . "mod_weblink_cat WHERE cat='$old_cat' AND cid=pid");
	if(list($cid) = mysql_fetch_row($result)) {
			
		$result = mysql_query("SELECT cat FROM " . $table_prefix . "mod_weblink_cat WHERE pid='$cid'");
		while(list($cat) = mysql_fetch_row($result)) {
			$cat = addslashes($cat);
			mysql_query("DELETE FROM " . $table_prefix . "mod_weblink_cat WHERE cat='$cat'");
			$link_result = mysql_query("SELECT lid FROM " . $table_prefix . "mod_weblink_data WHERE category='$cat'");
			list($lid) = mysql_fetch_row($link_result);
			remove_attachments($lid);
			mysql_query("DELETE FROM " . $table_prefix . "mod_weblink_data WHERE category='$cat'");
		}

	} else {

		mysql_query("DELETE FROM " . $table_prefix . "mod_weblink_cat WHERE cat='$old_cat'");
		$link_result = mysql_query("SELECT lid FROM " . $table_prefix . "mod_weblink_data WHERE category='$old_cat'");
		list($lid) = mysql_fetch_row($link_result);
		remove_attachments($lid);
		mysql_query("DELETE FROM " . $table_prefix . "mod_weblink_data WHERE category='$old_cat'");
	}
}


/**
 * Allows admins to modify current categories
 *
 * This populates the form with the current calues from the database
 * and allows the admin to modify the values.
 *
 * @author Steven Levin <steven@tux.appstate.edu>
 * @param string the category to be modified
 * @return none
 */

function modify_category($mod_cat) {
	global $table_prefix;

	$result = mysql_query("SELECT description FROM " . $table_prefix . "mod_weblink_cat WHERE cat='$mod_cat'");
	list($description) = mysql_fetch_row($result);

	$title = "Modifica Categoria";

	$mod_cat = stripslashes($mod_cat);

	$content = "
	<form method=\"post\" action=\"mod.php\">
	<input type=\"hidden\" name=\"mod\" value=\"weblink\" />
	<input type=\"hidden\" name=\"op\" value=\"categories\" />
	<input type=\"hidden\" name=\"old_cat\" value=\"$mod_cat\" /><br />
		TRANSLATE[[Edit Category]]: <input type=\"text\" name=\"new_cat\" value=\"$mod_cat\" size=\"25\" /><br />
		Descrio:<br /> 
		<textarea name=\"description\" rows=\"5\" cols=\"40\" wrap=\"virtual\">$description</textarea><br /><br />
		<input type=\"submit\" name=\"update\" value=\"Salvar as mudanas\" />&nbsp;&nbsp;
		<input type=\"submit\" name=\"delete\" value=\"TRANSLATE[[Delete Category]]\" />
	</form>";

	thememainbox($title, $content);
}


/**
 * Confirms with admin they want to delete the category
 *
 * @author Steven Levin <steven@tux.appstate.edu>
 * @param string the category to be deleted
 * @return none
 */

function delete_category_confirm($old_cat) {

	$title = "TRANSLATE[[Delete Category Confirm]]";

	$content = "
	<form method=\"post\" action=\"mod.php\">
	<input type=\"hidden\" name=\"mod\" value=\"weblink\" />
	<input type=\"hidden\" name=\"op\" value=\"categories\" />
		<input type=\"hidden\" name=\"delete\" value=\"1\" />
		<input type=\"hidden\" name=\"old_cat\" value=\"$old_cat\" /><br />
		TRANSLATE[[Are you sure you want to delete this category along with all possible categories and links below it?]]<br /><br />
		<span class=\"onebiggerred\">TRANSLATE[[Submission Decision]]</span><br />
		<input type=\"submit\" name=\"yes\" value=\"Sim\" />&nbsp;&nbsp;
		<input type=\"submit\" name=\"no\" value=\"No\" />
	</form>";

	thememainbox($title, $content);
}


/**
 * Form to edit the weblink settings
 *
 * Populated with the current values from the database
 *
 * @author Steven Levin <steven@tux.appstate.edu>
 * @param none
 * @return none
 */

function settings() {
	global $table_prefix;

	$result = mysql_query("SELECT link_list, top_list, new_list, search_list, user_add, show_hits, show_date, new_win FROM " . $table_prefix . "mod_weblink_cfg");
	list($link_list, $top_list, $new_list, $search_list, $user_add, $show_hits, $show_date, $new_win) = mysql_fetch_row($result);

	$title = "TRANSLATE[[Edit Settings]]";
 
	$content = "
	<form method=\"post\" action=\"mod.php\">
	<input type=\"hidden\" name=\"mod\" value=\"weblink\" />
	<input type=\"hidden\" name=\"op\" value=\"update_settings\" />
	TRANSLATE[[Links Per Page]]: <input type=\"text\" name=\"link_list\" value=\"$link_list\" size=\"4\" maxlength=\"3\" /><br />
	TRANSLATE[[Top Links]]: <input type=\"text\" name=\"top_list\" value=\"$top_list\" size=\"4\" maxlength=\"3\" /><br />
	Novos Links: <input type=\"text\" name=\"new_list\" value=\"$new_list\" size=\"4\" maxlength=\"3\" /><br />
	TRANSLATE[[Search Results]]: <input type=\"text\" name=\"search_list\" value=\"$search_list\" size=\"4\" maxlength=\"3\" /><br />
	TRANSLATE[[Open Links in New Window]]:
	<select name=\"new_win\">
	<option value=\"false\""; if(!$new_win) $content .= " selected=\"selected\""; $content .= ">No</option>
	<option value=\"true\""; if($new_win) $content .= " selected=\"selected\""; $content .= ">Sim</option>
	</select><br />
	TRANSLATE[[Display Hits]]:
	<select name=\"show_hits\">
	<option value=\"false\""; if(!$show_hits) $content .= " selected=\"selected\""; $content .= ">No</option>
	<option value=\"true\""; if($show_hits) $content .= " selected=\"selected\""; $content .= ">Sim</option>
	</select><br />
	TRANSLATE[[Display Date]]:
	<select name=\"show_date\">
	<option value=\"false\""; if(!$show_date) $content .= " selected=\"selected\""; $content .= ">No</option>
	<option value=\"true\""; if($show_date) $content .= " selected=\"selected\""; $content .= ">Sim</option>
	</select><br />
	TRANSLATE[[Allow User Submits]]:
	<select name=\"user_add\">
	<option value=\"false\""; if(!$user_add) $content .= " selected=\"selected\""; $content .= ">No</option>
	<option value=\"true\""; if($user_add) $content .= " selected=\"selected\""; $content .= ">Sim</option>
	</select><br /><br />
	<input type=\"submit\" value=\"Salvar as mudanas\" />
	</form>";

	thememainbox($title, $content);

	echo "
	<form method=\"post\" action=\"mod.php\">
	<input type=\"hidden\" name=\"mod\" value=\"weblink\" />
	<input type=\"hidden\" name=\"op\" value=\"admin_buttons\" />
		<input type=\"submit\" name=\"back\" value=\"Voltar\" />
	</form>";
}


/**
 * Provides the menu that shows up at the bottom of the main layout
 *
 * @author Steven Levin <steven@tux.appstate.edu>
 * @param none
 * @return none
 */

function admin_buttons() {
	global $table_prefix;

	$title = "TRANSLATE[[Web Link Menu]]";
 
	$content = "
	<form method=\"post\" action=\"mod.php\">
	<input type=\"hidden\" name=\"mod\" value=\"weblink\" />
	<input type=\"hidden\" name=\"op\" value=\"admin_buttons\" />
	<table width=\"100%\" cellpadding=\"10\" cellspacing=\"0\" border=\"0\">
	<tr>
	<td align=\"left\">";

		$link_result = mysql_query("SELECT lid FROM " . $table_prefix . "mod_weblink_data WHERE new='0' ORDER BY lid");
		$num_rows = mysql_num_rows($link_result);

		if($num_rows == 0)	$content .= "TRANSLATE[[There are no links in the database.]]";
		else if($num_rows == 1)	$content .= "TRANSLATE[[There is one link in the database.]]";
		else			$content .= "Existem $num_rows TRANSLATE[[links in the database.]]";

	$content .= "<br />
	<input type=\"submit\" name=\"current\" value=\"TRANSLATE[[View Current Links]]\" />
	</td>

	<td align=\"left\">
	&nbsp;
	</td>

	<td align=\"left\"><br />
	<input type=\"submit\" name=\"categories\" value=\"TRANSLATE[[Edit Categories]]\" />
	</td>
	</tr>

	<tr>
	<td align=\"left\">";

		$inc_result = mysql_query("SELECT * FROM " . $table_prefix . "mod_weblink_data WHERE new='1'");
		$num_rows = mysql_num_rows($inc_result);

		if($num_rows == 0)	$content .= "TRANSLATE[[There are no incoming links]].";
		else if($num_rows == 1)	$content .= "TRANSLATE[[There is one incoming link]].";
		else			$content .= "Existem $num_rows TRANSLATE[[incoming links]].";

	$content .= "<br />
	<input type=\"submit\" name=\"incoming\" value=\"TRANSLATE[[Incoming Links]]\" />
	</td>

	<td align=\"left\">
	&nbsp;
	</td>

	<td align=\"left\"><br />
	<input type=\"submit\" name=\"settings\" value=\"TRANSLATE[[Edit Settings]]\" />
	</td>
	</tr>
	</table>";

	thememainbox($title, $content);
}

/* Attaches a link from a userpage */
function save_attach($lid, $pages)
{
  global $table_prefix;

  for($i=0; $i < sizeof($pages); $i++)
  {
      $result = mysql_query("SELECT weblink_id FROM " . $table_prefix . "mod_userpage_related WHERE page_id='$pages[$i]'");
      list($weblink_id) = mysql_fetch_row($result);
      $weblink_id = unserialize(stripslashes($weblink_id));
      if(!is_array($weblink_id)) $weblink_id = array();
      array_push($weblink_id, $lid);
      $weblink_id = array_unique($weblink_id);
      $weblink_id = addslashes(serialize($weblink_id));
      mysql_query("UPDATE " . $table_prefix . "mod_userpage_related SET weblink_id='$weblink_id' WHERE page_id='$pages[$i]'");

      $result2 = mysql_query("SELECT related FROM " . $table_prefix . "mod_weblink_data WHERE lid='$lid'");
      list($related) = mysql_fetch_row($result2);

      $related = unserialize(stripslashes($related));
      if(!is_array($related)) $related = array();
      array_push($related, $pages[$i]);
      $related = array_unique($related);

      $related = addslashes(serialize($related));
      mysql_query("UPDATE " . $table_prefix . "mod_weblink_data SET related='$related' WHERE lid='$lid'");
  }
}

/* Dettaches a link from a userpage */
function save_dettach($lid, $related_pages)
{
  global $table_prefix;

  for($i=0; $i < sizeof($related_pages); $i++)
  {
    $result = mysql_query("SELECT weblink_id FROM " . $table_prefix . "mod_userpage_related WHERE page_id='$related_pages[$i]'");
    list($weblink_id) = mysql_fetch_row($result);
    $weblink_id = unserialize(stripslashes($weblink_id));
    $temp_index = array_search($lid, $weblink_id);
    array_splice($weblink_id, $temp_index, 1);
    $weblink_id = addslashes(serialize($weblink_id));
    mysql_query("UPDATE " . $table_prefix . "mod_userpage_related SET weblink_id='$weblink_id' WHERE page_id='$related_pages[$i]'");

    $result2 = mysql_query("SELECT related FROM " . $table_prefix . "mod_weblink_data WHERE lid='$lid'");
    list($related) = mysql_fetch_row($result2);

    $related = unserialize(stripslashes($related));
    $temp_index = array_search($related_pages[$i], $related);
    array_splice($related, $temp_index, 1);
    $related = addslashes(serialize($related));

    mysql_query("UPDATE " . $table_prefix . "mod_weblink_data SET related='$related' WHERE lid='$lid'");
  }
}


function remove_attachments($lid){
  global $table_prefix;

  $result = mysql_query("SELECT page_id, weblink_id FROM " . $table_prefix . "mod_userpage_related");
  while(list($page_id, $weblink_id) = mysql_fetch_row($result)){
    $weblink_id = unserialize(stripslashes($weblink_id));
    $temp_index = array_search($lid, $weblink_id);
    array_splice($weblink_id, $temp_index, 1);
    $weblink_id = addslashes(serialize($weblink_id));
    mysql_query("UPDATE " . $table_prefix . "mod_userpage_related SET weblink_id='$weblink_id' WHERE page_id='$page_id'");
  }
}

/**
 * Error message
 *
 * Printed when a link or category is entered that already exists in
 * the database.
 *
 * @author Steven Levin <steven@tux.appstate.edu>
 * @param string the type of error it is, link or category
 * @return none
 */

function exists_error($type) {
	$title = "<font color=\"red\"><b>TRANSLATE[[ERROR]]!!</b></font>";

	if($type == "link") $content = "TRANSLATE[[The link]] ";
	else if($type == "category") $content = "TRANSLATE[[The category]] ";

	$content .= "TRANSLATE[[you just entered already exists in the database.]]<br  />
	TRANSLATE[[You may receive this error as a result of refreshing your browser.]]";

	thememainbox($title, $content);
}


/**
 * Menu for users
 *
 * Provides the user menu that shows up at the bottom of the 
 * main user layout.
 *
 * @author Steven Levin <steven@tux.appstate.edu>
 * @param string except defines the button that does not need to show up on the menu
 * @return none
 */

function user_buttons($except) {
	global $table_prefix;

	$title = "TRANSLATE[[Web Link Navigation]]";

	$result = mysql_query("SELECT user_add FROM " . $table_prefix . "mod_weblink_cfg");
	list($user_add) = mysql_fetch_row($result);

	$content = "
	<form method=\"post\" action=\"mod.php\">
	<input type=\"hidden\" name=\"mod\" value=\"weblink\" />
	<input type=\"hidden\" name=\"op\" value=\"user_buttons\" />
	<table border=\"0\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\">
	<tr>";

	if($except != "main")	$content .= "<td align=\"center\"><input type=\"submit\" name=\"main\" value=\"Links-Principal\" /></td>";
	if($except != "top")	$content .= "<td align=\"center\"><input type=\"submit\" name=\"top_links\" value=\"TRANSLATE[[Top Links]]\" /></td>";
	if($except != "recent")	$content .= "<td align=\"center\"><input type=\"submit\" name=\"recent\" value=\"Novos Links\" /></td>";
	if($user_add)		$content .= "<td align=\"center\"><input type=\"submit\" name=\"user_add\" value=\"TRANSLATE[[Submit A Link]]\" /></td>";

	$content .= "
	</tr>
	</table>
	</form>";

	thememainbox($title, $content);
}


/**
 * Provides the main layout for the user side
 *
 * @author Steven Levin <steven@tux.appstate.edu>
 * @param none
 * @return none
 */

function user_layout() {
	global $table_prefix;

	$title = "TRANSLATE[[Web Link Categories]]";

	$cid_result = mysql_query("SELECT cid, pid, cat, description FROM " . $table_prefix . "mod_weblink_cat WHERE cid=pid ORDER BY cat ASC");
	$i = 0;
	$content = "";
	if(!mysql_num_rows($cid_result))	$content = "TRANSLATE[[There are no categories at this time.]]";
	while(list($cid, $pid, $cat, $description) = mysql_fetch_row($cid_result)) {
		$cat = addslashes($cat);
		$link_result = mysql_query("SELECT lid FROM " . $table_prefix . "mod_weblink_data WHERE category='$cat' AND new='0'");
		$num_links = mysql_num_rows($link_result);
		$cat = stripslashes($cat);
		if($i)	$content .= "<br /><hr /><br />";	/* put a bar in between main categories if one has already been printed */	
		$content .= "<a href=\"./mod.php?mod=weblink&amp;op=view_category&amp;cid=$cid&amp;start_num=0\">$cat</a>&nbsp;($num_links)<br />$description<br />\n";
		$i++;

		$result = mysql_query("SELECT cid, pid, cat, description FROM " . $table_prefix . "mod_weblink_cat WHERE pid='$cid' AND pid!=cid ORDER BY cat ASC");
		while(list($cid, $pid, $cat, $description) = mysql_fetch_row($result)) {

			$cat = addslashes($cat);
			$link_result = mysql_query("SELECT lid FROM " . $table_prefix . "mod_weblink_data WHERE category='$cat' AND new='0'");
			$num_links = mysql_num_rows($link_result);
			$cat = stripslashes($cat);

			$content .= "<blockquote><a href=\"./mod.php?mod=weblink&amp;op=view_category&amp;cid=$cid&amp;start_num=0\">$cat</a>&nbsp;($num_links)<br />$description</blockquote>\n";
		}
	}

	thememainbox($title, $content);

	$title = "TRANSLATE[[Search The Web Link Database]]";

	$content = "<center>
	<form method=\"post\" action=\"mod.php\">
	<input type=\"hidden\" name=\"mod\" value=\"weblink\" />
	<input type=\"hidden\" name=\"op\" value=\"search\" />
	<input type=\"text\" name=\"query\" size=\"25\" />
	<input type=\"submit\" value=\"Search\" />
	</form>";

	$link_result = mysql_query("SELECT lid FROM " . $table_prefix . "mod_weblink_data WHERE new='0' ORDER BY lid");
	$num_rows = mysql_num_rows($link_result);

	if($num_rows == 0)	$content .= "TRANSLATE[[There are no links in the database.]]";
	else if($num_rows == 1)	$content .= "TRANSLATE[[There is one link in the database.]]";
	else			$content .= "Existem $num_rows TRANSLATE[[links in the database.]]";

	$content .= "</center>";

	thememainbox($title, $content);

	user_buttons("main");
}


/**
 * Provides a list of links for the chosen category
 *
 * Builds a navigation bar and then the main content which consists
 * of the links for the specific category.  The navigation bar is placed
 * at the beginning and end of the list.
 *
 * @author Steven Levin <steven@tux.appstate.edu>
 * @param string the category which is to be viewed
 * @param int where to start listing from(part of control for how many links are listed per page
 * @return none
 */

function view_category($cid, $start_num) {
	global $table_prefix, $previous;

	$this_cid = $cid;

	$result = mysql_query("SELECT link_list, show_hits, show_date, new_win FROM " . $table_prefix . "mod_weblink_cfg");
	list($list_num, $show_hits, $show_date, $new_win) = mysql_fetch_row($result);

	$result = mysql_query("SELECT pid, cat, description FROM " . $table_prefix . "mod_weblink_cat WHERE cid='$cid'");
	list($pid, $cat, $description) = mysql_fetch_row($result);

	/* building the navigation bar */
	if($cid == $pid) {	/* this is for a main category */
		$navigation = "
		<table border=\"0\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\">
		<tr>
		<td width=\"70%\" valign=\"top\">
		TRANSLATE[[You are here]]:
		<a href=\"./mod.php?mod=weblink\">Principal</a>&nbsp;&gt;&nbsp;$cat<br />
		$description
		</td>
		<td width=\"30%\" valign=\"top\">\n";

		/* the main category navigation must list its sub categories */
		$result = mysql_query("SELECT cid, cat FROM " . $table_prefix . "mod_weblink_cat WHERE pid='$cid' AND cid!=pid");
		if(!mysql_num_rows($result))	$navigation .= "&nbsp;";
		else {
			$navigation .= "TRANSLATE[[More Links]]:<ul type=\"disc\">\n";
			while(list($sub_cid, $sub_cat) = mysql_fetch_row($result)) {
				$navigation .= "<li><a href=\"./mod.php?mod=weblink&amp;op=view_category&amp;cid=$sub_cid&amp;start_num=0\">$sub_cat</a></li>\n";
			}
			$navigation .= "</ul>";
		}
		$navigation .= "</td></tr></table>";

	} else {	/* this is for a subcategory */

		$result = mysql_query("SELECT cat FROM " . $table_prefix . "mod_weblink_cat WHERE cid='$pid'");
		list($main_cat) = mysql_fetch_row($result);

		$navigation = "
		<table border=\"0\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\">
		<tr>
		<td width=\"70%\" valign=\"top\">
		TRANSLATE[[You are here]]:
		<a href=\"./mod.php?mod=weblink\">Principal</a>&nbsp;&gt;&nbsp;
		<a href=\"./mod.php?mod=weblink&amp;op=view_category&amp;cid=$pid&amp;start_num=0\">$main_cat</a>&nbsp;&gt;&nbsp;$cat<br />";

		$navigation .= $description . "</td></tr></table>";
	}

	$title = "TRANSLATE[[Web Links For]]: " . $cat ;

	$content = $navigation . "<hr /><br />";

	$cat = addslashes($cat);
	$result = mysql_query("SELECT * FROM " . $table_prefix . "mod_weblink_data WHERE category='$cat' AND new='0' ORDER BY title LIMIT $start_num, $list_num");
	$i = 0;

	/* when no links are present in main category the sub categories are checked and the appropriate message is printed */
	if(!mysql_num_rows($result)) {
		$subcategories = "";
		$sub_result = mysql_query("SELECT cid FROM " . $table_prefix . "mod_weblink_cat WHERE cat='$cat'");
		list($cid) = mysql_fetch_row($sub_result);
		$sub_result = mysql_query("SELECT cid, cat, description FROM " . $table_prefix . "mod_weblink_cat WHERE pid='$cid' AND cid!=pid");
		while(list($cid, $cat, $description) = mysql_fetch_row($sub_result)) {
			$subcategories .= "<blockquote><a href=\"./mod.php?mod=weblink&amp;op=view_category&amp;cid=$cid&amp;start_num=0\">$cat</a><br />$description</blockquote>\n";
			$link_result = mysql_query("SELECT * FROM " . $table_prefix . "mod_weblink_data WHERE category='$cat'");
			if(mysql_num_rows($link_result))	$message = 1;
		}



		if($start_num)		$content .= "TRANSLATE[[The are no more links for this category.]]<br />";		
		else if($message) 	$content .= "TRANSLATE[[The links for this category are located in these subcategories.]]<br />" . $subcategories;
		else			$content .= "TRANSLATE[[There are no links in this category.]]<br />";
	}

	$prev = $start_num - $list_num;
	$start_num = $start_num + $list_num;

	if($new_win) $link_target = "_blank";
	else         $link_target = "_self";

	/* listing out the links for the specific category */
	while($row = mysql_fetch_object($result)) {
		if($i)	$content .= "<hr />";

		$content .= "
		<a href=\"./mod.php?mod=weblink&amp;op=visit_link&amp;lid=$row->lid&amp;url=" . $row->url . "\" target=\"" . $link_target . "\">" . $row->title . "</a>&nbsp;";
		if($show_hits)	$content .= "TRANSLATE[[Hits]]:$row->hits";

		$content .= "<br />
		Descrio:" . $row->description . "<br />";

		if($show_date)	$content .= "TRANSLATE[[Submitted On]]:" . $row->date . "<br />";

		$i++;
	}


	$content .= "<br />";

	if($prev >= 0)
		$content .= "<a href=\"./mod.php?mod=weblink&amp;op=view_category&amp;cid=$this_cid&amp;start_num=$prev\">&lt;&lt; TRANSLATE[[Previous]] $list_num </a>&nbsp;";

	if($i == $list_num)
		$content .= "&nbsp;<a href=\"./mod.php?mod=weblink&amp;op=view_category&amp;cid=$this_cid&amp;start_num=$start_num\">TRANSLATE[[Next]] $list_num &gt;&gt;</a>";
	
	$content .= "<br /><hr />" . $navigation;
	
	thememainbox($title, $content);
}


/**
 * Lists out the top and new links according to hits or date
 *
 * @author Steven Levin <steven@tux.appstate.edu>
 * @param string type defines whether the top or new links are to be listed
 * @return none
 */

function top_new_links($type) {
	global $table_prefix;

	if($type == "top") {
		$result = mysql_query("SELECT top_list, new_win FROM " . $table_prefix . "mod_weblink_cfg");
		list($list_num, $new_win) = mysql_fetch_row($result);

		$title = "TRANSLATE[[Top]] " . $list_num . " TRANSLATE[[Links]]";
		$result = mysql_query("SELECT * FROM " . $table_prefix . "mod_weblink_data WHERE new='0' ORDER BY hits DESC LIMIT $list_num");
	}	

	if($type == "recent") {
		$result = mysql_query("SELECT new_list, new_win FROM " . $table_prefix . "mod_weblink_cfg");
		list($list_num, $new_win) = mysql_fetch_row($result);

		$title = "TRANSLATE[[The]] " . $list_num . " TRANSLATE[[Newest Links]]";
		$result = mysql_query("SELECT * FROM " . $table_prefix . "mod_weblink_data WHERE new='0' ORDER BY date DESC LIMIT $list_num");
	}

	if($new_win) $link_target = "_blank";
	else         $link_target = "_self";

	$i = 0;
	if(!mysql_num_rows($result))	$content .= "TRANSLATE[[There are no links in the database]]";
	while($row = mysql_fetch_object($result)) {
		if($i)	$content .= "<br /><hr /><br />";

		$content .= "
		<a href=\"./mod.php?mod=weblink&amp;op=visit_link&amp;lid=$row->lid&amp;url=" . $row->url . "\" target=\"" . $link_target . "\">" . $row->title . "</a>&nbsp;";
		if($type == "top")	$content .= "TRANSLATE[[Hits]]:$row->hits";

		$content .= "<br />Descrio:" . $row->description . "<br />";

		if($type == "recent")	$content .= "TRANSLATE[[Submitted On]]:" . $row->date . "<br />";

		$cat_result = mysql_query("SELECT cid FROM " . $table_prefix . "mod_weblink_cat WHERE cat='$row->category'");
		list($cid) = mysql_fetch_row($cat_result);

		$content .= "TRANSLATE[[Category]]:<a href=\"./mod.php?mod=weblink&amp;op=view_category&amp;cid=$cid&amp;start_num=0\">$row->category</a><br />";

		$i++;
	}

	thememainbox($title, $content);

	user_buttons($type);
}


/**
 * Displays the results from a search query
 *
 * @author Steven Levin <steven@tux.appstate.edu>
 * @param string the query entered by the user
 * @return none
 */

function search_results($query) {
	global $table_prefix;

	$result = mysql_query("SELECT search_list, new_win FROM " . $table_prefix . "mod_weblink_cfg");
	list($list_num, $new_win) = mysql_fetch_row($result);

	$query_array = explode(" ", $query);

	$num_words = count($query_array);

	$title = "TRANSLATE[[Search Results]]";

	$search = "SELECT * FROM " . $table_prefix . "mod_weblink_data WHERE ";

	for($i=0; $i<$num_words; $i++) {
		if($i == 0)	$search .= "title LIKE '%$query_array[$i]%' OR url LIKE '%$query_array[$i]%' OR description LIKE '%$query_array[$i]%' OR cat LIKE '%$query_array[$i]%'";
		else		$search .= "OR title LIKE '%$query_array[$i]%' OR url LIKE '%$query_array[$i]%' OR description LIKE '%$query_array[$i]%' OR cat LIKE '%$query_array[$i]%'";
	}

	$search .= " AND new='0' LIMIT $list_num";

	$i = 0;

	if($new_win) $link_target = "_blank";
	else         $link_target = "_self";

	$result = mysql_query($search);
	if(!mysql_num_rows($result))	$content = "TRANSLATE[[No web links found matching your query.]]";
	while($row = mysql_fetch_object($result)){
		if($i)	$content .= "<br /><hr /><br />";

		$content .= "
		<a href=\"./mod.php?mod=weblink&amp;op=visit_link&amp;lid=$row->lid&amp;url=" . $row->url . "\" target=\"" . $link_target . "\">" . $row->title . "</a>&nbsp;TRANSLATE[[Hits]]:$row->hits<br />
		Descrio:" . $row->description . "<br />
		TRANSLATE[[Submitted On]]:" . $row->date . "<br />";

		$i++;
	}

	thememainbox($title, $content);

	echo "
	<form method=\"post\" action=\"mod.php\">
	<input type=\"hidden\" name=\"mod\" value=\"weblink\" />
		<input type=\"submit\" value=\"Voltar\" />
	</form>";
}


/**
 * Allows user to submit a weblink if the option is turned on
 *
 * @author Steven Levin <steven@tux.appstate.edu>
 * @param int 1 or 0 defines whether or no the link will be new or editing one because of error
 * @param string the catergory chosen so it can be auto selected
 * @return none
 */

function user_submit($new) {
	global $current_link;

	if($new) $current_link = new weblink;

	$current_link->submit_weblink();

	echo "
	<form method=\"post\" action=\"mod.php\">
	<input type=\"hidden\" name=\"mod\" value=\"weblink\" />
		<input type=\"submit\" value=\"Voltar\" />
	</form>";
}

function back_to_admin() {echo "<center><b><a href=\"./admin.php\">Voltar ao Menu Admin</a></b></center><br />\n";}

?>
