<?php

/*
 * This mainpage class has all the functions necessary to
 * create and edit a mainpage instance.
 *
 * @module mainpage
 * @package phpWebSite
 * @author Adam Morton, adam@tux.appstate.edu
*/

class mainpage
{
	var $title;
	var $text;
	var $image;
	var $alt;
	var $image_active;

function mainpage ()
{
	$this->title = "TRANSLATE[[Welcome to phpWebSite]]";
	$this->text = "TRANSLATE[[Developed by the Web Technology Group at Appalachian State University, phpWebSite provides a complete web site content management solution]].
	TRANSLATE[[All client output is valid XHTML 1.0 and meets the W3C Web Accessibility Initiative requirements]].
	</p>\r\n\r\n
	<p>TRANSLATE[[You can administrate this site by going the ]] <a href=\"admin.php\">TRANSLATE[[Administrative Menu]]</a>
	TRANSLATE[[and logging on using the following username and password:]]</p>\r\n\r\n
	<p>Nome de Usurio:  admin<br />\r\n Senha:  phpwebsite</p>\r\n\r\n
	<p>TRANSLATE[[Once you are logged in you can change this content to fit your needs]]
	TRANSLATE[[Remember to please change the administrative password to protect your site]].</p>\r\n\r\n
	<p>TRANSLATE[[Thank you!]]</p>\r\n
	<p> - TRANSLATE[[The phpWebSite Development Team]]</p>\r\n\r\n";
	$this->image = "wtg.jpg";
	$this->alt = "TRANSLATE[[phpWebSite delivers valid XHTML for client interoperability]]";
	$this->image_active = 1;
}

function set_data ($title, $text, $image, $image_name, $image_size, $image_type, $alt, $image_active, $existing_image)
{
	global $error_type, $table_prefix;
	include("./mod/mainpage/mainpage_config.php");

	$this->title = check_html($title);
	$this->text = check_html($text);
	$this->image_active = check_html($image_active);
	$this->alt = check_html($alt,"nohtml");
	
	if($image && $image != "none")
	{
		$img_input = 1;
		$temp_type = explode(";", $image_type);

		$res = mysql_query("select allowed_imgs,max_image_size,files_umask from ".$table_prefix."flags");
		list($allowed_types,$max_image_size,$files_umask) = mysql_fetch_row($res);

		if($image_size > $max_image_size) $error_type = "image_size";
		else if(!substr_count($allowed_types,$image_type)) $error_type = "image_type";
		else if(!$alt) $error_type = "alt";

		if($error_type != "image_size" && $error_type != "image_type")
		{
			if(!(file_exists($image_directory.$image_name) && filesize($image_directory.$image_name)==$image_size))
			{
                @umask((int)$files_umask);
				if(!@move_uploaded_file($image, $image_directory.$image_name))
				{
					$error_type = "image_creation";
					$this->image = "none";
				}
				else
				{
					$this->image = $image_name;
					system("chmod 644 " . $image_directory . $image_name);
				}
			}
			else
			$this->image = $image_name;
		}
	}
	
	// use a pre-existent image
	if(!$img_input && ($existing_image && $existing_image != "none"))
	{
		$img_input=2;
		$this->image = $existing_image;

                if(!$alt) $error_type = "alt";
	}
}

function view_mainpage ()
{
	include("./mod/mainpage/mainpage_config.php");

	$main_title = stripslashes($this->title);
	$main_text = stripslashes($this->text);
	$main_image = $this->image;
	$main_alt = $this->alt;

	if (!strstr ($main_title, '<p') && !strstr ($main_title, '<table') && !strstr ($main_title, '<br'))
        $main_title = nl2br($main_title);

	if (!strstr ($main_text, '<p') && !strstr ($main_text, '<table') && !strstr ($main_text, '<br'))
        $main_text = str_replace ("\n" , "<br />", $main_text). "<br />";

	if($this->image_active)
	{
		$size = GetImageSize ("$image_directory$main_image");
		/* The image is wide, therefore it will be placed above the information. */
		if ($size[0] >250)
		$content = "<center><img src=\"$image_directory$main_image\" border=\"0\" alt=\"$main_alt\" /></center><br /><br />\n";
		else
		$content = "<img src=\"$image_directory$main_image\" border=\"0\" alt=\"$main_alt\" align=\"right\" hspace=\"5\" vspace=\"5\" />\n";
	}

  $main_text = convert_to_links($i_text=$main_text);

	$content .= "$main_text<br />";

	thememainbox($main_title, $content);
}

function edit_mainpage ($active)
{
	include("./mod/mainpage/mainpage_config.php");

	$main_title = stripslashes($this->title);
	$main_text = stripslashes(htmlspecialchars($this->text));
	$main_image = stripslashes($this->image);
	$main_alt = stripslashes($this->alt);

	echo "<div style=\"text-align : center\"><a href=\"admin.php\">Voltar ao Menu Admin</a></div><br />\n";

	$title = "TRANSLATE[[Edit Main Page]]";
	$content = "<form action=\"mod.php\" method=\"post\" enctype=\"multipart/form-data\">\n";

	if($active) $content .= "<input type=\"checkbox\" name=\"active\" value=\"1\" checked=\"checked\" />\n";
	else $content .= "<input type=\"checkbox\" name=\"active\" value=\"1\" />\n";

	$content .= "TRANSLATE[[Make this content active]]?<br /><br />
	Ttulo Principal:<br />
	<input type=\"text\" name=\"title\" value=\"$main_title\" maxlength=\"200\" size=\"40\" /><br />
        Texto Principal: <br />
	<textarea name=\"text\" cols=\"80\" rows=\"15\" wrap=\"virtual\">$main_text</textarea>
	<br />
	";

	$content .= display_importexport_controls("imported","imported_mode","imported_stricttypes", "next_import", "./mod.php?mod=mainpage", 0);

        $content .= "TRANSLATE[[Main Image]]: <br />\n";

	if($main_image != "none")
	{
		$content .= "<img src=\"$image_directory$main_image\" alt=\"$main_alt\" /><br />
		<input type=\"submit\" name=\"remove_image\" value=\"Remove Imagem\" /><br /><br />\n";
	}

	$content .= "TRANSLATE[[Upload a new image]] : <input type=\"file\" name=\"image\" maxlength=\"60\" size=\"25\" /><br />";

	$imagesarray = list_existing_images($image_directory);
	$content .= " ou TRANSLATE[[Use existing image]] : ";

	$sel = ($main_image && in_array($main_image,$imagesarray)) ? $main_image : "";

        $content .= form_options(0,"option","existing_image",$imagesarray, $sel) . "<br />\n";
	$content .= "Pequena descrio da imagem:
        <input type=\"text\" name=\"alt\" maxlength=\"60\" size=\"33\" value=\"$main_alt\" /><br />\n";

        if($this->image_active) $content .= "<br /><input type=\"checkbox\" name=\"image_active\" value=\"1\" checked=\"checked\" />\n";
        else $content .= "<br /><input type=\"checkbox\" name=\"image_active\" value=\"1\" />\n";

        $content .= "TRANSLATE[[Make this image active?]]<br /><br />
	<input type=\"hidden\" name=\"mod\" value=\"mainpage\" />
	<input type=\"hidden\" name=\"op\" value=\"save_mainpage\" />
	<input type=\"submit\" value=\"Submeter\" />
	</form>\n";

	thememainbox($title, $content);
}

function remove_image ()
{
	$this->image = "none";
	$this->alt = "";
	$this->image_active = 0;

	$title = "TRANSLATE[[Image Removed]]";
	$content = "TRANSLATE[[You must save your data via the SUBMIT button for the changes to take effect!]]";
	thememainbox($title, $content);
}

function update_data ($active)
{
	include('config.php');
	$data = addslashes(serialize($this));
	$result = mysql_query("UPDATE " . $table_prefix."mod_mainpage_data SET active='$active', data='$data'");

	if($result)
	{
		back_to_admin();
		$title = "TRANSLATE[[Main Page Updated]]!";
		$content = "<b>TRANSLATE[[Your page has successfully been updated in the database]]!</b><br />\n";
		thememainbox($title, $content);
	}
	else
	{
		$this->page_error("database");
		$this->edit_mainpage($active);
	}
}

function page_error ($type)
{
	include("./mod/mainpage/mainpage_config.php");
	include("config.php");

        $res = mysql_query("select allowed_imgs,max_image_size from ".$table_prefix."flags");
        list($allowed_types,$max_image_size) = mysql_fetch_row($res);

	$title = "<span class=\"onebiggerred\">ERROR!</span>";
        $content = "<b>TRANSLATE[[The following error has occurred]]:</b><br /><br />\n";

	check_import_errors($content, $type);

	switch($type)
	{
		case "database":
		$content .= "<b>TRANSLATE[[There was a database error when attempting to update your page]]!</b><br /><br />
		TRANSLATE[[Please try to save it again in a moment]].<br />TRANSLATE[[If the problem persists, contact your system administrator]].\n";
		break;

		case "image_size":
		$content .= "TRANSLATE[[The file you selected for your image is too large]]!<br />
		TRANSLATE[[The largest file size allowed on this server is]] $max_image_size TRANSLATE[[bytes]].<br />TRANSLATE[[Please select a smaller image for uploading now]].";
		break;

		case "image_type":
		$content .= "TRANSLATE[[The file you selected for your image is not a valid image type]]!<br />
            	TRANSLATE[[The valid types are]]:<br /><br />$allowed_types<br /><br />TRANSLATE[[Please select a new file for uploading now]].\n";
		break;

		case "alt":
		$content .= "Voc deve fornecer uma pequena descrio para as imagens (por volta de 15-20 caracteres).\n";
		break;

		case "image_creation":
		$content = "TRANSLATE[[A problem occured when attempting to upload your image]].<br />TRANSLATE[[If the problem persists, contact your system administrator]].\n";
		break;
	}
	$content .= "<br /><br />";
	thememainbox($title, $content);
}

}

?>
