<?php

##########################################################
#							 #
# @module comments					 #
# @package phpWebSite					 #
# @author Ryan Cowan, ryan@tux.appstate.edu              #
#							 # 
# This file contains all the funtions that can be used   #
# by another module to interact with the comments.       #
# Examples of how to use these functions are provided in #
# the README file in the mod/comments directory.	 #
#							 #
##########################################################

ob_start();

include("config.php");
include_once("mainfile.php");
include_once("./mod/comments/comments.php");
include_once("./mod/comments/comments_functions.php");
include("open_session.php");

session_register("cmt_redirect");
session_register("cmt_mid");		    # The primary key for the current instance of the comment
session_register("cmt_mode");		    # The current mode
session_register("cmt_thold");		    # The current threshold
session_register("cmt_order");		    # The current order for the comments
session_register("cmt_comment_url");	    # The url where the comments are displayed
session_register("cmt_preview_flag");	    # If is has been previewed it = 1, else it = 0.
session_register("cmt_edit_flag");	    # If the comment has been edited it = 1, else it = 0.
session_register("cmt_set_defaults");       # If = 1 then the user defaults have been set, else they haven't.
session_register("cmt_current_parent");     # Holds the current parents comment information.
session_register("cmt_current_child");      # Holds the current childerns comment information.
session_register("cmt_start_key");          # Holds the cid of the comment to be displayed first.
session_register("cmt_comment_content");    # Holds the content to be displayed.

################################################################################
#  Params:  $cmt_module - The parent module name that will be using comments.  #
# 	    $cmt_id - The unique identifier, usually the primary key from the  #
#	    database, that will be used to associate the comment with the      #
#           parent module's instance.			        	       #
#									       #	
#  Description: Creates a navigaton bar if a record exists for the module      #
#		and if the comments are enabled for that module.  It           #
#               orders the comments and calls display_comments().  Displays    #
#  		$cmt_content, a global var used to store the data to be        #
#		displayed. 						       #
################################################################################   
function nav_bar($cmt_module, $cmt_id) 
{
	global $table_prefix, $cmt_comment_url, $cmt_mid, $cmt_mode, $cmt_comment_content, 
	$cmt_thold, $cmt_order, $user, $userinfo, $cmt_set_defaults;

	$cmt_mid = $cmt_module.$cmt_id;

	if(phpversion() < "4.1.0")
	{
		global $HTTP_SERVER_VARS;
		$cmt_comment_url = $HTTP_SERVER_VARS['HTTP_HOST'].$HTTP_SERVER_VARS['REQUEST_URI'];  
	}
 	else
	{
		global $_SERVER;
		$cmt_comment_url = $_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
	}

	$cmt_result = mysql_query("SELECT comment_moderate, default_mode, default_order, default_thold FROM ".$table_prefix."flags");
	list($cmt_moderate, $cmt_default_mode, $cmt_default_order, $cmt_default_thold) = mysql_fetch_row($cmt_result);

	$cmt_res = mysql_query("SELECT enabled FROM ".$table_prefix."mod_comments_flags WHERE mid='$cmt_mid'");
	if(list($cmt_enabled) = mysql_fetch_row($cmt_res))
	{
		if($cmt_enabled)
		{
			//Sets the default values.
			if(!isset($cmt_set_defaults))
				$cmt_set_defaults = 0;
			if((isset($user)) && $cmt_set_defaults)			     	
			{
				$cmt_set_defaults = 1;
				getusrinfo($user);
				$cmt_mode = $userinfo[umode];
				$cmt_order = $userinfo[uorder];
				$cmt_thold = $userinfo[thold];
			}
			if(empty($cmt_mode))
				$cmt_mode="$cmt_default_mode";
			if(empty($cmt_order))
				$cmt_order=$cmt_default_order;
			if(empty($cmt_thold))
				$cmt_thold=$cmt_default_thold;

			$cmt_title = "Comentrios - <a href = \"mod.php?mod=comments&amp;op=reply&amp;cmt_cid=a\">
			TRANSLATE[[Post Comment]]</a>";
	
			$cmt_comment_content = "<div align=\"center\">
			TRANSLATE[[The comments are owned by the poster. We are not responsible for its content.]]
			<form action=\"mod.php\" method=\"post\">
			Limiar:TRANSLATE[[Display]]&nbsp;<select name=\"cmt_new_thold\">";
			
			for ($cmt_i=-1; $cmt_i<=5; $cmt_i++)
			{
				$cmt_comment_content .=  "<option value=\"$cmt_i\"";
				if($cmt_thold==$cmt_i)
					$cmt_comment_content .=  "selected=\"selected\"";
				$cmt_result = mysql_query("SELECT COUNT(mid) FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid' AND score>='$cmt_i'"); 
				list($cmt_total) = mysql_fetch_row($cmt_result);
				$cmt_comment_content .=  ">$cmt_i : $cmt_total</option>";
			}
			$cmt_comment_content .=  "</select>";
			$cmt_comment_content .=  "&nbsp;<select name=\"cmt_new_mode\">
			<option value=\"nocomments\"";
			if($cmt_mode==nocomment)
				$cmt_comment_content .=  "selected=\"selected\"";
			$cmt_comment_content .=  ">TRANSLATE[[NO Comments]]</option>
			<option value=\"nested\"";
			if($cmt_mode==nested)
				$cmt_comment_content .=  "selected=\"selected\"";
			$cmt_comment_content .=  ">TRANSLATE[[Nested]]</option>
			<option value=\"threaded\"";
			if($cmt_mode==threaded)
				$cmt_comment_content .=  "selected=\"selected\"";
			$cmt_comment_content .=  ">Colocado</option>
			<option value=\"flat\" ";
			if($cmt_mode==flat)
				$cmt_comment_content .=  "selected=\"selected\"";
			$cmt_comment_content .=  ">Confirmado</option>
			</select>";
				$cmt_comment_content .=  "&nbsp;
			<select name=\"cmt_new_order\">
			<option value=\"4\" ";
			if($cmt_order==4)
				$cmt_comment_content .=  "selected=\"selected\"";
			$cmt_comment_content .=  ">Antigos primeiro</option>	
			<option value=\"1\" ";
			if($cmt_order==1)
				$cmt_comment_content .=  "selected=\"selected\"";
			$cmt_comment_content .=  ">Os mais novos primeiro</option>	
			<option value=\"3\" ";
			if($cmt_order==3)
				$cmt_comment_content .=  "selected=\"selected\"";
			$cmt_comment_content .=  ">TRANSLATE[[Lowest Scores First]]</option>	
			<option value=\"2\" ";
			if($cmt_order==2)
				$cmt_comment_content .=  "selected=\"selected\"";
			$cmt_comment_content .=  ">Primeiro os Placares Mais Altos</option>	
			</select>	   
		
			<input type=\"hidden\" name=\"mod\" value=\"comments\" />
			<input type=\"hidden\" name=\"op\" value=\"refresh\" />
			<br /><br /><input type=\"submit\" value=\"Recarregar\" />
			</form>
			
			<hr size=\"1\" width=\"50%\" />";

			$cmt_result = mysql_query("SELECT COUNT(mid) FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid'");
			list($cmt_total) = mysql_fetch_row($cmt_result); 
			if($cmt_total==0)
				$cmt_comment_content .=  "<span class=\"onebiggerred\">
				TRANSLATE[[NO comments yet! Be the first!]]
				</span><br />";
			else
			{
				
				if((($admintest==$security_hash) && ($cmt_moderate == 1)) || (($cmt_moderate == 2) && $user)) 
					$cmt_comment_content .= "<form action=\"mod.php\" method=\"post\">";
				if($cmt_mode!="nocomments")
					display_comment();
				$cmt_comment_content .=  "<div align=\"center\">";
				if((($admintest==$security_hash) && ($cmt_moderate == 1)) || (($cmt_moderate==2) && $user)) 
					$cmt_comment_content .= "
					<input type=\"hidden\" name=\"mod\" value=\"comments\" />
					<input type=\"hidden\" name=\"op\" value=\"moderate\" />
					<br /><input type=\"submit\" value=\"Moderaraes\" />
					</form><br />";
				$cmt_comment_content .=  "<a href = \"mod.php?mod=comments&amp;op=reply&amp;cmt_cid=a\">TRANSLATE[[Post Comment]]</a></div>";	
			}
			thememainbox($cmt_title, $cmt_comment_content);
		}
	}
}

################################################################################
#  Params:  $cmt_module - The name of the module that is using the comment.    #
# 	    $cmt_id - The unique identifer of the instance of the module.      #
#  									       #	
#  Description: Returns a the total number of comments  for 		       #
#		"$cmt_module.$cmt_id".     				       #
################################################################################
function comment_total($cmt_module, $cmt_id)
{
	global $table_prefix;

	$cmt_mid = $cmt_module.$cmt_id;
	
	$cmt_result = mysql_query("SELECT COUNT(cid) FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid'");
	list($cmt_total) = mysql_fetch_row($cmt_result);

	return $cmt_total;
}

################################################################################
#  Params:  $cmt_module - The parent module name that will be using comments.  #
# 	    $cmt_id - The unique identifier, usually the primary key from the  #
#		  database, that will be used to associate the comment         #
#                 with the parent module's instance.			       #
# 	    $cmt_comments - Form variable for enabling/disabling the comment.  #
#		        1 = yes, 0 = no					       #
#	    $cmt_postanon - Form variable for allowing users to post anonymous #
#			comments. 1= yes, 0 = no			       #
#  									       #	
#  Description: Returns a string that contains 2 yes/no radio button sets for  #
#		enabling/disabling the comment and the anonymous option.       #
################################################################################
function comments_menu($cmt_module, $cmt_id, $cmt_comments, $cmt_postanon)
{
	global $table_prefix;
	
	$cmt_mid = $cmt_module.$cmt_id;

	#if $cmt_postanon==3 then get flags out of table.
	#else use postanon that is supplied(for previews)
	if(($cmt_postanon!=3) && ($cmt_comments!=3))
	{
		if($cmt_postanon)
			$cmt_post_yes = "checked";
		else
			$cmt_post_no = "checked";
		if($cmt_comments)
			$cmt_check_yes = "checked";
		else
			$cmt_check_no = "checked";
	}
	else
	{
		$cmt_result = mysql_query("SELECT enabled, allow_postanon FROM ".$table_prefix."mod_comments_flags WHERE mid='$cmt_mid'");
		if(mysql_num_rows($cmt_result)!=0)
		{
			list($cmt_enabled, $cmt_allow) = mysql_fetch_row($cmt_result);
			if($cmt_enabled)
				$cmt_check_yes = "checked";
			else
				$cmt_check_no = "checked";
			if($cmt_allow)
				$cmt_post_yes = "checked";
			else
				$cmt_post_no = "checked";
		}
		else
		{
			$cmt_post_no = "checked";
			$cmt_check_no = "checked";
		}
	}
		
	$cmt_content .= "TRANSLATE[[Allow comments]]?<br />
	<input type=\"radio\" name=\"cmt_comments\" value=\"1\" $cmt_check_yes>SIM
        <input type=\"radio\" name=\"cmt_comments\" value=\"0\" $cmt_check_no>NO<p>
	TRANSLATE[[Allow anonymous users to post comments]]?<br />
	<input type=\"radio\" name=\"cmt_postanon\" value=\"1\" $cmt_post_yes>SIM
        <input type=\"radio\" name=\"cmt_postanon\" value=\"0\" $cmt_post_no>NO<br />
	(TRANSLATE[[This will not affect any comments that have already been posted anonomously]]. TRANSLATE[[If set to no, it will simply keep users from posting anonymously]].)</p>";
	
	return $cmt_content;
}

################################################################################
#  Params:  $cmt_module - The parent module name that will be using comments.  #
# 	    $cmt_id - The unique identifier, usually the primary key from the  #
#		  database, that will be used to associate the comment         #
#                 with the parent module's instance.			       #
# 	    $cmt_comments - Form variable for enabling/disabling the comment.  #
#		        1 = yes, 0 = no					       #
#	    $cmt_postanon - Form variable for allowing users to post anonymous #
#			comments. 1= yes, 0 = no			       #
#  									       #	
#  Description: It creates a new comment if one does not.                      #
#               Sets the enable and anonymous settings in the database.        #
################################################################################	
function enable_comments($cmt_module, $cmt_id, $cmt_comments, $cmt_postanon)
{
	global $table_prefix;
	
	$cmt_mid = $cmt_module.$cmt_id;

	#Creates a new entry if one hasn't already been saved.
	$cmt_result = mysql_query("SELECT * FROM ".$table_prefix."mod_comments_flags WHERE mid='$cmt_mid'");
	if(mysql_num_rows($cmt_result)==0) 
	{
		mysql_query("LOCK TABLES ".$table_prefix."mod_comments_flags WRITE");	
		$cmt_result = mysql_query("INSERT INTO ".$table_prefix."mod_comments_flags VALUES ('$cmt_mid', '$cmt_comments', '$cmt_postanon')");
		mysql_query("UNLOCK TABLES");	
	}
	
	#Sets enabled/anonymous flags
	mysql_query("UPDATE ".$table_prefix."mod_comments_flags SET enabled='$cmt_comments',allow_postanon='$cmt_postanon' WHERE mid='$cmt_mid'");

}

################################################################################
#  Params:  $cmt_module - The name of the module of that is using the comment. #
# 	    $cmt_id - The unique identifer of the instance of the module.      #
#  									       #	
#  Description: Delete the data of the Comment for "$cmt_module.$cmt_id".      #
################################################################################
function delete_comment_mid($cmt_module,$cmt_id)
{
	global $table_prefix;

	$cmt_mid = $cmt_module.$cmt_id;

	mysql_query("LOCK TABLES ".$table_prefix."mod_comments_data WRITE, ".$table_prefix."mod_comments_flags WRITE");
	mysql_query("DELETE FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid'");
	mysql_query("DELETE FROM ".$table_prefix."mod_comments_flags WHERE mid='$cmt_mid'");
	mysql_query("UNLOCK TABLES");
}

##################################################################################
#  Params:  $cmt_module - The name of the module that is using Comments.	 #
# 	    $cmt_max_id - The max unique identifer of the instance of the module.#
#  									         #	
#  Description: Deletes all the data of the Comment for "$cmt_module".           #
##################################################################################
function delete_all_comments_module($cmt_module, $cmt_max_id)
{
	global $table_prefix;

	for($cmt_i=1;$cmt_i<=$cmt_max_id;$cmt_i++)
	{
		$cmt_mid = $cmt_module.$cmt_i;
		mysql_query("LOCK TABLES ".$table_prefix."mod_comments_data WRITE");
		@mysql_query("DELETE FROM ".$table_prefix."mod_comments_data WHERE mid='$cmt_mid'");
		@mysql_query("DELETE FROM ".$table_prefix."mod_comments_flags WHERE mid='$cmt_mid'");
		mysql_query("UNLOCK TABLES");
	}
}

?>
