<?php

/**
 * Root calendar file used to transfer commands to proper function
 * via a switch function.
 *
 * There are two switch statements. One set is only accessible
 * If you are logged in as an administrator. The other are functions
 * that don't manipulate the database.

 * @module calendar
 * @modulegroup admin
 * @package Calendar
 * @author Matthew McNaney
 *
 */
include("open_session.php");

include("config.php");
include ("mod/calendar/language.php");
include ("mod/calendar/calendar_config.php");
global $calendar_display, $admintest;

if(!isset($mainfile))
{
  include("mainfile.php");
}

if(!$admintest)
{
	$result=mysql_query("select block_pos from " . $table_prefix."modules where plug_dir='calendar'");

	list($bpos)=mysql_fetch_row($result);
	if(!$bpos)
		html_header_location("index.php");
}


if ($calendar_display != 1){
	include("./mod/calendar/calendar_display.php");
	$calendar_display = 1;
}


if ($admintest){
	include("./mod/calendar/cal_functions.php");
	switch($op){
		case("mainmenu"):
			include("./mod/calendar/mainmenu.php");
			$op = "admin";
			break;

		case("change_name"):
			if ($plug_name == "")
				$plug_name = "Calendar";
			else
				$plug_name = check_html($plug_name,"nohtml");

			mysql_query ("update " . $table_prefix."modules set name='$plug_name' where plug_dir='calendar'");
			$note = $tran[Calendar_name_changed];
			include("./mod/calendar/mainmenu.php");
			$op = "admin";
			break;

		case("cat_admin"):
			if (strlen($delete_cat)){
				delete_cat($cat_id);
				$op = "admin";
				break;
			}
			cat_admin($cat_id, $image_name);
			$op = "admin";
			break;

		case("cat_action"):
			if (strlen($preview_image)){
				if ($use_image == 'none')
					html_header_location("./mod.php?mod=calendar&op=cat_admin&cat_id=$cat_id");
				else
					show_image($use_image, "cat_admin", "cat_id=$cat_id");
			}
			else {

				if ($image != 'none' && strlen($image)>1)
					copy_image($image, $image_name, $image_size, $image_type);
				else if ($use_image != 'none')
					$image_name = $use_image;
				else
					$image_name = '';

				cat_action($cat_id, $image_name, $category, $description, $email);
			}
			$op = "admin";
			break;

		case("subcat_admin"):
			if (strlen($delete_subcat)){
				delete_subcat($subcat_id);
				$op = "admin";
				break;
			}
			subcat_admin($cat_id, $subcat_id, $image_name);
			$op = "admin";
			break;

		case("subcat_action"):
			if (strlen($preview_image)){
				if ($use_image == 'none')
					html_header_location("./mod.php?mod=calendar&op=subcat_admin&cat_id=$cat_id&subcat_id=$subcat_id");
				else
					show_image($use_image, "cat_admin", "cat_id=$cat_id");
			}
			else {

				if ($image != 'none'  && strlen($image)>1)
					copy_image($image, $image_name, $image_size, $image_type);
				else if ($use_image != 'none')
					$image_name = $use_image;
				else
					$image_name = '';
				subcat_action ($subcat_id);
			}
			$op = "admin";
			break;

		case("location_admin"):
			if (strlen($delete_location)){
				delete_location($loc_id);
				$op = "admin";
				break;
			}
			location_admin($loc_id, $image_name);

			$op = "admin";
			break;

		case("loc_action"):
			if (strlen($preview_image)){
				if ($use_image == 'none')
					html_header_location("./mod.php?mod=calendar&op=location_admin&loc_id=$loc_id");
				else
					show_image($use_image, "cat_admin", "cat_id=$cat_id");
			}
			else {

				if ($image != 'none' && strlen($image)>1)
					copy_image($image, $image_name, $image_size, $image_type);
				else if ($use_image != 'none')
					$image_name = $use_image;
				else
					$image_name = '';

				loc_action($loc_id, $image_name, $loc_name, $description, $email);
			}
			$op = "admin";
			break;

		case("event_admin"):
			if ($delete_event){
				delete_event($event_id);
				$op = "admin";
				break;
			}
			event_admin($event_id);
			$op = "admin";
			break;

		case("event_action"):
			if (strlen($delete_event)){
				delete_event($event_id);
				$op = "admin";
				break;
			}
			if (strlen($preview_image)){
				if ($use_image == 'none')
					html_header_location("./mod.php?mod=calendar&op=event_admin&event_id=$event_id");
				else
					show_image($use_image, "cat_admin", "cat_id=$cat_id");
			}
			else {

				if ($image != 'none' && strlen($image)>1)
					copy_image($image, $image_name, $image_size, $image_type);
				else if ($use_image != 'none')
					$image_name = $use_image;
				else
					$image_name = '';
				event_action ($event_id);
			}
			$op = "admin";
			break;

		case("show_image"):
			show_image($picname);
			$op = "admin";
			break;
		case("delete_image"):
			delete_image($image_name, $delete);
			$op = "admin";
			break;
		case("delete_cat"):
			if (strlen($delete))
				delete_cat($cat_id, $delete);
			else {
				$note = "$tran[Removal_of] $tran[cat_name] $tran[suspended].";
				include("./mod/calendar/mainmenu.php");
			}
			$op = "admin";
			break;
		case("delete_location"):
			if (strlen($delete))
				delete_location($loc_id, $delete);
			else {
				$note = "$tran[Removal_of_location_suspended].";
				include("./mod/calendar/mainmenu.php");
			}
			$op = "admin";
			break;
		case("delete_event"):
			if (strlen($delete))
				delete_event($event_id, $delete);
			else {
				$note = "$tran[Removal_of_event_suspended].";
				include("./mod/calendar/mainmenu.php");
			}
			$op = "admin";
			break;
		case("delete_subcat"):
			if (strlen($delete))
				delete_subcat($subcat_id, $delete);
			else {
				$note = "$tran[Removal_of] $tran[subcat_name] $tran[suspended].";
				include("./mod/calendar/mainmenu.php");
			}
			$op = "admin";
			break;
		case("user_view"):
			mysql_query ("
				update " . $table_prefix."mod_calendar_settings
				set
				month_view='$month_view', week_view='$week_view', cat_view='$cat_view', subcat_view='$subcat_view', location_view='$location_view', today_view='$today_view', small_view='$small_view'
			");
			mysql_query ("update " . $table_prefix."modules set block_pos='$block_pos' where plug_dir='calendar'");
			$note = "$tran[User_view_updated].";
			include("./mod/calendar/mainmenu.php");
			$op = "admin";
			break;
		case("date_format"):
			mysql_query ("update " . $table_prefix."mod_calendar_settings set date_format='$date_order^$date_style^$separator'");
			$note = "$tran[Date_format_altered].";
			include("./mod/calendar/mainmenu.php");
			$op = "admin";
			break;
		case("format_time"):
			mysql_query ("update " . $table_prefix."mod_calendar_settings set time_format='$time_format'");
			$note = "$tran[Time_format_altered].";
			include("./mod/calendar/mainmenu.php");
			$op = "admin";
			break;
		case("server_time"):
			mysql_query ("update " . $table_prefix."mod_calendar_settings set time_diff='$time_diff'");
			$note = "$tran[Time_difference_altered].";
			include("./mod/calendar/mainmenu.php");
			$op = "admin";
			break;
		case("set_month_image"):
			if (!$write_image && !$preview_image)
				set_month_image($month, $image_name);

			if (strlen($preview_image)){
				if ($use_image == 'none')
					html_header_location("./mod.php?mod=calendar&op=set_month_image&month=$month");
				else
					show_image($use_image, "set_month_image", "month=$month");
			}
			elseif ($write_image) {
				if ($image != 'none' && strlen($image)>1)
					copy_image($image, $image_name, $image_size, $image_type);

				else if ($use_image != "none")
					$image_name = $use_image;

				else
					$image_name = '';

				mysql_query("update " . $table_prefix."mod_calendar_settings set pic_$month='$image_name'");
				$note = format_date("2000".$month."01","long_month")." $tran[image_changed]!";
				include("./mod/calendar/mainmenu.php");
			}

			$op = "admin";
			break;
		case("purge_events"):
			global $check, $purge_date;
			if ($check_all)
				$check="checked";
			elseif ($check_none)
				$check = "";
			if (!$purge_date)
				$purge_date=$purge_year.$purge_month.$purge_day;
			purge_events($purge_date);
			$op = "admin";
			break;
		case ("purge_action"):
			$j = 0;
			for ($i=1; $i <= $total_events; $i++){
				$event_id=${"remove_".$i};
				if (${"remove_".$i} > 0){
					mysql_query("lock tables " . $table_prefix."mod_calendar_events WRITE" . "," . $table_prefix."mod_calendar_post WRITE" . "," . $table_prefix."stories WRITE");

					$sql = "delete from " . $table_prefix."mod_calendar_events where event_id=$event_id";
					mysql_query($sql);
					$fetch_article = mysql_query ("select article_id from " . $table_prefix."mod_calendar_post where post_event_id='$event_id'");
					list ($article_id) = mysql_fetch_row ($fetch_article);
					mysql_query ("delete from " . $table_prefix."stories where sid = '$article_id'");
					$sql = "delete from " . $table_prefix."mod_calendar_post where post_event_id='$event_id'";
					mysql_query($sql);
					mysql_query("unlock tables");

					$j++;
				}
			}
			if ($j == 1)
				$note = "$tran[Event_removed]!";
			elseif ($j == 0)
				$note = "$tran[No_events_removed].";
			else
				$note = "$j $tran[events_removed]!";
			include("./mod/calendar/mainmenu.php");
			$op = "admin";
			break;
	}
}

switch ($op)
{
	case("list_events"):
		global $cat_id, $subcat_id, $limit, $date_start, $date_end, $loc_id;
		$date_start=$start_year.$start_month.$start_day;
		$date_end=$end_year.$end_month.$end_day;
		if ($loc_id)
			$sortby = "location";
		list_events($sortby);
		break;
	case("template_event"):
		$event_id=add_template_event($event_date);
		event_admin($event_id);
		$op = "admin";
		break;
	case("view_event"):
		view_event($event_id,$event_date);
		break;
	case("show_event"):
		show_event($event_id, $date);
		break;
	case("month_view"):
		 $agent = (phpversion() > "4.1.0") ? $_SERVER[HTTP_USER_AGENT] : $HTTP_SERVER_VARS[HTTP_USER_AGENT];

		if ($month && $year)
			$date=$year.$month."01";
		echo getenv($agent);
		if (stristr($agent, 'msie') || empty($netscape_view) || stristr($agent, 'gecko'))
		  month_view($date);
		else
		  alt_month_view($date);
		break;
	case("view_day"):
		view_day($date);
		break;
	case("week_view"):
		if (!$date)
			$date = date_now("Ymd");
		if ($month && $day && $year)
			$date=$year.$month.$day;
		week_view($date);
		break;
	case("admin"):
		break;
	case("uninstall"):
		include("header.php");
		$box_title = "TRANSLATE[[uninstall]]";
		include("./mod/calendar/calendar_uninstall.php");
		if(!$box_content)
			$box_content = "TRANSLATE[[No Errors]]<br />\n";

		$box_content .= "<br />\n<div align=\"center\">
                TRANSLATE[[You can now enter/go back to the Administration Panel]] <a href=\"admin.php\">TRANSLATE[[here]]</a>
		<br /></div>\n";

		thememainbox($box_title, $box_content);
		break;

	default:
		html_header_location("index.php");
		break;
}
include ("footer.php");

?>
