<?php

/*
 * This is the hub of the userpage module. All operational
 * decisions are made here.
 *
 * @module blocks
 * @package phpWebSite
 * @author Mike Wilson, mike@tux.appstate.edu
*/

ob_start();

/* Include class file. Module specific functions are included in it. */
include_once("./mod/blocks/blocks.php");

/* Include needed core/config files. */
include_once("config.php");
if(!isset($mainfile)) include("mainfile.php");
include("open_session.php");  #NEEDED FOR ADMIN CHECK!!
include("core_functions.php");
include("importexport.php");
include_once("htmlheader.php");

$blocks=new blocks;

//if($op != "delete_block" && $op != "move_block" && $op != "update_block" && $op!="make_block")

/* this check will clob user switch, but AFAIK only admins can manage blocks */
if($admintest != $security_hash)
	html_header_location("index.php");

if ($op=="edit_blocks")
include("header.php");

/* BEGIN ADMIN SWITCH */
if($admintest == $security_hash)
     switch($op)
     {
     case "edit_blocks":
       $blocks->edit_blocks($side);
     break;

     case "move_block":
       $blocks->move_block($id,$action,$side);
     break;

     case "delete_block":
       $blocks->delete_block($id);
     break;

     case "update_block":
       $error_type = "none";

       if($next_import[$id])
        import_no_extra($content, $imported[$id], $imported_stricttypes[$id], $imported_type[$id], $imported_size[$id], $imported_mode[$id]);
	if(($left_location=="on") && ($right_location=="on"))
		$blocks->update_block($id, $title, $content, B, $block_status);
	elseif($left_location=="on")	
		$blocks->update_block($id, $title, $content, L, $block_status);
	else
		$blocks->update_block($id, $title, $content, R, $block_status);
	    html_header_location("mod.php?mod=blocks&op=edit_blocks");
     break;

	case "make_block":
	$error_type = "none";
	
	if($next_import)
	       import_no_extra($content, $imported, $imported_stricttypes, $imported_type, $imported_size, $imported_mode);
	
      	if(($left_location=="on") && ($right_location=="on"))
		$blocks->make_block($title, $content, B);
	elseif($left_location=="on")		
		$blocks->make_block($title, $content, L);
 	else
		$blocks->make_block($title, $content, R);
	html_header_location("mod.php?mod=blocks&op=edit_blocks");
	break;

     case "export":
      $error_type = "none";
      if($id)
        export(array("core_blocks:data",$id,1,"block:content"), $export_mode, $conv, 1);
     break;
}
/* END ADMIN SWITCH */

/* BEGIN USER SWITCH */
/*
if(!$op)
     switch($op) {
     default:  //list_blocks
       $blocks->list_blocks($side);
     }
*/

include("footer.php");
?>
