<?php

/**
 * Right and Left Blocks Class and Functions
 *
 * @version $Id: block.php,v 1.3 2002/01/03 12:40:01 alextxm Exp $
 * @package phpWebSite
 * @author Mike Wilson <mike@tux.appstate.edu>
 */
class block
{
  /**
   * The block's title
   */
  var $title;
  /**
   * The block's content
   */
  var $content;

  /**
   * Sets the title of the block.
   *
   * @param string The title to assign to the block.
   */
  function set_title($new_title)
    {
      global $error_type;

      if (!$new_title) $error_type="title";
      else $this->title=$new_title;
    }

  /**
   * Assigns content to the block.
   *
   * @param string The content to assign to the block.
   */
  function set_content($new_content)
    {
      global $error_type;

      if (!$new_content) $error_type="content";
      else $this->content=$new_content;
    }

  /**
   * Return the title of the block.
   *
   * @return string The title of the block.
   */
  function get_title()
    {
      return $this->title;
    }
  
  /**
   * Returns the content to the block.
   *
   * @return string The content of the block.
   */
  function get_content()
    {
      return $this->content;
    }
  
  /**
   * Shows the block using thememainbox
   *
   */
  function show_block($showfunc="thememainbox")
    {
      $showfunc($this->title,$this->content);
    }

}
