<?php

/**
 * Items managament functions used by some Admin sub-panels
 *
 * @version $Id: itemfuncs.php,v 1.6 2002/02/14 17:59:54 alextxm Exp $
 * @package phpWebSite
 * @module itemfuncs 
 * @modulegroup administration
 * @author Alessandro Pisani (TXM) <alextxm@users.sourceforge.net>
 */

/**
 * Internal function which rebuilds all itemfuncs vars from prefix
 *
 * Internal function which rebuilds all vars needed by itemfuncs from the
 * vars prefix and return them in an array
 *
 */
function _itemfuncs_rebuild_vars($prefix)
{
                $itemtype = "$prefix"."_itemtype";
                $itemtype_mod = "$prefix"."_itemtype_mod";
                $location = "$prefix"."_location";
                $newitem = "$prefix"."_newitem";
                $itemop = "$prefix"."_itemop";
                $itemid = "$prefix"."_itemid";
                $backpoint = "$prefix"."_backpoint";

		global $$itemtype, $$itemtype_mod, $$location, $$newitem, $$itemop, $$itemid, $$backpoint;

		return array($$itemtype, $$itemtype_mod, $$location, $$newitem, $$itemop, $$itemid, $$backpoint);
}


/**
 * Robot function used to create allowed item types HTML tables
 *
 * This function will create a table of items with self Add/Remove/Edit
 * capabilities. This is useful for usage in admin panels.
 *
 */
function configuration_table_items($itemtype,$itemtype_mod,$location,$prefix,$backpoint)
{
	include("config.php");
	
	list($table,$field) = explode(':',$location);
	$result = mysql_query("SELECT $field FROM " . $table_prefix . "$table");
	if(!$result) return;
	else
	 list($data) = mysql_fetch_row($result);

        if(strlen($data))
          $allowed_array = explode(',',stripslashes($data));

	$defaultparams = "&amp;prefix=$prefix&amp;$prefix"."_itemtype_mod=$itemtype_mod&amp;$prefix"."_backpoint=$backpoint&amp;$prefix"."_location=$location&amp;$prefix"."_itemtype=$itemtype";

	$content = "
	<br />
	<a href=\"admin.php?op=configuration_select_items$defaultparams&amp;$prefix"."_itemop=add&amp;$prefix"."_itemid=\">TRANSLATE[[Add new]]</a><br />
	<br />

	<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width = \"100%\">
	<tr><td class=\"type0\">
	<table border=\"0\" cellpadding=\"1\" cellspacing=\"1\" width = \"100%\">\n";

	$mod = ($itemtype_mod) ? "/" : "";
	$vis = ($itemtype_mod) ? "$itemtype$mod" : "";

	if(strlen($data)) {
  	  $how = 0;
	  while($alloweditem = each($allowed_array))
	  {
		$item = ereg_replace("$itemtype/","",$alloweditem[1]);
		$item = ltrim(rtrim($item));

		$content .= "<td class=\"type5\" width=\"25%\"><a href=\"admin.php?op=configuration_select_items$defaultparams&amp;$prefix"."_itemop=modify&amp;$prefix"."_itemid=$how\">$vis$item</a></td>";
		
		$content .= "<td class=\"type5\" width=\"75%\"><a href=\"admin.php?op=configuration_select_items$defaultparams&amp;$prefix"."_itemop=delete&amp;$prefix"."_itemid=$how\">Apaga</td></tr>\n";

		$how++;
	  }
        }

	$content .= "</table>\n</td>\n</tr>\n</table>\n";

	return $content;
}

/**
 *
 * Update/Delete items (generic functions, handles both actions)
 *
 * This function updates or deletes allowed items from a list
 * written to be as much as generic as possible
 */
function configuration_update_items($prefix)
{
	include("config.php");

	// get variables
        list($itemtype, $itemtype_mod, $location, $newitem, $itemop, $itemid, $backpoint) = _itemfuncs_rebuild_vars($prefix);

	list($itemtab,$itemfield) = explode(":",$location);
	$result = mysql_query("select $itemfield from " . $table_prefix."$itemtab");
	list($tmp) = mysql_fetch_row($result);

	$newitem = ltrim(rtrim($newitem));
	$newitem = str_replace("$itemtype/","",$newitem);

	if($itemop!="delete" && (!strlen($newitem) || !eregi("^([a-z0-9-]+)$",$newitem)))
		html_header_location("admin.php?op=$backpoint");

	if(strlen($tmp))
	  $allowed_array = explode(",",$tmp);
	else
	  $allowed_array = array();	 

	$how = count($allowed_array);
	$searchwhat = ($itemtype_mod) ? "$itemtype/$newitem" : "$newitem";
	$t = array_search($searchwhat,$allowed_array);

	// This is redundand, but php 4.1.1 seems to have problems
	// setting result of array_search === FALSE (note: === and not
        // == ), so using in_array/array_search combo is safer.
	if( in_array($searchwhat,$allowed_array) )
	 $t = array_search($searchwhat,$allowed_array);
	else
	 $t = FALSE;

	switch($itemop)
	{
	case "add":
	if($t===FALSE)
	  array_push($allowed_array, $searchwhat);
	break;

	case "modify":
	// no changes: return
	if(!strcasecmp($searchwhat,$allowed_array[$itemid]))
	 break;

	// new modified item does not exist: change item of id $itemid 
	if($t===FALSE)
	  $allowed_array[$itemid] = $searchwhat;
	break;

	case "delete":
	$new=array();

	for($i=0;$i<$itemid;$i++)
	 array_push($new,$allowed_array[$i]);

	for($i=$itemid+1;$i<$how;$i++)
	 array_push($new,$allowed_array[$i]);

	$allowed_array = $new;
	break;
	}

	$allowed_list = addslashes(implode(",",$allowed_array));
	mysql_query("UPDATE $itemtab " . $table_prefix."SET $itemfield='$allowed_list'");
	html_header_location("admin.php?op=$backpoint");
}

/**
 *
 * Internal functions to handle input for an item selected for add/modify/delete
 *
 * This functions edit input for an item which is going to be added,modified or
 * deleted
 * written to be as much generic as possible
 */
function configuration_select_items($prefix)
{
        include("header.php");
        include('config.php');               // $table_prefix variable

        // get variables
	list($itemtype, $itemtype_mod, $location, $newitem, $itemop, $itemid, $backpoint) = _itemfuncs_rebuild_vars($prefix);

	$box_title = "Gerente $itemtype TRANSLATE[[types]]";

	list($itemtab,$itemfield) = explode(":",$location);
	$result = mysql_query("SELECT $itemfield FROM " . $table_prefix."$itemtab");

	list($tmp) = mysql_fetch_row($result);

	if(strlen($tmp))
	 $allowed_array = explode(',',stripslashes($tmp));

	// prepare form fields	 
	if($itemop!="add") {
	 $value = str_replace("$itemtype/","",$allowed_array[$itemid]);
	 
         if($itemop=="delete")
	  $extra = "disabled";
	 }

	// create label for submit button
	switch($itemop)
	 {
	 case "add":
	 $label ="Adicionar";
	 break;

	 case "modify":
	 $label ="Modifica";
	 break;

	 case "delete":
	 $label ="Apaga";
	 break;
	 }

        $mod = ($itemtype_mod) ? "/" : " : ";

	$box_stuff = "<br />
	<form method=\"post\" action=\"admin.php\">
	$itemtype$mod<input type=\"text\" name=\"$prefix"."_newitem\" size=\"10\" value=\"$value\" $extra />&nbsp;";

	$itemid = ($itemid>=0) ? $itemid : "-1";

	$box_stuff .= "
        <br /><br />
        <input type=\"hidden\" name=\"prefix\" value=\"$prefix\" />
        <input type=\"hidden\" name=\"$prefix"."_backpoint\" value=\"$backpoint\" />
        <input type=\"hidden\" name=\"$prefix"."_itemid\" value=\"$itemid\" />
        <input type=\"hidden\" name=\"$prefix"."_itemop\" value=\"$itemop\" />
        <input type=\"hidden\" name=\"$prefix"."_itemtype\" value=\"$itemtype\" />
        <input type=\"hidden\" name=\"$prefix"."_itemtype_mod\" value=\"$itemtype_mod\" />
        <input type=\"hidden\" name=\"$prefix"."_location\" value=\"$location\" />
        <input type=\"hidden\" name=\"op\" value=\"configuration_update_items\" />
        <input type=\"submit\" value=\"$label\" />
	</form>\n";

	themesidebox($box_title,$box_stuff);
	include ("footer.php");
}

?>
