<?php
ob_start();
/**
 * Generates page header.
 *
 * This file creates the "header" of the web page dependent on the
 * theme being used by the user. If the user is not logged in, the
 * default theme header is used.
 *
 * @module header
 * @modulegroup theme
 * @package phpWebSite
 */


/**
 * Global configuration file.
 */
include("config.php");

/**
 * Controls cacheing limits of browsers
 */
CacheControl();

echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">';

/**
 * Generates page header.
 *
 * The function checks if a user variable cookie is present, and
 * determines the corresponding theme files (theme.php and header.php)
 * to include. If unique_titles is set in the config file, the window
 * title will be pulled from the database if the page has a menu entry.
 */
function head()
{
  /**
   * Global configuration file.
   */
	include ("config.php");
	global $siteaddr, $user, $hr, $theme, $cookie, $admintest;
	global $menu;

	$res = mysql_query("select default_theme from ".$table_prefix."flags");
	list($default_theme) = mysql_fetch_row($res);

	if($unique_titles == 1)
	{
	  if(isset($menu)){
	    $res = mysql_query("SELECT menu_text FROM " . $table_prefix."menu WHERE menu_id=$menu");
	    $row = mysql_fetch_assoc($res);
	    $titletag = $row["menu_text"];
	  }
	}

	if(isset($user))
	{
		$user2 = base64_decode($user);
		$cookie = explode(":", $user2);

		if($cookie[9]=="") $cookie[9]="$default_theme";
		if(isset($theme)) $cookie[9]=$theme;

		// extra logic to override previous with $theme override var
	  /**
	   * theme.php of user theme.
	   */
		$theme_exists = @fopen("themes/$cookie[9]/theme.php", "r");
		if($theme_exists)
			include("themes/$cookie[9]/theme.php");
		else
			include("themes/$default_theme/theme.php");
	  /**
	   * header.php of user theme.
	   */
		$header_exists = @fopen("themes/$cookie[9]/header.php", "r");
		if($theme_exists && $header_exists)
			include("themes/$cookie[9]/header.php");
		else
			include("themes/$default_theme/header.php");
	}
	else
	{
	  /**
	   * theme.php of default theme.
	   */
		include("themes/$default_theme/theme.php");
	  /**
	   * header.php of default theme.
	   */
		include("themes/$default_theme/header.php");
	}
}

head();

/**
 * Does some statistics.
 */
include("counter.php");
?>
