<?php

/**
 * Update admin panel
 *
 * @version $Id: update_admin.php,v 1.4 2002/02/01 09:49:42 alextxm Exp $
 * @package phpWebSite
 * @module updateadmin
 * @modulegroup administration
 * @author Alessandro Pisani (TXM) <alextxm@users.sourceforge.net>,
 *	   Jeremy Agee <jagee@tux.appstate.edu>
 */

/**
 * The panel itself
 */
function phpws_update()
{
        include("header.php");
        include('config.php');                                                                                                  // $table_prefix variable
        GraphicAdmin(0);

	$msg = checkversion();
	if(!empty($msg))
		echo $msg;
	else
         {
	 $title = "phpWebSite TRANSLATE[[Update check]]";
	 $box = "TRANSLATE[[Your phpWebSite install is uptodate. No update required]].";
	 thememainbox($title,$box);
	 }

	include ("footer.php");
}


/**
 * Checks the version and displays if an update is avalable.
 *
 * @author Jeremy Agee
 */
function checkversion()
{
    include("config.php");

    /**
     * Contains the version number
     */
    include("version.php");

		$file = @fopen("http://phpwebsite.appstate.edu/downloads/current_version.php", "r");

		if (!$file)
		{
			$notify_version = "TRANSLATE[[Unable to open the version file at phpwebsite.appstate.edu.]]";
		}
		else
		{
			while (!feof ($file))
			{
				$line = fgets ($file, 1024);
			}
			$remote_version = split("_", $line);
			$local_version = split("_", $phpwebsite_version);

			if ($local_version[2][1] == "-"  && $local_version[2][2] == "r" && $local_version[2][3] == "c")
			{

				$notify_version = "You are running release candidate $local_version[0].$local_version[1].$local_version[2]<br />The current stable version is $remote_version[0].$remote_version[1].$remote_version[2]<br />";
				return $notify_version;
			}


			if($local_version[0] <= $remote_version[0])
			{
				$notify_version = "";
				if($local_version[1] <= $remote_version[1])
				{
					$notify_version = "";
					if($local_version[2] < $remote_version[2])
						$notify_version = "
						<table cellspacing=\"4\" cellpadding=\"2\" border=\"0\" width=\"99%\">
						<tr>
       						<td class=\"type5\" valign=\"top\" colspan=\"3\">
        					<span class=\"onebiggerred\"><b>TRANSLATE[[phpWebSite Update]]</b></span><br />
						TRANSLATE[[You are running version]] $local_version[0].$local_version[1].$local_version[2]<br />
						TRANSLATE[[The current version is]] $remote_version[0].$remote_version[1].$remote_version[2]<br />
        					<a href=\"http://phpwebsite.appstate.edu/mod.php?mod=userpage&amp;menu=16&amp;page_id=10\">TRANSLATE[[Download update]]</a><br />
        					</td>
						</tr>
						</table>";
				}
				else
					$notify_version = "
					<table cellspacing=\"4\" cellpadding=\"2\" border=\"0\" width=\"99%\">
					<tr>
       					<td class=\"type5\" valign=\"top\" colspan=\"3\">
        				<span class=\"onebiggerred\"><b>TRANSLATE[[phpWebSite Update]]</b></span><br />
					TRANSLATE[[You are running version]] $local_version[0].$local_version[1].$local_version[2]<br />
					TRANSLATE[[The current version is]] $remote_version[0].$remote_version[1].$remote_version[2]<br />
        				<a href=\"http://phpwebsite.appstate.edu/mod.php?mod=userpage&amp;menu=16&amp;page_id=10\">TRANSLATE[[Download update]]</a><br />
        				</td>
					</tr>
					</table>";
			}
			else
				$notify_version = "
					<table cellspacing=\"4\" cellpadding=\"2\" border=\"0\" width=\"99%\">
					<tr>
       					<td class=\"type5\" valign=\"top\" colspan=\"3\">
        				<span class=\"onebiggerred\"><b>TRANSLATE[[phpWebSite Update]]</b></span><br />
					TRANSLATE[[You are running version]] $local_version[0].$local_version[1].$local_version[2]<br />
					TRANSLATE[[The current version is]] $remote_version[0].$remote_version[1].$remote_version[2]<br />
        				<a href=\"http://phpwebsite.appstate.edu/mod.php?mod=userpage&amp;menu=16&amp;page_id=10\">TRANSLATE[[Download update]]</a><br />
        				</td>
					</tr>
					</table>";

			fclose($file);
		}
	
	return $notify_version;
}

?>
