<?php

/**
 * The backbone of the admin side.
 *
 * This is the backbone of the admin side. It includes all files
 * needed for the admin functions under the "Include Files" section
 * and all operations are function driven by "The Switch" statement at
 * the bottom.
 *
 * @version $Id: admin.php,v 1.184 2002/04/12 17:12:48 ryan Exp $
 * @module admin
 * @modulegroup administration
 * @package phpWebSite
 */
$temp_admin = $current_admin;

// The Include Files

/**
 * Handles the session initialization
 */
include("open_session.php");

/**
 * Contains the back to admin function.
 */
include("core_functions.php");

/**
 * Contains configuration variables for phpWebSite.
 */
include("config.php");

//IF mainfile has not been included THEN include it.
if (!IsSet($mainfile)) {
  /**
   * The core function definitions
   */
  include ("mainfile.php");
}

/**
 * Used to authorize the username and password of an incoming
 * administrator.
 */
include("auth.inc.php");

/**
 * Item handling functions.
 */
include("./itemfuncs.php");
/**
 * Referrer functions to see who is linking to the site.
 */
include("./admin/referer.php");
/**
 * Functions for creating and editing topics.
 */
include("./admin/topics_admin.php");
/**
 * Functions for creating and editing news/announcments and comments.
 */
include("./admin/news.php");
/**
 * Used for editing users and administrators for the web site.
 */
include("./admin/user_admin.php");
/**
/**
 * Used for editing menu items.
 */
include("./admin/menu_edit.php");
/**
 * Banner functions for administration of banners.
 */
include("./admin/banners_admin.php");
/**
 * Used for modification of help.
 */
include("./admin/help_admin.php");
/**
 * Used for the Configuration admin panel.
 */
include("./admin/config_admin.php");
/**
 * Used for the Update admin panel.
 */
include("./admin/update_admin.php");
/**
 * Used for the Look and Feel admin panel.
 */
include("./admin/lookfeel.php");
/**
 * Used for the HTML Setup admin panel.
 */
include("./admin/htmlsetup.php");
/**
 * Used to display module setup links
 */
include("./admin/module_installer.php");
/**
 * Censorship admin
 */
include("./admin/censorship_admin.php");
/*
 * Client Stats
 */
include("./admin/stats.php");


/**
 * Generates the login form.
 *
 * This function takes in the admin username and password and passes
 * them back to admin.php for verification.
 *
 * @author unknown (a phpNuke developer)
 */
function login()
{
  /**
   * Generates the page header
   */
	include ("header.php");

    $box_title = "Administrao - Login";
	$box_stuff = "<form action=\"admin.php\" method=\"post\">
	AdminID&nbsp;&nbsp;
	<input type=\"text\" name=\"current_admin\" size=\"20\" maxlength=\"20\" /><br />
	Senha&nbsp;&nbsp;
	<input type=\"password\" name=\"pwd\" size=\"20\" maxlength=\"18\" />
	<input type=\"hidden\" name=\"op\" value=\"login\" /><br />
	<input type=\"submit\" value=\"Login\" /></form>
	";

	thememainbox($box_title, $box_stuff);
  /**
   * Generates the page footer
   */
	include ("footer.php");
}

/**
 * Displays the admin menu or a link to the admin based on the flag param.
 *
 * @param boolean If false, just show link back to admin
 * @author unknown (a phpNuke developer)
 */
function GraphicAdmin($flag)
{
	include ("config.php");

	$res = mysql_query("select banners from ".$table_prefix."flags");
	list($banners) = mysql_fetch_row($res);

	//Only show icons on MAIN admin page. (increases readability).
	if(!$flag)
	{
		echo "<div style=\"text-align : center\"><a href=\"admin.php\">Voltar ao Menu Admin</a></div>";
		if(!$banners) echo "<br />";
		return;
	}

	$box_title = "Administrao - Incio";

	//if($help_system && $help_system < 3)
	//	$box_title .= help("admin");

	$box_stuff = "
<table cellspacing=\"4\" cellpadding=\"2\" border=\"0\" width=\"99%\">
<tr>
	<td class=\"type5\" valign=\"top\" width=\"25%\">
	<span class=\"onebiggerred\"><b>Blocos</b></span><br />
	<a href=\"mod.php?mod=mainpage&amp;op=edit_mainpage\">TRANSLATE[[Edit Main Page]]</a><br />
	";

	$box_stuff .= "
	<a href=\"admin.php?op=edit_menu\">Editar Menu Principal</a><br />
	<a href=\"mod.php?mod=blocks&op=edit_blocks\">TRANSLATE[[Edit Blocks]]</a><br /><br />
	</td>
	<td class=\"type5\" valign=\"top\" width=\"25%\">
	<span class=\"onebiggerred\"><b>Contedo</b></span><br />
	<a href=\"admin.php?op=adminStory\">TRANSLATE[[New Announcement]]</a><br />
	<a href=\"admin.php?op=listStory\">TRANSLATE[[Edit Announcements]]</a><br />
	<a href=\"admin.php?op=topicsmanager\">Gerencia Tpicos</a><br />
	<a href=\"mod.php?mod=userpage&amp;op=create_userpage\">TRANSLATE[[New Web Page]]</a><br />
	<a href=\"mod.php?mod=userpage&amp;op=list_userpages\">TRANSLATE[[Edit Web Page]]</a><br />
	<a href=\"mod.php?mod=userpage&amp;op=view_pages&amp;set=users\">TRANSLATE[[User Created Pages]]</a><br />
	<a href=\"mod.php?mod=weblink&amp;op=main_layout\">Web Links</a><br />
	<a href=\"mod.php?mod=poll&amp;op=create_poll\">Pesquisa/Enquete</a><br />
	<a href=\"mod.php?mod=comments&amp;op=adminmenu\">Comentrios</a><br />
	</td>
	<td class=\"type5\" valign=\"top\" width=\"25%\">
	<span class=\"onebiggerred\"><b>Acessos / Estatsticas</b></span><br />
	<a href=\"admin.php?op=mod_users\">Editar Usurios</a><br />
	<a href=\"admin.php?op=mod_authors\">Editar Administradores</a><br />
	<a href=\"admin.php?op=logout\">Logout / Sair</a><br />
	<a href=\"admin.php?op=hreferer\">Referncias HTTP</a><br />
	<a href=\"top.php\">10 mais</a><br />
	<a href=\"admin.php?op=view_stats\">Estatstica do Cliente</a><br /><br />
	</td>";

	if($admin_setup)
	{
		$box_stuff .= "
		<td class=\"type5\" valign=\"top\" width=\"25%\">
		<span class=\"onebiggerred\"><b>TRANSLATE[[Setup]]</b></span><br />
		<a href=\"admin.php?op=config_admin\">TRANSLATE[[Configuration]]</a><br />
		<a href=\"admin.php?op=lookfeel\">TRANSLATE[[Look and Feel]]</a><br />
		<a href=\"admin.php?op=htmlsetup\">TRANSLATE[[HTML Setup]]</a><br />
		<a href=\"admin.php?op=censorship_admin\">TRANSLATE[[Censorship]]</a><br />
		<a href=\"admin.php?op=phpws_update\">TRANSLATE[[Update check]]</a><br />
		<a href=\"admin.php?op=moduleinstaller\">TRANSLATE[[Modules Setup]]</a><br />
		<a href=\"admin.php?op=BannersAdmin\">TRANSLATE[[Banners]]</a><br /><br />
		</td>";
	}

$box_stuff .= "
</tr>
</table>";

thememainbox($box_title, $box_stuff);


//BEGIN CODE FOR MODULE ADMIN

	$plug_mysql = mysql_query ("select * from " . $table_prefix."modules");

	if (mysql_num_rows($plug_mysql))
	{
		$count = 0;
		$box_title = "Plug-Ins";
		$box_content = "<table cellspacing=\"4\" cellpadding=\"6\" border=\"0\"><tr>\n";

		while ($row = mysql_fetch_array($plug_mysql))
		{
			if ($count > 4)
			{
				$box_content .= "</tr><tr>";
				$count = 0;
			}

			extract($row);
			if(!$user_only)
			{
				$temp = explode(".", $source_file);
			
				if($temp[0] == "mod")
				{
					if($admin_inc) $temp_url = $source_file . "&amp;op=$admin_inc";
					else $temp_url = $source_file;
				}
				else $temp_url = "./$source_file?plug_id=$plug_id&amp;op=$admin_inc";

				$box_content .= "<td align=\"center\" valign=\"bottom\">
	           		<a href=\"$temp_url\">";

				if(file_exists("./mod/$plug_dir/$img"))
				{
					$imagehw = GetImageSize("./mod/$plug_dir/$img");
					$image_size = $imagehw[3];
					$box_content .= "<img src=\"./mod/$plug_dir/$img\" $image_size alt=\"$about\"  border=\"0\" /></a><br />$name</td>\n";
				}
				else $box_content .= "$name</a></td>\n";

				$count++;
			}
		}
		//if (mysql_num_rows($plug_mysql) > 5)  COMMENTED BY ADAM...NOT SURE IF THIS IS REALLY NEEDED
		//{
			while ($count < 5)
			{
				$box_content .= "<td>&nbsp;</td>";
				$count++;
			}
		//}
		$box_content .= "</tr></table>";
		thememainbox($box_title, $box_content);
	}
//END CODE FOR MODULE ADMIN
}

/**
 * Displays the Announcement Administration on Main Admin Page.
 *
 * @author unknown (a phpNuke developer)
*/
function adminMain()
{
	global $admintest;
	include ("header.php");
	include('config.php');

	GraphicAdmin(1);

	$box_title = "TRANSLATE[[Announcement Administration]]";
	$dummy = 0;
	$result = mysql_query("SELECT qid, subject, timestamp FROM " . $table_prefix."queue order by timestamp");

	if(mysql_num_rows($result) < 1)
	$box_stuff = "<span class=\"onebiggerred\">&gt;</span>&nbsp;&nbsp;Nenhuma Submisso nova<br />";
	else
	{
		$box_stuff = "<span class=\"onebiggerred\">Nova Submisso!</span><br /><br />
		<table cellspacing=\"1\" cellpadding=\"1\" border=\"0\" width=\"99%\">
		";

		while (list($qid, $subject, $timestamp) = mysql_fetch_row($result))
		{
			$subject = stripslashes($subject);
			$hour = "AM";
			ereg ("([0-9]{4})-([0-9]{1,2})-([0-9]{1,2}) ([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})", $timestamp, $datetime);

			if ($datetime[4] > 12)
			$datetime[4] = $datetime[4]-12; $hour = "PM";

			$datetime = date("%A, %B %d @ %T %Z", mktime($datetime[4],$datetime[5],$datetime[6],$datetime[2],$datetime[3],$datetime[1]));
			$box_stuff .= "
<tr>
	<td class=\"type5\"><b>$subject</b></td>
	<td class=\"type5\">$timestamp</td><td class=\"type5\" align=\"right\">
	<a href=\"admin.php?op=DisplayStory&amp;qid=$qid\">Lr Mais...</a> |
	<a href=\"admin.php?op=DeleteStory&amp;qid=$qid\">Apaga</a></td>
</tr>
			";
		}
	}

	if(mysql_num_rows($result))
	$box_stuff .= "</table>";

	thememainbox($box_title, $box_stuff);
	mysql_free_result($result);

	// ---

	$box_title = "TRANSLATE[[Web Links Administration]]";
	$dummy = 0;
	$result = mysql_query("SELECT * FROM " . $table_prefix . "mod_weblink_data WHERE new='1'");

	if(!$num_rows = mysql_num_rows($result))
		$box_stuff = "<span class=\"onebiggerred\">&gt;</span>&nbsp;&nbsp;Nenhuma Submisso nova<br />";
	else
	{
		$box_stuff = "<table boder=\"0\" width=\"100%\" cellpadding=\"0\" callspacing=\"0\"><tr><td>"; 
		$box_stuff .= "<span class=\"onebiggerred\">Nova Submisso!</span><br /><br />";

		if($num_rows == 1)	$box_stuff .= "TRANSLATE[[There is one incoming link]].";
		else			$box_stuff .= "Existem $num_rows TRANSLATE[[incoming links]].";

		$box_stuff .= "</td><td><a href=\"./mod.php?mod=weblink&amp;op=admin_buttons&amp;incoming=1\">TRANSLATE[[Incoming Links]]</a></td></tr>";
	}

	if(mysql_num_rows($result))
	$box_stuff .= "</table>";

	thememainbox($box_title, $box_stuff);
	mysql_free_result($result);

	// ---
	
	$result = mysql_query("SELECT admart FROM " . $table_prefix."flags");
	list($admart) = mysql_fetch_row($result);

	$box_title = "$admart TRANSLATE[[Last Announcements]]";
	$box_stuff = "<table cellspacing=\"1\" cellpadding=\"1\" border=\"0\" width=\"99%\">";

	$result=mysql_query("select sid, title, time, topic, informant, exp_date from " . $table_prefix."stories order by time desc limit 0,$admart");

	if (mysql_num_rows($result) < 1)
	$box_stuff = "<span class=\"onebiggerred\">&gt;</span>&nbsp;&nbsp;TRANSLATE[[No Announcements Found]]";
	else
	{
		while(list($sid, $title, $time, $topic, $informant, $exp_date) = mysql_fetch_row($result))
		{
			$title = stripslashes($title);
			$ta = mysql_query("select topictext from " . $table_prefix."topics where topicid='$topic'");
			list($topictext) = mysql_fetch_row($ta);

			if($exp_date == '2099-12-31 23:59:59') $exp_date = 'TRANSLATE[[No Expiration]]';
			else $exp_date = substr($exp_date,0,10);

			formatTimestamp($time);

			$box_stuff .= "
<tr>
	<td class=\"type5\"><b>$title</b></td>
	<td class=\"type5\">$topictext</td>
	<td class=\"type5\">$exp_date</td>
	<td class=\"type5\" align=\"right\">
	<a href=\"admin.php?op=EditStory&amp;sid=$sid\">Editar</a> |
	<a href=\"admin.php?op=RemoveStory&amp;sid=$sid\">Apaga</a> |
	<a href=\"admin.php?op=RefreshStory&amp;sid=$sid\">Recarregar</a>
	</td>
</tr>
			";
		}
	}

	if (mysql_num_rows ($result))
	$box_stuff .= "</table>";

	thememainbox($box_title, $box_stuff);
	mysql_free_result($result);

	include ("footer.php");
}

/**
 *  Function: The SWITCH (not REALLY a function)
 *  Author:   Started by phpNuke developers and edited by anyone who
 *            touched the admin side.
 *  Purpose:  This switch statement takes the arguement $op passed to the
 *            admin page and decides which functions to call based on
 *            that variable.
 */
//The session variable admintest is used to make sure an administrator has logged in. If NOT then it calls
//the login() function at the bottom of this switch statement.
if ($admintest == $security_hash)
{
	mysql_query("LOCK TABLES ".$table_prefix."stories READ, ".$table_prefix."flags READ, ".$table_prefix."topics READ");
	$res = mysql_query("SELECT announcement_display,topic_display FROM ".$table_prefix."flags");
	list($announcement_display, $topic_display) = mysql_fetch_row($res);

	$res = mysql_query("SELECT count(topicid) FROM ".$table_prefix."topics");
	list($topic_count) = mysql_fetch_row($res);
		
	$res = mysql_query("select count(sid) from " . $table_prefix."stories");
	list($announcement_count) = mysql_fetch_row($res);
	mysql_query("UNLOCK TABLES");

	switch($op)
	{
		case "view_stats":
		ViewStats();
		break;

		case "clear_stats":
		ClearStats();
		break;

		case "update_page_menu":
		update_page_menu($menu_id, $menu_text);
		menu_saved();
		break;

		case "new_menu_item_post":
		$menu_id = menu_post($title, 'content.php');
		mysql_query("update " . $table_prefix."menu set page_id='$page_id' where menu_id='$menu_id'");
		get_menu_text($menu_id);
		break;

		case "page_menu_post":
		page_menu_post($page_id);
		break;

		case "sub_page_menu_post":
		sub_page_menu_post($low_sub, $page_id);
		break;

		case "BannersSaveOptions":
		BannersSaveOptions($setbanners,$banners_myIP);
		break;

		case "BannersAdmin":
		BannersAdmin();
		break;

		case "BannersAdd":
		BannersAdd($name, $cid, $imptotal, $imageurl, $imageborder, $imagealt, $clickurl, $newwin);
		break;

		case "BannerAddClient":
		BannerAddClient($name, $contact, $email, $login, $passwd, $extrainfo);
		break;

		case "BannerFinishDelete":
		BannerFinishDelete($bid);
		break;

		case "BannerDelete":
		BannerDelete($bid, $ok);
		break;

		case "BannerEdit":
		BannerEdit($bid);
		break;

		case "BannerChange":
		BannerChange($bid, $cid, $imptotal, $impadded, $imageurl, $imageborder, $imagealt, $clickurl, $newwin);
		break;

		case "BannerClientDelete":
		BannerClientDelete($cid, $ok);
		break;

		case "BannerClientEdit":
		BannerClientEdit($cid);
		break;

		case "BannerClientChange":
		BannerClientChange($cid, $name, $contact, $email, $extrainfo, $login, $passwd);
		break;

		case "GraphicsAdmin":
		GraphicAdmin();
		break;

		case "hreferer":
		hreferer($sortby, $filter);
		break;

		case "delreferer":
		delreferer($action);
		break;

		case "adminMain":
		adminMain();
		break;

		case "refresh_topic_display":
		update_topic_display($new_display);
		topicsmanager($new_display, 0, $topicid, $topic_count);
		break;

		case "prevTopics":
		$topicid = $topicid - $topic_display;
		if($topicid<0)
			$topicid = 0;
		$res = move_Topics($topicid,$topic_display);
		topicsmanager($topic_display, $res, $topicid, $topic_count);
		break;

		case "nextTopics":
		$new_topicid = $topicid + $topic_display;
		if($new_topicid<$topic_count)
			$topicid = $new_topicid;		
		$res = move_Topics($topicid, $topic_display);
		topicsmanager($topic_display, $res, $topicid, $topic_count);
		break;

		case "topicsmanager":
		topicsmanager($topic_display, 0, 0, $topic_count);
		break;

		case "topicedit":
		topicedit($topicid);
		list_announcements_topic($topicid, $announcement_display, 0, 0);
		include("footer.php");
		break;

		case "topicmake":
		$topic = topicmake($topicparent, $topicname, $topicimage, $topictext, $topiclongtext, $topicimage_name, $topicimage_existing, $topicimage_type, $topicimage_size);
		topicsmanager($topic_display, 0, $topicid, $topic_count);
		break;

		case "topicdelete":
		topicdelete($topicid, $ok);
		break;

		case "topicchange":
		if($save)
			topicchange($topicid, $topicparent, $topicname, $topicimage, $topicimage_existing, $topictext, $topiclongtext, $topicimage_name, $topicimage_type, $topicimage_size, $topicimage_blank);
		else if($delete)
			topicdelete($topicid, $ok);
		
		topicsmanager($topic_display, 0, $topicid, $topic_count);
		break;

		case "sections":
		sections();
		break;

		case "sectionedit":
		sectionedit($secid);
		break;

		case "sectionmake":
		sectionmake($secname, $image);
		break;

		case "sectiondelete":
		sectiondelete($secid, $ok);
		break;

		case "sectionchange":
		sectionchange($secid, $secname, $image);
		break;

		case "secarticleadd":
		secarticleadd($secid, $title, $content);
		break;

		case "secartedit":
		secartedit($artid);
		break;

		case "secartchange":
		secartchange($artid, $secid, $title, $content);
		break;

		case "secartdelete":
		secartdelete($artid, $ok);
		break;

		case "ablock":
		ablock();
		break;

		case "changeablock":
		changeablock($title, $content);
		break;

		case "DisplayStory":
		displayStory($qid);
		break;

		case "PreviewAgain":
		previewStory($qid, $uid, $author, $subject, $hometext, $bodytext, $topic, $month, $day, $year, $allow_expire, $cmt_comments, $cmt_postanon);
		break;

		case "PostStory":
		postStory($qid, $uid, $author, $subject, $hometext, $bodytext, $topic, $notes, $month, $day, $year, $allow_expire, $cmt_comments, $cmt_postanon);
		break;
		
		case "RefreshStory":
		refreshStory($sid);
		break;
		
		case "refresh_announcement_display":
		update_announcement_display($new_display);
		include("header.php");
		back_to_admin();
		list_announcements($sid, 0, $new_display, $announcement_count);
		include("footer.php");
		break;
		
		case "refresh_topic_announcement_display":
		update_announcement_display($new_display);
		topicedit($topicid);
		list_announcements_topic($topicid, $new_display, 0, 0);
		include("footer.php");
		break;

		case "prev_topicStories":
		$result = mysql_query("SELECT sid FROM ".$table_prefix."stories WHERE topic='$topicid' AND sid<'$sid' limit $announcement_display");
		if(mysql_num_rows($result)==$announcement_display)
			$sql = "sid<'$sid'";
		else
			$sql = "sid>0";

		$res = move_topicStories($announcement_display, $topicid, $sql);
		topicedit($topicid);
		list_announcements_topic($topicid, $new_display, $res, $sid);
		include("footer.php");
		break;

		case "next_topicStories":
		$res = mysql_query("SELECT count(sid) FROM ".$table_prefix."stories WHERE topic='$topicid'");
		list($topic_announcement_count) = mysql_fetch_row($res);
		$result = mysql_query("SELECT MAX(sid) FROM ".$table_prefix."stories WHERE topic='$topicid'");
		list($max) = mysql_fetch_row($result);
		if($max!=$sid)
		{
			$sql = "sid>'$sid'";
			$res = move_topicStories($announcement_display, $topicid, $sql);
		}
		else
		{
			$res = mysql_query("SELECT sid, title, time, topic, informant, exp_date FROM ".$table_prefix."stories WHERE topic='$topicid'");
			$count = mysql_num_rows($res);
			$tmp = $count % $announcement_display;
			$row_number = $count - $tmp;
			mysql_data_seek ($res, $row_number);
		}
		topicedit($topicid);
		list_announcements_topic($topicid, $new_display, $res, $sid);
		include("footer.php");
		break;

		case "prevStories":
		$sid = $sid - $announcement_display;
		if($sid<0)
			$sid = 0;
		$res = move_Stories($sid, $announcement_display);
		include("header.php");
		back_to_admin();
		list_announcements($sid, $res, $announcement_display, $announcement_count);
		include("footer.php");
		break;

		case "nextStories":
		$new_sid = $sid + $announcement_display;
		if($new_sid<$announcement_count)
			$sid = $new_sid;
		$res = move_Stories($sid, $announcement_display);
		include("header.php");
		back_to_admin();
		list_announcements($sid, $res, $announcement_display, $announcement_count);
		include("footer.php");
		break;

		case "listStory":
		include("header.php");
		back_to_admin();
		list_announcements($sid, 0, $announcement_display, $announcement_count);
		include("footer.php");
		break;

		case "EditStory":
		editStory($sid);
		break;

		case "RemoveStory":
		removeStory($sid, $ok);
		break;

		case "RemoveComment":
		removeComment($tid, $sid);
		break;

		case "RemovePollComment":
		RemovePollComment($tid, $pollID);
		break;

		case "ChangeStory":
		changeStory($sid, $subject, $hometext, $bodytext, $topic, $notes, $month, $day, $year, $allow_expire, $informant, $cmt_comments, $cmt_postanon);
		break;

		case "DeleteStory":
		deleteStory($qid);
		break;

		case "adminStory":
		adminStory($sid);
		break;

		case "PreviewAdminStory":
		previewAdminStory($subject, $hometext, $bodytext, $topic, $month, $day, $year, $allow_expire,  $cmt_comments, $cmt_postanon);
		break;

		case "PostAdminStory":
		postAdminStory($subject, $hometext, $bodytext, $topic, $month, $day, $year, $allow_expire, $cmt_comments, $cmt_postanon);
		break;

		case "mod_authors":
		displayadmins();
		break;

		case "modifyadmin":
		modifyadmin($chng_aid);
		break;

		case "UpdateAuthor":
		updateadmin($chng_aid, $chng_name, $chng_email, $chng_url, $chng_pwd, $chng_pwd2);
		break;

		case "AddAuthor":
		if (!($add_aid && $add_name && $add_email && $add_pwd))
		{
			echo "You must complete all compulsory fields";
			return;
		}

		$crypt_pass = md5($add_pwd);

		mysql_query("lock tables " . $table_prefix."authors WRITE");
		$result = mysql_query("insert into " . $table_prefix."authors values ('$add_aid','$add_name','$add_url','$add_email','$crypt_pass','0')");
		mysql_query("unlock tables");

		if (!$result)
		{
			echo mysql_errno(). ": ".mysql_error(). "<br />";
			return;
		}
		html_header_location("admin.php?op=adminMain");
		break;

		case "deladmin":
		include("header.php");
		$box_title = "<span class=\"type4bigger\">Apagar autor</span>";
		$box_stuff = "Tem certeza que quer apagar $del_aid?<br />";
		$box_stuff .= "[ <a href=\"admin.php?op=deladminconf&amp;del_aid=$del_aid\">Sim</a>&nbsp;|&nbsp;<a href=\"admin.php?op=mod_authors\">No</a> ]";
		thememainbox($box_title, $box_stuff);
		include("footer.php");
		break;

		case "deladminconf":
		mysql_query("lock tables " . $table_prefix."authors WRITE");
		mysql_query("delete from " . $table_prefix."authors where aid='$del_aid'");
		mysql_query("unlock tables");

		header("location:./admin.php?op=adminMain");
		echo mysql_error();
		break;

		case "mod_users":
		displayUsers();
		break;

		case "modifyUser":
		modifyUser($chng_uid, $chng_uid2);
		break;

		case "updateUser":
		updateUser($chng_uid, $chng_uname, $chng_name, $chng_url, $chng_email, $chng_femail, $chng_pass, $chng_pass2);
		break;

		case "delUser":
		include("header.php");
		if($chng_uid2)
		{
			$result = @mysql_query("SELECT uid FROM " . $table_prefix."users where uname='$chng_uid2'");
			list($uid) = mysql_fetch_row($result);
			$chng_uid = $uid;
		}
		$box_title = "<span class=\"type4bigger\">Delete User</span>";
		$box_stuff = "Are you sure you want to delete user $chng_uid?<br />";
		$box_stuff .= "[ <a href=\"admin.php?op=delUserConf&amp;del_uid=$chng_uid\">Yes</a> | <a href=\"admin.php?op=mod_users\">No</a> ]";
		thememainbox($box_title, $box_stuff);
		include("footer.php");
		break;

		case "delUserConf":
		if ($user_dblocation)
		{
			@mysql_select_db("$user_dbname") or die ("Impossvel selecionar o Banco de Dados");
			
			$result = mysql_query("select uname from " . $table_prefix."users where uid='$del_uid' or uname='$del_uid'");
			list($uname) = mysql_fetch_row($result);

			mysql_query("lock tables " . $table_prefix."users WRITE");
			mysql_query("delete from " . $table_prefix."users where uid='$del_uid' or uname='$del_uid'");
			mysql_query("unlock tables");
			@mysql_select_db("$dbname") or die ("Impossvel selecionar o Banco de Dados");
		}
		else
		{
			$result = mysql_query("select uname from " . $table_prefix."users where uid='$del_uid' or uname='$del_uid'");
			list($uname) = mysql_fetch_row($result);
			
			mysql_query("lock tables " . $table_prefix."users WRITE");
			mysql_query("delete from " . $table_prefix."users where uid='$del_uid' or uname='$del_uid'");
			mysql_query("unlock tables");
		}

		mysql_query("LOCK TABLES " . $table_prefix."stories WRITE");
		mysql_query("UPDATE " . $table_prefix."stories SET informant='$anonymous' WHERE informant='$uname'");
		mysql_query("UPDATE " . $table_prefix."stories SET aid='$anonymous' WHERE aid='$uname'");
		mysql_query("UNLOCK TABLES");

		html_header_location("admin.php?op=adminMain");
		echo mysql_error();
		break;

		case "addUser":
		$add_pwd = md5($add_pass);

		if (!($add_uname && $add_email && $add_pass))
		{
			echo "You must complete all compulsory fields";
			return;
		}

		$sql = "insert into ".$table_prefix."users (name,uname,email,femail,url,pass,conversionflag) values ('$add_name','$add_uname','$add_email','$add_femail','$add_url','$add_pwd','1')";
		
		if ($user_dblocation)
		{
			@mysql_select_db("$user_dbname") or die ("Impossvel selecionar o Banco de Dados");
			mysql_query("lock tables " . $table_prefix."users WRITE");
			$result = mysql_query($sql);
			mysql_query("unlock tables");
			@mysql_select_db("$dbname") or die ("Impossvel selecionar o Banco de Dados");
		}
		else
		{
			mysql_query("lock tables " . $table_prefix."users WRITE");
			$result = mysql_query($sql);
			mysql_query("unlock tables");
		}

		if (!$result)
		{
			echo mysql_errno(). ": ".mysql_error(). "<br />";
			return;
		}
		html_header_location("admin.php?op=mod_users");
		break;

		case "create":
		poll_createPoll($flip);
		break;

		case "createPosted":
		mysql_query("update " . $table_prefix."flags set poll='1'");
		poll_createPosted();
		break;

		case "poll_active":
		if($active == 1)
		 mysql_query("update " . $table_prefix."flags set poll='1'");
		else
		 mysql_query("update " . $table_prefix."flags set poll='0'");
		poll_createPoll();
		break;

		case "poll_editPoll":
		poll_editPoll($pollID);
		break;

		case "ChangePoll":
		ChangePoll($pollID, $pollTitle, $optionText, $optionCount, $voteID);
		break;

		case "remove":
		poll_removePoll();
		break;

		case "removePosted":
		poll_removePosted();
		break;

		case "view":
		poll_viewPoll();
		break;

		case "viewPosted":
		poll_viewPosted();
		break;

		case "logout":
		$admintest = "";
		$current_admin="";
		session_unregister("admintest");
		session_unregister("current_admin");
		$titlebar = "Logged out";
		include("header.php");
		thememainbox("Voc est agora deslogado", "<br /><a href=\"index.php\">Clique aqui para voltar para a pgina principal</a>");
		include("footer.php");
		break;


		case "edit_menu":
		edit_menu();
		break;

		case "add_main_menu":
		add_main_menu();
		break;

		case "menu_post":
		menu_post($menu_text, $menu_url);
		edit_menu();
		break;


		case "add_sub_menu":
		add_sub_menu();
		break;

		case "sub_menu_post":
		sub_menu_post($low_sub, $menu_text, $menu_url);
		edit_menu();
		break;

		case "menu_prompt_delete":
		menu_prompt_delete();
		break;

		case "menu_delete":
		menu_delete($menu_id);
		edit_menu();
		break;

		case "menu_active":
		menu_active($menu_id, $menu_active);
		edit_menu();
		break;

		case "edit_menu_item":
		edit_menu_item($menu_id);
		break;

		case "update_menu_item":
		update_menu_item($menu_id, $menu_text, $menu_url);
		edit_menu();
		break;

		case "order_menu":
		order_menu($menu_id);
		break;

		case "update_menu_order":
		update_menu_order($menu_id, $menu_order, $move);
		order_menu($menu_id);
		break;

		case "menu_error":
		menu_error();
		break;

		case "moduleinstaller":
		module_installer();
		break;

                case "phpws_update":
                phpws_update();
                break;

                case "censorship_admin":
                censorshipadmin();
                break;

                case "save_censorship":
                save_censorship($censorship_censor_mode,$censorship_censor_replace);
                break;

                case "config_admin":
                configadmin();
                break;

                case "save_configuration":
                save_configuration($config_login_switch,$config_show_comments,$config_max_image_size,$config_max_import_size,$config_files_umask,$config_limit_cache, $config_url_to_email, $config_system, $config_admart, $config_minpass, $config_top, $config_maintop, $config_oldnum, $config_notify,$config_notify_email,$config_notify_subject,$config_notify_message,$config_notify_from);
                break;

		case "config_restore_mainpage":
		config_restore_mainpage();
		break;
                
		/*
		 * items management
		 */

		case "configuration_select_items":
		configuration_select_items($prefix);
		break;

		case "configuration_update_items":
		configuration_update_items($prefix);
		break;
		
		/*
		 * end of items management
		 */
                
                case "lookfeel":
                lookfeel();
                break;

                case "save_lookfeel":
                save_lookfeel($lf_default_theme,$lf_disable_themes,$lf_block_percent,$lf_extend_menu,$lf_show_articles_morebytes,$lf_footlines, $lf_show_article_read);
                break;
                
		case "htmlsetup":
                htmlsetup();
                break;
		
		case "htmlsetup_add_allowed_tags":
		htmlsetup_add_html_tag();
		break;
		
		case "htmlsetup_delete_allowed_tags":
		htmlsetup_delete_html_tag($hs_tag_id);
		break;
		
		case "htmlsetup_edit_allowed_tags":
		htmlsetup_edit_html_tag($hs_tag_id);
		break;
		
		case "htmlsetup_update_allowed_tags":
		htmlsetup_update_html_tag($hs_tag,$hs_tag_mode_user,$hs_tag_id);
		break;

		default:
		adminMain();
		break;
	}
}
//IF NOT ADMIN FORCE USER TO LOG IN.
else
login();

?>
