# File: createdb.sql
# Script Name: vNews 1.2
# Author: Vincent Ryan Ong
# Email: support@beanbug.net
#
# Description:
# vNews is a site news script used to relay the latest information
# regarding any topic to visitors. And being a part of vScripts,
# vNews comes with a powerful and flexible administration module 
# where administrators/webmasters can easily change the look of 
# the embedded news to conform with their existing site design.

# This script is a freeware but if you want to give donations,
# please send your checks (coz cash will probably be stolen in the
# post office) them to:
#
# Vincent Ryan Ong
# Rm. 440 Wellington Bldg.
# 655 Condesa St. Binondo, Manila
# Philippines, 1006
#
# --------------------------------------------------------
#
# Table structure for table 'newscontent'
#

CREATE TABLE newscontent (
   id int(11) NOT NULL auto_increment,
   news mediumtext NOT NULL,
   event datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
   PRIMARY KEY (id)
);

#
# Dumping data for table 'newscontent'
#

INSERT INTO newscontent VALUES ( '1', 'News script successfully set up.', NOW());

# --------------------------------------------------------
#
# Table structure for table 'newsdesign'
#

CREATE TABLE newsdesign (
   id tinyint(4) NOT NULL auto_increment,
   sAlignment varchar(6) NOT NULL,
   sWidth tinyint(4) DEFAULT '0' NOT NULL,
   sBSize tinyint(4) DEFAULT '0' NOT NULL,
   sBColor varchar(6) NOT NULL,
   hTitle varchar(30) NOT NULL,
   hBold char(1) NOT NULL,
   hAlignment varchar(6) NOT NULL,
   hBGcolor varchar(6) NOT NULL,
   hFont varchar(25) NOT NULL,
   hColor varchar(6) NOT NULL,
   hSize tinyint(4) DEFAULT '0' NOT NULL,
   dDate char(1) NOT NULL,
   dTime char(1) NOT NULL,
   dAlignment varchar(6) NOT NULL,
   dBold char(1) NOT NULL,
   dFont varchar(25) NOT NULL,
   dColor varchar(6) NOT NULL,
   dSize tinyint(4) DEFAULT '0' NOT NULL,
   cAlignment varchar(6) NOT NULL,
   cBGcolor varchar(6) NOT NULL,
   cBold char(1) NOT NULL,
   cFont varchar(25) NOT NULL,
   cColor varchar(6) NOT NULL,
   cSize tinyint(4) DEFAULT '0' NOT NULL,
   cShowMax int(11) DEFAULT '0' NOT NULL,
   PRIMARY KEY (id)
);

#
# Dumping data for table 'newsdesign'
#

INSERT INTO newsdesign VALUES ( '1', 'Center', '50', '1', '000000', 'vNews 1.0', 'y', 'Center', 'FF9900', 'Verdana', 'FFFFCC', '2', 'y', 'y', 'Left', 'n', 'Verdana', '990000', '2', 'Left', 'CCCCCC', 'N', 'Verdana', '000000', '2', '999');

