<?php
/*	eCorrei 1.2 - Main script
	A webbased E-mail solution
	Page: http://ecorrei.sourceforge.net/
	E-mail: jvreuls@f2s.com	
	Date: 24 September 2001
	Author: Jeroen Vreuls
	Copyright (C) 2000-2001 Jeroen Vreuls
		
	See the enclosed LICENSE file for license information or go to
	http://www.fsf.org/copyleft/gpl.html	
*/
	define("VERSION", "1.2");
	require("config.php");

	# Temp dir
	if (empty($tmpdir)) {
		$tmpdir = ini_get("upload_tmp_dir");
		if (empty($tmpdir)) {
			die("<p><font color=\"#FF0000\"><b>Please set 'upload_tmp_dir' in php.ini or set \$tmpdir in config.php!</b></font</p>");
		}
		$tmpdir .= "/";
	}

	# Don't cache pages
	header("Cache-Control: no-cache");
	header("Cache-Control: no-store");
	header("Pragma: no-cache");

	# Define global vars
	session_start();
	session_register("usr_username", "usr_encpasswd", "usr_domainnr", "usr_accessmethod", "usr_inmailport", "usr_inmailserver", "usr_langcode");   
	if (!$bypasscheck) {
		if (empty($usr_username) or empty($usr_encpasswd) or !isset($usr_domainnr) or empty($usr_accessmethod) or empty($usr_inmailport) or empty($usr_inmailserver) or empty($usr_langcode)) {
			header("Location: " . $protocol . "://" . $hostname . $ecorreidir . "index.php?action=wronglogin"); 
			exit();
		}
		$usr_password = decrypt($usr_encpasswd);
		$connectstring = $usr_inmailserver . "/" . $usr_accessmethod . ":" . $usr_inmailport;
	}

	if (isset($language) && !isset($usr_langcode)) {
		if ($language >= count($languages) or $language < 0) {
			exit();
		}
		$usr_langcode = $languages[$language]->code;
	}
	elseif (!isset($usr_langcode)) {
		$usr_langcode = $default_lang;
	}
	require($langdir . "lang." . $usr_langcode . ".php");

	$btn_create = "<td align=\"center\"><a href=\"create.php\"><img src=\"" . $imgdir . "btn_create.gif\" width=\"50\" height=\"45\" border=\"0\" alt=\"$lang_create\"></a><br><font size=\"1\" class=\"footer\" face=\"Verdana, Arial\">$lang_create</font></td>\n";
	$btn_refresh = "<td align=\"center\"><a href=\"inbox.php\"><img src=\"" . $imgdir . "btn_refresh.gif\" width=\"50\" height=\"45\" border=\"0\" alt=\"$lang_refresh\"></a><br><font size=\"1\" class=\"footer\" face=\"Verdana, Arial\">$lang_refresh</font></td>\n";
	$btn_inbox = "<td align=\"center\"><a href=\"inbox.php\"><img src=\"" . $imgdir . "btn_inbox.gif\" width=\"50\" height=\"45\" border=\"0\" alt=\"$lang_inbox\"></a><br><font size=\"1\" class=\"footer\" face=\"Verdana, Arial\">$lang_inbox</font></td>\n";
	$btn_reply = "<td align=\"center\"><a href=\"create.php?action=reply&msg=$msg\"><img src=\"" . $imgdir . "btn_reply.gif\" width=\"50\" height=\"45\" border=\"0\" alt=\"$lang_reply\"></a><br><font size=\"1\" class=\"footer\" face=\"Verdana, Arial\">$lang_reply</font></td>\n";
	$btn_forward = "<td align=\"center\"><a href=\"create.php?action=forward&msg=$msg\"><img src=\"" . $imgdir . "btn_forward.gif\" width=\"50\" height=\"45\" border=\"0\" alt=\"$lang_forward\"></a><br><font size=\"1\" class=\"footer\" face=\"Verdana, Arial\">$lang_forward</font></td>\n";
	$btn_delete = "<td align=\"center\"><a href=\"delete.php?msg=$msg\"><img src=\"" . $imgdir . "btn_delete.gif\" width=\"50\" height=\"45\" border=\"0\" alt=\"$lang_delete\"></a><br><font size=\"1\" class=\"footer\" face=\"Verdana, Arial\">$lang_delete</font></td>\n";
	$btn_send = "<td align=\"center\"><input type=\"image\" src=\"" . $imgdir . "btn_send.gif\" alt=\"$lang_send\" border=\"0\"><br><font size=\"1\" class=\"footer\" face=\"Verdana, Arial\">$lang_send</font></td>\n";
	$btn_logout = "<td align=\"center\"><a href=\"index.php?action=logout\"><img src=\"" . $imgdir . "btn_logout.gif\" width=\"50\" height=\"45\" border=\"0\" alt=\"$lang_logout\"></a><br><font size=\"1\" class=\"footer\" face=\"Verdana, Arial\">$lang_logout</font></td>\n"; 
	$btn_delete_form = "<td align=\"center\"><input type=\"image\" src=\"" . $imgdir . "btn_delete.gif\" alt=\"$lang_delete\" border=\"0\"><br><font size=\"1\" class=\"footer\" face=\"Verdana, Arial\">$lang_delete</font></td>\n";
	$btn_options = "<td align=\"center\"><a href=\"options.php\"><img src=\"" . $imgdir . "btn_options.gif\" width=\"50\" height=\"45\" alt=\"$lang_options\" border=\"0\"></a><br><font size=\"1\" class=\"footer\" face=\"Verdana, Arial\">$lang_options</font></td>\n";
	$btn_contacts = "<td align=\"center\"><a href=\"contacts.php\"><img src=\"" . $imgdir . "btn_contacts.gif\" width=\"50\" height=\"45\" alt=\"$lang_contacts\" border=\"0\"></a><br><font size=\"1\" class=\"footer\" face=\"Verdana, Arial\">$lang_contacts</font></td>\n";
	$btn_newgrp = "<td align=\"center\"><a href=\"contacts.php?action=newgrp\"><img src=\"" . $imgdir . "btn_newgrp.gif\" width=\"50\" height=\"45\" alt=\"$lang_contacts_new_group\" border=\"0\"></a><br><font size=\"1\" class=\"footer\" face=\"Verdana, Arial\">$lang_contacts_new_group</font></td>\n";
	$btn_add = "<td align=\"center\"><a href=\"contacts.php?action=add\"><img src=\"" . $imgdir . "btn_add.gif\" width=\"50\" height=\"45\" alt=\"$lang_contacts_add\" border=\"0\"></a><br><font size=\"1\" class=\"footer\" face=\"Verdana, Arial\">$lang_contacts_add</font></td>\n";

	# Functions & subs
	function print_header($title, $toolbar, $form, $head) {
		global $imgdir, $bgcolor, $titlebarcolor, $titlebartxtcolor, $windowbgcolor, $headersent, $lang_charset, $htmlpre;
		$headersent = 1; 
		print "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n";
		print "<html>\n";
		print "<head>\n";
		print "<script language=\"JavaScript\" type=\"text/javascript\">\n";
		print "<!--\n";
		print "function emptystr(string) {\n";
		print "	var x = 0;\n";
		print "	var chr;\n";
		print "	var empty = true;\n";
		print "	if (string.length) {\n";
		print "		do {\n";
		print "			chr = string.substring(x, x + 1);\n";
		print "			x++;\n";
		print "			empty = (chr == ' ' || chr == '\\t' || chr == '\\n' || chr == '\\r');\n";
		print "		} while (empty && x < string.length);\n";
		print "	}\n";
		print "	return empty;\n";
		print "}\n";
		print "//-->\n";
		print "</script>\n";
		print "$head\n";
		print "<meta http-equiv=\"Pragma\" content=\"no-cache\">\n";
		print "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=$lang_charset\">\n";
		print "<link rel=\"stylesheet\" href=\"" . $imgdir . "style.css\" type=\"text/css\">\n";
		print "<title>$title - eCorrei</title>\n";
		print "</head>\n";
		print "<body bgcolor=\"$bgcolor\" link=\"#0000FF\">\n";
		print "$htmlpre";
		print "<div align=\"center\">\n";
		print "$form\n";
		print "<table width=\"90%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n";
		print "<tr>\n";
		print "	<td bgcolor=\"$titlebarcolor\" height=\"20\" width=\"100%\">\n";
		print "	<font face=\"Verdana, Arial\" size=\"2\" class=\"caption\" color=\"$titlebartxtcolor\"><b>&nbsp; $title - eCorrei</b></font></td>\n";
		print "</tr>\n";
		print "<tr>\n";
		print "	<td bgcolor=\"$windowbgcolor\" height=\"25\" width=\"100%\"><div align=\"center\">\n";
		print "	<table border=\"0\" cellpadding=\"3\" cellspacing=\"0\">\n";
		print "	<tr>\n";
		print "	$toolbar\n";
		print "	</tr>\n";
		print "	</table>\n";
		print "	</div>\n";
		print "	</td>\n";
		print "</tr>\n";
	}
	
	function print_miniheader($title, $form, $head) {
		global $headersent, $titlebarcolor, $titlebartxtcolor, $imgdir, $bgcolor;
		$headersent = 1; 
		print "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n";
		print "<html>\n";
		print "<head>\n";
		print "<script language=\"JavaScript\" type=\"text/javascript\">\n";
		print "<!--\n";
		print "function emptystr(string) {\n";
		print "	var x = 0;\n";
		print "	var chr;\n";
		print "	var empty = true;\n";
		print "	if (string.length) {\n";
		print "		do {\n";
		print "			chr = string.substring(x, x + 1);\n";
		print "			x++;\n";
		print "			empty = (chr == ' ' || chr == '\\t' || chr == '\\n' || chr == '\\r');\n";
		print "		} while (empty && x < string.length);\n";
		print "	}\n";
		print "	return empty;\n";
		print "}\n";
		print "//-->\n";
		print "</script>\n";
		print "$head\n";
		print "<meta http-equiv=\"Pragma\" content=\"no-cache\">\n";
		print "<link rel=\"stylesheet\" href=\"" . $imgdir . "style.css\" type=\"text/css\">\n";
		print "<title>$title - eCorrei</title>\n";
		print "</head>\n";
		print "<body bgcolor=\"$bgcolor\" link=\"#0000FF\">\n";
		print "<div align=\"center\">\n";
		print "$form\n";
		print "<table width=\"95%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n";
		print "<tr>\n";
		print "	<td bgcolor=\"$titlebarcolor\" height=\"20\" width=\"100%\">\n";
		print "	<font face=\"Verdana, Arial\" size=\"2\" class=\"caption\" color=\"$titlebartxtcolor\"><b>&nbsp; $title - eCorrei</b></font><td>\n";
		print "</tr>\n";
	}	
	
	function print_footer($form) {
		global $htmlfooter;
		print "</table>\n";
		print "$form</div>\n";
		print "$htmlfooter\n";
		print "<div align=\"center\">\n";
		print "<hr width=\"80%\" size=\"1\">\n";
		print "<font face=\"Verdana\" class=\"footer\" size=\"2\">\n";
		print "<a href=\"http://ecorrei.sourceforge.net/\" target=\"_blank\">eCorrei " . VERSION . "</a> - &copy; 2000-2001 by Jeroen Vreuls.\n";	
		print "</font></div>\n";
  		print "</body></html>\n";
	}	

	function print_minifooter($form) {
		print "</tr>\n";
		print "</table>\n";
		print "$form</div>\n";
  		print "</body></html>\n";
	}	

	function encrypt($text) {
		for ($x=0;$x<strlen($text);$x++) {
			$nr = ord($text[$x]);
			if ($nr < 128) {
				$nr += 128;
			}
			elseif ($nr > 127) {
				$nr -= 128;
			}
			$nr = 255 - $nr;
			$outp .= sprintf("%02x", $nr);
		}
		return $outp;
	}

	function decrypt($text) {
		for ($x=0;$x<(strlen($text)/2);$x++) {
			$nr = hexdec($text[$x * 2] . $text[($x * 2) + 1]);
			$nr = 255 - $nr;
			if ($nr < 128) {
				$nr += 128;
			}
			elseif ($nr > 127) {
				$nr -= 128;
			}
			$outp .= chr($nr);
		}
		return $outp;
	}

	# SMTP Class
	class SMTP {
		var $fp = 0;

		function connect($hostname, $port) {
			$this->fp = fsockopen($hostname, $port);
			if (!$this->fp) {
				return 1;
			}
			else {
				$line = fgets($this->fp,1024);
				if (substr($line,0,3) != "220") {
					fclose($this->fp);
					return 2;
				}
				fputs($this->fp,"HELO $hostname\r\n");
				$line = fgets($this->fp, 1024);	
				if (substr($line,0,3) != "250") {
					fclose($this->fp);
					return 3;
				}
				return 4;
			}
		}
		function maildata($mailfrom, $mailto, $maildata) {
			fputs($this->fp, "MAIL FROM: <$mailfrom>\r\n");	
			$line = fgets($this->fp, 1024);
			if (substr($line,0,3) != "250") {
				fclose($this->fp);
				return 1;
			}
			fputs($this->fp, "RCPT TO: <$mailto>\r\n");	

			$line = fgets($this->fp, 1024);
			if (substr($line,0,3) != "250") {
				fclose($this->fp);
				return 2;
			}
			fputs($this->fp, "DATA\r\n");

			$line = fgets($this->fp, 1024);
			if (substr($line,0,3) != "354") {
				fclose($this->fp);
				return 3;
			}
		
			fputs($this->fp, $maildata);
			fputs($this->fp, "\r\n.\r\n");	

			$line = fgets($this->fp, 1024);
			if (substr($line,0,3) != "250") {
				fclose($this->fp);
				return 4;
			}
			return 6;
		}
		function close() {
			fputs($this->fp, "QUIT\r\n");

			$line = fgets($this->fp, 1024);
			if (substr($line,0,3) != "221") {
				fclose($this->fp);
				return 1;
			}
			fclose($this->fp);
		}
	}

	function is_even($number) {
		$res = $number / 2;
		if ($res != intval($res)) {
			return FALSE;
		}
		else {
			return TRUE;
		}
	}

	function convsize ($size) {
		if ($size > 1048576) {
			# Convert to MB
			return sprintf("%.1f MB", $size / 1048576);
		}
		else {
			# Convert to kB
			return sprintf("%.1f kB", $size / 1024);
		}
	}
	
	function mimetype ($mime) {
		switch ($mime) {
			case 6:
				return "video";
				break;
			case 5:
				return "image";
				break;
			case 4:
				return "audio";
				break;
			case 3:
				return "application";
				break;
			case 2:
				return "message";
				break;
			default:
				return "text";
				break;
		}
	}

	function invmimetype ($type) {
		switch (strtolower($type)) {
			case "video":
				return 6;
				break;
			case "image":
				return 5;
				break;
			case "audio":
				return 4;
				break;
			case "application":
				return 3;
				break;
			case "message":
				return 2;
				break;
			case "multipart": 
				return 1;
				break;
			case "text":
				return 0;
				break;
			default:
				return 3;
				break;
		}
	}

	function convsig($text) {
		$text = eregi_replace("\r", "", $text);
		$text = eregi_replace("\n", "\\n", $text);
		$text = eregi_replace('\"', '\\"', $text);
		return $text;
	}

	function error($err) {
		global $headersent, $darkbarcolor, $lang_error;
		if (!$headersent) {
			print_header($lang_error, "", "", "");
		}
		print "<tr>\n";
		print "	<td bgcolor=\"$darkbarcolor\" width=\"100%\">\n";
		print "	<font face=\"Verdana, Arial\" size=\"2\">&nbsp;$err</font>\n";
		print "	</td>\n";
		print "</tr>\n";
		print_footer("");
		exit();
	}

	function get_options() {
		global $usr_username, $usr_inmailserver, $usr_domainnr, $domains, $userpath;
		$data = array();
		if (file_exists($userpath . $usr_username . "@" . $usr_inmailserver)) {
			$data = file($userpath . $usr_username . "@" . $usr_inmailserver);
			$regs = array();
			for ($x=0;$x<sizeof($data);$x++) {
				$line = trim($data[$x]);
				if (ereg("^Real Name: (.*)", $line, $regs)) {
					$realname = urldecode($regs[1]);
				}
				elseif (ereg("^Real Email: (.*)", $line, $regs)) {
					$realemail = urldecode($regs[1]);
				}
				elseif (ereg("^Signature: (.*)", $line, $regs)) {
					$signature = urldecode($regs[1]);
				} 
			}
		}
		else {
			# Create file
			$realname = ucfirst($usr_username);
			$outf = fopen($userpath . $usr_username . "@" . $usr_inmailserver, "w");
			flock($outf, 2);
			fwrite($outf, "Real Name: " . urlencode($realname) . "\n");
			fwrite($outf, "Real Email: " . urlencode($usr_username . "@" . $domains[$usr_domainnr]->name) . "\n");
			flock($outf, 3);
			fclose($outf); 
		}
		return array($realname, $realemail, $signature);
	}

	function get_addresses() {
		global $usr_username, $usr_inmailserver, $userpath, $lang_err_datafile_not_found;
		$data = array();
		$groups = array();
		$addr = array();
		$regs = array();
		if (file_exists($userpath . $usr_username . "@" . $usr_inmailserver)) {
			$data = file($userpath . $usr_username . "@" . $usr_inmailserver);
		}
		else {
			error($lang_err_datafile_not_found);
		}
		# Parse file
		for ($c=0;$c<sizeof($data);$c++) {
			$line = trim($data[$c]);
			if (eregi("^Groups: (.*)", $line, $regs)) {
				$grpdata = urldecode($regs[1]);
			}
			elseif (eregi("^Addresses: (.*)", $line, $regs)) {
				$addrdata = urldecode($regs[1]);
			}
		}
		if ($grpdata) { $groups = explode("\n", $grpdata); }
		if ($addrdata) { $addr = explode("\n", $addrdata); }
		return array($groups, $addr);
	}
			
	function update_file($directive, $update) {
		global $usr_username, $usr_inmailserver, $userpath, $lang_err_datafile_not_found, $lang_err_file_too_big, $maxfilesize;
		$update = urlencode($update);
		# Open file
		$data = array();
		$dirfound = 0;		
		if (file_exists($userpath . $usr_username . "@" . $usr_inmailserver)) {
			$data = file($userpath . $usr_username . "@" . $usr_inmailserver);
		}
		else {
			error($lang_err_datafile_not_found);
		}
		$cnt = "";
		for ($m=0;$m<sizeof($data);$m++) {
			if (ereg("^" . $directive . ": .*", trim($data[$m]))) {
				$cnt .= $directive . ": " . $update . "\n";
				$dirfound = 1;
			}
			else {
				$cnt .= $data[$m];
			}
		}
		if (!$dirfound) {
			$cnt .= $directive . ": " . $update . "\n";
		}
		if (strlen($cnt) > $maxfilesize) {
			error($lang_err_file_too_big);
		}
		$outf = fopen($userpath . $usr_username . "@" . $usr_inmailserver, "w");
		flock($outf, 2);
		fwrite($outf, $cnt);
		flock($outf, 3);
		fclose($outf);
	}
 
	function decode_vcard($vcard) {
		# Decodes a VCard. I don't know if this complies with the standards...
		$is_vcard = 0;
		$lines = explode("\n", $vcard);
		for ($x=0;$x<sizeof($lines);$x++) {
			$line = trim($lines[$x]);
			if (eregi("begin:vcard", $line) or eregi("end:vcard", $line)) {
				$is_vcard++;
			}
			elseif (eregi("fn:(.*)", $line, $reg)) {
				$fn = $reg[1];
			}
			elseif (eregi("email;pref;internet:(.*)", $line, $reg)) {
				$email = $reg[1];
			}
		}			
		if ($is_vcard == 2) {
			return array($fn, $email);
		}
		else {
			return false;
		}
	}

	function getheadervalue($fieldname, $header) {
		$header = eregi_replace("\t", " ", $header);
		$results = array();
		if (eregi("$fieldname (.*)", $header, $results)) {
			$fieldval = $results[1];
			for ($b=0;$b<=strlen($fieldval);$b++) {
				$curr = substr($fieldval, $b, 1);
				$next = substr($fieldval, $b + 1, 1);
				if ($curr == "\n" && $next != " ") {
					break;
				}
				if ($curr == "\t") { $curr = " "; }
				if ($curr == "\n") { $curr = ""; }
				$resu .= $curr; 
			}
		}
		$resu = eregi_replace("\([^\)]*\)", "", $resu);
		return $resu;
	}

	function convert_email($email) {
		global $lang_err_invalid_email;
		$resu = array();
		if (eregi("\"([^\"]*)\" <([^>]*)>", $email, $resu)) {
			return $resu[2];
		}
		elseif (eregi("([^ ]*) <([^>]*)>", $email, $resu)) {
			return $resu[2];
		}
		elseif (eregi("<([^>]*)>", $email, $resu)) {
			return $resu[1];
		}
		elseif (eregi("(.*@.*\..*)", $email, $resu)) {
			return $resu[1];
		} 
		else {
			error($lang_err_invalid_email);
		}
	} 

	function parse_text($text) {
		$text = eregi_replace("\"", "&quot;", $text);
		$text = eregi_replace("'", "&#039;", $text);
		$text = eregi_replace("<", "&lt;", $text);
		$text = eregi_replace(">", "&gt;", $text);
		
		$text = eregi_replace("([:; \(\n])(([-&\._a-z0-9]*)@([a-z0-9-]*)\.([-\.a-z0-9]*))", "\\1<a href=\"create.php?to=\\2\">\\2</a>", $text);
		$text = eregi_replace("([[:alnum:]]+)://([a-z0-9/=?%#&_\.-]*)", "<a href=\"\\1://\\2\" target=\"_blank\">\\1://\\2</a>", $text);
		$text = eregi_replace("([^[:alnum:]\"/])(www\.)([a-z0-9/=?%#&_\.-]*)", "\\1<a href=\"http://\\2\\3\" target=\"_blank\" target=\"_new\">\\2\\3</a>", $text);
		$text = eregi_replace("([^[:alnum:]\"/>])(ftp\.)([a-z0-9/=?%#&_\.-]*)", "\\1<a href=\"ftp://\\2\\3\" target=\"_blank\" target=\"_new\">\\2\\3</a>", $text);

		$text = eregi_replace("  ", "&nbsp;&nbsp;", $text);
		return nl2br($text);
	}

	function parse_html($text) {
		$text = eregi_replace("<a ([^>]*)>", "<a target=\"_blank\" \\1>", $text);
		return $text;
	}	

	function html2text($html) {
		$html = eregi_replace("\r", "", $html);
		$html = eregi_replace("\n", " ", $html);
		$html = eregi_replace("\t", " ", $html);
		$html = eregi_replace("[ ]([ ]*)", " ", $html);
		$html = eregi_replace("<br([^>]*)>", "\n", $html);
		$html = eregi_replace("<p([^>]*)>", "\n\n", $html);
		$html = eregi_replace("</div([^>]*)>", "\n", $html);
		$html = eregi_replace("(&nbsp;)", " ", $html);
		return strip_tags($html);
	}

	function uniqueid() {
		return md5(uniqid(rand()));
	}

	function validate_email($email) {
		return eregi("^([-&\._a-z0-9]*)@([a-z0-9-]*)\.([-\.a-z0-9]*)$", $email);
	}

	function validate_name($name) {
		return eregi("[|\r\n\x22]", $name);
	}

	function validate_group($group) {
		return eregi("[|\r\n]", $group);
	}
?>
