<?php
/*	eCorrei 1.2 - Configure script
	A webbased E-mail solution
	Page: http://ecorrei.sourceforge.net/
	E-mail: jvreuls@f2s.com	
	Date: 24 September 2001
	Author: Jeroen Vreuls
	Copyright (C) 2000-2001 Jeroen Vreuls
		
	See the enclosed LICENSE file for license information or go to
	http://www.fsf.org/copyleft/gpl.html	
*/


# CONFIGURE HERE
################

# eCorrei dir
# Path to use in URL's to point to the eCorrei directory
# Include a trailing slash
$ecorreidir = "/ecorrei/";

# Image dir
# Path to use in URL's to point to the eCorrei images directory
# Include a trailing slash
$imgdir = "/ecorrei/images/";

# User path (where user settings are stored)
# See SECURITY for details
# Can be relative to current dir or can be absolute path
# Must be chmodded 777, include a trailing slash  
$userpath = "users/";

# Temp dir (where attachments are temporarily stored)
# Can be relative to current dir or can be absolute path
# If it is "" then 'upload_tmp_dir' from php.ini is used
# (it must be set if you want to use it!)
# Must be chmodded 777, include a trailing slash  
$tmpdir = "temp/";

# Languages path (where language files are stored)
# Can be relative to current dir or can be absolute path
# Include a trailing slash
$langdir = "lang/";

# Whether to display eCorrei host or not in sent mails
# Will add "X-eCorrei-Host:" to each sent mail
# Set to 1 for add the field, 0 to remove the field
$showhost = 1;

# Hostname for eCorrei computer
# Most of the time this is $HTTP_HOST, but you can set it
# manually here
$hostname = $HTTP_HOST;

# Protocol
# Which protocol to use: http or https (for secure connections)
$protocol = "http";

# Default sort in Inbox
# Can be:
# SORTDATE: message date
# SORTARRIVAL: arrival date
# SORTFROM: from emailaddress (note that the emailaddress 
# isn't displayed in the Inbox most of the time)
# SORTSUBJECT: message subject
# SORTTO: to emailaddress
# SORTCC: cc emailaddress
# SORTSIZE: size of message
$default_sort = SORTARRIVAL;

# Default sort direction
# 0: from low to high
# 1: from high to low
$default_direction = 1;

# Maximum size of settings file
# (user settings & addressbook file)
# in bytes
$maxfilesize = 51200;

# Maximum size of files that can be attached
# to a mail
# in bytes
$maxmailsize = 2097152;

# Text to add to every message sent with eCorrei
# Remember to start with at least one newline, to prevent
# it from messing up your messages
# Set to "" to disable
$msgsignature = "\n\n___________________________________________\nSent with eCorrei - http://ecorrei.sf.net/"; 

# Domain arrays
# name: string behind the "@" in the address
# inmailserver: mail server, e.g: "localhost"
# accessmethod: imap or pop3
# inmailport: mail server port
# outmail: smtp server, e.g: "localhost"
# set outmail to "__none__" (without the quotes)
# to send mail using the standard PHP mail() function
$domains[0]->name = "foobar.com";
$domains[0]->inmailserver = "mail.foobar.com";
$domains[0]->accessmethod = "imap";
$domains[0]->inmailport = 143;
$domains[0]->outmailserver = "smtp.foobar.com";
$domains[0]->outmailport = 25;

$domains[1]->name = "foobar.com";
$domains[1]->inmailserver = "pop.foobar.com";
$domains[1]->accessmethod = "pop3";
$domains[1]->inmailport = 110;
$domains[1]->outmailserver = "__none__";
$domains[1]->outmailport = 25;

# Default language to use
# See languages below
$default_lang = "en";

# HTML code that is inserted right after the <body> of every page
$htmlpre = ""; 

# HTML code that is inserted before the </body> tag of every page
$htmlfooter = "";

# Background color of all pages
$bgcolor = "#FFFFFF";

# Background color of messages
$msgbgcolor = "#FFFFFF";

# Titlebar color
$titlebarcolor = "#000080";

# Titlebar text color
$titlebartxtcolor = "#FFFFFF";

# Window background color
$windowbgcolor = "#C0C0FF";

# Dark bar color
$darkbarcolor = "#8080FF";

# Inbox color for normal messages
$inbxnormal = "#E6E6FF";

# Inbox color for new messages
$inbxnew = "#C0C0FF";

# END CONFIGURE

# Languages
# Doesn't need to be configured
$languages[0]->name = "English";
$languages[0]->code = "en";

$languages[1]->name = "Nederlands";
$languages[1]->code = "nl";

$languages[2]->name = "Portugus Brasileiro";
$languages[2]->code = "pt-br";

?>