<?PHP
////////////////////////////////////////////////////////////////////////////////
// Martin's Photo Frame                      http://dougiamas.com/photoframe
   $version = "5.1";
//
// Displays a directory full of images (JPEG, PNG, GIF) simply and easily.
// It will also create thumbnails and display JPEG comments if it finds them.
// Guests can leave comments, and it supports Imagemagick as well as PHP GD.
// I am placing this script in the Public Domain - use it as you wish.
//
// Requirements: A web server with this software (note minimum versions):
//               - PHP 4.0.2   http://www.php.net
//               AND EITHER THESE
//               - GD 1.8.3    http://www.boutell.com/gd
//               - libjpeg 6b  http://www.ijg.org/
//               OR
//               - Imagemagick http://www.imagemagick.org/
// 
// How to use:   1. Store all your images in a directory on your server
//               2. Save this file in that directory as index.php
//               3. Make sure the web server has write permissions so 
//                  that it can write in a sub directory (thumbnails etc).
//                  eg   mkdir thumb ; chown nobody thumb
//   (optional)  4. Change any of the settings below to suit. You can 
//                  also put these in a separate file called config.php
//   (optional)  5. Add an intro.html file if you like.
//   (optional)  6. Add header.html and footer.html files if you want 
//                  to change page colours, layout or styles.
//   (optional)  7. Add a sortfile if you want to control the order of  
//                  the photos, rather than the default alphabetical order.
//                  Just make a simple text file with one filename per line.
//                  eg   ls -1 *.jpg *.png > sortfile  
//                       (and then edit with vi)
//
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// config.php  - these settings are the default ones.  You can either 
//               change them here or create a file called "config.php"
//               that contains override settings.  The advantage of a 
//               separate file is that you can upgrade the script and 
//               keep all your settings. 

$title        = "My Photo Album";   // Title for the overall web page 
$marginsize   =  150;               // Size of the side frame, and thumbnails
$marginside   = "left";             // Margin frame location: "left" or "right"

$thumb        = "./thumb";          // Directory where thumbnails are stored 
$imagequality =  70;                // Quality of reduced images, range 0 - 100
$fullwindow   =  false;             // Display images to fill browser window?

$imageresize  =  0;                 // You can rescale all images to fit within 
                                    // a boundary square of this size (eg 800).
                                    // These rescaled images are cached on disk.
                                    // To just use original images, specify 0

$pagecolor    = "#FFFFFF";          // Background color of all pages
$textcolor    = "#000000";          // Text color for all pages
$linkcolor    = "#000055";          // Link color for all pages
$vlinkcolor   = "#550055";          // Visited link color for all pages
$background   = "";                 // Background image for all pages
$stylesheet   = "";                 // Full URL to a stylesheet for all pages.
                                    // HTML text tags used: <H1>,<P>,<TD>,<A>

$lang         = "en";               // Language: de/en/es/fi/fr/it/nl/no/pl/ru/se

$introfile    = "intro.html";       // If it exists, will be displayed up front 
$headerfile   = "header.html";      // If it exists, will be included at top
$footerfile   = "footer.html";      // If it exists, will be included at bottom

$sortfile     = "sortfile";         // If it exists, contains filenames in order
$sortreverse  =  false;             // If true, then the sort order is reversed

$guestcomment =  false;             // If true, then guests can leave comments
$recentcount  =  10;                // How many 'recent' comments to show
$email        = "";                 // If you put your email address here then
                                    // new guest comments will be mailed to you
                                    // ... PHP must already support mail.


$imagemagick  =  false;             // Are you using Imagemagick?  true / false

// If you ARE using Imagemagick, then define these:
$im_identify  = "/usr/bin/identify";// Path to Imagemagick "identify" program
$im_convert   = "/usr/bin/convert"; // Path to Imagemagick "convert" program

// If you are NOT using Imagemagick, then this script will use a combination 
// of the GD library (compiled into your PHP) and libjpeg.   Define this:
$getcomment   = "/usr/bin/rdjpgcom";// To extract JPG comments (part of libjpeg)

////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////
/// Normally, you won't need to change anything below here
////////////////////////////////////////////////////////////////////////////////

if (file_exists("config.php")) {    // Settings in here will override defaults
   include("config.php");
}

$scriptname = BaseName($PATH_TRANSLATED);  // The name of this file


/// Language Strings ///

// English - en
$ss["en"]["next"]    = "Next";
$ss["en"]["prev"]    = "Previous";
$ss["en"]["slide"]   = "Slideshow";
$ss["en"]["comments"]= "Comments";
$ss["en"]["name"]    = "Name";
$ss["en"]["message"] = "Message";
$ss["en"]["add"]     = "Add my message to this page";
$ss["en"]["start"]   = "Back to the start";
$ss["en"]["selectl"] = "Select images from the left";
$ss["en"]["selectr"] = "Select images from the right";
$ss["en"]["from"]    = "From";
$ss["en"]["recent"]  = "most recent guest comments";
$ss["en"]["seconds"] = "seconds";

// Deutsch - de
$ss["de"]["next"]    = "Nchstes";
$ss["de"]["prev"]    = "Vorheriges";
$ss["de"]["slide"]   = "Slideshow";
$ss["de"]["comments"]= "Kommentare";
$ss["de"]["name"]    = "Name";
$ss["de"]["message"] = "Kommentar";
$ss["de"]["add"]     = "Meinen Kommentar abschicken";
$ss["de"]["start"]   = "zum Anfang";
$ss["de"]["selectl"] = "Bitte whlen sie links ein Bild aus";
$ss["de"]["selectr"] = "Bitte whlen sie Recht ein Bild aus";
$ss["de"]["from"]    = "Von";
$ss["de"]["recent"]  = "neueste Gastanmerkungen";
$ss["de"]["seconds"] = "Sekunden";

// Nederlands - nl
// Thanks to Rob Heijmen!
$ss["nl"]["next"]    = "Volgende";
$ss["nl"]["prev"]    = "Vorige";
$ss["nl"]["slide"]   = "Diashow";
$ss["nl"]["comments"]= "Commentaar";
$ss["nl"]["name"]    = "Naam";
$ss["nl"]["message"] = "Melding";
$ss["nl"]["add"]     = "Voeg mijn melding toe";
$ss["nl"]["start"]   = "Terug naar het begin";
$ss["nl"]["selectl"] = "Selecteer afbeeldingen aan de linker zijde";
$ss["nl"]["selectr"] = "Selecteer afbeeldingen aan de rechter zijde";
$ss["nl"]["from"]    = "Van";
$ss["nl"]["recent"]  = "meest recente commentaar";
$ss["nl"]["seconds"] = "seconden";


// Francais - fr
// Thanks to Olivier Paul!
$ss["fr"]["next"]    = "Suivant";
$ss["fr"]["prev"]    = "Prcdent";
$ss["fr"]["slide"]   = "Prsentation";
$ss["fr"]["comments"]= "Commentaires";
$ss["fr"]["name"]    = "Nom";
$ss["fr"]["message"] = "Message";
$ss["fr"]["add"]     = "Ajouter mon message  cette page";
$ss["fr"]["start"]   = "Retour au dpart";
$ss["fr"]["selectl"] = "Slectionnez les images  partir de la gauche";
$ss["fr"]["selectr"] = "Slectionnez les images  partir de la droite";
$ss["fr"]["from"]    = "De";
$ss["fr"]["recent"]  = "commentaires les plus rcents de visiteurs";
$ss["fr"]["seconds"] = "secondes";


// Swedish - se
// Thanks to Jrgen Silverplatz!
$ss["se"]["next"]    = "N&auml;sta";
$ss["se"]["prev"]    = "F&ouml;reg&aring;ende";
$ss["se"]["slide"]   = "Bildvisning";
$ss["se"]["comments"]= "Kommentarer";
$ss["se"]["name"]    = "Namn";
$ss["se"]["message"] = "Meddelande";
$ss["se"]["add"]     = "L&auml;mna ett meddelande";
$ss["se"]["start"]   = "Till b&ouml;rjan";
$ss["se"]["selectl"] = "V&auml;lj bild frn v&auml;nster";
$ss["se"]["selectr"] = "V&auml;lj bild frn h&ouml;ger";
$ss["se"]["from"]    = "Fr&aring;n";
$ss["se"]["recent"]  = "Senaste g&auml;st kommentarerna";
$ss["se"]["seconds"] = "sekunder";
 
// Spanish - es
// Thanks to Eddie Galvez!
$ss["es"]["next"]    = "Prximo";
$ss["es"]["prev"]    = "Previo";
$ss["es"]["slide"]   = "Slideshow";
$ss["es"]["comments"]= "Comentarios";
$ss["es"]["name"]    = "Nombre";
$ss["es"]["message"] = "Mensaje";
$ss["es"]["add"]     = "Agrega mi mensaje a esta pgina";
$ss["es"]["start"]   = "Volver al comienzo";
$ss["es"]["selectl"] = "Selecciona imagenes a la izquierda";
$ss["es"]["selectr"] = "Selecciona imagenes a la derecha";
$ss["es"]["from"]    = "De";
$ss["es"]["recent"]  = "comentarios mas recientes";
$ss["es"]["seconds"] = "segundos";

// Russia - ru
// Thanks to Shamil!
$ss["ru"]["next"]    = "";
$ss["ru"]["prev"]    = "";
$ss["ru"]["slide"]   = " ";
$ss["ru"]["comments"]= "";
$ss["ru"]["name"]    = "";
$ss["ru"]["message"] = "";
$ss["ru"]["add"]     = "    ";
$ss["ru"]["start"]   = " ";
$ss["ru"]["selectl"] = "    ";
$ss["ru"]["selectr"] = "    ";
$ss["ru"]["from"]    = "";
$ss["ru"]["recent"]  = " ";
$ss["ru"]["seconds"] = "";

// Italiano - it
// Thanks to Sal!
$ss["it"]["next"]    = "Dopo";
$ss["it"]["prev"]    = "Precedente";
$ss["it"]["slide"]   = "Proiezione";
$ss["it"]["comments"]= "Osservazioni";
$ss["it"]["name"]    = "Nome";
$ss["it"]["message"] = "Messaggio";
$ss["it"]["add"]     = "Aggiungere il mio messaggio a questa pagina";
$ss["it"]["start"]   = "Di nuovo all' inizio";
$ss["it"]["selectl"] = "Selezionare le immagini a partire dal di sinistra";
$ss["it"]["selectr"] = "Selezionare le immagini a partire dal di destra";
$ss["it"]["from"]    = "Da";
$ss["it"]["recent"]  = "La maggior parte del ospite recente commenta";
$ss["it"]["seconds"] = "Secondi";

// Polish - pl
// Thanks to Wojtek Fraczak!
$ss["pl"]["next"]    = "Nastepne";
$ss["pl"]["prev"]    = "Poprzednie";
$ss["pl"]["slide"]   = "Prezentacja";
$ss["pl"]["comments"]= "Komentarze";
$ss["pl"]["name"]    = "Imie";
$ss["pl"]["message"] = "Komentarz";
$ss["pl"]["add"]     = "Dorzuc komentarz";
$ss["pl"]["start"]   = "Wroc na poczatek";
$ss["pl"]["selectl"] = "Wybierz zdjecie z lewej strony";
$ss["pl"]["selectr"] = "Wybierz zdjecie z prawej strony";
$ss["pl"]["from"]    = "From";
$ss["pl"]["recent"]  = "Ostatnie komentarze";
$ss["pl"]["seconds"] = "sekund";

// Norwegian - no
// Thanks to Christian Rambjr!
$ss["no"]["next"]    = "Neste";
$ss["no"]["prev"]    = "Forrige";
$ss["no"]["slide"]   = "Bildevisning";
$ss["no"]["comments"]= "Kommentarer";
$ss["no"]["name"]    = "Navn";
$ss["no"]["message"] = "Melding";
$ss["no"]["add"]     = "Legg igjen en melding";
$ss["no"]["start"]   = "Til Begynnelsen";
$ss["no"]["selectl"] = "Velg bilder fra venstre side";
$ss["no"]["selectr"] = "Velg bilder fra hyre side";
$ss["no"]["from"]    = "Fra";
$ss["no"]["recent"]  = "Siste kommentarene";
$ss["no"]["seconds"] = "Sekunder";

// Finnish - fi
// Thanks to Ante Mulari!
$ss["fi"]["next"]    = "Seuraava";
$ss["fi"]["prev"]    = "Edellinen";
$ss["fi"]["slide"]   = "Kuvaesitys";
$ss["fi"]["comments"]= "Kommentit";
$ss["fi"]["name"]    = "Nimi";
$ss["fi"]["message"] = "Viesti";
$ss["fi"]["add"]     = "Lis viestini tlle sivulle";
$ss["fi"]["start"]   = "Takaisin alkuun";
$ss["fi"]["selectl"] = "Valitse kuvat vasemmalta";
$ss["fi"]["selectr"] = "Valitse kuvat oikealta";
$ss["fi"]["from"]    = "Tullut";
$ss["fi"]["recent"]  = "viimeisimmt kommentit kvijilt";
$ss["fi"]["seconds"] = "sekunnit";


// Please send me more translations  :-)



/// Check that Image processing is available ///


if ($imagemagick) {
   if (! (is_executable("$im_convert") && is_executable("$im_identify"))) {
       PrintHeader();
       PrintError("Sorry, but I couldn't find the Imagemagick programs that
                   you specified ($im_convert and $im_identify).<BR>
                   Check the configuration of this script and your server.");
       die;
   }
} else if (!function_exists("ImageTypes")) {
   PrintHeader();
   PrintError("Sorry, but this script requires access to 
               an image library.  You should either install Imagemagick 
               (and then turn on the Imagemagick switch in this script), or
               make sure your copy of PHP has been compiled with native 
               support for images. <BR>configure --with-gd  ...");
   die;
}


/// Functions ///

function RemoveNewLines (&$item, $key) {
   $item = chop($item);
}

function GetFileList( $dirname="." ) {   // Finds all the images
   // First check to see if there's a file called $sortfile
   // that contains a sorted list of filenames, one per line
   // otherwise, will default to all files in alphabetical order
   global $sortfile, $sortreverse;

   $files = array(); 

   if (file_exists($sortfile)) {
      $files = file($sortfile);
      array_walk($files, 'RemoveNewLines');
   } else {
      $dir = opendir( $dirname );
      while( $file = readdir( $dir ) ) {
         if (eregi("\.jpe?g$", $file) || 
             eregi("\.gif$", $file) ||  
             eregi("\.png$", $file)) {
             $files[] = $file; 
         }
      }
      if ($sortreverse) {
          rsort($files);
      } else {
          sort($files);
      }
   }
   return $files; 
} 

function GetNeighbours($imagelist, $currimage, &$previmage, &$nextimage) {
   // For a given image, return the next and previous ones
   $lastimage = count($imagelist) - 1;
   for ( $i=0; $i<=$lastimage; $i++) {
       if ($imagelist[$i] == $currimage) {
           if ($i == 0) { 
               $nextimage = $imagelist[$i+1];
               $previmage = NULL;
               return;
           } else if ($i == $lastimage) {
               $previmage = $imagelist[$i-1];
               $nextimage = NULL;
               return;
           } else {
               $previmage = $imagelist[$i-1];
               $nextimage = $imagelist[$i+1];
               return;
           }
       }
   }
   $previmage = NULL;
   $nextimage = NULL;
   return;

}

function PrintError($message) {
   echo "<P ALIGN=CENTER><FONT COLOR=RED>Error: $message</FONT></P>";
}

function PrintHeader($pagetitle="", $meta="") {
// Special case when meta = "margin"
   global $headerfile;
   global $stylesheet;
   global $pagecolor, $textcolor, $linkcolor, $vlinkcolor, $background;

   echo "<HEAD>\n";
   echo "<TITLE>$pagetitle</TITLE>\n";
   if ($meta && $meta != "margin") {
       echo "$meta\n";
   }
   if ($stylesheet) { 
       echo "<LINK REL=\"stylesheet\" HREF=\"$stylesheet\">";
   }
   echo "</HEAD>\n";

   echo "<BODY BGCOLOR=\"$pagecolor\" TEXT=\"$textcolor\" ";
   echo " LINK=\"$linkcolor\" VLINK=\"$vlinkcolor\" BACKGROUND=\"$background\">\n";
   
   if ($meta != "margin" && file_exists($headerfile)) { 
       include($headerfile); 
   }
}


function PrintFooter() {
   global $footerfile;
   global $title;

   if (file_exists($footerfile)) { 
       include($footerfile); 
   } else {
       echo "<CENTER><BR><P><FONT SIZE=-1>";
       echo "<A TARGET=_top HREF=\".\" >$title</A></P>\n";
   }
   echo "</BODY>";
}

function SafeURL($filename) {
// Makes a URL safe to use as a link
   return str_replace(" ","%20",$filename);
}

function UnSafeURL($filename) {
// Restores a URL back to the actual string
   return str_replace("%20"," ",$filename);
}

function PrintRecentComments($recent) {
   global $thumb, $marginsize, $scriptname;
   global $ss, $lang;

   if (! $recent) {
      return;
   }

   $imagelist = GetFileList();

   $comments = array();

   foreach ($imagelist as $filename) {
      $commentfile = "$thumb/$filename.txt";
      if (file_exists($commentfile)) {
         $file = file($commentfile);
         foreach ($file as $line) {
            $line = chop($line)."###$filename";
            $comments[] = $line;
         }
      }
   }
   rsort($comments);
   $count = 0;

   echo "</CENTER></P>";   // Just in case;
   echo "<BR><H3 ALIGN=CENTER>$recent ".$ss[$lang]["recent"].":</H3>";
   foreach ($comments as $comment) {
      $comm = explode ("###", $comment);

      echo "<TABLE ALIGN=CENTER WIDTH=\"90%\"><TR><TD COLSPAN=2><HR></TD></TR>";
      echo "<TR><TD VALIGN=TOP WIDTH=\"100%\">";
      echo "<FONT SIZE=2>";
      echo $ss[$lang]["from"].": <B>".$comm[1]."</B>, <I>".date("l, j F Y, g:i A T", $comm[0])."</I><BR>";
      echo "<UL>".$comm[2]."</UL></FONT>";
      echo "</TD><TD WIDTH=\"$marginsize\">";
      $image = $comm[3];
      $maincomment = GetMainComment($image);
      $thumbimage = "$thumb/$image";
      $image      = SafeURL($image);
      echo "<A TITLE=\"$maincomment\" HREF=\"$scriptname?image=$image&d=d.html\" TARGET=imain>"; 
      if (file_exists($thumbimage)) {
         $thumbimage = SafeURL("$thumb/$image");
         echo "<IMG ALT=\"$maincomment\" SRC=\"$thumbimage\" BORDER=0>";
      } else {
         echo "<FONT SIZE=1>$maincomment</FONT>";
      }
      echo "</A>";
      echo "</TD></TR></TABLE>\n";

      $count++;
      if ($count >= $recent) {
         break;
      }
   }
   echo "<HR>\n";
}

function PrintComments($filename) {
   // Given an image filename, finds, reads and formats the 
   // associated file of guest comments
   global $thumb, $ss, $lang;

   $commentfile = "$thumb/$filename.txt";

   if (file_exists($commentfile)) {
      $comments = file($commentfile);
      echo "<BR><BLOCKQUOTE><BLOCKQUOTE><HR>\n";
      foreach ($comments as $comment) {
         $comm = explode ("###", $comment);

         echo "<FONT SIZE=2>";
         echo $ss[$lang]["from"].": <B>".$comm[1]."</B>, <I>".date("l, j F Y, g:i A T", $comm[0])."</I><BR>";
         echo "<UL>".$comm[2]."</UL></FONT>\n";
         echo "<HR SIZE=1>\n";
      }
      echo "</BLOCKQUOTE></BLOCKQUOTE><BR>\n";
   }
}

function PrintCommentForm($filename) {
    global $scriptname, $textcolor, $pagecolor;
    global $ss, $lang;


?>

<FORM ACTION=<?=$scriptname?> METHOD=POST>
<INPUT TYPE=hidden NAME=comment VALUE="<?=$filename?>">
<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0 ALIGN=CENTER BGCOLOR=#BBBBBB>
<TR><TD><TABLE BORDER=0 CELLPADDING=5 CELLSPACING=0 WIDTH="100%" BGCOLOR="<?=$pagecolor?>">
   <TR>
       <TD ALIGN=right><FONT SIZE=2 COLOR="<?=$textcolor?>">
           <B><?=$ss[$lang]["name"] ?>:</B></FONT></TD>
       <TD><FONT SIZE=2 COLOR="<?=$textcolor?>">
           <INPUT size=50 type=text name="name"></FONT></TD>
   </TR>
   <TR>
       <TD ALIGN=right valign=top><FONT SIZE=2 COLOR="<?=$textcolor?>">
           <B><?=$ss[$lang]["message"] ?>:</B></FONT></TD>
       <TD><FONT SIZE=2 COLOR="<?=$textcolor?>">
           <TEXTAREA name="message" rows=4 cols=40></TEXTAREA></FONT></TD>
   </TR>
   <TR>
       <TD ALIGN=CENTER COLSPAN=2>
           <FONT SIZE=2 COLOR="<?=$textcolor?>">
           <INPUT type=submit value="<?=$ss[$lang]["add"] ?>"></FONT>
       </TD>
   </TR>
</TABLE></TD></TR></TABLE>
</FORM>

<?
}


function AddComment($filename, $name, $message) {
   // Clean up a given comment and add to the appropriate database
   global $thumb, $email, $title, $SERVER_NAME, $REQUEST_URI, $REMOTE_HOST;

   if (ereg( "\\.\\.", $filename)) {  // using ".." in the filename
       PrintError("That filename ($filename) was not secure.");
       return;
   }
            
   if (!$name) {
       PrintError("You need to fill out your name.");
       return;
   }
   if (!$message) {
       PrintError("There was no message to post.");
       return;
   }

   $commentfile = "$thumb/$filename.txt";

   if ($file = fopen ($commentfile, "a") ) {
       $timenow = time();
       $name    = strip_tags($name);
       $message = stripslashes(strip_tags($message, "A"));

       if ($email) {   // Try and send the comment via email
           mail($email, "Comment added: $title", 
                "From: $name ($REMOTE_HOST)\n\n".
                "$message\n\n".
                "http://$SERVER_NAME$REQUEST_URI?image=$filename",
                "From: $email");
       }

       $message = nl2br($message);
       $message = strtr($message, "\r", " ");
       $message = strtr($message, "\n", " ");
       fwrite($file, "$timenow###$name###$message\n");
       fclose($file);

   } else {
       PrintError("Could not add comment for $filename");
   }
}

function GetMainComment($image) {
   global $getcomment, $imagemagick, $im_identify;

   if ($imagemagick) {
      Exec("$im_identify -ping -format \"%c\" ".EscapeShellArg($image), $commentlines);
   } else {  // Try and use rdjpgcom from libjpeg
      Exec("$getcomment ".EscapeShellArg($image), $commentlines);
   }

   if (! $commentlines) { 
       $comment = $image; 
   } else {
       foreach ($commentlines as $commentline) {
           $comment .= "$commentline ";
       }
   }
   return $comment;
}

function ReadImageFromFile($filename, $type) {
   $imagetypes = ImageTypes();

   switch ($type) {
      case 1 :
         if ($imagetypes & IMG_GIF)
             return $im = ImageCreateFromGIF($filename);
         break;
      case 2 :
         if ($imagetypes & IMG_JPEG)
             return ImageCreateFromJPEG($filename);
         break;
      case 3 :
         if ($imagetypes & IMG_PNG)
             return ImageCreateFromPNG($filename);
         break;
      default:
         return 0;
   }
}

function WriteImageToFile($im, $filename, $type) {
   global $imagequality;

   switch ($type) {
      case 1 :
         return ImageGIF($im, $filename);
      case 2 :
         return ImageJpeg($im, $filename, $imagequality);
      case 3 :
         return ImagePNG($im, $filename);
      default:
         return false;
   }
}


function ResizeImage($image, $newimage, $newwidth, $newheight=0) {
// Returns true if new image was created, else false
// If newheight is not specified then image is scaled in proportion
// to newwidth.  If newheight is specified, then newheight and newwidth
// represent a bounding box to fit image into
    global $imagemagick;

    if ($imagemagick) {
        return ResizeImageUsingIM($image, $newimage, $newwidth, $newheight);
    } else {
        return ResizeImageUsingGD($image, $newimage, $newwidth, $newheight);
    }
}

function ResizeImageUsingGD($image, $newimage, $newwidth, $newheight) {

   $size = GetImageSize($image);
   $width  = $size[0];
   $height = $size[1];
   $type   = $size[2];

   if ($im = ReadImageFromFile($image, $type)) {
      if ($newheight && ($width < $height)) {
         $newwidth = ($newheight / $height) * $width;
      } else {
         $newheight = ($newwidth / $width) * $height;
      }
      if (function_exists("ImageCreateTrueColor")) {
         $im2 = ImageCreateTrueColor($newwidth,$newheight);
      } else {
         $im2 = ImageCreate($newwidth,$newheight);
      }
      if (function_exists("ImageCopyResampled")) {
          ImageCopyResampled($im2,$im,0,0,0,0,$newwidth,$newheight,$width,$height);
      } else {
          ImageCopyResized($im2,$im,0,0,0,0,$newwidth,$newheight,$width,$height);
      }

      if (WriteImageToFile($im2, $newimage, $type)) {
          return true;
      }
   }
   return false;
}

function ResizeImageUsingIM($image, $newimage, $newwidth, $newheight) {
   global $im_identify, $im_convert, $imagequality;

   if (! $sizeinfo = Exec("$im_identify -ping -format \"%w %h\" \"$image\"")) {
      return false;
   }
   $size = explode(" ", $sizeinfo);
   $width  = $size[0];
   $height = $size[1];

   if (!$width) {
      return false;
   }

   if ($newheight && ($width < $height)) {
      $newwidth = ($newheight / $height) * $width;
   } else {
      $newheight = ($newwidth / $width) * $height;
   }

   Exec("$im_convert -geometry \"$newwidth"."x"."$newheight\" -quality \"$imagequality\" \"$image\" \"$newimage\"");

   return file_exists($newimage);
}


function PrintSlideshowForm ($nextimage, $slide=0) {
   global $scriptname;
   global $ss, $lang;
    
   $common = "$scriptname?image=$nextimage&slide=";
   $options = array (2 => "2 ".$ss[$lang]["seconds"], 
                     5 => "5 ".$ss[$lang]["seconds"], 
                     7 => "7 ".$ss[$lang]["seconds"], 
                     10 => "10 ".$ss[$lang]["seconds"], 
                     20 => "20 ".$ss[$lang]["seconds"], 
                     30 => "30 ".$ss[$lang]["seconds"],
                     40 => "40 ".$ss[$lang]["seconds"], 
                     50 => "50 ".$ss[$lang]["seconds"], 
                     60 => "60 ".$ss[$lang]["seconds"]);

   echo "<FORM NAME=auto>";
   echo "<SELECT NAME=popup onChange=\"window.location=document.auto.popup.options[document.auto.popup.selectedIndex].value\">\n";

   echo "   <OPTION VALUE=\"javascript:void(0)\">".$ss[$lang]["slide"]."...</OPTION>\n";
   foreach ($options as $value => $label) {
      echo "   <OPTION VALUE=\"$common$value\"";
      if ($value == $slide) {
         echo " SELECTED";
      }
      if ($label) {
         echo ">$label</OPTION>\n";
      } else {
         echo ">$value</OPTION>\n";
      }
   }
   echo "</SELECT></FORM>";
}


/// Individual pages are created here ///

if ($intro) {                       // Print initial info in main frame
   PrintHeader($title);
   if (file_exists($introfile)) { 
       include($introfile);
   } else {
       echo "<CENTER><H1>$title</H1>";
       if ($marginside == "right") {
           echo "<P>". $ss[$lang]["selectr"] ."</P>";
       } else {
           echo "<P>". $ss[$lang]["selectl"] ."</P>";
       }
   }
   if ($guestcomment && $recentcount) {
       echo "<BR>";
       echo "<P align=center><A HREF=\"$scriptname?recent=$recentcount\">";
       echo "$recentcount ". $ss[$lang]["recent"];
       echo "</A></P>";
   }
   die;
}

if ($recent) {
   if ($guestcomment) {
      PrintHeader("$title: Recent Comments");
      PrintRecentComments($recent);
   }
   echo "<P ALIGN=CENTER><A HREF=\"$scriptname?intro=true\">".$ss[$lang]["start"]."</A></P>";
   die;
}

if ($margin) {                      // Create a list of thumbnails
   if (!file_exists($thumb)) { 
       if ( ! mkdir($thumb, 0755)) {
           PrintError("Could not create thumb dir - check write permissions");
           die;
       }
   }

   PrintHeader("$title: Thumbnails", "margin");

   $imagelist = GetFileList();

   foreach ($imagelist as $image) {

       $thumbimage = $thumb."/".$image;
       $thumb_exists = file_exists($thumbimage);

       if (!$thumb_exists) {   // Try to create the thumbnail
          set_time_limit(30);
          $thumbwidth = $margin - 20;

          $thumb_exists = ResizeImage($image, $thumbimage, $thumbwidth);

       }

       $comment    = GetMainComment($image);
       $image      = SafeURL($image);
       $thumbimage = SafeURL($thumbimage);

       // The  d=d.html  was added to help dumb caches
       echo "<A TITLE=\"$comment\" HREF=\"$scriptname?image=$image&d=d.html\" TARGET=imain>"; 
       if ($thumb_exists) {
           echo "<IMG SRC=\"$thumbimage\" BORDER=0 ALT=\"$comment\">";
       } else {
           echo "<FONT SIZE=1>$comment</FONT>";
       }
       echo "</A><BR><BR>\n";
   } 

   echo "<P ALIGN=CENTER><FONT SIZE=1><A TARGET=_top HREF=\".\" >".$ss[$lang]["start"]."</A></FONT></P>\n";
   echo "<P ALIGN=CENTER><BR><FONT SIZE=1>Made with ";
   echo "<A TARGET=_top HREF=\"http://dougiamas.com/photoframe/\">Martin's Photo Frame</A> $version</FONT></P>\n";

   die;
}

if ($comment) {
    AddComment($comment, $name, $message);
    $image = $comment;
}

if ($image) {

   if (ereg( "\\.\\.", $image)) {  // using ".." in the filename
       PrintError("That filename ($image) was not secure.");
       die;
   }

   $cleanimage = $image;
   $image = UnSafeURL($image);

   if (!file_exists($image)) { 
      PrintError("Strangely, that picture doesn't exist");
      die;
   }

   $imagelist = GetFileList();
   GetNeighbours($imagelist, $image, $previmage, $nextimage);

   $comment = GetMainComment($image);

   if ($slide && $nextimage) {
      $meta="<META HTTP-EQUIV=REFRESH CONTENT=\"$slide;URL=$scriptname?image=$nextimage&slide=$slide\">";
   } else {
      $meta = "";
      $slide = "0";
   }

   PrintHeader($comment, $meta);

   echo "<TABLE ALIGN=RIGHT CELLPADDING=0 CELLSPACING=0><TR>";
   if ($previmage) {
      echo "<TD><FORM ACTION=\"$scriptname\">
            <INPUT TYPE=hidden name=image value=\"$previmage\">
            <INPUT TYPE=submit VALUE=".$ss[$lang]["prev"]."></FORM></TD>";
   }
   if ($nextimage) {
      echo "<TD><FORM ACTION=\"$scriptname\">
            <INPUT TYPE=hidden name=image value=\"$nextimage\">
            <INPUT TYPE=submit VALUE=".$ss[$lang]["next"]."></FORM></TD>";

      echo "<TD>";
      PrintSlideshowForm($nextimage, $slide);
      echo "</TD>";
   }
   echo "</TR></TABLE>\n";

   echo "<H3 align=left>$comment</H3>";

   if ($fullwindow) {
      $imagewidth = "WIDTH=100%";
   }

   echo "<BR CLEAR=ALL><CENTER><P>";

   if ($imageresize && ! $originalimage) {
       $rimage = "$thumb/$imageresize$image";
       $cleanrimage = SafeURL("$rimage");
       if (! file_exists("$rimage")) {
           $imageresize = ResizeImageUsingGD($image, $rimage, $imageresize, $imageresize);
       }
       if ($imageresize) {
          echo "<A HREF=\"$scriptname?image=$cleanimage&originalimage=true&d=d.html\" TARGET=imain";
          echo " TITLE=\"Click here to see the full-sized version of this image\">";
          echo "<IMG BORDER=0 $imagewidth SRC=\"$cleanrimage\">";
          echo "</A>";
       } else {
          echo "<IMG $imagewidth SRC=\"$cleanimage\">";
       }

   } else {
       echo "<IMG $imagewidth SRC=\"$cleanimage\">";
   }

   echo "</P></CENTER>";

   if ($guestcomment) {
       echo "<P ALIGN=CENTER><BR><B>".$ss[$lang]["comments"]."</B></P>";
       PrintComments($image);
       PrintCommentForm($image);
   }

   PrintFooter();
   die;
}


?>
<HTML>
<HEAD>
  <TITLE><? echo $title ?></TITLE>
  <META NAME="Description" CONTENT="Made with Martin's Photo Frame <?=$version?>, http://dougiamas.com/photoframe">
  <LINK REL="SHORTCUT ICON" HREF="http://dougiamas.com/photoframe/pf.ico">
</HEAD>
<?
if ($marginside == "right") {
?>
<FRAMESET COLS="*,<?=$marginsize?>" BORDER=1>
  <FRAME NAME=imain SRC="<?=$scriptname?>?intro=1" FRAMEBORDER=0 SCROLLING=AUTO>
  <FRAME NAME=imargin SRC="<?=$scriptname?>?margin=<?=$marginsize?>" FRAMEBORDER=0 
         marginwidth="0" marginheight="0" noresize SCROLLING=AUTO>
<?
} else {
?>
<FRAMESET COLS="<?=$marginsize?>,*" BORDER=1>
  <FRAME NAME=imargin SRC="<?=$scriptname?>?margin=<?=$marginsize?>" FRAMEBORDER=0 
         marginwidth="0" marginheight="0" noresize SCROLLING=AUTO>
  <FRAME NAME=imain SRC="<?=$scriptname?>?intro=1" FRAMEBORDER=0 SCROLLING=AUTO>
<?
}
?>
  <NOFRAMES>
     This site works best wih frames, which your browser doesn't support.
     You can still browse this photo album, though, by starting 
     <A HREF="<?=$scriptname?>?margin=<?=$marginsize?>">here</A>
  </NOFRAMES>
</FRAMESET>
</HTML>

