<?php
// ###########################  autor  ###################################
// ******************************************************** //
//                                                          //
//  Nome: der Josu Chagas                                 //
//  homepage: http://www.dcc.ufmg.br/~ejchagas              //
//  E-mail: ejchagas@dcc.ufmg.br                            //
//                                                          //
//          Script: Enquete                                 //
//                                                          //
//    Breve descrio: Enquete simples usando CheckBoxes,   //
// no utiliza banco de dados guardando todos os resultados //
// em arquivos, podendo ter at 10 opes por enquete.      //
//    Contm uma pgina para administrao da enquete, para //
// ter acesso a essa pgina basta digitar o password 123456 //
//                                                          //
//    Para fazer o seu script funcionar basta  dar um       //
// chmod 766 nos arquivos que gravam os dados.              //
//                                                          //
// ******************************************************** //



// ###########################  head  ###################################
// head: funo que configura a pgina e inicializa a tabela
//
function head() 
{
	include('config.php');
	echo "<BODY bgcolor=\"$bgcolor\" link=\"#CCCC00\"";
	echo "vlink=\"#CCCC00\"";
	echo "alink=\"#CCCC00\">";
	echo "<table align=\"center\" width=\"500\" border=\"0\" cellpadding=\"1\" cellspacing=\"1\">
		<tr><td bgcolor=\"$tableborder\">
		<table width=\"495\" border=\"0\" 
		cellpadding=\"0\" cellspacing=\"\" align=\"center\">
		<tr><td bgcolor=\"$bgcolor\">";
} // head

// ###########################  foot  ###################################
// foot: funo que finaliza a tabela
//
function foot () 
{
	echo "</td></tr></table></td></tr></table>";
} // foot

// ###########################  record  #################################
// record: grava o endereo ip no arquivo $ip_file
//
function record($REMOTE_ADDR) 
{
	include('config.php');

	// abre o arquivo para escrita aps a ltima linha.
	$fp=fopen("$ip_file", "a+"); 
	
	// envia para o arquivo o ip e a hora
	fputs ($fp,$REMOTE_ADDR."][".time()."\n");
	fclose($fp); // fecha o arquivo
} // record

// ###########################  chech  #################################
// check: funo que checa se o ip j est gravado
//
function check($REMOTE_ADDR) 
{
	include('config.php');
	global $valid;
	$ip=$REMOTE_ADDR;
	$data=file("$ip_file");
	$now=time();
	foreach ($data as $record) 
	{
		$subdata=explode("][",$record);
		if ($now < ($subdata[1]+3600*$timeout)) 
		{
			if ($ip == $subdata[0]) 
			{
				$valid=0;
				break;
			}
		}
	}
}// check 

// ###########################  save  ##################################
// save: funo que computa o voto
//
function save($opcao)
{
	global $opcao;
	include('config.php');
	$data=file($datafile);
	$subdata=explode("][",$data[$opcao]);
	$subdata[2]+=1;
	$data[$opcao]=implode("][", $subdata);
	$data[$opcao]=$data[$opcao]."\n";
	$fp=fopen($datafile,"w+");
	$a=0;

	do {
		fputs($fp,$data[$a]);
		$a++;
	} while($a<count($data));

	fclose($fp);
}// fim save

// ###########################  form  ##################################
// form: funo que cria a tabela para votao
//
function form($PHP_SELF)
{
	include('config.php');

	head(); //inicializa a tabela

	echo "<font size=\"$fontsize\" face=\"$font\" color=\"$textcolor\"><form method=\"post\" action=\"vote.php\"><p align=\"center\">";
	$data=file($datafile);
	$question=$data[0];
	$nb_options=count($data)-1;
	echo "<b>$question</b></p><br>";

	for($nb=1;$nb <= $nb_options; $nb++)
	{
		$option=explode("][","$data[$nb]");
		echo "<input type=\"radio\" name=\"opcao\" value=\"$nb\"> ";
		echo "$option[0]<br>";
	}

	echo "<input type=\"hidden\" name=\"save\" value=\"yes\">";
	echo "<p align=\"center\"><input type=\"submit\" name=\"submit\"
		value=\"Votar\"></form></font>";
	echo "<font size=\"$fontsize\" face=\"$font\" color=\"$textcolor\">
		<a href=\"vote.php?action=results\">
		Confira os resultados</font></p>"; 
	foot();// fecha a tabela
}// form

// ###########################  results  ##################################
// results: funo que imprime os resultados 
//
function results()
{
	include('config.php');

	head();
	
	$data=file($datafile);
	$nb_answers=count($data);
	$votes=0;
	$a=1;

	do { // calcula o total de votos
		$subdata=explode("][",$data[$a]);
		$votes += $subdata[2];
		$a++;
	} while($a < $nb_answers);

	$a=1;
	$b="answerv";
	if($votes!=0)
		$v=100/$votes; //descobre o valor de 1 voto em %
	echo "<p><font size=\"$fontsize\" face=\"$font\"
		color=\"$textcolor\"><b>$data[0]<br>Resultado da enquete.
		</b><br><br>";

	do {
		$subdata=explode("][",$data[$a]);
		$av = $subdata[2] * $v; // calcula a porcentagem de cada opo
		echo "<font size=\"$fontsize\" face=\"$font\" color=\"$textcolor\">$subdata[0] ";
		echo " - $subdata[2] votos<br>";
		echo "<img src=\"$subdata[1]\" border=\"0\" width=\"$av\"
			height=\"15\">";
		printf(" %01.1f", $av); 
		echo"%<br>";
		$a++;
	} while ($a < $nb_answers);

	echo "<br><font size=\"$fontsize\">
		J foram computados $votes votos";
	echo "<br>";
	foot(); //fecha a tabela
}// results

// ###########################  execuo  ################################
// execuo da pgina
//
check($REMOTE_ADDR);

if ($valid=="0")// se j votou, mostra somente os resultados
{ 
	results();
}
elseif ($action=="results") // se clicar para ver os resultados
{ 
	results(); 
}
elseif ($save=="yes" && $valid!="0") // se votou e o ip ainda no foi gravado
{ 
	save($opcao); // computa o voto
	record($REMOTE_ADDR); // grava o ip
	results(); // mostra os resultados
}
elseif ($action=="save" && !empty($valid)) // se enviou o voto, sem
							 // marcar uma opo
{ 
	results(); 
}
elseif ($action!="save" && $valid!="0") // se ainda no enviou o voto,
						    // mas uma opo est marcada
{ 
	form($PHP_SELF); 
}

?>
