<?php
/*Global user-defined variables*/
$TrackCount = true; /*Keeps a record of the number of hits per page. If set to false, $OutputCount will do
                      nothing!*/
$OutputCount = true; //Set it to true to send an HTML string stating the count. Also see $TrackCount
$TrackSingle = true; //Create and track a record per page.
$TrackGlobal = true; //Create and track a record for all pages. Set the $GlobalFile variable too.
$GlobalFile = "all.php";

/*Common Log Format: Set $WriteCLF to true to write to a Common Log Format File; if set to true, also give the
path below.*/
$WriteCLF = true;
$CLF_Path = "clf.log";

/*
The following var is needed for all file-writing routines! If
you want to track page counts or write a CLF log, set this
variable correctly!

Keep the trailing slash!

*/
$DataDir = "/users/pdf24/public_html/counters/"; //Keep the trailing forward slash!


/*
The following function sends out a string as part of the HTML that contains the count of the page.
*/
function OutputCount($count){
   //echo "In Outputcount";
   if($GLOBALS["TrackCount"] == true && $GLOBALS["OutputCount"]==true){
      echo "<p class=\"PHPCounterCount\">You are visitor number: " . $count . " since 21 May 02.</p>";
      }
}

/*
The following function writes the CLF log.
*/

function WriteCLF($log){
    if($GLOBALS["WriteCLF"] == true && $GLOBALS["CLF_Path"]){
           if($fd = @fopen($GLOBALS["DataDir"] . $GLOBALS["CLF_Path"],  "a")) {
               fputs($fd, $log);
               fclose($fd);
               }
           }
}

function GetPageCountFile(){
   $countpage = getenv("REQUEST_URI");
   $countpage = preg_replace("/(\?.*)/", "", $countpage);
   $countpage = preg_replace("/[^\w]/", "_", $countpage);
   return $countpage;
}

function WriteSingle($log){
   $count = 0;
   $data = "";
   //echo "In WriteSingle()";
   $CntFl = $GLOBALS["DataDir"] . "counter" . GetPageCountFile() . ".php";
   if($GLOBALS["TrackCount"] == true && $GLOBALS["TrackSingle"] == true){
      //if the file doesn't exist, create it and chmod it properly.
      if (!file_exists($CntFl)) {
      $templatefile = $GLOBALS["DataDir"] . "template.php";
      //echo "Template file is: " . $templatefile;
      copy($templatefile , $CntFl);
      chmod($CntFl, 0666);
      }
      if (file_exists($CntFl)){
         //echo $CntFl;
      }
      else{
          echo "Count file not found!";
      }
      if($fd = @fopen($CntFl,  "r+")) {
               while(!feof($fd)) {
                  $data .= fgets($fd, 8000);
                  }
                fclose($fd);
                preg_match("/Total number of hits for this page: (.*) hits\./", $data, $matches);
                $count = $matches[1];
                $count++;
                $CountReplacementStr = "Total number of hits for this page: " . $count . " hits.";
                $data = preg_replace("/Total number of hits for this page: .*\./", $CountReplacementStr , $data);
                $data = preg_replace("/<!--InsertCounterDataHere-->/", $log, $data);
                $fd = fopen($CntFl, "w");
                fputs($fd, $data);
                fclose($fd);
                OutputCount($count);
                }
           }
}

function WriteGlobal($log){
   $count = 0;
   $data = "";
   $CntFl = $GLOBALS["DataDir"] . $GLOBALS["GlobalFile"];
   if($GLOBALS["TrackCount"] == true && $GLOBALS["TrackGlobal"] == true){
      //echo "Global counter: " . $CntFl;
      if($fd = fopen($CntFl,  "r+")) {
               while(!feof($fd)) {
                  $data .= fgets($fd, 8000);
                  }
                fclose($fd);
                preg_match("/Total Number of Hits: (.*) hits\./", $data, $matches);
                $count = $matches[1];
                $count++;
                $CountReplacementStr = "Total Number of Hits: " . $count . " hits.";
                $data = preg_replace("/Total Number of Hits: .*\./", $CountReplacementStr , $data);
                $data = preg_replace("/<!--InsertCounterDataHere-->/", $log, $data);
                $fd = fopen($CntFl, "w");
                fputs($fd, $data);
                fclose($fd);
                }
           }

}

function get_var($name,$default) {
    if($var = getenv($name)) {
    return $var;
    } else {
    return $default;
    }
}

//Prepare the variables

if(!$remote = get_var("HTTP_X_FORWARDED_FOR",false)){
    if(!$remote = get_var("REMOTE_HOST", false)) {
      $remote = get_var( "REMOTE_ADDR",  "-");
     }
    }
if(!$remote_host = get_var("REMOTE_HOST", false)) {
   $remote_host = get_var( "REMOTE_ADDR",  "-");
}

$remote_user = get_var( "REMOTE_USER",  "-");
$remote_ident = get_var( "REMOTE_IDENT",  "-");
$server_port = get_var( "SERVER_PORT", 80);
if($server_port!=80) {
    $server_port =  ":" . $server_port;
} else {
    $server_port =  "";
}
$server_name = get_var( "SERVER_NAME",  "-");
$request_method = get_var( "REQUEST_METHOD",  "GET");
$request_uri = get_var( "REQUEST_URI",  "");
$user_agent = get_var( "HTTP_USER_AGENT",  "");
$date = gmdate( "d/M/Y:H:i:s");
$referer = get_var("HTTP_REFERER", "-");

$CLFLog = "$remote_host $remote_ident $remote_user [$date $timezone] \"".
    "$request_method http://$server_name$server_port$request_uri\" 200 $size\n";
$referer_split = chunk_split($referer, 30, " "); //make it pretty.
$HTMLLog = "<!--InsertCounterDataHere-->\n<tr><td class=\"recordtd\">".
         "<a href=\"$request_uri\">$request_uri</a></td><td class=\"recordtd\">".
         "<a href=\"$referer\" target=\"_blank\">$referer_split</a></td><td class=\"recordtd\">".
         "$user_agent</td><td class=\"recordtd\">".
         "$remote</td><td class=\"recordtd\">".
         "$date</td></tr>";
WriteSingle($HTMLLog);
WriteGlobal($HTMLLog);
WriteCLF($CLFLog);

?>



