#!/usr/bin/perl

# ******************************************************************* #
# Pesquisa D' Alencar                 Verso 2.1                      #
# Copyright (c) 1999                  Criado em: 22/06/99             #
# Autor: Marcus Aurlio D' Alencar    Atualizado: 10/04/2000          #
# Pgina: www.dalencar.cjb.net        E-mail: dalencar@mailbr.com.br  #
# Aracaju - Sergipe - Brasil                                          #
# ******************************************************************* #

require "var_dalencar.dat";

use CGI qw(:standard);

$termos = param('termos');
$conectivo = param('conectivo');
$caso = param('caso');
$rpp = param('rpp');
$primeiro = param('primeiro');
$ultimo = param('ultimo');
$script = url(-relative=>1);

$ver = "2.1";


print redirect($url) unless ($termos);

if (length($termos) < 3) {
 &TopoHtml("Erro na Pesquisa");
 print <<Min;
<center>
<table width="90%" bgcolor="#fff1df">
<tr>
<td width="20%">
<$fonte>
A espresso (<b>$termos</b>)  muito pequena, so necessrios no mnimo 3 (trs) caracteres.<br> Pesquise por termos semelhantes.</font>
</td></tr>
</table>
<br>
<a href="$url">voltar</a></b>
Min

&FimHtml;
exit;
}


&Base_errada unless (-e "$basedir");

@dirs = ($basedir);
$max = 1;

for ($i = 0; $i < $max; $i++) {
 $dir = @dirs[$i];

 opendir (DIR, "$dir") || &Erro("$dir");
 @arqs = readdir (DIR);
 closedir (DIR);

foreach (@arqs) {
 $arq = "$dir/$_";

if ((-d $arq) && ($_ ne "." && $_ ne "..")) {
 push @dirs, $arq;
 $max++;
}

if ((-T $arq) && (m! .$ext $ !ix)) {
 push @arquivos, $arq;
}

} #fim do for
} #fim do foreach


$rpp = "10" unless ($rpp);
$caso = "insensivel" unless ($caso);
$conectivo = "ou" unless ($conectivo);

@termos = split (/\s+/, $termos);


foreach $arquivo (@arquivos) {

 open (ARQ, "<$arquivo") || &Erro("$arquivo");
 $_ = join (' ', <ARQ>);
 close ARQ;

s{ \n | \r | \t }{ }gx;
s{ <script> (.*) </script> }{}gix;

foreach $termo (@termos) {

if ($conectivo eq "e") {
 if ($caso eq "insensivel" && (!/$termo/i)) {
  $incluir{$arquivo} = 0;
   last;
  }
  else { $incluir{$arquivo} = 1; }

 if ($caso eq "sensivel" && (!/$termo/)) {
  $incluir{$arquivo} = 0;
  last;
 }
 else { $incluir{$arquivo} = 1; }

} #fim do conectivo e

elsif ($conectivo eq "ou") {
 if ($caso eq "insensivel" && (/$termo/i)) {
  $incluir{$arquivo} = 1;
  last;
 }

 if ($caso eq "sensivel" && (/$termo/)) {
  $incluir{$arquivo} = 1;
  last;
 }

} #fim do conectivo ou

} #fim do foreach termo

$titulo{$arquivo} = m! <title> ([^<]*) </title> !ix ? $1 : "Sem Ttulo";

if (m! <meta \s+ name="description" \s+ content=" ([^\"]*) "> !ix) { $sumario{$arquivo} = $1; }

elsif (m! <body !ix) {
 s{ <body [^>]* > (.*) }{$1}ix;
 s{ <title> ([^<]*) </title> }{}ix;
 s{ < ([^>])* > }{}gx;
 $sumario{$arquivo} = substr ($_, 0, 300);
}

} #fim do foreach arquivo


foreach $chave (keys %incluir) { if ($incluir{$chave}) { $contp++;} }

&TopoHtml("$titulo");

if ($contp) {

$primeiro = "1" unless ($primeiro);
$ultimo = "$rpp" unless ($ultimo);

 print <<Res;
<p>
<table align="center" width="95%" bgcolor="#fff1df">
<tr>
<td width="20%">
<$fonte>
 &nbsp; Resultado da pesquisa por <b>$termos</b>.<br>
 &nbsp; Foram encontrados <b>$contp</b> documentos.<br>
 &nbsp; Exibindo de $primeiro at 
Res

 if ($contp < $ultimo) { print "$contp"; }
 else { print "$ultimo"; }

print ".</td></tr>\n</table>\n<br><p>\n\n";

foreach $link (sort keys %incluir) {
 if ($incluir{$link}) {

 $cont++;
 next if ($cont < $primeiro);
 last if ($cont > $ultimo);

 $tam = int(((stat($link))[7])/1024 + .5) ." Kb";
 $nome = $link;
 if ($nome =~ m! ^$basedir (.*) !ix) { $nome = $1; }

 print "$cont. <b><a href=\"$baseurl$nome\">$titulo{$link}</a></b>\n";
 print "<br><small>";
 print "$sumario{$link} ...<br>\n" if ($descricao);
 print "<font color=808080><i>$baseurl$nome, $tam</i>";
 print "</font></small><p>\n\n";
 }
}

print "<center>\n<b>";

if ($primeiro > 1) {
 print "<small>&lt;&lt;</small> ";
 print "<a href=\"$script?termos=$termos&conectivo=$conectivo&caso=$caso&rpp=$rpp&primeiro=", ($primeiro-$rpp) ,"&ultimo=", ($ultimo-$rpp) ,"\">$rpp Anteriores</a>"; 
}

print " | " if (($primeiro > 1) && ($ultimo < $contp));

if ($ultimo < $contp) {
 print "<a href=\"$script?termos=$termos&conectivo=$conectivo&caso=$caso&rpp=$rpp&primeiro=", ($primeiro+$rpp) ,"&ultimo=", ($ultimo+$rpp) ,"\">";

 eval { $prox = ($contp - $ultimo); };
 if ($prox == 1) { print "Prximo"; }
 elsif ($prox < $rpp) { print "Prximos $prox"; }
 else { print "Prximos $rpp"; }

 print "</a> <small>&gt;&gt;</small>";
}

 print "</b>\n";
}
else {
 print <<Nada;
<center>
<table width="90%" bgcolor="#fff1df">
<tr>
<td width="20%">
<$fonte><b>No foi encontrado nenhum documento com "$termos".<br> Pesquise por termos semelhantes.</b></font>
</td></tr>
</table>
Nada
}

print <<Form;
<p>
<hr width="85%" size=1>
<form action="$script" method="POST">
<input type="hidden" name="caso" value="$caso">
<input type="hidden" name="conectivo" value="$conectivo">
<input type="hidden" name="rpp" value="$rpp">
<input type="text" name="termos" size="35">
<input type="submit" value="Pesquisar">
<br>
<a href="$url">+ opes</a>
</form>\n
Form

&FimHtml;

#fim do resultado


if ($log) {
 ($min,$hora,$dia,$mes,$ano) = (localtime($^T))[1,2,3,4,5];
 $mes++;
 $mes = "0$mes" if ($mes < 10);
 eval { $ano = (2000 + $ano); };
 $horaf = sprintf("%02d:%02d", $hora,$min);
 $data = "$dia/$mes/$ano $horaf h";

unless (-e "dalencar.log") {
 open (PRI, ">dalencar.log") || &Erro("dalencar.log");
 flock PRI, 2;
 print PRI "Pesquisa D' Alencar $ver - Aquivo Log\n";
 print PRI "------------------------------------\n\n";
 close PRI;
}

 open (LOG, ">>dalencar.log") || &Erro("dalencar.log");
 flock LOG, 2;
 print LOG "$termos - $data - $ENV{'REMOTE_ADDR'} - $ENV{'HTTP_USER_AGENT'}\n";
 close LOG;
}


sub TopoHtml {
 my ($title) = $_[0];
 print header;
 print <<Topo;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">\n
<html>\n
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="Author" content="Marcus Aurlio D' Alencar">
<meta name="Generator" content="Pesquisa D' Alencar $ver">
<title>$title</title>
</head>\n
<body $corpo>\n
<h1 align="center">$title</h1>
<$fonte>
Topo
}


sub FimHtml {

 ## No altere as linhas abaixo seno voc estar violando o Copyright  ##

 print <<Fim;
<p>&nbsp;</p>
<center>
<hr width="50%" size=1>
<small>Pesquisa D' Alencar $ver (freeware)<br>
Copyright &copy; 1999 <a href="mailto:dalencar\@mailbr.com.br">Marcus D' Alencar</a><br>
Visite <a href="http://www.dalencar.cjb.net">www.dalencar.cjb.net</a>
</small>
</center>\n
</body>\n
</html>
Fim
}


sub Base_errada {
 &TopoHtml("Diretrio Base Errado");
 print <<Base;
O script tentou encontrar o diretrio base (\$basedir) que voc especificou:<p>
<dd><b>$basedir</b></dd><p>
Mas o sistema informou que ele no existe.<p>
Informe-se com o administrador do servidor - hostmaster - qual o seu \$basedir e altere-o no arquivo "var_dalencar.dat".<p>
<u>Dica:</u> Tente colocar \$basedir = "../"
Base

&FimHtml;
exit;
}


sub Erro {
 my ($erro) = $_[0];
 &TopoHtml("Erro na Configurao");
 print <<Erro;
<b>O script no pode abrir $erro: $!</b><p>
<u>Obs.</u> Tenha certeza de que esse script e os arquivos requeridos esto no diretrio especificado e <b>acessveis</b>  leitura.
Erro

&FimHtml;
exit;
}

exit;
