package jcode;
;######################################################################
;#
;# Copyright (c) 1999-2000 Joao Orui <jfsso@hotmail.com>
;#
;; $rcsid = q$Id: brascode.pl,v 2.10 2000/12/25 17:47:41 utashiro Exp $;
;#
;######################################################################
;#
&init unless defined $version;

;#
sub init {
    $version = $rcsid =~ /,v ([\d.]+)/ ? $1 : 'unkown';

    $re_bin  = '[\000-\006\177\377]';

    $re_jis0208_1978 = '\e\$\@';
    $re_jis0208_1983 = '\e\$B';
    $re_jis0208_1990 = '\e&\@\e\$B';
    $re_jis0208 = "$re_jis0208_1978|$re_jis0208_1983|$re_jis0208_1990";
    $re_jis0212 = '\e\$\(D';
    $re_jp      = "$re_jis0208|$re_jis0212";
    $re_asc     = '\e\([BJ]';
    $re_kana    = '\e\(I';
    $esc_0208 = "\e\$B";
    $esc_0212 = "\e\$(D";
    $esc_asc  = "\e(B";
    $esc_kana = "\e(I";

    $re_sjis_c    = '[\201-\237\340-\374][\100-\176\200-\374]';
    $re_sjis_kana = '[\241-\337]';

    $re_euc_c    = '[\241-\376][\241-\376]';
    $re_euc_kana = '\216[\241-\337]';
    $re_euc_0212 = '\217[\241-\376][\241-\376]';

    $undef_sjis = "\x81\xac";

    $cache = 1;

    ($h2z_high = $h2z = <<'__TABLE_END__') =~ tr/\041-\176/\241-\376/;
!        !#        $        !"        %        !&        "        !V        #        !W
^        !+        _        !,        0        !<
'        %!        (        %#        )        %%        *        %'        +        %)
,        %c        -        %e        .        %g        /        %C
1        %"        2        %$        3        %&        4        %(        5        %*
6        %+        7        %-        8        %/        9        %1        :        %3
6^        %,        7^        %.        8^        %0        9^        %2        :^        %4
;        %5        <        %7        =        %9        >        %;        ?        %=
;^        %6        <^        %8        =^        %:        >^        %<        ?^        %>
@        %?        A        %A        B        %D        C        %F        D        %H
@^        %@        A^        %B        B^        %E        C^        %G        D^        %I
E        %J        F        %K        G        %L        H        %M        I        %N
J        %O        K        %R        L        %U        M        %X        N        %[
J^        %P        K^        %S        L^        %V        M^        %Y        N^        %\
J_        %Q        K_        %T        L_        %W        M_        %Z        N_        %]
O        %^        P        %_        Q        %`        R        %a        S        %b
T        %d                        U        %f                        V        %h
W        %i        X        %j        Y        %k        Z        %l        [        %m
\        %o        ]        %s        &        %r        3^        %t
__TABLE_END__
    %h2z = split(/\s+/, $h2z . $h2z_high);
    %z2h = reverse %h2z;

    $convf{'jis'  , 'jis' } = *jis2jis;
    $convf{'jis'  , 'sjis'} = *jis2sjis;
    $convf{'jis'  , 'euc' } = *jis2euc;
    $convf{'euc'  , 'jis' } = *euc2jis;
    $convf{'euc'  , 'sjis'} = *euc2sjis;
    $convf{'euc'  , 'euc' } = *euc2euc;
    $convf{'sjis' , 'jis' } = *sjis2jis;
    $convf{'sjis' , 'sjis'} = *sjis2sjis;
    $convf{'sjis' , 'euc' } = *sjis2euc;
    $h2zf{'jis' } = *h2z_jis;
    $z2hf{'jis' } = *z2h_jis;
    $h2zf{'euc' } = *h2z_euc;
    $z2hf{'euc' } = *z2h_euc;
    $h2zf{'sjis'} = *h2z_sjis;
    $z2hf{'sjis'} = *z2h_sjis;
}

;#
sub jis_inout {
    $esc_0208 = shift || $esc_0208;
    $esc_0208 = "\e\$$esc_0208" if length($esc_0208) == 1;
    $esc_asc = shift || $esc_asc;
    $esc_asc = "\e\($esc_asc" if length($esc_asc) == 1;
    ($esc_0208, $esc_asc);
}

;#
sub get_inout {
    local($esc_0208, $esc_asc);
    $_[$[] =~ /($re_jis0208)/o && ($esc_0208 = $1);
    $_[$[] =~ /($re_asc)/o && ($esc_asc = $1);
    ($esc_0208, $esc_asc);
}

;#
sub getcode {
    local(*_) = @_;
    local($matched, $code);

    if (!/[\e\200-\377]/) {        # not Japanese
        $matched = 0;
        $code = undef;
    }                                # 'jis'
    elsif (/$re_jp|$re_asc|$re_kana/o) {
        $matched = 1;
        $code = 'jis';
    }
    elsif (/$re_bin/o) {        # 'binary'
        $matched = 0;
        $code = 'binary';
    }
    else {                        # should be 'euc' or 'sjis'
        local($sjis, $euc);

        $sjis += length($1) while /(($re_sjis_c)+)/go;
        $euc  += length($1) while /(($re_euc_c|$re_euc_kana|$re_euc_0212)+)/go;

        $matched = &max($sjis, $euc);
        $code = ('euc', undef, 'sjis')[($sjis<=>$euc) + $[ + 1];
    }
    wantarray ? ($matched, $code) : $code;
}
sub max { $_[ $[ + ($_[$[] < $_[$[+1]) ]; }

;#
sub convert {
    local(*_, $ocode, $icode, $opt) = @_;
    return (undef, undef) unless $icode = $icode || &getcode(*_);
    return (undef, $icode) if $icode eq 'binary';
    $ocode = 'jis' unless $ocode;
    $ocode = $icode if $ocode eq 'noconv';
    local(*f) = $convf{$icode, $ocode};
    &f(*_, $opt);
    wantarray ? (*f, $icode) : $icode;
}

;#
sub jis  { &to('jis',  @_); }
sub euc  { &to('euc',  @_); }
sub sjis { &to('sjis', @_); }
sub to {
    local($ocode, $_, $icode, $opt) = @_;
    &convert(*_, $ocode, $icode, $opt);
    $_;
}
sub what {
    local($_) = @_;
    &getcode(*_);
}
sub trans {
    local($_) = shift;
    &tr(*_, @_);
    $_;
}

;#
sub sjis2jis {
    local(*_, $opt, $n) = @_;
    &sjis2sjis(*_, $opt) if $opt;
    s/(($re_sjis_c|$re_sjis_kana)+)/&_sjis2jis($1) . $esc_asc/geo;
    $n;
}
sub _sjis2jis {
    local($_) = shift;
    s/(($re_sjis_c)+|($re_sjis_kana)+)/&__sjis2jis($1)/geo;
    $_;
}
sub __sjis2jis {
    local($_) = shift;
    if (/^$re_sjis_kana/o) {
        $n += tr/\241-\337/\041-\137/;
        $esc_kana . $_;
    } else {
        $n += s/($re_sjis_c)/$s2e{$1}||&s2e($1)/geo;
        tr/\241-\376/\041-\176/;
        $esc_0208 . $_;
    }
}

;#
sub euc2jis {
    local(*_, $opt, $n) = @_;
    &euc2euc(*_, $opt) if $opt;
    s/(($re_euc_c|$re_euc_kana|$re_euc_0212)+)/&_euc2jis($1) . $esc_asc/geo;
    $n;
}
sub _euc2jis {
    local($_) = shift;
    s/(($re_euc_c)+|($re_euc_kana)+|($re_euc_0212)+)/&__euc2jis($1)/geo;
    $_;
}
sub __euc2jis {
    local($_) = shift;
    local($esc) = tr/\216//d ? $esc_kana : tr/\217//d ? $esc_0212 : $esc_0208;
    $n += tr/\241-\376/\041-\176/;
    $esc . $_;
}

;#
sub jis2euc {
    local(*_, $opt, $n) = @_;
    s/($re_jp|$re_asc|$re_kana)([^\e]*)/&_jis2euc($1,$2)/geo;
    &euc2euc(*_, $opt) if $opt;
    $n;
}
sub _jis2euc {
    local($esc, $_) = @_;
    if ($esc !~ /$re_asc/o) {
        $n += tr/\041-\176/\241-\376/;
        if ($esc =~ /$re_kana/o) {
            s/([\241-\337])/\216$1/g;
        }
        elsif ($esc =~ /$re_jis0212/o) {
            s/([\241-\376][\241-\376])/\217$1/g;
        }
    }
    $_;
}

;#
sub jis2sjis {
    local(*_, $opt, $n) = @_;
    &jis2jis(*_, $opt) if $opt;
    s/($re_jp|$re_asc|$re_kana)([^\e]*)/&_jis2sjis($1,$2)/geo;
    $n;
}
sub _jis2sjis {
    local($esc, $_) = @_;
    if ($esc =~ /$re_jis0212/o) {
        s/../$undef_sjis/g;
        $n = length;
    }
    elsif ($esc !~ /$re_asc/o) {
        $n += tr/\041-\176/\241-\376/;
        s/($re_euc_c)/$e2s{$1}||&e2s($1)/geo if $esc =~ /$re_jp/o;
    }
    $_;
}

;#
sub sjis2euc {
    local(*_, $opt,$n) = @_;
    $n = s/($re_sjis_c|$re_sjis_kana)/$s2e{$1}||&s2e($1)/geo;
    &euc2euc(*_, $opt) if $opt;
    $n;
}
sub s2e {
    local($c1, $c2, $code);
    ($c1, $c2) = unpack('CC', $code = shift);

    if (0xa1 <= $c1 && $c1 <= 0xdf) {
        $c2 = $c1;
        $c1 = 0x8e;
    } elsif (0x9f <= $c2) {
        $c1 = $c1 * 2 - ($c1 >= 0xe0 ? 0xe0 : 0x60);
        $c2 += 2;
    } else {
        $c1 = $c1 * 2 - ($c1 >= 0xe0 ? 0xe1 : 0x61);
        $c2 += 0x60 + ($c2 < 0x7f);
    }
    if ($cache) {
        $s2e{$code} = pack('CC', $c1, $c2);
    } else {
        pack('CC', $c1, $c2);
    }
}

;#
sub euc2sjis {
    local(*_, $opt,$n) = @_;
    &euc2euc(*_, $opt) if $opt;
    $n = s/($re_euc_c|$re_euc_kana|$re_euc_0212)/$e2s{$1}||&e2s($1)/geo;
}
sub e2s {
    local($c1, $c2, $code);
    ($c1, $c2) = unpack('CC', $code = shift);

    if ($c1 == 0x8e) {                # SS2
        return substr($code, 1, 1);
    } elsif ($c1 == 0x8f) {        # SS3
        return $undef_sjis;
    } elsif ($c1 % 2) {
        $c1 = ($c1>>1) + ($c1 < 0xdf ? 0x31 : 0x71);
        $c2 -= 0x60 + ($c2 < 0xe0);
    } else {
        $c1 = ($c1>>1) + ($c1 < 0xdf ? 0x30 : 0x70);
        $c2 -= 2;
    }
    if ($cache) {
        $e2s{$code} = pack('CC', $c1, $c2);
    } else {
        pack('CC', $c1, $c2);
    }
}

;#
sub jis2jis {
    local(*_, $opt) = @_;
    s/$re_jis0208/$esc_0208/go;
    s/$re_asc/$esc_asc/go;
    &h2z_jis(*_) if $opt =~ /z/;
    &z2h_jis(*_) if $opt =~ /h/;
}
sub sjis2sjis {
    local(*_, $opt) = @_;
    &h2z_sjis(*_) if $opt =~ /z/;
    &z2h_sjis(*_) if $opt =~ /h/;
}
sub euc2euc {
    local(*_, $opt) = @_;
    &h2z_euc(*_) if $opt =~ /z/;
    &z2h_euc(*_) if $opt =~ /h/;
}

;#
sub cache {
    ($cache, $cache = 1)[$[];
}
sub nocache {
    ($cache, $cache = 0)[$[];
}
sub flushcache {
    undef %e2s;
    undef %s2e;
}

;#
sub h2z_jis {
    local(*_, $n) = @_;
    if (s/$re_kana([^\e]*)/$esc_0208 . &_h2z_jis($1)/geo) {
        1 while s/(($re_jis0208)[^\e]*)($re_jis0208)/$1/o;
    }
    $n;
}
sub _h2z_jis {
    local($_) = @_;
    $n += s/([\41-\137]([\136\137])?)/$h2z{$1}/g;
    $_;
}

sub h2z_euc {
    local(*_) = @_;
    s/\216([\241-\337])(\216([\336\337]))?/$h2z{"$1$3"}/g;
}

sub h2z_sjis {
    local(*_, $n) = @_;
    s/(($re_sjis_c)+)|(([\241-\337])([\336\337])?)/
        $1 || ($n++, $e2s{$h2z{$3}} || &e2s($h2z{$3}))/geo;
    $n;
}

;#
sub z2h_jis {
    local(*_, $n) = @_;
    s/($re_jis0208)([^\e]+)/&_z2h_jis($2)/geo;
    $n;
}
sub _z2h_jis {
    local($_) = @_;
    s/((\%[!-~]|![\#\"&VW+,<])+|([^!%][!-~]|![^\#\"&VW+,<])+)/&__z2h_jis($1)/ge;
    $_;
}
sub __z2h_jis {
    local($_) = @_;
    return $esc_0208 . $_ unless /^%/ || /^![\#\"&VW+,<]/;
    $n += length($_) / 2;
    s/(..)/$z2h{$1}/g;
    $esc_kana . $_;
}

sub z2h_euc {
    local(*_, $n) = @_;
    &init_z2h_euc unless defined %z2h_euc;
    s/($re_euc_c|$re_euc_kana)/$z2h_euc{$1} ? ($n++, $z2h_euc{$1}) : $1/geo;
    $n;
}

sub z2h_sjis {
    local(*_, $n) = @_;
    &init_z2h_sjis unless defined %z2h_sjis;
    s/($re_sjis_c)/$z2h_sjis{$1} ? ($n++, $z2h_sjis{$1}) : $1/geo;
    $n;
}

;#
sub init_z2h_euc {
    local($k, $_);
    s/([\241-\337])/\216$1/g && ($z2h_euc{$k} = $_) while ($k, $_) = each %z2h;
}
sub init_z2h_sjis {
    local($_, $v);
    /[\200-\377]/ && ($z2h_sjis{&e2s($_)} = $v) while ($_, $v) = each %z2h;
}

;#
sub tr {
    # $prev_from, $prev_to, %table are persistent variables
    local(*_, $from, $to, $opt) = @_;
    local(@from, @to);
    local($jis, $n) = (0, 0);

    $jis++, &jis2euc(*_) if /$re_jp|$re_asc|$re_kana/o;
    $jis++ if $to =~ /$re_jp|$re_asc|$re_kana/o;

    if ($from ne $prev_from || $to ne $prev_to) {
        ($prev_from, $prev_to) = ($from, $to);
        undef %table;
        &_maketable;
    }

    s/([\200-\377][\000-\377]|[\000-\377])/
        defined($table{$1}) && ++$n ? $table{$1} : $1/ge;

    &euc2jis(*_) if $jis;

    $n;
}

sub _maketable {
    local($ascii) = '(\\\\[\\-\\\\]|[\0-\133\135-\177])';

    &jis2euc(*to) if $to =~ /$re_jp|$re_asc|$re_kana/o;
    &jis2euc(*from) if $from =~ /$re_jp|$re_asc|$re_kana/o;

    grep(s/(([\200-\377])[\200-\377]-\2[\200-\377])/&_expnd2($1)/ge,$from,$to);
    grep(s/($ascii-$ascii)/&_expnd1($1)/geo,$from,$to);

    @to   = $to   =~ /[\200-\377][\000-\377]|[\000-\377]/g;
    @from = $from =~ /[\200-\377][\000-\377]|[\000-\377]/g;
    push(@to, ($opt =~ /d/ ? '' : $to[$#to]) x (@from - @to)) if @to < @from;
    @table{@from} = @to;
}

sub _expnd1 {
    local($_) = @_;
    s/\\(.)/$1/g;
    local($c1, $c2) = unpack('CxC', $_);
    if ($c1 <= $c2) {
        for ($_ = ''; $c1 <= $c2; $c1++) {
            $_ .= pack('C', $c1);
        }
    }
    $_;
}

sub _expnd2 {
    local($_) = @_;
    local($c1, $c2, $c3, $c4) = unpack('CCxCC', $_);
    if ($c1 == $c3 && $c2 <= $c4) {
        for ($_ = ''; $c2 <= $c4; $c2++) {
            $_ .= pack('CC', $c1, $c2);
        }
    }
    $_;
}

1;
