#!/usr/bin/perl

require 'pesquisa.conf';


&analisa_form;
&arquivos;
&pesquisa;
&retorna_html;

sub analisa_form {
   read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
   @pairs = split(/&/, $buffer);
   foreach $pair (@pairs) {
      ($name, $value) = split(/=/, $pair);
      $value =~ tr/+/ /;
      $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
      $FORM{$name} = $value;
   }
}

sub arquivos {

   chdir($basedir);
   foreach $file (@files) {
      $ls = `ls $file`;
      @ls = split(/\s+/,$ls);
      foreach $temp_file (@ls) {
         if (-d $file) {
            $filename = "$file$temp_file";
            if (-T $filename) {
               push(@FILES,$filename);
            }
         }
         elsif (-T $temp_file) {
            push(@FILES,$temp_file);
         }
      }
   }
}

sub pesquisa {
   @terms = split(/\s+/, $FORM{'terms'});
   foreach $FILE (@FILES) {
      open(FILE,"$FILE");
      @LINES = <FILE>;
      close(FILE);
      $string = join(' ',@LINES);
      $string =~ s/\n//g;
      if ($FORM{'boolean'} eq 'AND') {
         foreach $term (@terms) {
            if ($FORM{'case'} eq 'Insensitive') {
               if (!($string =~ /$term/i)) {
                  $include{$FILE} = 'no';
  		  last;
               }
               else {
                  $include{$FILE} = 'yes';
               }
            }
            elsif ($FORM{'case'} eq 'Sensitive') {
               if (!($string =~ /$term/)) {
                  $include{$FILE} = 'no';
                  last;
               }
               else {
                  $include{$FILE} = 'yes';
               }
            }
         }
      }
      elsif ($FORM{'boolean'} eq 'OR') {
         foreach $term (@terms) {
            if ($FORM{'case'} eq 'Insensitive') {
               if ($string =~ /$term/i) {
                  $include{$FILE} = 'yes';
                  last;
               }
               else {
                  $include{$FILE} = 'no';
               }
            }
            elsif ($FORM{'case'} eq 'Sensitive') {
               if ($string =~ /$term/) {
		  $include{$FILE} = 'yes';
                  last;
               }
               else {
                  $include{$FILE} = 'no';
               }
            }
         }
      }
      if ($string =~ /<title>(.*)<\/title>/i) {
         $titles{$FILE} = "$1";
      }
      else {
         $titles{$FILE} = "$FILE";
      }
   }
}
      
sub retorna_html {
   print "Content-type: text/html\n\n";
   print "<html>\n<head>\n<title>$title</title>\n</head>\n";
   print "<$body>\n";
   print "<p><$font><b>Resumo da Pesquisa:</b> <br>\n";
   print "<table border=0 cellspacing=0><tr><td>";
   print "<$font>&nbsp Palavra(s): </td>\n";
   print " <td><$font color=FF0000><b>";
   $i = 0;
   foreach $term (@terms) {
      print "$term";
      $i++;
      if (!($i == @terms)) {
         print ", ";   
      }
   }
   print "</b></font></td></tr>\n";
   print "<tr><td><$font>&nbsp Boolean: </td>\n";
   print "<td><$font>$FORM{'boolean'}</td></tr>\n";
   print "<tr><td><$font>&nbsp Caso: </td>\n";
   print "<td><$font>$FORM{'case'}</td></tr>\n";
   print "<tr><td><$font>&nbsp Localizao: </td>\n";
   print " <td><$font><a href='$baseurl'>$baseurl</a></td></tr></table>\n";
   print "<center><hr></center>\n";
   print "<ol>\n";
   foreach $key (keys %include) {
      if ($include{$key} eq 'yes') {
         print "<li><a href=\"$baseurl$key\">$titles{$key}</a>\n";
      }
   }
   print "</ol>\n";
   print "<hr>\n";
   print "<p><center><a href='$ENV{HTTP_REFERER}'><$font><b>Fazer nova Pesquisa.</b></a>\n";
   print "<p><hr width=300>\n";
   print "<font size=-1>Desenvolvido por Csar Botelho</a>\n";
   print "</body>\n<noscript>\n</html>\n";
}
   
