//
//  autolist.js
//  ----------------
//  External script for AutoList-Lite/Autolist21 free toplisting systems.
//  Copyright (c) 2000 Mike Stannett (web@noisefactory.co.uk). All Rights Reserved.
//
//  DO NOT EDIT ANY PART OF THIS FILE. IT IS AN INTEGRAL PART OF AUTOLIST AND
//  CHANGING IT MAY EASILY RENDER AUTOLIST INOPERATIVE
//
//  Issued with update April 2000


var page  = location.pathname;
if ( page.charAt(page.length-1) == "/" ) page += "index.html";


function checkAddress( a ) {
  var at  = a.lastIndexOf("@");
  var dot = a.indexOf(".",at);
  if ( a.length < 8  ||  dot < 1  ||  at < 1  ||  (dot-at) < 4 ) {
    var msg = "The email address you have given\n\t" + a + "\nis not valid. To be valid, an address "
            + "must be at least 8 characters long, and have the form \"username@yoursite.domain,\" "
            + "where \"yoursite\" is at least 3 characters long.";
    alert(msg);
    return false;
  }
  else return true;
}


function missing( entry, name ) {
  if ( entry == '' ) {
    var msg = "You need to specify... " + name;
    alert(msg);
    return true;
  }
  return false;
}

function editConfirm() {

  var f = document.formEditEntry;

  f.page.value = page;
  f.act.value = 'edit';
  f.action = script;

  var userid  = f.userid.value;
  var userpw  = f.userpw.value;
  var oldurl  = f.oldurl.value;
  var newurl  = f.newurl.value;
  var newdesc = f.newdesc.value;

  if ( missing( userid, "User Id" ) ) return false;
  if ( missing( userpw, "Password") ) return false;
  if ( missing( oldurl, "Old URL" ) ) return false;

  if ( newurl == '' ) newurl = "No Change";
  if ( newdesc == '' ) newdesc = "No Change";

  var msg = "You have specified the following changes\n"
          + "\nOld URL:\t\t" + oldurl
          + "\nNew URL:\t" + newurl
          + "\nDescription:\t" + newdesc;

  if ( newurl != "No Change" ) {
    msg += "\n\nWARNING\nWhen you change your registered URL, you must ALSO change any "
        + "existing calls to the list that references that URL. Otherwise "
        + "the calls will fail, and your referrals won't be counted.";
  }

  msg += "\n\nAre you sure you want to change your entry?";

  if ( confirm(msg) ) return true; else return false;

}

var noisy = "AutoList Lite by NoiseFactory (http://noisefactory.co.uk)";
function initialise() { defaultStatus = noisy; }

function addConfirm() {

  var f = document.formAddUrl;

  f.page.value = page;
  f.act.value = 'add';
  f.action = script;

  var userid  = f.userid.value;
  var userpw  = f.userpw.value;
  var userpw2 = f.userpw2.value;
  var url     = f.url.value;
  var desc    = f.desc.value;
  var address = f.email.value;

  if ( missing( url,    "URL"              ) ) return false;
  if ( missing( desc,   "Site Description" ) ) return false;
  if ( missing( userid, "User ID"          ) ) return false;
  if ( missing( userpw, "Password"         ) ) return false;

  if ( userpw != userpw2 ) {
    f.userpw.value = "";
    f.userpw2.value = "";
    alert("Your password entries disagree with each other. Please re-enter both strings again.");
    return false;
  }

  var msg = "You are about to add the entry\n"
          + "\nURL:\t\t"  + url
          + "\nDescription:\t" + desc
          + "\nUser ID:\t\t" + userid
          + "\nPassword:\t" + userpw
          + "\nConfirm to:\t";

  if ( address ) {
    if ( checkAddress(address) ) msg += address;
    else {
      msg = "The email address you have given is not valid. To be valid, an address must contain "
          + "at least 8 characters in the form \"username@yoursite.domain\"., where \"yoursite\" "
          + "is at least 3 characters long.";
      alert(msg);
      return false;
    }
  }
  else msg += "No confirmation";

  msg += "\n\nDo you want to add this entry?";
  if ( confirm(msg) ) { return true; } else { return false; }

}

function do_jump(target) {

  var outwnd = open(outward,"al_outward"); outwnd.status = noisy;
  var tmpwnd = open("", "", "resizable,status,scrollbars,height=180,width=480");
  with ( tmpwnd.document ) {
    open();
    writeln('<html><head><title>Confirm AutoList Redirection</title>');
    writeln('<scr', 'ipt language=JavaScript', '>');
    writeln('<', '!--');
    writeln('function handle_jump() {');
    writeln('  parent.open("', script, '?act=out&page=', escape(page), '&url=', escape(target), '", "_blank");');
    writeln('  this.close();');
    writeln('}');
    writeln('/','/',' --', '>');
    writeln('</scr', 'ipt></head>');
    writeln('<body text=white link=lightblue vlink=lightblue alink=yellow bgcolor=black>');
    writeln('<center><form name="jumpForm" onSubmit="handle_jump();">');
    writeln('<p><font size=+3 color=lightblue>Continue jump to original selection?</font><p>');
    writeln('<input type=submit value="Continue to ', target, '">');
    writeln('<input type=button value="Don\'t bother" onClick="window.close();"></form><p>');
    writeln('<hr><font face="Arial,Helvetica" size=-1>AutoList: Copyright &copy; 2000 ');
    writeln('<a href=mailto:web@noisefactory.co.uk>NoiseFactory</a>.');
    writeln(' All Rights Reserved.</center></font></body></html>');
    close();
  }
}

