#!/usr/bin/perl
#  ---------------------------------------------------------------------------
#  Mike's AutoList                                                  AutoList21
#  Copyright (c) 1999, 2000 Mike Stannett            http://noisefactory.co.uk
#  All Rights Reserved                                  web@noisefactory.co.uk
#  ---------------------------------------------------------------------------
#   This version is distributed free of charge by NoiseFactory subject to
#   conditions agreed by the user before the scripts were shipped (see
#   http://adultaudiovisual.com/scripts/autolist/index.html for details).
#
#   By using a freely downloaded version of AutoList you agree that the
#   author and distributor are not liable for any problems or losses,
#   direct or indirect, arising through its use. Free versions of AutoList
#   are supplied as-is, and no warrantee or guarantee as to their
#   merchantability or suitability for purpose are intended or should be
#   inferred. You use these scripts at your own risk. Note that the right
#   to use these scripts does not include the right to redistribute them.
#   You may direct people to the NoiseFactory free download site, but you
#   should not distribute or redistribute any part of this product directly.
#
#   This program is the property of Mike Stannett. Distributing, re-distributing
#   or selling the code for this program in any form whatsoever without his prior
#   written consent is expressly forbidden.
#  ---------------------------------------------------------------------------

# This script uses the file locking function "flock" to avoid synchronisation
# problems in the unlikely event that two referals occur at almost exactly the same
# time. If you have a non-UNIX server, this may cause a program failure. Uncommenting
# the following line by removing the hash mark at the beginning will tell the program
# not to use file locking.

#    $NO_FILE_LOCKING = 1;

# This script uses the UNIX email command 'sendmail -t' in order to send a
# confirmation message to a new client whenever they add their site to the
# list. If this doesn't work on your server, your internet hosting company
# may be able to give you details of any alternative email programs they have
# available. You will need to amend the SendMailPath setting in the user-section
# of the core library (alcore.pl) supplied with this release.


# SAFETY MESSAGE: DON'T EDIT ANYTHING BELOW THIS LINE
# ---------------------------------------------------

  my $LOCK_EX  = 2;   # exclusive lock
  my $LOCK_UN  = 8;   # unlock

  %status   = ( OK                   =>  0,
                OK_ADD               => -1,
                OK_EDIT              => -2,
                ERR_ADD_DUPLICATE    => -3,
                ERR_NO_OUTWARD_MATCH => -4,
                ERR_NO_EDIT_MATCH    => -5,
                ERR_BAD_KEY          => -6,
                ERR_EDIT_DUPLICATE   => -7
              );

  sub main_process;

  local @outarray;
  require "alcore.pl";
  &parse_stdin(*form,*admin);

  $action  = $form{act};

  $form{page} = $admin{DefaultList} if not defined $form{page};
  $url = $admin{Server} . $form{page};

  if ( open(AUTOLIST,"+<$ENV{DOCUMENT_ROOT}$form{page}") ) {

    unless ( $NO_FILE_LOCKING) {
      flock(AUTOLIST, $LOCK_EX) or die "ARRRRRGH WRITE ($!)\n";
    }
    my $OldFH = select AUTOLIST; $| = 1 ; select $OldFH;

    @lines = <AUTOLIST>;

    foreach $line (@lines) {
      al_core_loop(*line,*form,*admin,*data);
    }

    seek AUTOLIST, 0, 0;
    $output = join('',@outarray);
    print AUTOLIST $output;

    truncate AUTOLIST, tell AUTOLIST;
    flock(AUTOLIST, $LOCK_UN) unless $NO_FILE_LOCKING;
    close AUTOLIST;
  }
  else {
    print "Content-type: text/html\n\n";
    print "<html><head><title>Sorry</title></head>";
    print "<body bgcolor=black text=lime link=white vlink=white alink=white>";
    print "<center><h1>Sorry</h1></center>";
    print "Sorry - I can't open the list page at the moment. It may just be ";
    print "a temporary glitch, so <a href=$url>clicking here</a> may ";
    print "be enough to return you to the page...<p>";
    print "Sorry about this. If you still can't get through, please email ";
    print "the webmaster at $admin{Server} to report the problem. Cheers!</body></html>";
    exit;
  }


  if   ( $data{status} != $status{OK} ) { &report_status(*data,*form,*admin); }
  else { print "Location: $url\n\n"; }
  exit(0);

#	-----------------------------------------------------------------------------

sub main_process
{
  local ( *form, *data, *admin ) = @_;

  #	ADD NEW ENTRY
  if ( $action eq 'add' ) {

    my ( $target, $desc ) = ( $form{url}, $form{desc} );
    if ( $target =~ /"([^"]*)"/  ) { $target = $1;  }
    if ( $desc   =~ /"([^"]*)"/  ) { $desc = $1;    }

    if ( find_url($target,*data) == -1 ) {
      my $t = time;
      $data[ $data{nent}++ ] = {
        desc    => $desc,
        url     => $target,
        in      => 0,
        out     => 0,
        prevIn  => $t,
        prevOut => $t,
        key     => &alcore::encrypt( $admin{OwnerId}, $form{userid}, $form{userpw} )
      };
      $data{status} = $status{OK_ADD};
    }
    else {
      $data{status} = $status{ERR_ADD_DUPLICATE};
    }

  }
  #	EDIT EXISTING ENTRY
  elsif ( $action eq 'edit' ) {

     my $key = &alcore::encrypt( $admin{OwnerId}, $form{userid}, $form{userpw} );
     my $entry = find_url( $form{oldurl} );

     $oldurl  = $data[$entry]->{url};
     $newurl  = defined $form{newurl}  ? $form{newurl}  : "No Change";
     $olddesc = $data[$entry]->{desc};
     $newdesc = defined $form{newdesc} ? $form{newdesc} : "No Change";

     if ( $entry < 0 ) {
     	$data{status} = $status{ERR_NO_EDIT_MATCH};
     }
     elsif ( $data[$entry]->{key} ne $key ) {
    	$data{status} = $status{ERR_BAD_KEY};
     }
     elsif ( defined $form{newurl} && find_url($form{newurl}) != -1 ) {
       $data{status} = $status{ERR_EDIT_DUPLICATE};
     }
     else {
       $oldurl  = $data[$entry]->{url};
       $newurl  = defined $form{newurl}  ? $form{newurl}  : $oldurl;
       $olddesc = $data[$entry]->{desc};
       $newdesc = defined $form{newdesc} ? $form{newdesc} : $olddesc;

       $data[$entry]->{url}  = $newurl;
       $data[$entry]->{desc} = $newdesc;
       $data{status} = $status{OK_EDIT};
     }

  }
  #	OUTWARD REFERRAL
  elsif ( $action eq 'out' ) {

    my $entry  = find_url($form{url},*data);
    if ( $entry < 0 ) {
      $data{status} = $status{ERR_NO_OUTWARD_MATCH};
    }
    else {
      if ( $form{url} =~ /^interlink:(.+)/ ) {

        my ( $extscript, $extpage ) = split(/\@/,$1);
        my $call = "$admin{Server}$admin{Script}\@$form{page}";
        my $page = 'page=' . &alcore::al_encode($extpage) . '&' if defined $extpage;
        $url = "${extscript}?${page}url=interlink%3A" . &alcore::al_encode($call);
      }
      else {
        $url = ($form{url} =~ /^#/) ? ( $url . $form{url} ) : $form{url};
      }
      $data{status} = $status{OK};
      $data[$entry]->{out}++;
      $data[$entry]->{prevOut} = time;
    }

  }
  #	INWARD REFERRAL
  else {

    $data{status} = $status{OK};
    my $target = $form{url};
    if ( $target =~ /"[^"]*?"/  ) { $target = $1;  }
    my $entry = find_url($target,*data);
    if ( $entry >= 0 ) {
      my $prev = $data[$entry]->{prevIn};
      my $delay = $admin{delay};
      my $t = time;
      if ( (not $delay) || ( ($t-$prev) > $delay ) ) {
        $data[$entry]->{in}++;
        $data[$entry]->{prevIn} = $t;
      }
    }
  }

}

#	----------------------------------------------------------------------------

sub report_status
{
  local ( *data, *form, *admin ) = @_;
  my $status = $data{status};

  if ( $status == $status{OK} ) {
    # Shouldn't be in this subroutine!
    print "Location: $url\n\n";
    exit(0);
  }

  print "Content-type: text/html\n\n";
  print "<html><head><title>AutoList Status Report</title></head>\n";
  print "<body bgcolor=black text=white link=aqua vlink=aqua alink=yellow onLoad=\"defaultStatus='AutoList by NoiseFactory. Visit our site at http://noisefactory.co.uk'\">\n";

  if ( $action eq 'out' ) {

    if ( $status == $status{ERR_NO_OUTWARD_MATCH} ) {
      print "<center><h1>Thank you for using AutoList</h1></center>\n";
      print "Unfortunately, the URL you chose ($form{url}) no longer seems to be registered with\n";
      print "the list's owner, so I cannot forward your call to view that page.\n";
    }

  }

  elsif ( $action eq 'edit' ) {

    print "<center><h1>Change AutoList Entry</h1></center>\n";
    print "You requested the following changes to be made:<p>\n";
    print "<tt><blockquote>\n";
    print "Old URL: $oldurl<br>\n";
    print "New URL: $newurl<p>\n";
    print "Old Description: $olddesc<br>\n";
    print "New Description: $newdesc<p>\n";
    print "</blockquote></tt><p><hr><p><b>\nStatus:</b> ";

    if ( $status == $status{OK_EDIT} ) {
    	print "Change of details successfully completed\n";
    }
    elsif ( $status == $status{ERR_NO_EDIT_MATCH} ) {
   	print "Original URL not found in list - please check your entry carefully\n";
    }
    elsif ( $status == $status{ERR_BAD_KEY} ) {
   	print "User ID or password not recognised - please check your details carefully\n";
    }
    elsif ( $status == $status{ERR_EDIT_DUPLICATE} ) {
   	print "The new URL is already listed - it cannot be added twice\n";
    }

  }

  elsif ( $action eq 'add' ) {

    if ( $status == $status{ERR_ADD_DUPLICATE} ) {
      print "<center><h1>AutoList: Duplicate entry not added</h1></center>\n";
      print "Thank you for your interest in <i>AutoList</i>.\nUnfortunately ";
      print "the entry you wanted to add ($form{url}) is already included in ";
      print "the list, and cannot be added a second time.\n";
    }
    elsif ( $status == $status{OK_ADD} ) {

      my $cgi      = "$admin{Server}$admin{Script}";
      my $congrats = "Congratulations! Your site ($form{url}) has been "
                   . "successfully added to the AutoList at $admin{Server}$form{page}. To activate "
                   . "your entry and have your referrals counted, remember "
                   . "to add the following link to as many of your web pages "
                   . "as possible.";
      my $target = &alcore::al_encode($form{url});
      my $page = &alcore::al_encode($form{page});

      my $image = $admin{OwnerImage} if defined $admin{OwnerImage};
      if ( $image =~ /([^\\\/]*)\.(jpg|gif)/i ) {
        $imgshort = "$1.$2";
      }

      my $cgicall  = "\n<!-- BEGIN AUTOLIST CODE -->"
                   . "\n<a href=\"${cgi}?page=$page\&url=$target\">";
      $cgicall    .= $image ?
                     "<img\nsrc=\"$imgshort\" alt=\"$admin{OwnerImageAlt}\">"
                   : "$admin{OwnerImageAlt}";
      $cgicall    .= "</a>\n<!-- END AUTOLIST CODE -->\n";

      my $userid = "Your User ID:  $form{userid}\n";
      my $userpw = "Your Password: $form{userpw}\n";
      my $desc   = "Description:   $form{desc}\n";

      my $mailcmd = $admin{SendMailPath};
      if ( $mailcmd =~ /^\s*(\S+)/ ) { $mailprog = $1; }

      if ( ($mailprog and -e $mailprog) and ($form{'email'} or $admin{OwnerEmail}) ) {

        $mail = "${congrats}\n\n\t${cgicall}\n\n"
              . "Please write these details down. You will need them to edit your entry:\n\n"
              . "\t$userid\t$userpw\t$desc\n";
        if ( $image ) {
          $mail .= "The image mentioned in the link code can be downloaded here:\n\n$image\n";
        }
        $mail .= "\n-----------------------------------------------------"
               . "\n  Build your own AutoList: http://noisefactory.co.uk "
               . "\n-----------------------------------------------------";

        open (MAIL, "| $mailcmd");
        if ( $form{'email'} ne $admin{OwnerEmail} )
          { print MAIL "To: $form{'email'}\nCC: $admin{OwnerEmail}\n"; }
        else
          { print MAIL "To: $admin{OwnerEmail}\n"; }
        print MAIL "From: $admin{OwnerEmail}\n";
        print MAIL "Subject: Confirmation of details\n\n";
        print MAIL "$mail\n";
        close MAIL;
      }

      $cgicall =~ s/</&lt;/g;
      $cgicall =~ s/\n/<br>/g;

      my $checkentry = "<a href=\"${cgi}?page=$page\&url=$target\">Click here to verify "
                     . "your entry</a>.\n\nThank you again for using "
                     . "AutoList, a product by http://noisefactory.co.uk\n";


      print "<center><h1>AutoList: Site added to list</h1></center>\n";
      print "<p>${congrats}\n";
      print "<p><tt>${cgicall}</tt>\n";
      if ( $image ) {
        print "<p>The image mentioned in the link code can be downloaded by "
             . "right-clicking the image and selecting 'Save Image'. Copy it to the same directory you "
             . "intend calling the link from:<center><img src=$image></center>";
      }
      print "<p>Please write these details down. You will need them to edit ";
      print "your entry:<p>$userid<br>$userpw<br>$desc<p>";

      if ( $admin{SendMailPath} and $form{'email'} ) {
        print "\n<p>A copy of this information has been sent to \"$form{'email'}\"\n";
      }

      print "\n<p><h2>Check Your Entry</h2><p>\n";
      print "${checkentry}<p>\n";
      print "<b>Don't forget to Refresh the AutoList page, if necessary, or ";
      print "you may not see your entry!</b>\n";

    }

  }

  print "<p>\&nbsp;<br><center><a href=$admin{Server}$form{page}><font size=+1>Return to List</font></a></center>\n";
  print "<p><hr><font face=\"Arial,Helvetica\" size=-1>\n";
  print "Build your own AutoList: <a href=http://noisefactory.co.uk>http://noisefactory.co.uk/autolist</a>\n";
  print "</font></body></html>\n";

}




