#!/usr/bin/perl
#  ---------------------------------------------------------------------------
#  Mike's AutoList                                 AutoList (Versions Lite/21)
#  Copyright (c) 1999, 2000 Mike Stannett            http://noisefactory.co.uk
#  All Rights Reserved                                  web@noisefactory.co.uk
#  ---------------------------------------------------------------------------
#   This version is distributed free of charge by NoiseFactory subject to
#   conditions agreed by the user before the scripts were shipped (see
#   http://adultaudiovisual.com for details), and is used at the users risk.
#
#   By using a freely downloaded version of AutoList you agree that the
#   author and distributor are not liable for any problems or losses,
#   direct or indirect, arising through its use. Free versions of AutoList
#   are supplied as-is, and no warrantee or guarantee as to their
#   merchantability or suitability for purpose are intended or should be
#   inferred. You use these scripts at your own risk. Note that the right
#   to use these scripts does not include the right to redistribute them.
#   You may direct people to the NoiseFactory free download site, but you
#   should not distribute or redistribute any part of this product directly.
#
#   This program is the property of Mike Stannett. Distributing, re-distributing
#   or selling the code for this program in any form whatsoever without his prior
#   written consent is expressly forbidden.
#
#   You must obtain written permission before selling or redistributing this
#   software over the Internet or in any other medium. In all cases, Mike's
#   ownership of this program, his copyright, and this header, should all
#   remain intact.
#
#  ---------------------------------------------------------------------------




#
# Usage:
#
# require "alcore.pl";
#
#   al_core_loop(*line,*gaplists,*admin,*data);
#   find_url($target,*data);
#   parse_stdin(*form);
#   parse_params(*line);
#

package alcore;
sub main::parse_stdin {

  local ( *form, *admin ) = @_;
  my @pairs = ();

  #
  # Do NOT edit this ID after you have acquired clients, or they won't be able
  # to edit their entries. If you are entitled to support services, changing
  # this ID may also prevent us validating your entitlement.
  #

  $admin{OwnerId} = "autolist demo";

# -----------------------------------------------------------------------------
# CHANGE THESE VARIABLES TO MATCH YOUR SETUP


  $admin{OwnerEmail}    = 'you@yoursite.com';
  $admin{Server}        = 'http://yoursite.com';
  $admin{OwnerImage}    = 'http://yoursite/yourpath/yourlogo.gif';
  $admin{OwnerImageAlt} = 'Free toplist systems from NoiseFactory';
  $admin{DefaultList}   = '/yourpath/autolist/index.html';
  $admin{Script}        = '/yourcgibin/autolist/autolist.cgi';
  $admin{SendMailPath}  = '/usr/sbin/sendmail -t';




# DON'T CHANGE ANYTHING BELOW THIS LINE
# -----------------------------------------------------------------------------

  $admin{items}  = [ 'rank', 'link', 'url', 'desc', 'in', 'out', 'prevIn', 'prevOut' ];
  $in_list = 0;

  if ( $ENV{REQUEST_METHOD} =~ /GET/i ) {
    @pairs = split( /&/, $ENV{QUERY_STRING} );
  }
  elsif ( $ENV{REQUEST_METHOD} =~ /POST/i ) {
    read( STDIN, $buffer, $ENV{CONTENT_LENGTH} );
	  @pairs = split(/&/, $buffer);
  }

	foreach $pair (@pairs) {
	   my ($name, $value) = split(/=/, $pair);
	   if ( defined $value ) {
		   $value =~ tr/+/ /;
		   $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
		   $value =~ s/<([^>]|\n)*>//g;
		   $value =~ s/<//g;
		   $value =~ s/>//g;
		   $form{$name} = $value if $value =~ /[^\s\n]/;
	   }
  }

}

# -----------------------------------------------------------------------------

sub al_encode
{
  my ( $url ) = @_;
  $url =~ s/\#/%23/g;
  $url =~ s/\:/%3A/g;
  $url =~ s/ /%20/g;
  $url =~ s/\?/%3F/g;
  $url =~ s/=/%3D/g;
  $url =~ s/~/%7E/g;
  $url;
}

sub al_decode
{
  my ( $url ) = @_;
  $url =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  $url;
}

sub encrypt
{
   my ( $dat1, $dat2, $dat3 ) = @_;
   my $len1 = length($dat1);
   my $len2 = length($dat2);
   my $len3 = length($dat3);
   my $len  = $len2 > $len3 ? $len2 : $len3;
   my $enc = "";

   for ( $n = 0; $n < $len; $n++ ) {
   	my $c1 = unpack("C",substr( $dat1, $n % $len1, 1));
   	my $c2 = unpack("C",substr( $dat2, $n % $len2, 1));
   	my $c3 = unpack("C",substr( $dat3, $n % $len3, 1));
      $enc .= chr( ($c1 + $c2 + $c3)%26 + 97 );
   }

   $enc;
}

#	-----------------------------------------------------------------------

sub main::al_core_loop
{
  local ( *line, *form, *admin, *data ) = @_;

  if ( not $in_list ) {
    if ( $line =~ /<!-- al_begin/ ) {
      al_parse_begin(*line,*admin,*data);
      if ( (not defined $admin{editname}) or ($data{name} eq $admin{editname}) ) {
        $in_list = 1;
      }
      else { push(@main::outarray,$line); }
    }
    else  { push(@main::outarray,$line);  }
  }
  elsif ( $line =~ /<!-- al_end/  ) {
    $in_list = 0;
    ::main_process(*form,*data,*admin);
    al_write_list(*gaplists,*admin,*data);
  }
  elsif ( $line =~ /<!-- al_data/ ) {
    al_parse_data(*line,*data);
  }
  elsif ( $headering ) {
    al_parse_header(*line,*admin,*data);
    $headering = 0 if $line =~ m'</tr>'i;
  }
  elsif ( $line =~ /<!-- al_gap/ ) {
    $blocking = 0;
    my $params = parse_params(*line);
    $ngap = $params->{al_gap};
    $gaplists[$ngap] = [];
  }
  elsif ( not $blocking ) {
    if ( $line =~ /<!-- al_block/ ) {
      al_parse_block(*line,*admin);
      $blocking = 1;
      $headering = 1;
    }
    else { push( @{$gaplists[$ngap]}, $line); }
  }
  elsif ( $line =~ m#<td[^>]*>(.*)</td>#i ) {
    local $entry = $1;
    al_parse_entry(*entry,*data);
  }
}

#	-----------------------------------------------------------------------------

sub main::find_url
{
  local ( $target, *data ) = @_;
  for ( $n = 0; $n < $data{nent}; $n++ ) {
    return $n if $data[$n]->{url} eq $target;
  }
  -1;
}

#	-----------------------------------------------------------------------------

sub parse_params
{
  local ( *line ) = @_;
  my $params = {};
  my @params = split(' ',$line);
  foreach $p ( @params  ) {
    my ($name, $value) = split('=',$p);
    $params->{$name} = $value if defined $value;
  }
  $params;
}

#	-----------------------------------------------------------------------------

sub al_parse_begin
{
  local ( *line, *admin, *data ) = @_;
  my $params = parse_params(*line);
  $data{name} = delete $params->{al_begin};

  $admin{from}->[0] = delete $params->{from};
  $admin{to}->[0]   = delete $params->{to};
  $admin{scoreby}   = delete $params->{scoreby};
  $admin{blocker}   = delete $params->{blocker};
  $admin{delay}     = delete $params->{delay};
  $admin{reset}     = delete $params->{reset};

  foreach $item ( @{$admin{items}} ) {
    if ( exists $params->{$item} ) {
      my $tmp = delete $params->{$item};
      $tmp = al_decode($tmp);
      if ( $tmp =~ /"([^"]*)"/ ) { $tmp = $1; }
      my @settings = split(';',$tmp);
      $admin{head}->{$item}  = $settings[0];
      $admin{width}->{$item} = $settings[1];
    }
  }

  while ( ($key,$value) = each %$params )  {
    $data{whereis}->{$value} = $key;
    $data{whatsin}->[$key]   = $value;
    $admin{col}->{$value}    = $key;
  }
  foreach $item ( @{$admin{items}} ) {
    if ( not defined $data{whereis}->{$item} ) {
      $data{whereis}->{$item} = 0;
      $admin{col}->{$item}    = 0;
    }
  }
  $data{nent} = 0;
  $nblk = 0;
}

#	-----------------------------------------------------------------------------

sub al_parse_block
{
  ++$nblk;
  $need_linkcolor = 1;
  $need_textcolor = 1;
  local ( *line, *admin ) = @_;
  my $params = parse_params(*line);
  $admin{from}->[$nblk] = $params->{from};
  $admin{to}->[$nblk]   = $params->{to};
}

#	-----------------------------------------------------------------------------

sub al_parse_data
{
  local ( *line, *data ) = @_;
  ++$data{nent};
  my $params = parse_params(*line);

  $data[$data{nent}-1]->{key} = delete $params->{al_data};

  while ( ($name,$value) = each %$params ) {
    if ( $name ne 'rank' ) {
      $value = al_decode($value);
      $data[$data{nent}-1]->{$name} = $value;
    }
  }
  $col = 0;
}

#	-----------------------------------------------------------------------------

sub al_parse_entry
{
  local( *entry, *data ) = @_;
  my $item = $data{whatsin}->[++$col];

  if ( $need_linkcolor && $item eq 'link' ) {
    $need_linkcolor = 0;
    if ( $entry =~ / color=([#\w\d]+)/ ) {
      $admin{link}->[$nblk] = $1;
    }
  }
  elsif ( $need_textcolor && $item ne 'link' ) {
    $need_textcolor = 0;
    if ( $entry =~ / color=([#\w\d]+)/ ) {
      $admin{text}->[$nblk] = $1;
    }
  }

  if ( $item eq 'link' ) {
    if ( $entry =~ m%do_jump\('([^']+?)'\)>([^\n]*)</a>%i ) {
      $data[$data{nent}-1]->{url} = $1;
      my $desc = $2;
      $desc =~ s/<([^>]|\n)*>//g;
      $data[$data{nent}-1]->{desc} = $desc;
    }
  }
  elsif ( $item ne 'rank' ) {
    $entry =~ s/<([^>]|\n)*>//g;
    $data[$data{nent}-1]->{$item} = $entry;
  }
}

#	-----------------------------------------------------------------------------

sub al_parse_header
{
  local ( *line, *admin, *data ) = @_;
  my $tmp = $line;

  if ( $line =~ /<table/i ) {
    $tmp = $';
    if ( $nblk == 1 ) {
      my @vars = ('border','padding','spacing');
      foreach $v (@vars) {
        if ( $tmp =~ /$v=(\d+?)/i ) {
          $admin{$v} = $1;
          $tmp = $';
        }
      }
      if ( $tmp =~ /width=(\d+%?)/i ) { $admin{twidth} = $1; $tmp = $'; }
    }
    if ( $tmp =~ /bgcolor=([^ >]+?)( |>)/i ) {
      $admin{bgcolor}->[$nblk] = $1; $tmp = $';
    }
    if ( $tmp =~ /background="?([^"]+?)"?(>| nosave)/i ) {
      $admin{bgimage}->[$nblk] = $1;
    }
    $col = 0;
  }
  elsif ( $line =~  m'<td([^>]*)>(.*)</td>'i ) {
    my ( $params, $entry ) = ( $1, $2 );
    my $item = $data{whatsin}->[++$col];

    if ( $nblk == 1 ) {
      if ($params =~ /width=(\d+%?)/i) {$admin{width}->{$item} = $1; $params = $'; }
      if ($params =~ /align=(\w+)/i  ) {$admin{align}->{$item} = $1; }
    }

    if ( $entry =~ m'<font ([^>]+)>(.*)</font>'i ) {
    	( $params, $entry ) = ( $1, $2 );
      if ( $params =~ /face="([^"]+?)"/i || $params =~ /face=(.*?)(?: |$)/i ) {
      	$admin{face}->[$nblk] = $1; $params = $';
      }
      if ($params =~ /size=([^ ]+?)( |$)/i) {$admin{size}->[$nblk]=$1; $params=$';}
      if ($params =~ /color=([^ ]+?)( |>)/i) {$admin{text}->[$nblk]=$1; }
    }

    if ($entry =~ m'^<b>(.*)</b>$'i)   { $admin{bold}->[$nblk]  = 1; $entry = $1; }
    if ($entry =~ m'^<i>(.*)</i>$'i)   { $admin{ital}->[$nblk]  = 1; $entry = $1; }
    if ($entry =~ m'^<u>(.*)</u>$'i)   { $admin{uline}->[$nblk] = 1; $entry = $1; }
    if ($entry =~ m'^<tt>(.*)</tt>$'i) { $admin{tt}->[$nblk]    = 1; $entry = $1; }
    if ($entry =~ m'^<blink>(.*)</blink>$'i) { $admin{blink}->[$nblk] = 1; $entry = $1; }

    $admin{head}->{$item} = $entry if $nblk == 1;
  }

}

#	-----------------------------------------------------------------------------

sub lessthan {
  local ( $scoreby, $x, $y ) = @_;
  ($scoreby eq 'desc' || $scoreby eq 'url' ) ? ($x cmp $y)>0 : ($x < $y);
}

#	-----------------------------------------------------------------------------

sub al_verify_boundaries
{
  local ( *lower, *upper, *bottom, *top, *admin, *data ) = @_;
  my $blocker = ($admin{blocker} =~ /Rank/i ) ? 'rank' : 'value';
  local $scoreby = $admin{scoreby};

  foreach $n (0..5) {
	  $lower[$n] = defined $admin{from}->[$n] ? $admin{from}->[$n] : '*';
	  $upper[$n] = defined $admin{to}->[$n]   ? $admin{to}->[$n] : '*';
  }
  if ( $lower[0] ne '*' ) {
  	foreach $n (1..5) { $lower[$n] = $lower[0] if ( $lower[$n] eq '*' || lessthan($scoreby, $lower[$n],$lower[0]) ); }
  }
  if ( $upper[0] ne '*' ) {
  	foreach $n (1..5) { $upper[$n] = $upper[0] if ( $upper[$n] eq '*' || lessthan($scoreby, $upper[0],$upper[$n]) ); }
  }
  if ( $blocker eq 'rank') {
  	foreach $n (1..5) {
    	$bottom[$n] = $upper[$n] eq '*' ? ( $upper[0] eq '*' ? $data{nent} : $upper[0] ) : $upper[$n];
      $top[$n]    = $lower[$n] eq '*' ? ( $lower[0] eq '*' ?      1      : $lower[0] ) : $lower[$n];
    }
  }
  else {
    if ( $scoreby eq 'desc' || $scoreby eq 'url' ) {
    	foreach $n (1..5) {
        $bottom[$n] = $upper[$n] eq '*' ? ( $upper[0] eq '*' ? $data[$data{nent}-1]->{$scoreby} : $upper[0] ) : $upper[$n];
        $top[$n]    = $lower[$n] eq '*' ? ( $lower[0] eq '*' ? $data[       0     ]->{$scoreby} : $lower[0] ) : $lower[$n];
      }
    } else {
    	foreach $n (1..5) {
        $bottom[$n] = $lower[$n] eq '*' ? ( $lower[0] eq '*' ? $data[$data{nent}-1]->{$scoreby} : $lower[0] ) : $lower[$n];
        $top[$n]    = $upper[$n] eq '*' ? ( $upper[0] eq '*' ? $data[       0     ]->{$scoreby} : $upper[0] ) : $upper[$n];
      }
    }
  }
}

# -----------------------------------------------------------------------------

sub al_verify_columns
{
  local ( *admin ) = @_;
  my ( @validentry, %validcol, %conflicts );
  my @items = @{$admin{items}};

  # do entries specified by the user first

  foreach $item (@items) {
    if ( defined $admin{col}->{$item} ) {
      if ($validentry[$admin{col}->{$item}]) { push(@conflicts,$item); }
      else {
        $validcol{$item} = $admin{col}->{$item};
        $validentry[$admin{col}->{$item}] = $item;
      }
    }
  }

  # now do any others that were already there

  foreach $item (@items) {
    if ( not defined $admin{col}->{$item} ) {
      my $col = $admin{whereis}->{$item};
      if ( $col ) {
        if ( defined $validentry[$col] ) { push(@conflicts,$item); }
        else {
          $validcol{$item} = $col;
          $validentry[$col] = $item;
        }
      }
      else { $validcol{$item} = 0; }
    }
  }

  # use conflicting entries to fill any gaps

  my $prev = 0;
  foreach $item (@conflicts) {
    my $test = $prev + 1;
    if ( not defined $validentry[$test] ) {
      $validentry[$test] = $item;
      $validcol{$item} = $test;
      $prev = $test;
    }
    else { $test++; }
  }

  # Get the final layout by closing any remaining gaps

  my $col = 1;
  my ( @final, %final );
  foreach $n ( 1 .. $#validentry ) {
    if ( defined $validentry[$n] ) {
      $item = $validentry[$n];
      $final[$col]   = $item;
      $final{$item} = $col;
      $col++;
    }
  }

  # Copy back to *admin

  foreach $item (@items) {
    $col = $final{$item} ? $final{$item} : 0;
    $admin{whereis}->{$item} = $col;
    $admin{whatsin}->[$col] = $item if $col;
    $admin{col}->{$item} = $col;
  }

}

#	-----------------------------------------------------------------------------

sub al_write_list
{
  local ( *gaplists, *admin, *data ) = @_;
  local $scoreby = $admin{scoreby};
  local ( @lower, @upper, @bottom, @top );
  local $blocker = ($admin{blocker} =~ /Rank/i ) ? 'rank' : 'value';
  local $rank = 1;
  local %mydata = ();
  my ( $g ) = ( 0 );

  sub sorter {
    if ( $scoreby eq 'url' || $scoreby eq 'desc' ) {
      ($a->{$scoreby}) cmp ($b->{$scoreby});
    }
    else {
      ($b->{$scoreby}) <=> ($a->{$scoreby});
    }
  };
  @data = sort sorter @data;

  al_verify_boundaries(*lower,*upper,*bottom,*top,*admin,*data);
  al_verify_columns(*admin,*data);

  sub score {
    $blocker eq 'rank' ? $rank : $data[$rank-1]->{$scoreby};
  }

  $do_reset = 0;
  if ( $admin{reset} =~ /\d;\d/ ) {
    my @r = split(';',$admin{reset});
    my $t = time;
    if ( $r[0]>0 && ( ($t-$r[1]) > $r[0] ) ) {
      $r[1] = $t - ( ($t-$r[1]) % $r[0] );
      $admin{reset} = $r[0] . ';' . $r[1];
      $do_reset = 1;
    }
  }

  if ( $do_reset ) {
    for ( $e = 0; $e < $data{nent}; $e++ ) {
      $data[$e]->{in} = 0;
      $data[$e]->{out} = 0;
    }
  }

  $outline = "<!-- al_begin=$data{name} scoreby=$scoreby blocker=$blocker";
  foreach $item ( @{$admin{items}} ) {
    my $col = $admin{col}->{$item};
    $data{whereis}->{$item} = $col;
    if ( $col ) {
      $data{whatsin}->[$col] = $item; ++$data{ncols};
      $outline .= " $col=$item";
    }
    else {
      my $head = $admin{head}->{$item};
      my $width = $admin{width}->{$item};
      $head = al_encode($head);
      $outline .= " $item=$head;$width";
    }
  }

  $outline .= " from=$lower[0] to=$upper[0] delay=$admin{delay} reset=$admin{reset} -->\n";
  push(@main::outarray,$outline);  $outline = '';

  my $tpl = '';

  foreach $b (1..5) {
    while ( ( $blocker eq 'rank'
              ? lessthan( $scoreby, score(),  $top[$b] )
              : lessthan( $scoreby, $top[$b], score()  )   )
            and ($rank <= $data{nent})
          )
    {
    	al_write_data_only($rank++,*admin,*data);
    }

    $outline = "<!-- al_gap=$g -->\n", ;
    push(@main::outarray,$outline); $outline = '';
    push(@main::outarray,@{$gaplists[$g++]});

    $outline = "<!-- al_block from=$lower[$b] to=$upper[$b] -->\n";
    push(@main::outarray,$outline); $outline = '';

    my $close_table_tag = 0;

    if ( $data{ncols} && ( $blocker eq 'value' || $rank <= $data{nent} ) )
    {
      al_write_block_header($b,*mydata,*admin,*data) if $data{ncols};
      $tpl = defined $admin{tpl} ? $admin{tpl} : al_determine_current_tpl(*mydata,*admin,*data);
      $close_table_tag = 1;
    }

    if ( ($blocker eq 'rank') ? not lessthan($scoreby,$bottom[$b],$top[$b]) : not lessthan($scoreby,$top[$b],$bottom[$b]) )
    {
      while ( ( ($blocker eq 'rank') ? not lessthan($scoreby,$bottom[$b],score()) : not lessthan($scoreby,score(),$bottom[$b]) )
              and $rank <= $data{nent} )
      {
      	al_write_entry($rank++,$tpl,*admin,*data);
      }
    }

    if ( $close_table_tag ) {
    	$outline .= "</table>\n";
      $close_table_tag = 0;
      push(@main::outarray,$outline); $outline = '';
    }
  }
  while ( $rank <= $data{nent} )
  {
  	al_write_data_only($rank++,*admin,*data);
  }
  $outline .= "<!-- al_gap=5 -->\n";
  push(@main::outarray,$outline);
  push(@main::outarray,@{$gaplists[5]});
  $outline = "<!-- al_end -->\n";
  push(@main::outarray,$outline); $outline = '';
}

# -----------------------------------------------------------------------------

sub al_write_entry
{
  local ( $rank, $tpl, *admin, *data ) = @_;

  my $string = $tpl;
  my $entry = $rank - 1;

  foreach $item (@{$admin{'items'}}) {
    my $value = $item eq 'rank' ? $rank : $data[$entry]->{$item};
    my $encoded = $value; $encoded =~ al_encode($encoded);
    $string =~ s/--$item--/$value/g;
    $string =~ s/--enc_$item--/$encoded/g;
  }
  $string =~ s/--key--/$data[$entry]->{key}/g;
  push(@main::outarray,"$string");

}

#	-----------------------------------------------------------------------------

sub al_determine_current_tpl
{
  local ( *mydata, *admin, *data) = @_;

  $tpl = "  <!-- al_data=--key-- ";
  foreach $item (@{$admin{items}}) {
  	if ( $data{whereis}->{$item} == 0 ) {
      if ( $item eq 'url' || $item eq 'desc' ) {
        $tpl .= "$item=--enc_$item-- " if $data{whereis}->{link} == 0;
      }
      elsif ( $item ne 'rank' && $item ne 'link' ) {
        $tpl .= "$item=--enc_$item-- ";
      }
	  }
  }
  $tpl .= "-->\n";

  if ( $data{ncols} ) {
  	$tpl .= "  <tr>\n";
    foreach $col ( 1 .. $data{ncols} ) {
      $item = $data{whatsin}->[$col];
      my $value = ( $item eq 'link' )
             ? "<a href=javascript:do_jump('--url--')>$mydata{fontlink}--desc--$mydata{unfontlink}</a>"
             : $item ? "$mydata{font}--$item--$mydata{unfont}" : '';
      $tpl .= "    <td";
      $tpl .= " align=$admin{align}->{$item}" if defined $admin{align}->{$item};
      $tpl .= ">$value</td>\n";
    }
    $tpl .= "  </tr>\n";
  }

  $tpl;
}

#	-----------------------------------------------------------------------------

sub al_write_block_header
{
	local ( $n, *mydata, *admin, *data ) = @_;

	foreach $v ('face', 'size', 'text', 'link', 'bgcolor', 'bold', 'ital', 'uline', 'tt', 'blink') {
	  if ( defined $admin{$v}->[$n] ) { $mydata{$v} = $admin{$v}->[$n]; }
    elsif ( defined $admin{$v}->[0]  ) { $mydata{$v} = $admin{$v}->[0];     }
  }

  if ( defined $admin{bgimage}->[$n] ) {
    $mydata{bgimage} = $admin{bgimage}->[$n];
  }
  elsif ( defined $admin{bgimage}->[0] ) {
    $mydata{bgimage} = $admin{bgimage}->[0];
  }

  foreach $v ( 'bgimage', 'face' ) {
	  if ( defined $mydata{$v} ) {
	  	my $tmp = $mydata{$v};
	    if ( $tmp =~ /"([^"]+)"/ ) { $tmp = $1;               }
	    if ( $tmp =~ /[\s,]/     ) { $tmp = '"' . $tmp . '"'; }
	    $mydata{$v} = $tmp;
	  }
  }

  my $outline = '';
  $outline .= "<p><table";
  $outline .= " border=$admin{border}"       if defined $admin{border};
  $outline .= " cellpadding=$admin{padding}" if defined $admin{padding};
  $outline .= " cellspacing=$admin{spacing}" if defined $admin{spacing};
  $outline .= " width=$admin{twidth}"        if defined $admin{twidth};
  $outline .= " bgcolor=$mydata{bgcolor}"    if defined $mydata{bgcolor};
  $outline .= " background=$mydata{bgimage}" if defined $mydata{bgimage};
  $outline .= ">\n";
  push(@main::outarray,$outline); $outline = '';

  $mydata{font} = ''; $mydata{fontlink} = '';
  if ( defined $mydata{face} || defined $mydata{size} ) {
    $mydata{font} .= "<font";
    $mydata{font} .= " face=$mydata{face}"     if defined $mydata{face};
    $mydata{font} .= " size=$mydata{size}"     if defined $mydata{size};
  }
  if ( $mydata{font} ne '' ) {
    $mydata{fontlink}  = $mydata{font};
    $mydata{font}     .= " color=$mydata{text}" if defined $mydata{text};
    $mydata{fontlink} .= " color=$mydata{link}" if defined $mydata{link};
    $mydata{font}     .= ">";
    $mydata{fontlink} .= ">";
  }
  else {
    $mydata{font}     = "<font color=$mydata{text}>" if defined $mydata{text};
    $mydata{fontlink} = "<font color=$mydata{link}>" if defined $mydata{link};
  }
  $mydata{unfont}     = $mydata{font}     ? "</font>" : '';
  $mydata{unfontlink} = $mydata{fontlink} ? "</font>" : '';

  my $tag=''; my $untag='';
  if ( $mydata{bold}  ) { $tag .= "<b>";     $untag = "</b>".$untag;     }
  if ( $mydata{ital}  ) { $tag .= "<i>";     $untag = "</i>".$untag;     }
  if ( $mydata{uline} ) { $tag .= "<u>";     $untag = "</u>".$untag;     }
  if ( $mydata{tt}    ) { $tag .= "<tt>";    $untag = "</tt>".$untag;    }
  if ( $mydata{blink} ) { $tag .= "<blink>"; $untag = "</blink>".$untag; }

  $mydata{font}       .= $tag;
  $mydata{fontlink}   .= $tag;
  $mydata{unfont}      = $untag . $mydata{unfont};
  $mydata{unfontlink}  = $tag . $mydata{unfontlink};

  $outline .= "  <tr>\n";
  foreach $col ( 1 .. $data{ncols} ) {
    my $item = $data{whatsin}->[$col];
    $outline .= "    <td";
    $outline .= " width=$admin{width}->{$item}" if defined $admin{width}->{$item};
    $outline .= " align=$admin{align}->{$item}" if defined $admin{align}->{$item};
    $outline .=	">$mydata{font}$admin{head}->{$item}$mydata{unfont}</td>\n";
  }
  $outline .= "  </tr>\n";
  push(@main::outarray,$outline); $outline = '';
}

#	-----------------------------------------------------------------------------

sub al_write_data_only
{
	local ( $rank, *admin, *data ) = @_;
   my $entry = $rank - 1;

   my $outline = '';
	$outline .= "  <!-- al_data=$data[$entry]->{key} ";
	foreach $item ( @{$admin{items}} ) {
    if ( $item ne 'rank' && $item ne 'link') {
    	my $value = $data[$entry]->{$item};
    	$value = al_encode($value);
    	$outline .= "$item=$value ";
  	}
  }
  $outline .= "-->\n";
  push(@main::outarray,$outline);
}

#	-----------------------------------------------------------------------------

1;


