#!/usr/bin/perl
#  ---------------------------------------------------------------------------
#  Mike's AutoList                                                  AutoList21
#  Copyright (c) 1999, 2000 Mike Stannett            http://noisefactory.co.uk
#  All Rights Reserved                                  web@noisefactory.co.uk
#  ---------------------------------------------------------------------------
#   This version is distributed free of charge by NoiseFactory subject to
#   conditions agreed by the user before the scripts were shipped (see
#   http://adultaudiovisual.com for details).
#
#   By using a freely downloaded version of AutoList you agree that the
#   author and distributor are not liable for any problems or losses,
#   direct or indirect, arising through its use. Free versions of AutoList
#   are supplied as-is, and no warrantee or guarantee as to their
#   merchantability or suitability for purpose are intended or should be
#   inferred. You use these scripts at your own risk. Note that the right
#   to use these scripts does not include the right to redistribute them.
#   You may direct people to the NoiseFactory free download site, but you
#   should not distribute or redistribute any part of this product directly.
#
#   This program is the property of Mike Stannett. Distributing, re-distributing
#   or selling the code for this program in any form whatsoever without his prior
#   written consent is expressly forbidden.
#
#   You must obtain written permission before selling or redistributing this
#   software over the Internet or in any other medium. In all cases, Mike's
#   ownership of this program, his copyright, and this header, should all
#   remain intact.
#
#  ---------------------------------------------------------------------------


# SAFETY MESSAGE: DON'T EDIT ANYTHING BELOW THIS LINE
# ---------------------------------------------------
  sub main_process;
  require "alcore.pl";
  parse_stdin(*form,*admin);

  $admin{editname} = $form{editname} if defined $form{editname};

  $source = defined $form{defsource} ? $admin{DefaultList}
          : defined $form{source} ? $form{source}
          : 0;

  $target = defined $form{deftarget} ? $admin{DefaultList}
          : defined $form{target} ? $form{target}
          : 0;

  if ( $source ) {

    open(SOURCE,"$ENV{DOCUMENT_ROOT}$source");
    @lines = <SOURCE>;
    close SOURCE;

    foreach $line (@lines) {
      al_core_loop(*line,*form,*admin,*data);
    }

    if ( $target ) {
      open(TARGET,">$ENV{DOCUMENT_ROOT}$target");
      flock(TARGET,2) unless $PLATFORM_IS_WINDOWS;
      print TARGET @outarray;
      flock(TARGET,8) unless $PLATFORM_IS_WINDOWS;
      close TARGET;
    	print "Location: $admin{Server}$target\n\n";
    }
    else {
    	print "Content-type: text/html\n\n";
      print @outarray;
    }
  }
  else {
    print "Location: $admin{Server}$admin{DefaultList}\n\n";
  }

#	-----------------------------------------------------------------------------

sub main_process
{
  local ( *form, *data, *admin ) = @_;

  my @v = ('tpl', 'editname','source','target','scoreby','blocker','padding','spacing','twidth','border');
  foreach $v (@v) {
  	$admin{$v} = $form{$v} if defined $form{$v};
  }

  my $scoreby = $admin{scoreby};
  $admin{scoreby} = $scoreby =~ /Url/i ? 'url'
                  : $scoreby =~ /Description/i ? 'desc'
                  : $scoreby =~ /Most recent inward/i ? 'prevIn'
                  : $scoreby =~ /Most recent outward/i ? 'prevOut'
                  : $scoreby =~ /Referrals outward/i ? 'out' : 'in';


  my $ddays  = $form{delayDays}  if defined $form{delayDays};
  my $dhours = $form{delayHours} if defined $form{delayHours};
  my $dmins  = $form{delayMins}  if defined $form{delayMins};
  my $dsecs  = $form{delaySecs}  if defined $form{delaySecs};

  if ( defined $ddays || defined $dhours || defined $dmins || defined $dsecs ) {
    $admin{delay} = ((($ddays * 24) + $dhours)*60 + $dmins)*60 + $dsecs;
  }

  my $rdays  = $form{resetDays}  if defined $form{resetDays};
  my $rhours = $form{resetHours} if defined $form{resetHours};
  my $rmins  = $form{resetMins}  if defined $form{resetMins};
  my $rsecs  = $form{resetSecs}  if defined $form{resetSecs};

  if ( defined $rdays || defined $rhours || defined $rmins || defined $rsecs ) {
    @r = split(/;/,$admin{reset});
    $r[0] = ((($rdays * 24) + $rhours)*60 + $rmins)*60 + $rsecs;
    $r[1] = time if not $r[1];
    $admin{reset} = $r[0] . ';' . $r[1];
  }

  @v = ('col','head','width','align');
  foreach $item ( @{$admin{items}} ) {
  	foreach $v (@v) {
  		my $tmp = $item . '_' . $v;
  		$admin{$v}->{$item} = $form{$tmp} if defined $form{$tmp};
    }
  }

  @v = ('from','to','face','size','text', 'link', 'bgcolor',
        'bold','ital','uline','tt','blink','bgimage','nosave'
  );
  foreach $v (@v) {
    my $tmp = $v . '_0';
    $admin{$v}->[0] = $form{$tmp} if defined $form{$tmp};
  }
	foreach $n (1..5) {
    foreach $v (@v) {
      my $tmp0 = $v . '_0';
    	my $tmpn = $v . '_' . $n;
      if ( defined $form{$tmpn} ) {
		    $admin{$v}->[$n] = $form{$tmpn};
      }
      elsif ( defined $form{$tmp0} ) {
        $admin{$v}->[$n] = $form{$tmp0};
      }
    }
	}

}
