#!/usr/bin/perl
require "statlp_en.pl";
# 
#####################################################################################
$flock=1;
$salt="a1Mj";
# These variables need to be set

# Set this to the HTML directory where the New Statpages will reside. This is a PATH not a URL
# Do not include a trailing slash
$basedir="/iiw/htdocs/www.mannyjuan.com/ezstat";
# $basedir = "../webpages/ezstat";

# This is your URL of where the cgi programs are kept
# Do not include a trailing slash
$cgiurl = "/cgi-bin";
# $cgiurl = "/cgi-bin";

# This is your URL of where the new HTML pages will be kept.
# Do not include a trailing slash
$baseurl = "http://www.mannyjuan.com/ezstat";
# $baseurl = "http://10.26.36.193/ezstat";

# This is the index of all pages created by HPM
# This file should be chmod to 777 and placed in the ezstat directory
$indexpage = "$basedir/index.html";

# This is the location of the data.txt file. This holds each user's
# login name and e-mail address for confirmation
$data = "$basedir/data.txt";

$cfgname="mystat.cfg";
#Site title

$title="$txt{'1'}";

# self explanatory variables for your site logo
$logo = "$baseurl/mjmall.jpg";
$logoalt = "$txt{'1'}";

# Location of the sendmail program
$sendmail = '/usr/sbin/sendmail';

# Your e-mail address here
$myemail = 'manny@jps.net';

# That's it.

# DO NOT CHANGE ANYTHING BELOW THIS LINE
######################################################################################
$SIG{__DIE__} = \&Error_Msg;

sub Error_Msg {
    $msg = "@_";
    print "\nContent-type: text/html\n\n";
    print "The following error occurred : $msg\n";
    exit;
}

# Get the input
read(STDIN, $input, $ENV{'CONTENT_LENGTH'});

    # split the input
    @pairs = split(/&/, $input);

    # split the name/value pairs
    foreach $pair (@pairs) {

    ($name, $value) = split(/=/, $pair);

    $name =~ tr/+/ /;
    $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $value =~ s/<([^>]|\n)*>//g;

  $FORM{$name} = $value;
    }

# Lets do some translating first
$usrname = $FORM{'usrname'};
$email = $FORM{'email'};
$login = $FORM{'login'};
$updact = $FORM{'updact'};
$shorttitle = $FORM{'shorttitle'};
$hits_by_weekday=$FORM{'hits_by_weekday'};
$top_countries=$FORM{'top_countries'};
$top_browsers=$FORM{'top_browsers'};
$top_os=$FORM{'top_os'};
$top_host=$FORM{'top_host'};
$show_ccodes=$FORM{'show_ccodes'};
$show_max=$FORM{'show_max'};
$ip_time=$FORM{'ip_time'};
$offset=$FORM{'offset'};
$password=$FORM{'password'};
$pwdagain=$FORM{'pwdagain'};
$ipsklist=$FORM{'ipsklist'};
$ipsklist =~ s/\cM//g;
$ipsklist =~ s/\n/%%/g;

$pagename = $login;

# eliminate some special characters
$pagename=~s/\W//g;
# If the user tries to add more than one word in
# the page name field, this will put an underscore
# in the spaces to make it one word
$pagename =~ s/ /_/g;

# Find out what the user wants to do
if ($FORM{'action'} eq "New Statpage") {
    &newpage;
    }
if ($FORM{'action'} eq "Create Statpage") {
    &create;
    }
if ($FORM{'action'} eq "Edit Statpage") {
    &confirm("edit");
    }
if ($FORM{'action'} eq "checkuser") {
    &checkuser;
    }
if ($FORM{'action'} eq "recreate") {
    &recreate;
    }
if ($FORM{'action'} eq "Delete Statpage") {
    &confirm("delete");
    }
exit;

sub newpage {
    local($usrname, $email,$pagename);

($usrname, $email, $pagename) = split(/&&/, "");

    $shorttitle="";
    $show_ccodes="yes";
    $show_max="20";
    $resetctr=1;
    $hits_by_weekday="yes";
    $top_countries="yes";
    $top_browsers="yes";
    $top_os="yes";
    $top_host="yes";
    $offset="0";
    $ip_time="15";

# To avoid any security risks. Take out the HTML tags added when HPM translated
# the && to: <br><br>. They will be re-translated to: && Once the user updateGes
# the page, the: && will be put back to: <br><br>
$body =~ s/<br><br>/&&/g;

# print the edit-page form

print "Content-type: text/html\n\n";
print "<html>\n";
print "<head>\n";
print "<title>Create Your Own Shockwave Statpage</title>\n";
print "$txt{'54'}\n";
print "</head>\n";
print "\n";
print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\">\n";
print "\n";
print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center>\n";
print "<br>\n";
print "<b>$txt{'2'}</b>\n";
print "<br><br>$txt{'3'}\n";
print "<br><br>$txt{'4'}\n";
print "<br><br>$txt{'5'}\n";
print "<br><br>$txt{'6'}\n";
print "<br><br>$txt{'7'}\n";
print "\n";
print "<br><br>\n";
print "<form action=\"$cgiurl/ezstatpg.pl\" method=POST>\n";
print "<input type=hidden name=\"action\" value=\"Create Statpage\">\n";
print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n";
print "<tr>\n";
print "<td>$txt{'8'}</td>\n";
print "<td><input type=text size=20 name=\"usrname\" value=\"$usrname\"></td>\n";
print "</tr>\n";
print "<tr>\n";
print "<td>$txt{'9'}</td>\n";
print "<td><input type=text size=20 name=\"login\" value=\"$login\"></td>\n";
print "</tr>\n";
print "<tr>\n";
print "<td>$txt{'10'}</td>\n";
print "<td><input type=text size=20 name=\"email\" value=\"$email\"></td>\n";
print "</tr>\n";
print "<tr>\n";
print "<td>$txt{'11'}</td>\n";
print "<td><input type=password size=20 name=\"password\" value=\"$password\"></td>\n";
print "</tr>\n";
print "<tr>\n";
print "<td>$txt{'11a'}</td>\n";
print "<td><input type=password size=20 name=\"pwdagain\" value=\"$pwdagain\"></td>\n";
print "</tr>\n";
print "<tr>\n";
print "<td colspan=2>\n";
&build_form_body;
print "</td>\n";
print "</tr>\n";
print "<tr>\n";
print "<td><br><input type=submit value=\"Create Statpage\"></td>\n";
# print "<td><br><h3>Sorry, Create Statpage is not allowed at this time!</h3>please download the ";
# print "<a href=\"http://www.mannyjuan.com/ezstatpg.zip\">zipfile</a> and install at your site.  thanks.</td>\n";
print "<td>&nbsp;</td>\n";
print "</tr>\n";
print "</table>\n";
print "</form>\n";
print "</body>\n";
print "</html>\n";
    }

sub create {

&missing(missing_usrname) unless $usrname;
&missing(missing_login) unless $login;
&missing(missing_email) unless $email;
&missing(missing_pagename) unless $pagename;
&missing(missing_shorttitle) unless $shorttitle;

# if they try to name their page "index" This will stop them
if ($pagename eq "index") {
    print "Content-type: text/html\n\n";
    print "<html>\n";
    print "<head>\n";
    print "<title>$txt{'12'}</title>\n";
    print "$txt{'54'}\n";
    print "</head>\n";
    print "\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\">\n";
    print "\n";
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center>\n";
    print "<br><br>$txt{'13'}\n";
    print "<br>$txt{'14'}\n";
    print "\n";
    exit;
        }

# if the user tries to name their page 
# something that is already taken
# this should stop them - it's a check for directory-present
if (-d "$basedir/$pagename") {
    print "content-type: text/html\n\n";
    print "<html><head><title>Error</title></head>\n";
    print "<body>";
    &put_banner;
    print "<p>The Access Stats page name: <b>$pagename</b>\n";
    print "is already taken.\n";
    print "Please go back and rename your page</p>\n";
    print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
    exit;
    }

# create the new directory for pagename
umask(000);  # UNIX file permission junk
mkdir("$basedir/$pagename", 0777) unless (-d "$basedir/$pagename");     

#now, lets create our new html page
  &buildpage;

# Write the login name and email address to a separate file for confirmation
# when they want to edit their page
open (FILE, ">>$data") || die "I can't open $data\n";
if ($flock==1) { flock (FILE, 2) or die "can't lock data file\n"; }
$cryptpwd=crypt($password,$salt);
print FILE "$login&&$email&&$cryptpwd\n";
close(FILE);


# Suck the index page, and write the new entry to it
open(FILE, "$indexpage") || die "I can't open that file\n";
if ($flock==1) { flock (FILE, 1) or die "can't lock index file\n"; }
    @lines = <FILE>;
    close(FILE);
    $sizelines = @lines;

# Now, re-open the links file, and add the new link
open(FILE, ">$indexpage") || die "I can't open that file\n";
if ($flock==1) { flock (FILE, 2) or die "can't lock index file\n"; }
    
        for ($a = 0; $a <= $sizelines; $a++) {
    
        $_ = $lines[$a];

    if (/<!--begin-->/) {
    
    print FILE "<!--begin-->\n";
    print FILE "<p><font face=\"Arial, Geneva\" size=4><a href=\"$baseurl/$pagename/index.html\">$shorttitle</a>\n";

        } else {
            print FILE $_;
        }
    }
close(FILE);


# Give the user a response
print "Content-type: text/html\n\n";
print "<html>\n";
print "<head>\n";
print "<title>$txt{'17'}</title>\n";
print "$txt{'54'}\n";
print "</head>\n";
print "\n";
print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\">\n";
print "\n";
print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center>\n";
print "<br><br>$txt{'18'}\n";
print "<br><br>$txt{'19'} <a href=\"$baseurl/$pagename/index.html\">$baseurl/$pagename/index.html</a>\n";
print "<br>$txt{'20'}\n";
print "<br><br>$txt{'14'}\n";
print "\n";
print "</body>\n";
print "</html>\n";
    

# Send the user an e-mail confirming their page
open (MAIL, "| $sendmail -t") || die "I can't open sendmail\n";
  print MAIL "To: $usrname <$email>\n";
  print MAIL "From: $myemail\n";
  print MAIL "Subject: $title - $txt{'21'}\n";
  print MAIL "$txt{'22'}\n";
  print MAIL "\n";
  print MAIL "$baseurl/$pagename/index.html\n";
  print MAIL "\n$txt{'23'}\n\n$login\n$email\n$password\n";
  print MAIL "\n$txt{'24'} $txt{'1'}\n";
  print MAIL "\n\n$txt{'25'} - $myemail\n";
  close (MAIL);

# Notify us when someone creates a page
open (MAIL, "| $sendmail -t") || die "I can't open sendmail\n";
  print MAIL "To: $myemail\n";
  print MAIL "From: $usrname <$email>\n";
  print MAIL "Subject: $txt{'26'}\n";
  print MAIL "$usrname $txt{'27'}\n";
  print MAIL "$baseurl/$pagename/index.html\n";
close(MAIL);

        }

sub recreate {
    # Suck the index page, and update site name (in case it changed)
    open(FILE, "$indexpage") || die "I can't open that file $indexpage\n";
    if($flock){flock (FILE, 1) or die "can't lock index file\n";}
        @lines = <FILE>;
        close(FILE);
        $sizelines = @lines;

    # Now, re-open the links file, and replace the index entry
    open(FILE, ">$indexpage") || die "I can't open that file >$indexpage\n";
    if($flock){flock (FILE, 2) or die "can't lock index file to delete entry\n";}

            for ($a = 0; $a <= $sizelines; $a++) {

            $_ = $lines[$a];

        if (/\/ezstat\/$pagename\/index.html/) {
            print FILE "<p><font face=\"Arial, Geneva\" size=4><a href=\"$baseurl/$pagename/index.html\">$shorttitle</a></font></p>\n";
          } 
        else {
          print FILE $_;
           }
        }
    close(FILE);

#now, lets create our new html page
   &buildpage;

# Send the user a notice that their page has been re-done
  open (MAIL, "| $sendmail -t") || die "I can't open sendmail\n";
  print MAIL "To: $usrname <$email>\n";
  print MAIL "From: $myemail\n";
  print MAIL "Subject: $txt{'28'} $txt{'1'}\n";
  print MAIL "$txt{'29'}\n";
  print MAIL "\n";
  print MAIL "$baseurl/$pagename/index.html\n";
  print MAIL "\n$txt{'24'} $txt{'1'}}\n";
  print MAIL "\n\n$txt{'25'} - $myemail\n";
  close (MAIL);

# Give the user a response
print "Content-type: text/html\n\n";
print "<html>\n";
print "<head>\n";
print "<title>$txt{'30'}</title>\n";
print "$txt{'54'}\n";
print "</head>\n";
print "\n";
print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\">\n";
print "\n";
print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center>\n";
print "<br><br>$txt{'31'}\n";
print "<br><br><a href=\"$baseurl/$pagename/index.html\">$baseurl/$pagename/index.html</a>\n";
print "<br>$txt{'32'}\n";
print "<br><br>$txt{'14'}\n";
print "\n";
print "</body>\n";
print "</html>\n";
        }

sub buildpage {
open(HTML, ">$basedir/$pagename/index.html") || die "I can't create $basedir/$pagename/index.html\n";
if ($flock==1) { flock (HTML, 2) or die "can't lock html file\n"; }
print HTML <<EOHTML;
<html>
<head>
<title>$txt{'1'}</title
$txt{'55'}
</head>

<body bgcolor=\"#ffffff\" TEXT=\"#000000\">

<h3>$txt{'33'} - $pagename</h3>
<ul><li>$txt{'34'} <a href=$cgiurl/ezstatvu.pl?pagename=$pagename>$txt{'35'}</a>
<li>$txt{'36'}
<pre>
&lt;a href=\"$cgiurl/ezstatvu.pl?pagename=$pagename\"&gt;
&lt;script language="JavaScript"&gt;
&lt;!--
document.write("&lt;img src=$cgiurl/ezstatlg.pl?pagename=$pagename&ref="+top.document.referrer
+" width=16 height=16 border=0&gt;");
// --&gt;
&lt;/script&gt;
&lt;/a&gt;
&lt;noscript&gt;
&lt;img src="$cgiurl/ezstatlg.pl?pagename=$pagename&ref=noscript" width=16 height=16 border=0&gt;
&lt;/noscript&gt;
</pre>
<li>$txt{'37'}<a href=$cgiurl/ezstatlg.pl?pagename=$pagename>$txt{'35'}</a>.
</ul>
<p><a href="$baseurl">$txt{'38'}</a>
</body></html>
EOHTML

$ipsklist =~ s/\n/%%/g;

# create user data file.
open(MYCFG, ">$basedir/$pagename/$cfgname") || die "I can't create $basedir/$pagename/$cfgname\n";
if ($flock==1) { flock (MYCFG, 2) or die "can't lock $basedir/$pagename/$cfgname\n"; }
print MYCFG 
"$usrname&&$shorttitle&&$hits_by_weekday&&$top_countries&&$top_browsers&&$top_os&&$top_host&&$show_ccodes&&$show_max&&$ip_time&&$offset&&$ipsklist&&1";
close(MYCFG);
}

# Standard error message for any missing required fields
sub missing {
local ($missing) = @_;
print "Content-type: text/html\n\n";

    print "<html>\n";
    print "<head>\n";
    print "<title>$txt{'39'}</title>\n";
    print "$txt{'54'}\n";
    print "</head>\n";
    print "\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\">\n";
    print "\n";
    print "<br><br>$txt{'40'}\n";
    print "<br><ul> $missing.</ul>\n";
    print "<br><br>$txt{'14'}.\n";
    print "\n";
    print "</body>\n";
    print "</html>\n";
    exit;
}

sub confirm {
    local ($updact) = @_;

print "Content-type: text/html\n\n";
print "<html>\n";
print "<head>\n";
print "<title>$updact - $txt{'41'}.</title>\n";
print "$txt{'54'}\n";
print "</head>\n";
print "\n";
print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\">\n";
print "\n";
print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center>\n";
print "<br><br>$txt{'42'}\n";
print "\n";
print "<br><br>\n";
print "<form action=\"$cgiurl/ezstatpg.pl\" method=POST>\n";
print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n";
print "<tr>\n";
print "<td>$txt{'9'}</td>\n";
print "<td><input size=20 type=text name=\"login\"></td>\n";
print "</tr>\n";
print "<tr>\n";
print "<td>$txt{'10'}</td>\n";
print "<td><input size=20 type=text name=\"email\"></td>\n";
print "</tr>\n";
print "<tr>\n";
print "<td>$txt{'11'}</td>\n";
print "<td><input type=password size=20 name=\"password\"></td>\n";
print "</tr>\n";
print "<tr>\n";
print "<td>&nbsp;</td>\n";
print "<td><input type=submit value=submit></td>\n";
print "</tr>\n";
print "\n";
print "<input type=hidden name=\"action\" value=\"checkuser\">\n";
print "<input type=hidden name=\"updact\" value=\"$updact\">\n";
print "</table>\n";
print "\n";
print "</form>\n";
print "</body>\n";
print "</html>\n";
    }

sub checkuser {
open(FILE, "$data") || die "I can't open $data\n";  
if ($flock==1) { flock (FILE, 1) or die "can't lock data file\n"; }

    while(<FILE>) {
    chop;       
    @all = split(/\n/);

    foreach $line (@all) {
    ($loginname, $loginemail, $logincryptpwd) = split(/&&/, $line);
    if($loginname eq "$login" && $loginemail eq "$email" && $logincryptpwd eq crypt($password,$salt)) {
        $match = 1;
        if($updact eq "edit") {
          &edit($loginname);
          }
        else {
          &delpage($loginname);
          }
        }
      }
    }

close(FILE);

if (! $match) {
    &error;
    }

# del entry from data
if($updact eq "delete") {

    # Suck the index page, and write the new entry to it
    open(FILE, "$data") || die "I can't open that file\n";
    if ($flock==1) { flock (FILE, 1) or die "can't lock data file\n"; }
        @lines = <FILE>;
        close(FILE);
        $sizelines = @lines;

    # Now, re-open the links file, and comment out the page to delete
    open(FILE, ">$data") || die "I can't open that file\n";
    if ($flock==1) { flock (FILE, 2) or die "can't lock index file for append\n"; }
    chop;
            for ($a = 0; $a <= $sizelines; $a++) {
            $_ = $lines[$a];
            $w = $_;
            $w =~ s/\cM//g;
            $w =~ s/\n//g;
    ($loginname, $loginemail, $logincryptpwd) = split(/&&/, $w);
    if($loginname eq "$login" && $loginemail eq "$email" && $logincryptpwd eq crypt($password,$salt)) {
          # do nothing  (ie. don't write)
          } 
        else {
          if($w eq "") {
            # do nothing (skip)
            }
          else {
            print FILE "$w\n";
            }
          }
        }
    close(FILE);
    print "Content-type: text/html\n\n";
    print "<html>\n";
    print "<head>\n";
    print "<title>$updact - $txt{'41'}.</title>\n";
    print "$txt{'54'}\n";
    print "</head>\n";
    print "\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\">\n";
    print "\n";
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center>\n";
    print "<br><br>$txt{'43'}\n";
    print "$txt{'14'}.\n";
    print "\n";
    print "</form>\n";
    print "</body>\n";
    print "</html>\n";
  }
}

sub edit {

    # get the config file
    open(CFGFILE, "$basedir/$pagename/$cfgname") || die "I can't open $basedir/$pagename/$cfgname\n";
    if($flock==1){flock (CFGFILE, 1) or die "can't lock $basedir/$pagename/$cfgname for edit\n";}
    $txrec=<CFGFILE>;
($usrname,$shorttitle,$hits_by_weekday,$top_countries,$top_browsers,$top_os,$top_host,$show_ccodes,$show_max,$ip_time,$offset,$ipsklist,$dum)=split('&&',$txrec);

    close(CFGFILE);

    $ipsklist =~ s/%%/\n/g;

    &build_edit_form();
    }

sub delpage {
    local ($pagename) = @_;
    &deltree(0,"$basedir/$pagename");

    # Suck the index page, and write the new entry to it
    open(FILE, "$indexpage") || die "I can't open that file\n";
    if ($flock==1) { flock (FILE, 1) or die "can't lock index file\n"; }
        @lines = <FILE>;
        close(FILE);
        $sizelines = @lines;

    # Now, re-open the links file, and comment out the page to delete
    open(FILE, ">$indexpage") || die "I can't open that file\n";
    if ($flock==1) { flock (FILE, 2) or die "can't lock index file to delete entry\n"; }

            for ($a = 0; $a <= $sizelines; $a++) {

            $_ = $lines[$a];

        if (/$pagename\/index.html/) {
          # do nothing  (ie. don't write)
          } 
        else {
          print FILE $_;
           }
        }
    close(FILE);

    }

sub deltree {
    local ($lvl, $dir) = @_;
    local @tnlist;
    opendir (TN, "$dir");
    rewinddir (TN);
    @tnlist =  grep(!/^\.\.?$/, readdir (TN));
    closedir (TN);
    foreach $tn (@tnlist) {
        if (-d "$dir/$tn") {
            $lvl++;
            &deltree($lvl,"$dir/$tn" );
            $lvl--;
            }
        else {
            $cnt=unlink("$dir/$tn");
#            print "<br>deleting $dir/$tn";
            }
        }
    rmdir ("$dir");
#    print "<br>removing $dir";
    }

sub build_edit_form {
    
# To avoid any security risks. Take out the HTML tags added when HPM translated
# the && to: <br><br>. They will be re-translated to: && Once the user updates
# the page, the: && will be put back to: <br><br>
$body =~ s/<br><br>/&&/g;

# print the edit-page form

print "Content-type: text/html\n\n";
print "<html>\n";
print "<head>\n";
print "<title>$txt{'44'}</title>\n";
print "$txt{'54'}\n";
print "</head>\n";
print "\n";
print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\">\n";
print "\n";
print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center>\n";
print "\n";
print "<br><br>$txt{'45'}\n";
print "<br><br>\n";
print "\n";
print "<form action=\"$cgiurl/ezstatpg.pl\" method=POST>\n";
print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n";
print "<input type=hidden name=\"action\" value=\"recreate\">\n";
print "<input type=hidden name=\"login\" value=\"$login\">\n";
print "<tr>\n";
print "<td>$txt{'8'}</td>\n";
print "<td><input type=input name=\"usrname\" value=\"$usrname\"></td>\n";
print "</tr>\n";
print "<tr>\n";
print "<td>$txt{'10'}</td>\n";
print "<td><input type=hidden name=\"email\" value=\"$email\">$email</td>\n";
print "</tr>\n";
print "<tr>\n";
print "<td colspan=2>\n";

&build_form_body;

print "</td>\n";
print "</tr>\n";
print "<tr>\n";
print "<td><input type=submit value=\"update page\"></td>\n";
print "<td>&nbsp;</td>\n";
print "</tr>\n";
print "</table>\n";
print "\n";
print "</form>\n";
print "</body>\n";
print "</html>\n";
    }

sub build_form_body {
    print "<br><br>$txt{'48'}:<br>$txt{'49'}\n";
    print "<br><input type=text size=40 name=\"shorttitle\" value=\"$shorttitle\">\n";
    print "<br>";
    &prt_ckb($hits_by_weekday,'hits_by_weekday',$txt{'61'});
    &prt_ckb($top_countries,'top_countries',$txt{'62'});
    &prt_ckb($top_browsers,'top_browsers',$txt{'63'});
    &prt_ckb($top_os,'top_os',$txt{'64'});
    &prt_ckb($top_host,'top_host',$txt{'65'});
    print "<br>";
    &prt_ckb($show_ccodes,'show_ccodes',$txt{'66'});
    print "$txt{'67'}";
    print "<select name=\"show_max\">";
    &put_opt($show_max,'10','10');
    &put_opt($show_max,'15','15');
    &put_opt($show_max,'20','20');
    &put_opt($show_max,'25','25');
    &put_opt($show_max,'30','30');
    &put_opt($show_max,'40','40');
    &put_opt($show_max,'50','50');
    print "\n</select>";
    print "<p>$txt{'68'}";
    print "<select name=\"offset\">";
    &put_opt($offset,'-11','-11');
    &put_opt($offset,'-10','-10');
    &put_opt($offset,'-9','-9');
    &put_opt($offset,'-8','-8');
    &put_opt($offset,'-7','-7');
    &put_opt($offset,'-6','-6');
    &put_opt($offset,'-5','-5');
    &put_opt($offset,'-4','-4');
    &put_opt($offset,'-3','-3');
    &put_opt($offset,'-2','-2');
    &put_opt($offset,'-1','-1');
    &put_opt($offset,'0','0');
    &put_opt($offset,'+1','+1');
    &put_opt($offset,'+2','+2');
    &put_opt($offset,'+3','+3');
    &put_opt($offset,'+4','+4');
    &put_opt($offset,'+5','+5');
    &put_opt($offset,'+6','+6');
    &put_opt($offset,'+7','+7');
    &put_opt($offset,'+8','+8');
    &put_opt($offset,'+9','+9');
    &put_opt($offset,'+10','+10');
    &put_opt($offset,'+11','+11');
    print "\n</select>";
    print "<p>$txt{'69'}";
    print "<select name=\"ip_time\">";
    &put_opt($ip_time,'10min','10');
    &put_opt($ip_time,'15min','15');
    &put_opt($ip_time,'20min','20');
    &put_opt($ip_time,'30min','30');
    &put_opt($ip_time,'45min','45');
    &put_opt($ip_time,'1hr','60');
    &put_opt($ip_time,'2hrs','120');
    &put_opt($ip_time,'4hrs','240');
    &put_opt($ip_time,'6hrs','360');
    &put_opt($ip_time,'12hrs','720');
    &put_opt($ip_time,'1day','1440');
    print "\n</select>";
    print "<p>$txt{'70'})<br>\n";
    print "<textarea cols=16 rows=8 wrap=on name=\"ipsklist\">$ipsklist</textarea><br><br>\n";
}
sub put_opt  {
    local ($show_max, $id, $swkopt)=@_;
    print "\n<option value=\"$swkopt\"";
    if ($show_max eq $swkopt) {print " SELECTED";}
    print ">$id";
    }
sub prt_ckb {
    local ($var, $varname, $ckbdesc) = @_;
    print "\n<br><input type=\"checkbox\" name=\"$varname\" value=\"yes\"";
    if ($var eq "yes") {print " CHECKED";} 
    print ">&nbsp;&nbsp;$ckbdesc";
    }

sub put_banner {
    # do nothing
    }
sub error {
    local ($updact) = @_;
print "Content-type: text/html\n\n";
print "<html>\n";
print "<head>\n";
print "<title>$txt{'53'}</title>\n";
print "$txt{'54'}\n";
print "</head>\n";
print "\n";
print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\">\n";
print "\n";
print "<br><br>$txt{'53'}\n";
print "<br><ul>$updact</ul>\n";
print "<br>$txt{'14'}\n";

print "</body>\n";
print "</html>\n";
exit;
    }
#    print "content-type: text/html\n\n";
#    print "<html><head><title>Error</title></head>\n";
#    print "<body>$basedir/$pagename";
#    print "</body></html>";
#    exit;
