#!/usr/bin/perl
#########################################################################
#  Access Stats v1.12                                                   #
#  Copyright (c)2000 Chi Kien Uong                                      #
#  URL: http://www.proxy2.de                                            #
#                                                                       #
# This Software is distributed under the GNU General Public             #
# License. For more details see license.txt                             #
#                                                                       #
#########################################################################
&parse_ref;
$pagename=$FORM{'pagename'};
$referer=$FORM{'ref'};
if ($referer =~ /(http:\/\/.*\.[a-z]{2,4}\/)/i) {
  $referer = $1;
}

$flock=1;
$cfgname="mystat.cfg";
# path to the site  without trailing "/" (chmoded to 777 (drwxrwxrwx))
# $basedir = "../ezstat";
$basedir="/iiw/htdocs/www.mannyjuan.com/ezstat";
# $basedir = "../webpages/ezstat";
# url to the directory
$baseurl = "http://www.mannyjuan.com/ezstat";
# $baseurl = "http://10.26.36.193/ezstat";

# url to the image file
# $output = "$baseurl/log.gif";
$output = "$baseurl/log.gif";

# get config info
    open(CFGFILE, "$basedir/$pagename/$cfgname") || die "I can't open $basedir/$pagename/$cfgname\n";
    if($flock==1){flock (CFGFILE, 1) or die "can't lock $basedir/$pagename/$cfgname for edit\n";}
    $txrec=<CFGFILE>;
($usrname,$shorttitle,$hits_by_weekday,$top_countries,$top_browsers,$top_os,$top_host,$show_ccodes,$show_max,$ip_time,$offset,$ipsklist,$dum)=split('&&',$txrec);

    close(CFGFILE);


# Ignored IPs - Comment it out if you don't use it e.g. #@skip=('127.0.0.1');
    @skip=split('%%',$ipsklist);

# log file extension
$log_file_ext = "txt";

# IP log file - 666 (-rw-rw-rw-)
$ip_file = "$basedir/$pagename/ip.log";

## time (in min) to keep visitor IP in table (ip blocking)
#$ip_time = 0;
## server time offset - add one hour = +1 ; subtract one hour = -1
#$offset = 0;

# Done
###########

$check=0;

sub check_ip {

  open(FILE,"$ip_file");
  my @lines = <FILE>;
  close(FILE);
  my $found = 0;
  my $this_time = time();

  open(TABLE,">$ip_file");
  foreach $visitor (@lines) {
    ($ip_addr,$time_stamp) = split(/\|/,$visitor);
    if ($this_time < $time_stamp+(60*$ip_time)) {
      if ($ip_addr eq $ENV{'REMOTE_ADDR'}) {
        $found=1;
      } else {
        print TABLE "$ip_addr|$time_stamp";
      }
    }
  }
  print TABLE "$ENV{'REMOTE_ADDR'}|$this_time\n";
  close(TABLE);
  return $found;
}

sub parse_ref0 {

  my $query = $ENV{'QUERY_STRING'};
  ($value, $referer) = split(/=/, $query);
  if ($referer) {
    if ($referer =~ /(http:\/\/.*\.[a-z]{2,4}\/)/i) {
      $referer = $1;
    }
  } else {
     $referer = "-";
  }
}

sub parse_ref {
  my $buffer = $ENV{'QUERY_STRING'};
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
      ($name, $value) = split(/=/, $pair);
      $name =~ tr/+/ /;
      $name =~ s/%([a-f0-9]{2})/pack("C", hex($1))/egi;
      $value =~ tr/+/ /;
      $value =~ s/%([a-f0-9]{2})/pack("C", hex($1))/egi;
      $FORM{$name} = $value;
  }
}

sub write_log {

  my @months = ('January','February','March','April','May','June','July','August','September','October','November','December');
  my @days = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat');
  my ($min,$hour,$mday,$mon,$year,$wday) = (localtime(time+($offset*3600)))[1,2,3,4,5,6];

  $min = "0$min" if ($min < 10);
  $hour = "0$hour" if ($hour < 10);
  $mday = "0$mday" if ($mday < 10);
  $year += 1900;
  $month = $mon+1;
  $month = "0$month" if ($month < 10);

  my $logdat = "$basedir/$pagename/$month-$year\.$log_file_ext";
  my $this_day = ("$days[$wday] $mday-$months[$mon]-$year $hour:$min");

  open(DATA,">>$logdat");
  print DATA ("$this_day - $host - \"$ENV{'HTTP_USER_AGENT'}\" - \"$referer\"\n");
  close (DATA);
}

sub get_host {

  my ($ip_address,$ip_number,@numbers);
  if ($ENV{'REMOTE_HOST'}) {
    $host = $ENV{'REMOTE_HOST'};
  } else {
    $ip_address = $ENV{'REMOTE_ADDR'};
    @numbers = split(/\./, $ip_address);
    $ip_number = pack("C4", @numbers);
    $host = (gethostbyaddr($ip_number, 2))[0];
  }
  if ($host eq "") {
    $host = "$ENV{'REMOTE_ADDR'}";
  }
}

if (@skip) {
  foreach $ips (@skip) {
    if($ENV{'REMOTE_ADDR'} =~ /$ips/) {
      $check = 1;
      last;
    }
  }
}

$check = &check_ip if ($check==0);

if ($check == 0) {
  &get_host();
#  &parse_ref();
  &write_log();
}

print "Location: $output\n\n";
exit (0);
