#!/usr/bin/perl
# 
# ezfaqmkr.pl - EZ SmartFAQ Page Generator - by Manny Juan <manny@jps.net> 9/10/2001
# http://mannyjuan.com/smartfaq
#
#
# This will give your visitors the opportunity to set up a SmartFAQ Page on your site.
# the generated SmartFAQ Page uses SmartFAQ Page.pl, patterned after SmartFAQ  
# script, and modified so it could service multiple SmartFAQ Pages 
#####################################################################################
$SIG{__DIE__} = \&Error_Msg;

sub Error_Msg {
    $msg = "@_";
    print "\ncontent-type: text/html\n\n";
    print "The following error occurred : $msg\n";
    exit;
}

# Get the input
read(STDIN, $input, $ENV{'CONTENT_LENGTH'});

    # split the input
    @pairs = split(/&/, $input);

    # split the name/value pairs
    foreach $pair (@pairs) {

    ($name, $value) = split(/=/, $pair);

    $name =~ tr/+/ /;
    $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    if (($name eq 'header') || ($name eq 'footer')) {
        # do nothing
        }
    else {
        $value =~ s/<([^>]|\n)*>//g;
        }

    $FORM{$name} = $value;
    }
$gSalt = "a1Mj";

######################################################################################
# set variables HERE
$cgi='pl';
$win95=0;
$faqvuepl="smartfaq.cgi";
$faqadmpl="faqadmin.cgi";
$cgiurl = "/cgi-bin";
# $basedir = "../webpages/smartfaq";
$basedir = "/home/manny/www/smartfaq";
$baseurl = "/smartfaq";

# This is a URL and dir for the images sub directory in the userpages directory.
# Create the images directory in the userpages directory. This is where
# you will upload your background images
$imageurl = "/smartfaq";

# This is the index of all generated pages
# This file should be chmod to 777 and placed in the userpages directory
$indexpage = "$basedir/index.html";

# This is the location of the data.txt file. This holds each user's
# login name and e-mail address for confirmation
$data = "$basedir/data.txt";

#Site title

$title="Easy SmartFAQ Page";

# self explanatory variables for your site logo
$logo = "$imageurl/mjmall.jpg";
$logoalt = "Easy SmartFAQ Page";

# Location of the sendmail program
$sendmail = '/usr/sbin/sendmail';

# Your e-mail address here
$myemail = 'manny@jps.net';

# That's it.

# DO NOT CHANGE ANYTHING BELOW THIS LINE
######################################################################################

# Lets do some translating first
$updact = $FORM{'updact'};
$usrname = $FORM{'usrname'};
$login = $FORM{'login'};
$email = $FORM{'email'};
$password = $FORM{'password'};
$pwdagain = $FORM{'pwdagain'};
$hint = $FORM{'hint'};
$addsearchbox = $FORM{'addsearchbox'};
$header = $FORM{'header'};
$footer = $FORM{'footer'};
$layout = $FORM{'layout'};
$retlink=$FORM{'retlink'};
$cfgpwd=$FORM{'cfgpwd'};
$colorset = $FORM{'colorset'};
($bkgdc, $textc, $linkc, $vlinkc) = split('~', $colorset);
$sitename=$FORM{'sitename'};


# If the user tries to add more than one word in
# the page name field, this will put an underscore
# in the spaces to make it one word
$login =~ s/\W//g;


if ($FORM{'action'} eq "New SmartFAQ Page") {
    &newpage;
    }
if ($FORM{'action'} eq "Create SmartFAQ Page") {
    &create;
    }
if ($FORM{'action'} eq "Edit SmartFAQ Page") {
    &confirm("edit");
    }
if ($FORM{'action'} eq "checkuser") {
    &checkuser;
    }
if ($FORM{'action'} eq "recreate") {
    &recreate;
    }
if ($FORM{'action'} eq "Delete SmartFAQ Page") {
    &confirm("delete");
    }
    exit;

sub newpage {

    $sitename="";
    $colorset="FFFFFF~333333~006699~999900";
    ($bkgdc, $textc, $linkc, $vlinkc) = split('~', $colorset);
    $header="<center>Welcome to my SmartFAQ Page</center>";
    $footer="<center>Thanks for visiting my SmartFAQ Page</center>";
    $addsearchbox=1;
    $layout="1";
    $retlink="http://";
    $usrname="Webmaster";

    # To avoid any security risks. Take out the HTML tags added when HPM translated
    # the && to: <br><br>. They will be re-translated to: && Once the user updates
    # the page, the: && will be put back to: <br><br>

    # print the edit-page form

    print "content-type: text/html\n\n";
    print "<html><head><title>Create Your Own SmartFAQ Page</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\">\n";
    &put_banner;
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
    print "<table width=75% cellspacing=2 cellpadding=2 border=0>\n";
    print "<tr><td width=100% align=left valign=top>\n";
    print "<p><font face=\"Arial, Geneva\"><h2>Create Your Own SmartFAQ Page</h2></font></p>\n";
    print "<p>Below is an empty form for you to fill in. The next five fields (<b>bold</b>) are required.\n";
    print "You can edit any part of your page later</p>\n";
    print "<p></p>\n";
    print "<form action=\"$cgiurl/ezfaqmkr.$cgi\" method=POST>\n";
    print "<input type=hidden name=\"action\" value=\"Create SmartFAQ Page\">\n";
    print "<b>Your name:</b><br>\n";
    print "<font size=\"-1\">(will appear in page as link to your email)</font><br>\n";
    print "<input type=text size=40 name=\"usrname\" value=\"$usrname\"><br><br>\n";
    print "<h3>(The next 3 fields will be used for editing)<h3>\n";
    print "<b>Login Id:</b>\n";
    print "<font size=\"-1\">(one word only you should know, used later for editing)</font><br>\n";
    print "<input type=text size=40 name=\"login\" value=\"$login\"><br><br>\n";
    print "<b>Your e-mail:</b>\n";
    print "<font size=\"-1\">(used for editing, will also appear in page)</font><br>\n";
    print "<input type=text size=40 name=\"email\" value=\"$email\"><br><br>\n";
    print "<b>Enter Password:</b>\n";
    print "<font size=\"-1\">(used for administration)</font><br>\n";
    print "<input type=password size=40 name=\"password\" value=\"$password\"><br><br>\n";
    print "<b>Enter Password Again:</b>\n";
    print "<font size=\"-1\">(for verification)</font><br>\n";
    print "<input type=password size=40 name=\"pwdagain\" value=\"$pwdagain\"><br><br>\n";
    print "<b>Hint:</b>\n";
    print "<font size=\"-1\">(for reminding you of your password)</font><br>\n";
    print "<input type=text size=40 name=\"hint\" value=\"$hint\"><br><br>\n";
    print "</td></tr></table>\n";
    &build_form_content;
    print "<P><input type=submit value=\"create page\">\n";
    print "</form>\n";
    print "</body></html>\n";
    }

sub create {
    $pagename=$login;
    # Now, lets do some error checking. Making sure they filled out each field
    # This is pretty low tech now. I'll improve it later
    &missing(missing_name) unless $usrname;
    &missing(missing_email) unless $email;
    &missing(missing_password) unless $password;
    &missing(missing_password_retyped) unless $pwdagain;
    if ($password ne $pwdagain) { &error ("the two password fields entered do not match!"); }

    # if they try to name their page "index" This will stop them
    if (uc($pagename) eq "INDEX") {
        print "content-type: text/html\n\n";
        print "<html><head><title>Error</title></head>\n";
        print "<body>";
        &put_banner;
        print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
        print "<p>You cannot name your page <b>index</b>\n";
        print "Please go back and re-name your page</p>\n";
        print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
        exit;
        }
    # if the user tries to name their page 
    # something that is already taken
    # this should stop them - it's a check for directory-present
    if (-d "$basedir/$pagename") {
        print "content-type: text/html\n\n";
        print "<html><head><title>Error</title></head>\n";
        print "<body>";
        &put_banner;
        print "<p>The page name: <b>$pagename</b>\n";
        print "is already taken.\n";
        print "Please go back and rename your page</p>\n";
        print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
        exit;
        }

    # create the new directory for pagename
    umask(000);  # UNIX file permission junk
    mkdir("$basedir/$pagename", 0777) unless (-d "$basedir/$pagename");     
    mkdir("$basedir/$pagename/subject", 0777) unless (-d "$basedir/$pagename/subject");     

    $cryptpwd=crypt($password,$gSalt);
    $cfgpwd=$cryptpwd;

    &build_cfg;

    # Write the login name and email address to a separate file for confirmation
    # when they want to edit their page
    open (FILE, ">>$data") || die "I can't open >>$data\n";
    if($win95==0){flock (FILE, 2) or die "can't lock data file\n";}
    print FILE "$login&&$email&&$cryptpwd&&$hint\n";
    close(FILE);


    # Suck the index page, and write the new entry to it
    open(FILE, "$indexpage") || die "I can't open that file $indexpage\n";
    if($win95==0){flock (FILE, 1) or die "can't lock index file\n";}
    @lines = <FILE>;
    close(FILE);
    $sizelines = @lines;

    # Now, re-open the links file, and add the new link
    open(FILE, ">$indexpage") || die "I can't open that file >$indexpage\n";
    if($win95==0){flock (FILE, 2) or die "can't lock index file\n";}

    for ($a = 0; $a <= $sizelines; $a++) {

        $_ = $lines[$a];

        if (/<!--begin-->/) {

            print FILE "<!--begin-->\n";
            print FILE "<p><font face=\"Arial, Geneva\" size=4><a href=\"$cgiurl/$faqvuepl?pagename=$pagename\">$sitename</a></p>\n";

        } else {
            print FILE $_;
            }
        }
    close(FILE);


    # Give the user a response
    print "content-type: text/html\n\n";
    print "<html><head><title>thanks</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\">\n";
    &put_banner;
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
    print "<BR><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";

    print "Your page has been created, and you will receive an e-mail confirming this!\n";
    print "Your URL is: <a href=\"$cgiurl/$faqvuepl?pagename=$pagename\">\n";
    print "$cgiurl/$faqvuepl?pagename=$pagename</a>\n";
    print "(The admin function is accessed from the Edit button)\n";
    print "Remember to press Reload.\n";
    print "Thanks for your participation!\n";
    print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
    print "</body></html>\n";


    # Send the user an e-mail confirming their page
    open (MAIL, "| $sendmail -t") || die "I can't open sendmail\n";
    print MAIL "To: $usrname <$email>\n";
    print MAIL "From: $myemail\n";
    print MAIL "Subject: Your new URL on the $title\n";
    print MAIL "Your page can be viewed at the URL below:\n";
    print MAIL "\n";
    print MAIL "$cgiurl/$faqvuepl?pagename=$pagename\n";
    print MAIL "\n(the admin function is accessed from the Edit button)";
    print MAIL "\nHere is your login info - please save for later use";
    print MAIL "\nlogin=$login";
    print MAIL "\nemail=$email";
    print MAIL "\npassword=$password";
    print MAIL "\nhint=$hint";
    print MAIL "\n\nThank you for using the $title\n";
    print MAIL "\n\nThe Mall Manager - $myemail\n";
    close (MAIL);

    # Notify us when someone creates a page
    open (MAIL, "| $sendmail -t") || die "I can't open sendmail\n";
    print MAIL "To: $myemail\n";
    print MAIL "From: $usrname <$email>\n";
    print MAIL "Subject: $title New Page Report\n";
    print MAIL "$usrname created a new page:\n";
    print MAIL "$cgiurl/$faqvuepl?pagename=$pagename\n";
    close(MAIL);

    }

sub recreate {
    $pagename=$login;
    # Suck the index page, and update site name (in case it changed)
    open(FILE, "$indexpage") || die "I can't open that file $indexpage\n";
    if($win95==0){flock (FILE, 1) or die "can't lock index file\n";}
        @lines = <FILE>;
        close(FILE);
        $sizelines = @lines;

    # Now, re-open the links file, and replace the index entry
    open(FILE, ">$indexpage") || die "I can't open that file >$indexpage\n";
    if($win95==0){flock (FILE, 2) or die "can't lock index file to delete entry\n";}

            for ($a = 0; $a <= $sizelines; $a++) {

            $_ = $lines[$a];

        if (/pagename=$pagename\b/) {
            print FILE "<p><font face=\"Arial, Geneva\" size=4><a href=\"$cgiurl/$faqvuepl?pagename=$pagename\">$sitename</a></font></p>\n";
          } 
        else {
          print FILE $_;
           }
        }
    close(FILE);

    #now, lets create our new html page
    # recreate the user's config and index file
    &build_cfg;

    &ntfy_usr_edt;

    # Give the user a response
    print "content-type: text/html\n\n";
    print "<html><head><title>thanks</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\">\n";
    &put_banner;
    print "<CENTER><IMG SRC=\"$logo\" alt=\"$logoalt\" border=0></CENTER>\n";
    print "<P><BR><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";
    print "Your page has been revised, and you will receive an e-mail confirming this!\n";
    print "Your URL is: <a href=\"$cgiurl/$faqvuepl?pagename=$pagename\">\n";
    print "$cgiurl/$faqvuepl?pagename=$pagename</a>\n";
    print "Remember to press Reload.\n";
    print "Thanks for your participation!\n";
    print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
    print "</body></html>\n";
    }

sub build_cfg {
    $header =~ s/\n/%%/g;
    $header =~ s/\cM//g;
    $footer =~ s/\n/%%/g;
    $footer =~ s/\cM//g;
    # create the config file
    open (CFGFILE,">$basedir/$pagename/myfaqmkr.cfg")||die "i can't open >$basedir/$pagename/myfaqmkr.cfg";
    print CFGFILE "$usrname&&$email&&$sitename&&$colorset&&$header&&$footer&&$addsearchbox&&$layout&&$retlink&&$cfgpwd";
    close(CFGFILE);

    # create the index file
    open (IDXFILE,">$basedir/$pagename/index.html")||die "i can't open >$basedir/$pagename/index.html";
 print IDXFILE <<"_%%%";
<html><head><title>ezfaqmkr - SmartFAQ Page Generator</title></head>
<body bgcolor=\"#$bkgdc\" text=\"#$textc\" link=\"#$linkc\" vlink=\"#$vlinkc\" alink=\"#$linkc\" >
<center><h1>$sitename</h1></center><hr>
<a href="$cgiurl/$faqvuepl?pagename=$pagename">View SmartFAQ</a>
<br><a href="$cgiurl/$faqadmpl?pagename=$pagename">Administer SmartFAQ</a>
</body></html>
_%%%
    close(IDXFILE);
    }
sub ntfy_usr_edt {
    # Send the user a notice that their page has been re-done
    open (MAIL, "| $sendmail -t") || die "I can't open sendmail\n";
    print MAIL "To: $usrname <$email>\n";
    print MAIL "From: $myemail\n";
    print MAIL "Subject: Your Changes on the $title\n";
    print MAIL "Your revised page can be viewed at the URL below:\n";
    print MAIL "\n";
    print MAIL "$cgiurl/$faqvuepl?pagename=$pagename\n";
    print MAIL "\nOnce again thank you for using the $title\n";
    print MAIL "\n\nThe Mall Manager\n";
    close (MAIL);
    }

# Standard error message for any missing required fields
sub missing {
    local ($missing) = @_;
    print "content-type: text/html\n\n";

    print "<HTML><head><TITLE>You missed something</TITLE></head>\n";
    print "<body>\n";
    &put_banner;    
    print "You forgot to fill in one of the fields. Please go back and make\n";
    print "sure that all required fields are filled in! $missing\n";
    print "</body></HTML>\n";
    exit;
    }

sub confirm {
    local ($updact) = @_;

    print "content-type: text/html\n\n";
    print "<html><head><title>$updact Confirmation</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\" >\n";
    &put_banner; 
    print "<CENTER><IMG SRC=\"$logo\" alt=\"$logoalt\"  border=0></CENTER>\n";
    print "<P><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";
    print "<p><h3>Please Enter your login name, e-mail and password in order to $updact</h3></p>\n";
    print "<form action=\"$cgiurl/ezfaqmkr.$cgi\" method=POST>\n";
    print "<P><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";
    print "Login name:<br>\n";
    print "<input size=40 type=text name=\"login\"><br><br>\n";
    print "E-mail:<br>\n";
    print "<input size=40 type=text name=\"email\"><br><br>\n";
    print "Password:<br>\n";
    print "<input type=password size=40 name=\"password\"><br><br>\n";
    print "<input type=submit value=submit>\n";
    print "<input type=hidden name=\"action\" value=\"checkuser\">\n";
    print "<input type=hidden name=\"updact\" value=\"$updact\">\n";
    print "</FONT>\n";
    print "</form></body></html>\n";
    }

sub checkuser {
    open(FILE, "$data") || die "I can't open $data\n";  
    if($win95==0){flock (FILE, 1) or die "can't lock data file\n";}

    while(<FILE>) {
    chop;       
    @all = split(/\n/);

    foreach $line (@all) {
    ($loginname, $loginemail, $loginpassword, undef) = split(/&&/, $line);
    if($loginname eq "$login" && $loginemail eq "$email" && $loginpassword eq crypt($password,$gSalt)) {
        $match = 1;
        if($updact eq "edit") {
          &edit($login);
          }
        else {
          &delpage($login);
          }
        }
      }
    }

    close(FILE);

    if (! $match) {
        &denied;
        }

    # del entry from data
    if($updact eq "delete") {

        # Suck the index page, and write the new entry to it
        open(FILE, "$data") || die "I can't open that file $data\n";
        if($win95==0){flock (FILE, 1) or die "can't lock data file\n";}
            @lines = <FILE>;
            close(FILE);
            $sizelines = @lines;

        # Now, re-open the links file, and comment out the page to delete
        open(FILE, ">$data") || die "I can't open that file >$data\n";
        if($win95==0){flock (FILE,2) or die "can't lock index file for append\n";}
        chop;
                for ($a = 0; $a <= $sizelines; $a++) {
                $_ = $lines[$a];
                $w = $_;
                $w =~ s/\cM//g;
                $w =~ s/\n//g;
        ($loginname, $loginemail, $loginpassword) = split(/&&/, $w);
        if($loginname eq "$login" && $loginemail eq "$email" && $loginpassword eq crypt($password,$gSalt)) {
              # do nothing  (ie. don't write)
              } 
            else {
              if($w eq "") {
                # do nothing (skip)
                }
              else {
                print FILE "$w\n";
                }
              }
            }
        close(FILE);
        print "content-type: text/html\n\n";
        print "<html><head><title>$updact Confirmation</title></head>\n";
        print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\" >\n";
        &put_banner; 
        print "<CENTER><IMG SRC=\"$logo\" alt=\"$logoalt\" border=0></CENTER>\n";
        print "<P><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";
        print "<p>your page has been deleted";
        print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
        print "</form></body></html>\n";
      }
    }

sub edit {
    local ($pagename)= @_;
    # get the config file
    open(CFGFILE, "$basedir/$pagename/myfaqmkr.cfg") || die "I can't open $basedir/$pagename/myfaqmkr.cfg\n";
    if($win95==0){flock (CFGFILE, 1) or die "can't lock data file for edit\n";}
    $txrec=<CFGFILE>;
($usrname,$email,$sitename,$colorset,$header,$footer,$addsearchbox,$layout,$retlink,$cfgpwd)=split('&&',$txrec);
    $header =~ s/%%/\n/g;
    $footer =~ s/%%/\n/g;
    &build_edit_form;
    close(CFGFILE);
    }

sub delpage {
    local ($pagename) = @_;
    &deltree(0,"$basedir/$pagename");

    # Suck the index page, and store entries in array
    open(FILE, "$indexpage") || die "I can't open that file $indexpage\n";
    if($win95==0){flock (FILE, 1) or die "can't lock index file\n";}
        @lines = <FILE>;
        close(FILE);
        $sizelines = @lines;

    # Now, recreate the page but do not write the deleted page
    open(FILE, ">$indexpage") || die "I can't open that file >$indexpage\n";
    if($win95==0){flock (FILE, 2) or die "can't lock index file to delete entry\n";}
        for ($a = 0; $a <= $sizelines; $a++) {
        $_ = $lines[$a];
        if (/pagename=$pagename\b/) {
          # do nothing  (ie. don't write)
          } 
        else {
          print FILE $_;
           }
        }
    close(FILE);

    # Suck the users page, and store entries in array
    open(FILE, "$data") || die "I can't open that file $data\n";
    if($win95==0){flock (FILE, 1) or die "can't lock $data\n";}
        @lines = <FILE>;
        close(FILE);
        $sizelines = @lines;

    # Now, recreate the page but do not write the deleted page
    open(FILE, ">$data") || die "I can't open that file >$data\n";
    if($win95==0){flock (FILE, 2) or die "can't lock users file to delete entry\n";}
        for ($a = 0; $a <= $sizelines; $a++) {
        $_ = $lines[$a];
        if (/pagename=$pagename\b/) {
          # do nothing  (ie. don't write)
          } 
        else {
          print FILE $_;
           }
        }
    close(FILE);
    }

sub deltree {
    local ($lvl, $dir) = @_;
    local @tnlist;
    opendir (TN, "$dir");
    rewinddir (TN);
    @tnlist =  grep(!/^\.\.?$/, readdir (TN));
    closedir (TN);
    foreach $tn (@tnlist) {
        if (-d "$dir/$tn") {
            $lvl++;
            &deltree($lvl,"$dir/$tn" );
            $lvl--;
            }
        else {
            $cnt=unlink("$dir/$tn");
#            print "<br>deleting $dir/$tn";
            }
        }
    rmdir ("$dir");
#    print "<br>removing $dir";
    }

sub build_edit_form {
    # To avoid any security risks. Take out the HTML tags added when HPM translated
    # the && to: <br><br>. They will be re-translated to: && Once the user updates
    # the page, the: && will be put back to: <br><br>

    # print the edit-page form

    print "content-type: text/html\n\n";
    print "<html><head><title>Edit Your Page</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\">\n";
    &put_banner; 
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
    print "<table width=75% cellspacing=2 cellpadding=2 border=0>\n";
    print "<tr><td width=100% align=left valign=top>\n";
    print "<p><font face=\"Arial, Geneva\"><h2>Edit Your SmartFAQ Page</h2></font></p>\n";
    print "<p>Below is a form with the contents\n";
    print "of the SmartFAQ Page you created. You can edit any part of your page</p>\n";
    print "<p></p>\n";
    print "<form action=\"$cgiurl/ezfaqmkr.$cgi\" method=POST>\n";
    print "<input type=hidden name=\"action\" value=\"recreate\">\n";
    print "<input type=hidden name=\"login\" value=\"$login\">\n";
    print "Your name:<br>\n";
    print "<input type=text size=40 name=\"usrname\" value=\"$usrname\"><br><br>\n";
    print "Your e-mail:<br>\n";
    print "<input type=text size=40 name=\"email\" value=\"$email\"><br><br>\n";
    print "</td></tr></table>\n";
    &build_form_content;
    print "<P><input type=submit value=\"update page\">\n";
    print "</form>\n";
    print qq~
<hr>
<p><font face="Arial, Geneva"><h2>Administer Your SmartFAQ Page</h2></font>
<form method="GET" action="$cgiurl/$faqadmpl">
Enter your password:
<br><input type="password" name="password"
  size="14">&nbsp;<input type="submit" value="Access" name="B1"></p>
<input type="hidden" name="pagename" value="$pagename">
</form>
~;
    print "</body></html>\n";
    }

sub build_form_content {

    print "<br><b>Title of your SmartFAQ Page:</b>&nbsp;(eg. Jean and Lee's SmartFAQ Page)";
    print "<br><input type=text size=40 name=\"sitename\" value=\"$sitename\"><br><br>\n";
    print "<b>Select Preset Colors:</b>";
    print "<SELECT NAME=\"colorset\">";
    &put_clropt($colorset,'01','FFFFFF~333333~006699~999900');
    &put_clropt($colorset,'02','CCCCCC~000000~0000CC~660066');
    &put_clropt($colorset,'03','FFFF00~FF6600~FF0033~336633');
    &put_clropt($colorset,'04','CCCC66~330000~CC0000~003300');
    &put_clropt($colorset,'05','FFFF99~330000~CC0000~333333');
    &put_clropt($colorset,'06','99CCCC~000066~0000CC~003366');
    &put_clropt($colorset,'07','CC99FF~000000~FF0033~660066');
    &put_clropt($colorset,'08','CCFF99~666600~006699~003300');
    &put_clropt($colorset,'09','FFCC00~330000~CC0000~660066');
    &put_clropt($colorset,'10','00FF33~0000CC~FF0099~660066');
    &put_clropt($colorset,'11','006699~CCFFCC~FFFF00~00FFFF');
    &put_clropt($colorset,'12','330000~FF6666~FFCC00~CCFF99');
    &put_clropt($colorset,'13','003300~CCCC66~FFFFFF~FFFF00');
    &put_clropt($colorset,'14','333333~CCCCCC~FF6666~CCCC66');
    &put_clropt($colorset,'15','666600~FFFFFF~FFFF00~99CCFF');
    &put_clropt($colorset,'16','000000~99CCFF~FFFF00~CCCC66');
    &put_clropt($colorset,'17','333333~FFFFFF~99CCFF~CC99FF');
    &put_clropt($colorset,'18','CC0000~FFFFFF~FFFF00~00FFFF');
    print "\n</SELECT>";
    print "<br><img src=\"$baseurl/ezpalette.gif\">\n";
    print "<p><b>Select Layout:</b>&nbsp;&nbsp;";
    print "<SELECT NAME=\"layout\">";
    &put_clropt($layout,"show question links, followed by question-and-answer pairs",'1');
    &put_clropt($layout,"show question-and-answer pairs only",'2');
    &put_clropt($layout,"show question links only",'3');
    print "\n</SELECT>\n";
    print "<p><b>Search Box Option:</b>\n";
    print "<br><INPUT TYPE=\"CHECKBOX\" NAME=\"addsearchbox\" VALUE=\"1\"";
    if ($addsearchbox eq "1") {print " CHECKED";} 
    print ">&nbsp;&nbsp;add a search box to FAQ page";
    print "\n<p><b>Header:</b> (HTML allowed, except &lt;body&gt; tag)\n";
    print "<br><textarea cols=65 rows=6 wrap=on name=\"header\">$header</textarea>\n";
    print "<p><b>Footer:</b> (HTML allowed)\n";
    print "<br><textarea cols=65 rows=6 wrap=on name=\"footer\">$footer</textarea>\n";
    print "\n<p><b>Return Link (URL):</b>&nbsp;&nbsp;link here when user clicks Return<br>\n";
    print "<input type=text size=50 name=\"retlink\" value=\"$retlink\"><br><br>\n";
    print "<input type=hidden name=\"cfgpwd\" value=\"$cfgpwd\">";
    }

sub put_optvar  {
    local ($optvar, $id, $value)=@_;
    print "\n<OPTION VALUE=\"$value\"";
    if ($optvar eq $value) {print " SELECTED";}
    print ">$id";
    }
sub put_clropt  {
    local ($colorset, $id, $colors)=@_;
    print "\n<OPTION VALUE=\"$colors\"";
    if ($colorset eq $colors) {print " SELECTED";}
    print ">$id";
    }

sub prt_ckb {
    local ($var, $varname, $ckbdesc) = @_;
    print "\n<tr><td><INPUT TYPE=\"CHECKBOX\" NAME=\"$varname\" VALUE=\"1\"";
    if ($var eq "1") {print " CHECKED";} 
    print "></td>";
    print "<td>$ckbdesc</td></tr>";
    }

sub denied {
    local ($updact) = @_;
    print "content-type: text/html\n\n";
    print "<html><head><title>Permission Denied</title></head>\n";
    print "<body>\n";
    &put_banner; 
#    print "$loginname, $loginemail, $loginpassword";
#    print "<br>$login, $mail, $password";

    print "<p><h1>Permission Denied</h1></p>\n";
    print "You do not have permission to $updact\n";
    print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
    print "</body></html>\n";
    exit;
    }

sub error {
    local ($msg) = @_;
    print "content-type: text/html\n\n";
    print "<html><head><title>Error</title></head>\n";
    print "<body>";
    &put_banner;
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
    print "<p>$msg\n";
    print "Please go back and correct the error</p>\n";
    print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
    exit;
    }

sub put_banner {
    # do nothing
    }
