#!/usr/bin/perl -w
# ----------------------------------------------------------------------------
# vstasks.pl
# Copyright (c) 2001 Jason M. Hinkle. All rights reserved. This script is
# free software; you may redistribute it and/or modify it under the same
# terms as Perl itself.
# For more information see: http://www.verysimple.com/scripts/
#
# LEGAL DISCLAIMER:
# This software is provided as-is.  Use it at your own risk.  The
# author takes no responsibility for any damages or losses directly
# or indirectly caused by this software.
# 
# Version History
# 1.4.6 - 10/02/01 - fixed bug viewing pages in "show all" mode
# 1.4.5 - 08/22/01 - added file locking
# 1.4.4 - 08/05/01 - handle missing datafiles gracefully 
# ----------------------------------------------------------------------------
my $VERSION = "1.4.6";
# my $basedir="../webpages/vsorg/"; 
my $basedir = "/home/manny/www/vsorg/";

# ----------------------------------------------------------------------------

# $|++;
print "Content-type: text/html\n\n";


eval 'use vsLock';
eval 'use vsDB';
eval 'use CGI';
my ($objCGI) = new CGI;
my ($pagename) = $objCGI->param('pagename');

# --- get the configuration settings 
my ($configFilePath) = &CurrentDirectory . "data/tasks.cfg";
my ($objConfig) = new vsDB(
    file => $configFilePath,
    delimiter => "\t",
);
$objConfig->Open;
my ($title) = $objConfig->FieldValue("Title");
my ($bodyTag) = $objConfig->FieldValue("BodyTag");
my ($headerColor) = $objConfig->FieldValue("HeaderColor");
my ($dataDarkColor) = $objConfig->FieldValue("DataDarkColor");
my ($dataLightColor) = $objConfig->FieldValue("DataLightColor");
my ($detailIcon) = $objConfig->FieldValue("DetailIcon");
my (@showFields) = split(",",$objConfig->FieldValue("ShowFields"));
my ($fileName) = $objConfig->FieldValue("FileName") || "tasks.tab";
my ($delimiter) = $objConfig->FieldValue("Delimiter") || "\t";
my ($pageSize) = $objConfig->FieldValue("PageSize") || "10";
my ($useFileLocking) = $objConfig->FieldValue("UseFileLocking") || 0;

$objConfig->Close;
undef($objConfig);
# -- end config 

# print the header
print "
    <html>
    <head><title>$title</title></head>
    $bodyTag
    <font face='arial' size='2'>
    <table bgcolor='$headerColor' border='0' width='100%'><tr><td><b>$title</b></td></tr></table>
    <p>
";

my ($command) = $objCGI->param('vsCOM') || "";
my ($showCompleted) = $objCGI->param('vsSC') || 0;
my ($idNum) = $objCGI->param('vsID') || "";
my ($scriptName) = $ENV{'SCRIPT_NAME'} || "data/vscontac.pl";
my ($filePath) = &CurrentDirectory . $fileName;
my ($activePage) = $objCGI->param('vsAP') || "1";
my ($sortField) = $objCGI->param('vsSORT') || "";


print "<form action='" . $scriptName . "' method='post'>\n";
print "<input type='hidden' name='pagename' value='$pagename'>";


my ($objDB) = new vsDB(
    file => $filePath,
    delimiter => $delimiter,
);

# lock the datafile 
my ($objLock) = new vsLock(-warn => 1, -max => 5, delay => 1);
if ($useFileLocking) {
    $objLock->lock($filePath) || die "Couldn't Lock Datafile";
}

if (!$objDB->Open) {print $objDB->LastError;$objLock->unlock($filePath);die;};

if ($command eq "EDIT") {
    $objDB->Filter("ID","eq",$idNum);
    PrintCurrentRecord($objDB);
} elsif ($command eq "UPDATE") {
    $objDB->Filter("ID","eq",$idNum);
    UpdateCurrentRecord($objDB,$objCGI);
    $objDB->RemoveFilter;
    $objDB->MoveFirst;
    PrintAllRecords($objDB);
} elsif ($command eq "DELETE") {
    $objDB->Filter("ID","eq",$idNum);
    $objDB->Delete;
    $objDB->Commit;
    $objDB->RemoveFilter;
    $objDB->MoveFirst;
    PrintAllRecords($objDB);
} elsif ($command eq "ADD") {
    PrintBlankRecord($objDB);
} elsif ($command eq "INSERT") {
    $objDB->AddNew;
    my ($newId) = $objDB->Max("ID") || 0;
    $newId = int($newId) + 1;
    $objDB->FieldValue("ID",$newId);
    UpdateCurrentRecord($objDB,$objCGI);
    $objDB->MoveFirst;
    PrintAllRecords($objDB);
} else {
    PrintAllRecords($objDB);
}

if ($useFileLocking) {
    $objLock->unlock($filePath);
}

print "<b><font face='arial' size='2'><a href='$scriptName" . PassThrough("vsCOM","ADD") . "&pagename=$pagename'>Add New Task</a></font></b>\n";
if ($showCompleted) {
    print "| <b><font face='arial' size='2'><a href='$scriptName?pagename=$pagename&vsSORT=$sortField'>Hide Completed</a></font></b>\n";
} else {
    print "| <b><font face='arial' size='2'><a href='$scriptName?pagename=$pagename&vsSORT=$sortField&vsSC=1'>Show Completed</a></font></b>\n";
}
print "
    </form>
    <hr><font size='1'>
    VerySimple Task Editor $VERSION &copy 2001, <a href='http://www.verysimple.com/'>VerySimple</a><br>
";
print "vsDB Module Version " . $objDB->Version . "<br>";
print "vsLock Module Version " . $objLock->Version;
print "
    </font><p>
    </font>
    </body>
    </html>
";
undef($objDB);
undef($objLock);
undef($objCGI);

#_____________________________________________________________________________
sub PrintAllRecords {
    my ($objMyDB) = shift;
    my ($fieldName, $fieldValue);
    my ($count) = 0;

    $objMyDB->Sort($sortField) if ($sortField ne "");   
    $objMyDB->Filter("Complete","ne","Yes") unless ($showCompleted);

    $objMyDB->PageSize($pageSize);
    $objMyDB->ActivePage($activePage);
    
    $activePage = $objMyDB->ActivePage; # (in case we specified one out of range) 
    my ($pageCount) = $objMyDB->PageCount;
    
    print "<table cellspacing='2' cellpadding='2' border='0'>\n";
    print "<tr valign='top' bgcolor='#CCCCCC'>\n";
    print "<td>&nbsp;</td>\n";
    foreach $fieldName (@showFields) {
        print "<td><b><font face='arial' size='2'><a href='$scriptName?pagename=$pagename&vsSORT=$fieldName&vsSC=$showCompleted'>" . $fieldName . "</a></font></b></td>\n";
    }
    print "</tr>\n";
    while (!$objMyDB->EOF && $count < $pageSize) {
        print "<tr valign='top' bgcolor='$dataLightColor'>\n";
        print "<td><font face='arial' size='1'><a href='" . $scriptName . "?pagename=$pagename&vsSORT=$sortField&vsAP=$activePage&vsCOM=EDIT&vsID=" . $objMyDB->FieldValue("ID") . "'><img src='/vsorg/$detailIcon' alt='Details' border='0'></a></font></td>\n";
        foreach $fieldName (@showFields) {
            $fieldValue = $objMyDB->FieldValue($fieldName);
            $fieldValue = "&nbsp;" if ($fieldValue eq "");
            if ($fieldName eq "SpecialField") {
                # not used at the moment, but maybe later...
                print "<td><font face='arial' size='2'>" . $fieldValue . "</font></td>\n";
            } else {
                print "<td><font face='arial' size='2'>" . $fieldValue . "</font></td>\n";
            }
        }
        print "</tr>\n";
        $objMyDB->MoveNext;
        $count++;
    }   
    print "</table>\n";
    print "<p>\n";

    print "Result Page " . $activePage . " of " . $pageCount;
    if ($activePage > 1) {
        print " <a href='$scriptName" . PassThrough("vsAP",$activePage - 1) . "&pagename=$pagename'>Previous</a>";
    }
    if ($activePage < $pageCount) {
        print " <a href='$scriptName" . PassThrough("vsAP",$activePage + 1) . "&pagename=$pagename'>Next</a>";
    }
    print " (" . $objMyDB->RecordCount . " Tasks)\n";
    print "<p>\n";

}

#_____________________________________________________________________________
sub PrintCurrentRecord {
    my ($objMyDB) = shift;
    my ($fieldName, $fieldValue);
    print "<table cellspacing='2' cellpadding='2' border='0'>\n";
    foreach $fieldName ($objMyDB->FieldNames) {
        if ($fieldName eq "ID") {
            print "<input type='hidden' name='vsID' value='" . $objMyDB->FieldValue("ID") . "'>\n";
        } else {
            print "<tr valign='top' bgcolor='$dataLightColor'>\n";
            print "<td><font face='arial' size='2'>" . $fieldName . "</font></td>\n";
            if ($fieldName eq "Complete") {
                my ($yes) = "";
                my ($no) = "";
                $yes = "checked" if ($objMyDB->FieldValue("Complete") eq "Yes");
                $no = "checked" if ($objMyDB->FieldValue("Complete") eq "No");
                print "<td><font face='arial' size='2'>";
                print "<input type=\"radio\" name=\"Complete\" value=\"Yes\" $yes>Yes\n";
                print "<input type=\"radio\" name=\"Complete\" value=\"No\" $no>No\n";
                print "</font></td>";
            } elsif ($fieldName eq "Notes") {
                print "<td><textarea name='Notes' cols='38' rows='3'>";
                $fieldValue = $objMyDB->FieldValue("Notes");
                $fieldValue =~ s/\"/&quot;/g;       
                print $fieldValue . "</textarea></td>\n";
            } else {
                print "<td><input size=\"50\" name=\"" . $fieldName . "\" value=\"";
                $fieldValue = $objMyDB->FieldValue($fieldName);
                $fieldValue =~ s/\"/&quot;/g;       
                print $fieldValue . "\"></td>\n";
            }
            print "</tr>\n";
        }
    }
    print "</table>\n";
    print "<p>\n";
    print "<input type='hidden' name='vsSC' value='$showCompleted'>\n";
    print "<input type='hidden' name='vsAP' value='$activePage'>\n";
    print "<input type='hidden' name='vsSORT' value='$sortField'>\n";
    print "<input type='hidden' name='vsCOM' value='UPDATE'>\n";
    print "<input type='submit' value='Update'>\n";
    print "<input style=\"COLOR: maroon;\" type='reset' value='Delete'  onclick=\"if (confirm('Permenantly delete this task?')) {self.location='$scriptName?pagename=$pagename&vsSORT=$sortField&vsAP=$activePage&vsSC=$showCompleted&vsCOM=DELETE&vsID=" . $objMyDB->FieldValue("ID") . "';return false;} else {return false;};\">\n";
    print "<input type='reset' value='Cancel' onclick=\"window.history.go(-1);return false;\">\n";
    print "<p>\n";
}

#_____________________________________________________________________________
sub PrintBlankRecord {
    my ($objMyDB) = shift;
    my ($fieldName);
    print "<table cellspacing='2' cellpadding='2' border='0'>\n";
    foreach $fieldName ($objMyDB->FieldNames) {
        if ($fieldName ne "ID") {
            print "<tr valign='top' bgcolor='$dataLightColor'>\n";
            print "<td><font face='arial' size='2'>" . $fieldName . "</font></td>\n";
            if ($fieldName eq "Complete") {
                print "<td><font face='arial' size='2'>";
                print "<input type=\"radio\" name=\"Complete\" value=\"Yes\">Yes\n";
                print "<input type=\"radio\" name=\"Complete\" value=\"No\" checked>No\n";
                print "</font></td>";
            } elsif ($fieldName eq "Notes") {
                print "<td><textarea name='Notes' cols='38' rows='3'></textarea></td>\n";
            } else {
                print "<td><input size=\"50\" name=\"" . $fieldName . "\" value=\"\"></td>\n";
            }
            print "</tr>\n";
        }
    }
    print "</table>\n";
    print "<p>\n";
    print "<input type='hidden' name='vsSC' value='$showCompleted'>\n";
    print "<input type='hidden' name='vsAP' value='$activePage'>\n";
    print "<input type='hidden' name='vsSORT' value='$sortField'>\n";
    print "<input type='hidden' name='vsCOM' value='INSERT'>\n";
    print "<input type='submit' value='Add'>\n";
    print "<input type='reset' value='Cancel' onclick=\"window.history.go(-1);return false;\">\n";
    print "<p>\n";
}

#_____________________________________________________________________________
sub UpdateCurrentRecord {
    my ($objMyDB) = shift;
    my ($objMyCGI) = shift;
    my ($fieldName,$fieldValue);
    foreach $fieldName ($objMyDB->FieldNames) {
        $fieldValue = $objMyCGI->param($fieldName);
        $objMyDB->FieldValue($fieldName,$fieldValue);
    }
    $objMyDB->Commit;
}

#_____________________________________________________________________________
sub PassThrough {
    my ($fieldName) = shift || return '';
    my ($fieldValue) = shift;
    my (@params) = $objCGI->param;
    my ($appendChar) = "?";
    my ($param) = '';
    my ($queryString) = '';

    foreach $param (@params) {
        unless ($fieldName eq $param) {
            $queryString .= $appendChar . $param . "=" . $objCGI->param($param);
            $appendChar = "&";
        }
    }       

    $queryString .= $appendChar . $fieldName . "=" . $fieldValue;

    return $queryString;    
}

#______________________________________________________________________________
sub CurrentDirectory {
    my ($currentDirectory);
    $currentDirectory = $basedir . $pagename . "/"; 
    return $currentDirectory;
}
sub CurrentDirectory_old {
    my ($currentDirectory);
    if ($ENV{'PATH_TRANSLATED'}) {
        # windows servers need the full path
        my ($scriptPath) = $ENV{'PATH_TRANSLATED'};
        my ($directorySeparator) = "/";
        $currentDirectory = substr($scriptPath,0,rindex($scriptPath,$directorySeparator)) . $directorySeparator . "webpages/vsorg/manny1/";
    } else {
        # everything else works with a relative path
        $currentDirectory = "./webpages/vsorg/manny1/"; 
    }
    return $currentDirectory;
}
