#!/usr/bin/perl -w
# ----------------------------------------------------------------------------
# vsDB.pl DataFile Editor
# Copyright (c) 2001 Jason M. Hinkle. All rights reserved. This script is
# free software; you may redistribute it and/or modify it under the same
# terms as Perl itself.
# For more information see: http://www.verysimple.com/scripts/
#
# LEGAL DISCLAIMER:
# This software is provided as-is.  Use it at your own risk.  The
# author takes no responsibility for any damages or losses directly
# or indirectly caused by this software.
# ----------------------------------------------------------------------------

my $VERSION = "1.3";
# my $basedir="../webpages/vsorg/"; 
my $basedir = "/home/manny/www/vsorg/";

# ----------------------------------------------------------------------------

$|++;
# my $noModList="DetailIcon,ShowFields,FileName,Delimiter,UseFileLocking";
my $noModList="DetailIcon,ShowFields,FileName,Delimiter";
my @noModFields=split(',',$noModList);
my (%noMod);
foreach $fn (@noModFields) {
    $noMod{$fn}=1;
    }

print "Content-type: text/html\n\n";
print "
    <html>
    <head><title>VerySimple Organizer Setup</title></head>
    <body bgcolor='#FFFFFF' link='blue' vlink='blue' alink='blue'>
    <font face='arial' size='2'>
    <table bgcolor='#BBBBBB' border='0' width='100%'><tr><td><b>VerySimple Organizer Setup</b></td></tr></table>
    <p>
";


eval 'use vsDB';
eval 'use CGI';
my ($objCGI) = new CGI;
my ($pagename) = $objCGI->param('pagename');

my ($command) = $objCGI->param('vsCOM') || "";
my ($rowNum) = $objCGI->param('vsRN') || "";
my ($fileName) = $objCGI->param('vsFILE') || "data/calendar.cfg";
my ($delimiter) = $objCGI->param('vsDEL') || "\t";
my ($pageSize) = 10;
my ($activePage) = $objCGI->param('vsAP') || 1;



my ($scriptName) = $ENV{'SCRIPT_NAME'} || "vssetup.pl";
my ($filePath) = &CurrentDirectory . $fileName;

print "<form action='" . $scriptName . "' method='post'>\n";
print "<input type='hidden' name='pagename' value='$pagename'>";
print "<input type='hidden' name='vsFILE' value='" . $fileName . "'>\n";
print "<input type='hidden' name='vsDEL' value='" . $delimiter . "'>\n";
print "<p>\n";
print "<table bgcolor='#DDDDDD' border='1' cellspacing='0' cellpadding='2'><tr>\n";

if ($fileName eq "data/calendar.cfg") {
    print "<td align='center'><font size='2'><b><a href='$scriptName?pagename=$pagename&vsFILE=data/calendar.cfg&vsAP=1&vsDEL=&vsCOM=EDIT&vsRN=1'>Calendar</a></b></font></td>\n";
} else {
    print "<td align='center' bgcolor='#BBBBBB'><font size='2'><a href='$scriptName?pagename=$pagename&vsFILE=data/calendar.cfg&vsAP=1&vsDEL=&vsCOM=EDIT&vsRN=1'>Calendar</a></font></td>\n";
}   
if ($fileName eq "data/contacts.cfg") {
    print "<td align='center'><font size='2'><b><a href='$scriptName?pagename=$pagename&vsFILE=data/contacts.cfg&vsAP=1&vsDEL=&vsCOM=EDIT&vsRN=1'>Contacts</a></b></font></td>\n";
} else {
    print "<td align='center' bgcolor='#BBBBBB'><font size='2'><a href='$scriptName?pagename=$pagename&vsFILE=data/contacts.cfg&vsAP=1&vsDEL=&vsCOM=EDIT&vsRN=1'>Contacts</a></font></td>\n";
}   
if ($fileName eq "data/tasks.cfg") {
    print "<td align='center'><font size='2'><b><a href='$scriptName?pagename=$pagename&vsFILE=data/tasks.cfg&vsAP=1&vsDEL=&vsCOM=EDIT&vsRN=1'>Tasks</a></b></font></td>\n";
} else {
    print "<td align='center' bgcolor='#BBBBBB'><font size='2'><a href='$scriptName?pagename=$pagename&vsFILE=data/tasks.cfg&vsAP=1&vsDEL=&vsCOM=EDIT&vsRN=1'>Tasks</a></font></td>\n";
}   

print "<tr><td colspan='3'>\n";

# default to tab character 
$delimiter = "\t" unless ($delimiter);
my ($objDB) = new vsDB(
    file => $filePath,
    delimiter => $delimiter,
);

if ($fileName) {

    $objDB->Open;

    #$objDB->Sort("ID");
    #$objDB->Commit;

    if ($command eq "EDIT") {
        $objDB->AbsolutePosition($rowNum);
    } elsif ($command eq "UPDATE") {
        $objDB->AbsolutePosition($rowNum);
        UpdateCurrentRecord($objDB,$objCGI);
        #print "<font size='2' color='green'>Updated</font><br>\n";
    }
    PrintCurrentRecord($objDB);
}

print "
    </td></tr></table>
    </form>
    <hr><font size='1'>
    VerySimple Datafile Editor &copy 2001, <a href='http://www.verysimple.com/'>VerySimple</a><br>
";
print "vsDB Module Version " . $objDB->Version;
print "
    </font><p>
    </font>
    </body>
    </html>
";
undef($objDB);

#_____________________________________________________________________________
sub PrintCurrentRecord {
    my ($objMyDB) = shift;
    my ($fieldName, $fieldValue);
    print "<table cellspacing='2' cellpadding='2' border='0'>\n";
    foreach $fieldName ($objMyDB->FieldNames) {
        print "<tr valign='top' bgcolor='#DDDDDD'>\n";
        print "<td><font face='arial' size='2'>" . $fieldName . "</font></td>\n";
        $fieldValue = $objMyDB->FieldValue($fieldName);
        $fieldValue =~ s/\"/&quot;/g;       
        if($noMod{$fieldName}) {
            print "<td>$fieldValue";
            print "<input type='hidden' name='$fieldName' value='$fieldValue'>";
            print "</td>\n";            }
        else {
            print "<td><input size=\"50\" name=\"" . $fieldName . "\" value=\"";
            print $fieldValue . "\"></td>\n";
            }
        print "</tr>\n";
    }
    print "</table>\n";
    print "<p>\n";
    print "<input type='hidden' name='vsFILE' value='$fileName'>\n";
    print "<input type='hidden' name='vsRN' value='" . $objMyDB->AbsolutePosition . "'>\n";
    print "<input type='hidden' name='vsCOM' value='UPDATE'>\n";
    print "<input type='hidden' name='vsAP' value='$activePage'>\n";
    print "<input type='submit' value='Apply'>\n";
    print "<input type='reset' value='Cancel' onclick=\"window.history.go(-1);return false;\">\n";
}


#_____________________________________________________________________________
sub UpdateCurrentRecord {
    my ($objMyDB) = shift;
    my ($objMyCGI) = shift;
    my ($fieldName,$fieldValue);
    foreach $fieldName ($objMyDB->FieldNames) {
        $fieldValue = $objMyCGI->param($fieldName);
        $objMyDB->FieldValue($fieldName,$fieldValue);
    }
    $objMyDB->Commit;
}

#______________________________________________________________________________
sub CurrentDirectory {
    my ($currentDirectory);
    $currentDirectory = $basedir . $pagename . "/"; 
    return $currentDirectory;
}
sub CurrentDirectory_old {
    my ($currentDirectory);
    if ($ENV{'PATH_TRANSLATED'}) {
        # windows servers need the full path
        my ($scriptPath) = $ENV{'PATH_TRANSLATED'};
        my ($directorySeparator) = "/";
        $currentDirectory = substr($scriptPath,0,rindex($scriptPath,$directorySeparator)) . $directorySeparator . "webpages/vsorg/manny1/";
    } else {
        # everything else works with a relative path
        $currentDirectory = "./webpages/vsorg/manny1/"; 
    }
    return $currentDirectory;
}
