#!/usr/bin/perl -w
# ----------------------------------------------------------------------------
# vsDB.pl DataFile Editor
# Copyright (c) 2001 Jason M. Hinkle. All rights reserved. This script is
# free software; you may redistribute it and/or modify it under the same
# terms as Perl itself.
# For more information see: http://www.verysimple.com/scripts/
#
# LEGAL DISCLAIMER:
# This software is provided as-is.  Use it at your own risk.  The
# author takes no responsibility for any damages or losses directly
# or indirectly caused by this software.
# 
# Version History
# 1.5.4 - 10/02/01 - fixed bug in direct link
# 1.5.3 - 10/02/01 - added direct link to event & show/hide details
# 1.5.2 - 08/22/01 - added file locking
# ----------------------------------------------------------------------------
my $VERSION = "1.5.4";
# my $basedir="../webpages/vsorg/"; 
my $basedir = "/home/manny/www/vsorg/";

# ----------------------------------------------------------------------------

# $|++;
print "Content-type: text/html\n\n";
eval 'use vsLock';
eval 'use vsDB';
eval 'use CGI';
my ($objCGI) = new CGI;
my ($pagename) = $objCGI->param('pagename');

# --- get the configuration settings 
my ($configFilePath) = &CurrentDirectory . "data/calendar.cfg";
my ($objConfig) = new vsDB(
    file => $configFilePath,
    delimiter => "\t",
);

$objConfig->Open;
my ($title) = $objConfig->FieldValue("Title");
my ($bodyTag) = $objConfig->FieldValue("BodyTag");
my ($headerColor) = $objConfig->FieldValue("HeaderColor");
my ($dataDarkColor) = $objConfig->FieldValue("DataDarkColor");
my ($dataLightColor) = $objConfig->FieldValue("DataLightColor");
my ($dataDayColor) = $objConfig->FieldValue("DataDayColor");
my ($dataHighlightColor) = $objConfig->FieldValue("DataHighlightColor");
my ($detailIcon) = $objConfig->FieldValue("DetailIcon");
my ($fileName) = $objConfig->FieldValue("FileName") || "calendar.tab";
my ($delimiter) = $objConfig->FieldValue("Delimiter") || "\t";
my ($useFileLocking) = $objConfig->FieldValue("UseFileLocking") || 0;
$objConfig->Close;
undef($objConfig);
# -- end config

my ($filePath) = &CurrentDirectory . $fileName;

# print the header
print "
    <html>
    <head><title>$title</title></head>
    $bodyTag
    <font face='arial' size='2'>
    <table bgcolor='$headerColor' border='0' width='100%'><tr><td><b>$title</b></td></tr></table>
    <p>
";

my ($scriptName) = $ENV{'SCRIPT_NAME'} || "vscalend.pl";
my @dateArray = localtime(time);
my ($month) = $objCGI->param('vsMonth') || $dateArray[4]+1;
my ($year) = $objCGI->param('vsYear') || $dateArray[5]+1900;
my ($day) = $objCGI->param('vsDay') || $dateArray[3];
my ($command) = $objCGI->param('vsCOM') || "";
my ($id) = $objCGI->param('vsID') || "";
my ($showDefault) = 0;

my ($showDayDetails) = $objCGI->param('vsSD') || 0;
my ($noShowDayDetails) = 1;
my ($cellSize) = 25;
$cellSize = 60 if ($showDayDetails);
$noShowDayDetails = 0 if ($showDayDetails);

my ($nmonth, $nyear, $pmonth, $pyear, $highlightDate);

my ($objDB) = new vsDB(
    file => $filePath,
    delimiter => $delimiter,
);

# lock the datafile 
my ($objLock) = new vsLock(-'warn' => 1, -max => 5, delay => 1);
if ($useFileLocking) {
    $objLock->lock($filePath) || die "Couldn't Lock Datafile";
}

if (!$objDB->Open) {print $objDB->LastError;$objLock->unlock($filePath);die;};


# show the default screen if specified

# figure out following month & year    
$nmonth = $month + 1;
$nyear  = $year;
if ($nmonth > 12) {
    $nmonth = 1;
    $nyear++;
}
# figure out previous month & year    
$pmonth = $month - 1;
$pyear  = $year;
if ($pmonth < 1) {
    $pmonth = 12;
    $pyear--;
}
$highlightDate = $year . "." . $month . "." . $day;

# --------- Main Logic --------------
if ($command eq "UPDATE") {
    $objDB->Filter("ID","eq",$id);
    UpdateCurrentRecord($objDB,$objCGI);
    $objDB->RemoveFilter;
    $objDB->MoveFirst;
} elsif ($command eq "DELETE") {
    $objDB->Filter("ID","eq",$id);
    $objDB->Delete;
    $objDB->Commit;
    $objDB->RemoveFilter;
    $objDB->MoveFirst;
} elsif ($command eq "INSERT") {
    $objDB->AddNew;
    my ($newId) = $objDB->Max("ID") || 0;
    $newId = int($newId) + 1;
    $objDB->FieldValue("ID",$newId);
    UpdateCurrentRecord($objDB,$objCGI);
    $objDB->MoveFirst;
}

if ($useFileLocking) {
    $objLock->unlock($filePath);
}

# ----------- print everything to the browser ---
&PrintDefault;

# --- print the html footer ---
print "
    </form>
    <hr><font size='1'>
    VerySimple Calendar $VERSION &copy 2001, <a href='http://www.verysimple.com/'>VerySimple</a><br>
";
print "vsDB Module Version " . $objDB->Version . "<br>";
print "vsLock Module Version " . $objLock->Version;
print "
    </font><p>
    </font>
    </body>
    </html>
";
undef($objDB);
undef($objLock);
undef($objCGI);


# _____________________________________________________________________________
sub PrintDefault {
    print "<table cellspacing='0' cellpadding=10' border='0'><tr valign='top'>\n";
    print "<td>\n";
    print "<font size='2' face='arial,helvetica'>\n";

    &PrintMonth($month,$year,$objDB,$highlightDate);
    if (!$showDayDetails) {
        &PrintMonth($nmonth,$nyear,$objDB,$highlightDate);
    }

    print "<p>\n";
    print "<a href='$scriptName?pagename=$pagename&vsSD=$showDayDetails&vsMonth=$pmonth&vsYear=$pyear'>Previous Month</a>\n";
    print "| <a href='$scriptName?pagename=$pagename&vsSD=$showDayDetails&vsMonth=$nmonth&vsYear=$nyear'>Next Month</a>\n";

    print "</font>\n";
    print "</td><td>\n";
    print "<font size='2' face='arial,helvetica'>\n";

    &PrintDay($year,$month,$day,$objDB);

    print "<p>\n";    
    if ($command eq "EDIT") {
    $objDB->Filter("ID","eq",$id);
    PrintCurrentRecord($objDB);
    } else {
    PrintBlankRecord($objDB);
    }    
    print "</font>\n";
    print "</td>\n";
    print "</tr></table>\n";
}

# _____________________________________________________________________________
sub PrintDay {
    my $year = shift || return 0 ;
    my $month = shift || return 0 ;
    my $day = shift || return 0 ;
    my $objMyDb = shift || return 0;

    my $thisDate = "$year.$month.$day";
     
    # my @days = ('Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday');
    my @months = ('January','February','March','April','May','June','July','August','September','October','November','December');

    $objMyDb->RemoveFilter; 
    $objMyDb->Filter("DATE","eq",$thisDate);

    print "<table border='1' cellspacing='0' cellpadding='2' width='350' bgcolor='$dataHighlightColor'>\n";
    print "<font size='2' face='arial,helvetica'><b>Details For $months[$month-1] $day, $year </b></font><br>\n";
    print "<tr><td width='25'>&nbsp;</td>\n";
    print "<td width='75'><font size='2' face='arial,helvetica'><b>Time</b></font></td>\n";
    print "<td width='250'><font size='2' face='arial,helvetica'><b>Event</b></font></td></tr>\n";

    while (!$objMyDb->EOF) {
    print "<tr><td><a href='$scriptName?pagename=$pagename&vsSD=$showDayDetails&vsCOM=EDIT&vsMonth=$month&vsYear=$year&vsDay=$day&vsID=" . $objMyDb->FieldValue("ID") . "'><img src='/vsorg/$detailIcon' border='0'></a></td>";
    print "<td><font size='2' face='arial,helvetica'>" . $objMyDb->FieldValue("TIME") . "&nbsp;</font></td>";
    print "<td><font size='2' face='arial,helvetica'>" . $objMyDb->FieldValue("EVENT") . "&nbsp;</font></td></tr>\n";
    $objMyDb->MoveNext;
    }

    print "</table>\n";
    # print "<p><font size='2' face='arial,helvetica'><a href='$scriptName?pagename=$pagename&vsCOM=ADD&vsMonth=$month&vsYear=$year&vsDay=$day'>Add New Event</a></font>\n";
}    

# _____________________________________________________________________________
sub PrintMonth {

    my $month = shift || 1;
    my $year = shift || 2001;
    my $objMyDb = shift || return 0;
    
    my ($firstDay,$numDays,$numWeeks) = &GetMonthInfo($month,$year);

    my @days = ('Su','M','Tu','W','Th','F','Sa');
    my @months = ('January','February','March','April','May','June','July','August','September','October','November','December');
    my $temp;
    my $dayCount = 0;
    my $weekDayCount = 0;
    my $thisDate;
    my $style;
    
    my @dateArray = localtime(time);
    $dateArray[5]+=1900;
    $dateArray[4]+=1;
    my $today = $dateArray[5] . "." . $dateArray[4] . "." . $dateArray[3];

    my $highlightDate = shift || $today;

    print "<p>\n";
    print "<font face='arial,helvetica' size='2'><b>$months[$month-1] $year</b></font>\n";
    if ($showDayDetails) {
        print " <font size='1'>[<a href='$scriptName?pagename=$pagename&vsSD=0&vsMonth=$month&vsYear=$year'>Hide Details</a>]</font>\n"
    } else {
        print " <font size='1'>[<a href='$scriptName?pagename=$pagename&vsSD=1&vsMonth=$month&vsYear=$year'>Show Details</a>]</font>\n"
    }       
    print "<table border='1' cellspacing='0' cellpadding='2'>\n";

    
    # print the days of the week 
    print "<tr>\n";
    foreach $temp (@days) {
    print "<td bgcolor='$dataDarkColor'><font face='arial,helvetica' size='2'><b>$temp</b></font></td>";
    }    
    print "</tr>\n";



    for ($cellCount=1;$cellCount <= $numWeeks; $cellCount++) {
    print "<tr valign='top'>\n";
    foreach $temp (@days) {
        if (($dayCount > $firstDay-1) && ($weekDayCount < $numDays)) {
        $weekDayCount++;

        $thisDate = $year . "." . $month . "." . $weekDayCount;

        if ($thisDate eq $highlightDate) {
            print "<td width='$cellSize' height='$cellSize' bgcolor='$dataHighlightColor'><font face='arial,helvetica' size='2'>";
        } else {
            print "<td width='$cellSize' height='$cellSize'><font face='arial,helvetica' size='2'>";
        }
        
        if ($thisDate eq $today) {
            $style = "style=\"color:$dataDayColor\"";
        } else {
            $style = "";
        }           

        $objMyDb->RemoveFilter; 
        $objMyDb->Filter("DATE","eq",$thisDate);

        if ($objMyDb->EOF) {
            print "<a $style href='$scriptName?pagename=$pagename&vsSD=$showDayDetails&vsMonth=$month&vsYear=$year&vsDay=$weekDayCount'>$weekDayCount</a><br>";
        } else {
            print "<b><a $style href='$scriptName?pagename=$pagename&vsSD=$showDayDetails&vsMonth=$month&vsYear=$year&vsDay=$weekDayCount'>$weekDayCount</a></b><br>";
        }           

        if ($showDayDetails) {
            print "<font size='1'>";
            while (!$objMyDb->EOF) {
            print "<a href='$scriptName?pagename=$pagename&vsSD=$showDayDetails&vsCOM=EDIT&vsMonth=$month&vsYear=$year&vsDay=$weekDayCount&vsID=" . $objMyDb->FieldValue("ID") . "'>" .$objMyDb->FieldValue("EVENT") . "</a><br>";
            $objMyDb->MoveNext;
            }
            print "</font>";
        }
        
        # if ($thisDate eq $today) {print "*"}

        print "</font></td>\n";
        } else {
        print "<td bgcolor='$dataLightColor'><font face='arial,helvetica' size='1'>&nbsp;</font></td>\n";
        }
        
        $dayCount++;
    }    
    print "</tr>\n";
    }    
    print "</table>\n";
}


# _____________________________________________________________________________
sub GetMonthInfo {

    my $month = shift || 1;
    my $year = shift || 2001;

    my($firstDow,$numDays);

    require Time::Local;

    # convert user input into approp format for proc4essing
    --$month;
    $year -= 1900;

    # figure out following month & year    
    my $nmonth = $month + 1;
    my $nyear  = $year;
    if ($nmonth > 11) {
    $nmonth = 0;
    $nyear++;
    }

    # ready to grab first day of the month (0 based array)
    $firstDow  = (localtime(Time::Local::timelocal(0,0,0,1,$month,$year)))[6];
    # numDays is one day prior to 1st of month after
    $numDays = (localtime(Time::Local::timelocal(0,0,0,1,$nmonth,$nyear) - 60*60*24))[3];

    # figure out the number of weeks the month spans across
    my $numWeeks = ($numDays + $firstDow) / 7;
    $numWeeks = int($numWeeks) + 1 unless ($numWeeks == int($numWeeks));

    return ($firstDow,$numDays, $numWeeks);
}


#_____________________________________________________________________________
sub PrintCurrentRecord {
    my ($objMyDB) = shift;
    my ($fieldName, $fieldValue);
    print "<form action='$scriptName' method='post'>\n";
    print "<input type='hidden' name='pagename' value='$pagename'>";
    print "<p>\n";
    print "<b>Update This Event:</b><br>\n";
    print "<table cellspacing='2' cellpadding='2' border='0'>\n";
    foreach $fieldName ($objMyDB->FieldNames) {
        if ($fieldName eq "ID") {
            print "<input type='hidden' name='vsID' value='" . $objMyDB->FieldValue("ID") . "'>\n";
        } elsif ($fieldName eq "DATE") {
            print "<input type='hidden' name='DATE' value='" . $objMyDB->FieldValue("DATE") . "'>\n";
        } elsif ($fieldName eq "DETAILS") {
            print "<tr valign='top' bgcolor='#DDDDDD'>\n";
            print "<td><font face='arial' size='2'>" . $fieldName . "</font></td>\n";
            print "<td><textarea name='DETAILS' cols='30' rows='3'>";
            $fieldValue = $objMyDB->FieldValue($fieldName);
            $fieldValue =~ s/\"/&quot;/g;       
            print $fieldValue . "</textarea></td>\n";
            print "</tr>\n";
        } else {
            print "<tr valign='top' bgcolor='#DDDDDD'>\n";
            print "<td><font face='arial' size='2'>" . $fieldName . "</font></td>\n";
            print "<td><input size=\"40\" name=\"" . $fieldName . "\" value=\"";
            $fieldValue = $objMyDB->FieldValue($fieldName);
            $fieldValue =~ s/\"/&quot;/g;       
            print $fieldValue . "\"></td>\n";
            print "</tr>\n";
        }
    }
    print "</table>\n";
    print "<p>\n";
    print "<input type='hidden' name='vsSD' value='$showDayDetails'>\n";
    print "<input type='hidden' name='vsDay' value='$day'>\n";
    print "<input type='hidden' name='vsMonth' value='$month'>\n";
    print "<input type='hidden' name='vsYear' value='$year'>\n";
    print "<input type='hidden' name='vsCOM' value='UPDATE'>\n";
    print "<input type='submit' value='Update'>\n";
    print "<input type='submit' value='Delete' onclick=\"if (confirm('Delete This Record?')) {self.location='$scriptName?pagename=$pagename&vsCOM=DELETE&vsMonth=$month&vsYear=$year&vsDay=$day&vsID=" . $objMyDB->FieldValue("ID") . "';return false;} else {return false;};\">\n";
    print "<input type='reset' value='Cancel' onclick=\"window.history.go(-1);return false;\">\n";
    print "</form>\n";
}   

#_____________________________________________________________________________
sub PrintBlankRecord {
    my ($objMyDB) = shift;
    my ($fieldName);
    print "<form action='$scriptName' method='post'>\n";
    print "<input type='hidden' name='pagename' value='$pagename'>";
    print "<p>\n";
    print "<b>Add An Event For This Day:</b><br>\n";
    print "<table cellspacing='2' cellpadding='2' border='0'>\n";
    print "<input type='hidden' name='DATE' value='$year.$month.$day'>\n";
    foreach $fieldName ($objMyDB->FieldNames) {
        if ($fieldName eq "DETAILS") {
            print "<tr valign='top' bgcolor='#DDDDDD'>\n";
            print "<td><font face='arial' size='2'>DETAILS</font></td>\n";
            print "<td><textarea name='DETAILS' cols='30' rows='3'></textarea></td>\n";
            print "</tr>\n";
        } elsif ($fieldName ne "ID" && $fieldName ne "DATE") {
            print "<tr valign='top' bgcolor='#DDDDDD'>\n";
            print "<td><font face='arial' size='2'>" . $fieldName . "</font></td>\n";
            print "<td><input size=\"40\" name=\"" . $fieldName . "\" value=\"\"></td>\n";
            print "</tr>\n";
        }
    }
    print "</table>\n";
    print "<p>\n";
    print "<input type='hidden' name='vsSD' value='$showDayDetails'>\n";
    print "<input type='hidden' name='vsDay' value='$day'>\n";
    print "<input type='hidden' name='vsMonth' value='$month'>\n";
    print "<input type='hidden' name='vsYear' value='$year'>\n";
    print "<input type='hidden' name='vsCOM' value='INSERT'>\n";
    print "<input type='submit' value='Add'>\n";
    print "<input type='reset' value='Cancel' onclick=\"window.history.go(-1);return false;\">\n";
    print "<p>\n";
}

#_____________________________________________________________________________
sub UpdateCurrentRecord {
    my ($objMyDB) = shift;
    my ($objMyCGI) = shift;
    my ($fieldName,$fieldValue);
    foreach $fieldName ($objMyDB->FieldNames) {
        $fieldValue = $objMyCGI->param($fieldName);
        $objMyDB->FieldValue($fieldName,$fieldValue);
    }
    $objMyDB->Commit;
}

#______________________________________________________________________________
sub CurrentDirectory {
    my ($currentDirectory);
    $currentDirectory = $basedir . $pagename . "/"; 
    return $currentDirectory;
}
sub CurrentDirectory_old {
    my ($currentDirectory);
    if ($ENV{'PATH_TRANSLATED'}) {
        # windows servers need the full path
        my ($scriptPath) = $ENV{'PATH_TRANSLATED'};
        my ($directorySeparator) = "/";
        $currentDirectory = substr($scriptPath,0,rindex($scriptPath,$directorySeparator)) . $directorySeparator . "webpages/vsorg/manny1/";
    } else {
        # everything else works with a relative path
        $currentDirectory = "./webpages/vsorg/manny1/"; 
    }
    return $currentDirectory;
}
