#!/usr/bin/perl
# 
# eznewspg.pl - EZ NewsPage Generator - by Manny Juan <manny@jps.net> 2/23/2002
# http://mannyjuan.com/newscrol
#
#
# This will give your visitors the opportunity to set up a NewsPage on your site.
# the generated NewsPage uses newscroller.cgi from UPOINT dotNET (www.upoint.net/cgiscripts.updn)
# this script was written by manny juan to generated news pages that are powered by
# a special version of newscroller.cgi
#
#####################################################################################
$SIG{__DIE__} = \&Error_Msg;

sub Error_Msg {
    $msg = "@_";
    print "\ncontent-type: text/html\n\n";
    print "The following error occurred : $msg\n";
    exit;
}

# Get the input
read(STDIN, $input, $ENV{'CONTENT_LENGTH'});

    # split the input
    @pairs = split(/&/, $input);

    # split the name/value pairs
    foreach $pair (@pairs) {

    ($name, $value) = split(/=/, $pair);

    $name =~ tr/+/ /;
    $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    if (".header.title_front.title_back.font.font_short" =~ /\.$name/) {
        # do nothing
        }
    else {
        $value =~ s/<([^>]|\n)*>//g;
        }

    $FORM{$name} = $value;
    }
$gSalt = "a1Mj";

######################################################################################
# set variables HERE
$win95=0;
$cgiurl = "http://mannyjuan.com/cgi-bin";
$baseurl = "http://mannyjuan.com/newscrol";
$basedir = "/home/manny/www/newscrol";
# $cgiurl = "http://127.0.0.1/cgi-bin";
# $baseurl = "http://127.0.0.1/newscrol";
# $basedir = "../webpages/newscrol";

# This is a URL and dir for the images sub directory in the userpages directory.
# Create the images directory in the userpages directory. This is where
# you will upload your background images
$imageurl = "/newscrol";

# This is the index of all generated pages
# This file should be chmod to 777 and placed in the userpages directory
$indexpage = "$basedir/index.html";

# This is the location of the data.txt file. This holds each user's
# login name and e-mail address for confirmation
$data = "$basedir/data.txt";

#Site title

$title="Easy NewsPage Generator";

# self explanatory variables for your site logo
$logo = "$imageurl/mjmall.jpg";
$logoalt = "Easy NewsPage Maker";

# Location of the sendmail program
$sendmail = '/usr/sbin/sendmail';

# Your e-mail address here
$myemail = 'manny@jps.net';

# That's it.

# DO NOT CHANGE ANYTHING BELOW THIS LINE
######################################################################################

# Lets do some translating first
$updact = $FORM{'updact'};
$usrname = $FORM{'usrname'};
$login = $FORM{'login'};
$email = $FORM{'email'};
$password = $FORM{'password'};
$pwdagain = $FORM{'pwdagain'};
$cfgpwd = $FORM{'cfgpwd'};
$hint = $FORM{'hint'};
$retlink=$FORM{'retlink'};
$sitename=$FORM{'sitename'};
$popupbgcolor=$FORM{'popupbgcolor'};

# If the user tries to add more than one word in
# the page name field, this will put an underscore
# in the spaces to make it one word
$login =~ s/\W//g;


if ($FORM{'action'} eq "New NewsPage") {
    &newpage;
    }
if ($FORM{'action'} eq "Create NewsPage") {
    &create;
    }
if ($FORM{'action'} eq "Edit NewsPage") {
    &confirm("edit");
    }
if ($FORM{'action'} eq "checkuser") {
    &checkuser;
    }
if ($FORM{'action'} eq "recreate") {
    &recreate;
    }
if ($FORM{'action'} eq "Delete NewsPage") {
    &confirm("delete");
    }
if ($FORM{'action'} eq "showhtml") {
    &showhtml;
    }
exit;

sub newpage {

    $retlink="http://";
    $usrname="Webmaster";
    $sitename="";
    $popupbgcolor="white";

    # To avoid any security risks. Take out the HTML tags added when HPM translated
    # the && to: <br><br>. They will be re-translated to: && Once the user updates
    # the page, the: && will be put back to: <br><br>

    # print the edit-page form

    print "content-type: text/html\n\n";
    print "<html><head><title>Create Your Own NewsPage</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\">\n";
    &put_banner;
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
    print "<table width=75% cellspacing=2 cellpadding=2 border=0>\n";
    print "<tr><td width=100% align=left valign=top>\n";
    print "<p><font face=\"Arial, Geneva\"><h2>Create Your Own NewsPage</h2></font></p>\n";
    print "<p>Below is an empty form for you to fill in. The next five fields (<b>bold</b>) are required.\n";
    print "You can edit any part of your page later</p>\n";
    print "<p></p>\n";
    print "<form action=\"$cgiurl/eznewspg.pl\" method=POST>\n";
    print "<input type=hidden name=\"action\" value=\"Create NewsPage\">\n";
    print "<b>Your name:</b><br>\n";
    print "<font size=\"-1\">(will appear in page as link to your email)</font><br>\n";
    print "<input type=text size=40 name=\"usrname\" value=\"$usrname\"><br><br>\n";
    print "<h3>(The next 3 fields will be used for editing)<h3>\n";
    print "<b>Login Id:</b>\n";
    print "<font size=\"-1\">(one word only you should know, used later for editing)</font><br>\n";
    print "<input type=text size=40 name=\"login\" value=\"$login\"><br><br>\n";
    print "<b>Your e-mail:</b>\n";
    print "<font size=\"-1\">(used for editing, will also appear in page)</font><br>\n";
    print "<input type=text size=40 name=\"email\" value=\"$email\"><br><br>\n";
    print "<b>Enter Password:</b>\n";
    print "<font size=\"-1\">(letters and/or numbers, no spaces)</font><br>\n";
    print "<input type=password size=40 name=\"password\" value=\"$password\"><br><br>\n";
    print "<b>Enter Password Again:</b>\n";
    print "<font size=\"-1\">(for verification)</font><br>\n";
    print "<input type=password size=40 name=\"pwdagain\" value=\"$pwdagain\"><br><br>\n";
    print "<b>Hint:</b>\n";
    print "<font size=\"-1\">(for reminding you of your password)</font><br>\n";
    print "<input type=text size=40 name=\"hint\" value=\"$hint\"><br><br>\n";
    print "</td></tr></table>\n";
    &build_form_content;
    print "<P><input type=submit value=\"create page\">\n";
    print "</form>\n";
    print "</body></html>\n";
    }

sub create {
    $pagename=$login;
    # Now, lets do some error checking. Making sure they filled out each field
    # This is pretty low tech now. I'll improve it later
    &missing(missing_name) unless $usrname;
    &missing(missing_email) unless $email;
    &missing(missing_password) unless $password;
    &missing(missing_password_retyped) unless $pwdagain;
    if ($password ne $pwdagain) { &error ("the two password fields entered do not match!"); }

    # if they try to name their page "index" This will stop them
    if (uc($pagename) eq "INDEX") {
        print "content-type: text/html\n\n";
        print "<html><head><title>Error</title></head>\n";
        print "<body>";
        &put_banner;
        print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
        print "<p>You cannot name your page <b>index</b>\n";
        print "Please go back and re-name your page</p>\n";
        print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
        exit;
        }
    # if the user tries to name their page 
    # something that is already taken
    # this should stop them - it's a check for directory-present
    if (-d "$basedir/$pagename") {
        print "content-type: text/html\n\n";
        print "<html><head><title>Error</title></head>\n";
        print "<body>";
        &put_banner;
        print "<p>The page name: <b>$pagename</b>\n";
        print "is already taken.\n";
        print "Please go back and rename your page</p>\n";
        print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
        exit;
        }

    # create the new directory for pagename
    umask(000);  # UNIX file permission junk
    mkdir("$basedir/$pagename", 0777) unless (-d "$basedir/$pagename");     

    $cryptpwd=crypt($password,$gSalt);
    $cfgpwd=$cryptpwd;

    &build_cfg;
    &create_user_index;
    &create_general_file;
    &create_news_file;

    # Write the login name and email address to a separate file for confirmation
    # when they want to edit their page
    open (FILE, ">>$data") || die "I can't open >>$data\n";
    if($win95==0){flock (FILE, 2) or die "can't lock data file\n";}
    print FILE "$login&&$email&&$cryptpwd&&$hint\n";
    close(FILE);


    # Suck the index page, and write the new entry to it
    open(FILE, "$indexpage") || die "I can't open that file $indexpage\n";
    if($win95==0){flock (FILE, 1) or die "can't lock index file\n";}
    @lines = <FILE>;
    close(FILE);
    $sizelines = @lines;

    # Now, re-open the links file, and add the new link
    open(FILE, ">$indexpage") || die "I can't open that file >$indexpage\n";
    if($win95==0){flock (FILE, 2) or die "can't lock index file\n";}

    for ($a = 0; $a <= $sizelines; $a++) {

        $_ = $lines[$a];

        if (/<!--begin-->/) {

            print FILE "<!--begin-->\n";
            print FILE "<p><font face=\"Arial, Geneva\" size=4><a href=\"$baseurl/$pagename/index.html\" target=\"_blank\">$sitename</a></p>\n";

        } else {
            print FILE $_;
            }
        }
    close(FILE);


    # Give the user a response
    print "content-type: text/html\n\n";
    print "<html><head><title>thanks</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\">\n";
    &put_banner;
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
    print "<BR><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";

    print "Your page has been created, and you will receive an e-mail confirming this!\n";
    print "<br><br>You must first activate your newspage by logging in and adding at least one news item:\n";
    print "<br><a href=\"$cgiurl/newscroller.cgi?pagename=$pagename\" target=\"_blank\">login now</a>\n";
    print "<br><br>After closing the news admin window, return here and select this link to view your newspage:\n";
    print "<br><a href=\"$baseurl/$pagename/index.html\">$sitename</a>\n";
    print "<br><br>Thanks for your using EZNEWSPG!\n";
    print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
    print "</body></html>\n";


    # Send the user an e-mail confirming their page
    open (MAIL, "| $sendmail -t") || die "I can't open sendmail\n";
    print MAIL "To: $usrname <$email>\n";
    print MAIL "From: $myemail\n";
    print MAIL "Subject: Your new URL on the $title\n";
    print MAIL "please activate your newspage by logging in and adding at least one news item";
    print MAIL "\n$cgiurl/newscroller.cgi?pagename=$pagename";
    print MAIL "\n\nafter it has been activated, you may view your newspage by clicking below";
    print MAIL "\n$baseurl/$pagename/index.html\n";
    print MAIL "\nHere is your login info - please save for later use";
    print MAIL "\nlogin=$login";
    print MAIL "\nemail=$email";
    print MAIL "\npassword=$password";
    print MAIL "\nhint=$hint";
    print MAIL "\n\nThank you for using the $title\n";
    print MAIL "\n\nThe Mall Manager - $myemail\n";
    close (MAIL);

    # Notify us when someone creates a page
    open (MAIL, "| $sendmail -t") || die "I can't open sendmail\n";
    print MAIL "To: $myemail\n";
    print MAIL "From: $usrname <$email>\n";
    print MAIL "Subject: $title New Page Report\n";
    print MAIL "$usrname created a new page:\n";
    print MAIL "$baseurl/$pagename/index.html\n";
    close(MAIL);

    }
sub create_user_index {
    open (IDXFILE,">$basedir/$pagename/index.html")||die "i can't open >$basedir/$pagename/index.html";
    print IDXFILE <<EOHTML;
<html><body>
<h1>$sitename</h1>
<table><tr><td>EZNEWSPG Scroller</td><td>

<!-- start of scroller html -->
<script language="JavaScript1.2" src="$baseurl/$pagename/scroller.js"></script>
<script language="JavaScript1.2" src="$baseurl/diff_function.js"></script>

<ilayer id="main" width=&{scrollerwidth}; height=&{scrollerheight}; 
bgColor=&{scrollerbgcolor}; background=&{scrollerbackground}; visibility=hide>
<layer id="first" left=0 top=1 width=&{scrollerwidth};>
<script language="JavaScript1.2">
if (document.layers)
document.write(messages[0])
</script>
</layer>
<layer id="second" left=0 top=0 width=&{scrollerwidth}; visibility=hide>
<script language="JavaScript1.2">
if (document.layers)
document.write(messages[1])
</script>
</layer>
</ilayer>
<br><center><font size="-2">powered by <a href="http://www.upoint.net/cgiscripts.updn">\@1&nbsp;newscroller</a>
<br>generated by <a href="http://mannyjuan.com">eznewspg</a></font></center>
<!-- end of scroller html -->

</td></tr></table>

<!-- the code below is for admin only -->
<br><a href="$cgiurl/newscroller.cgi?pagename=$pagename" target="_blank">Update News</a>
<br><a href="$retlink">Return</a>
<form action="$cgiurl/eznewspg.pl" method=POST>
<input type=submit value="Show HTML">
<input type=hidden name="login" value="$pagename">
<input type=hidden name="action" value="showhtml">
</form>
</body></html>
EOHTML
    close(IDXFILE);
    }

sub create_general_file {
    $count=1;      # initialize with minimum required 2 news items;
    ($height_window,$width_window,$f)=split("~","400~500~Verdana, Arial");
    ($height,$width,$pause,$speed,$image_yes,$image_background,$font_h,$size_h,$color_h,$bold_h,$italics_h,$underline_h,$font,$size,$color,$bold,$italics,$underline)
    =split("~","300~200~5000~3~~background1.gif~Verdana, Arial~2~red~Yes~No~No~Verdana, Arial~2~blue~No~Yes~No");
    $gendata="\|\*\|$count\|\*\|\n";
    $gendata.="\|\*\|$height\|\*\|$width\|\*\|$pause\|\*\|$speed\|\*\|$image_yes\|\*\|$image_background\|\*\|$font_h\|\*\|$size_h\|\*\|$color_h\|\*\|$bold_h\|\*\|$italics_h\|\*\|$underline_h\|\*\|$font\|\*\|$size\|\*\|$color\|\*\|$bold\|\*\|$italics\|\*\|$underline\|\*\|\n";
    $gendata.="\|\*\|$height_window\|\*\|$width_window\|\*\|$f\|\*\|\n";
    open (GENFILE,">$basedir/$pagename/general.txt")||die "i can't open >$basedir/$pagename/general.txt";
    print GENFILE $gendata;
    close(GENFILE);
    }

sub create_news_file {
    $newsdata="\|\*\|eznewspg is here\|\*\|\|\*\|\|\*\|\|\*\|\|\*\|Top\|\*\|newscroller has been successfully converted to ez script\|\*\|\|\*\|\n";
    $newsdata.="\|\*\|headline\|\*\|\|\*\|\|\*\|\|\*\|\|\*\|Top\|\*\|short news description\|\*\|\|\*\|\n";
    open (NEWSFILE,">$basedir/$pagename/news.txt")||die "i can't open >$basedir/$pagename/news.txt";
    print NEWSFILE $newsdata;
    close(NEWSFILE);
    }

sub create_empty_table {
    my ($tbname,$fldnames) = @_;
    my (@fn) =split(',',$fldnames);
    open(FILE, ">$tbname") || die "I can't open that file >$tbname\n";
    if($win95==0){flock (FILE, 2) or die "can't lock $tbname\n";}
    print FILE join("\t",@fn) . "\n";
    close FILE;
    }

sub recreate {
    $pagename=$login;
    # Suck the index page, and update site name (in case it changed)
    open(FILE, "$indexpage") || die "I can't open that file $indexpage\n";
    if($win95==0){flock (FILE, 1) or die "can't lock index file\n";}
        @lines = <FILE>;
        close(FILE);
        $sizelines = @lines;

    # Now, re-open the links file, and replace the index entry
    open(FILE, ">$indexpage") || die "I can't open that file >$indexpage\n";
    if($win95==0){flock (FILE, 2) or die "can't lock index file to delete entry\n";}

            for ($a = 0; $a <= $sizelines; $a++) {

            $_ = $lines[$a];

        if (/\/$pagename\/index.html/) {
            print FILE "<p><font face=\"Arial, Geneva\" size=4><a href=\"$baseurl/$pagename/index.html\" target=\"_blank\">$sitename</a></font></p>\n";
          } 
        else {
          print FILE $_;
           }
        }
    close(FILE);

    #now, lets create our new html page
    # recreate the user's config and index file
    &build_cfg;

    &create_user_index;
#    &create_general_file;
#    &create_news_file;
    &ntfy_usr_edt;

    # Give the user a response
    print "content-type: text/html\n\n";
    print "<html><head><title>thanks</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\">\n";
    &put_banner;
    print "<CENTER><IMG SRC=\"$logo\" alt=\"$logoalt\" border=0></CENTER>\n";
    print "<P><BR><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";
    print "Your page has been revised, and you will receive an e-mail confirming this!\n";
    print "Your URL is: <a href=\"$baseurl/$pagename/index.html\">\n";
    print "$baseurl/$pagename/index.html</a>\n";
    print "Remember to press Reload.\n";
    print "Thanks for your participation!\n";
    print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
    print "</body></html>\n";
    }

sub build_cfg {
    # create the config file
    open (CFGFILE,">$basedir/$pagename/mynews.cfg")||die "i can't open >$basedir/$pagename/mynews.cfg";
    print CFGFILE "$usrname&&$email&&$sitename&&$popupbgcolor&&$retlink&&$cfgpwd";
    close(CFGFILE);
    }

sub ntfy_usr_edt {
    # Send the user a notice that their page has been re-done
    open (MAIL, "| $sendmail -t") || die "I can't open sendmail\n";
    print MAIL "To: $usrname <$email>\n";
    print MAIL "From: $myemail\n";
    print MAIL "Subject: Your Changes on the $title\n";
    print MAIL "Your revised page can be viewed at the URL below:\n";
    print MAIL "\n";
    print MAIL "$baseurl/$pagename/index.html\n";
    print MAIL "\nOnce again thank you for using the $title\n";
    print MAIL "\n\nThe Mall Manager\n";
    close (MAIL);
    }

# Standard error message for any missing required fields
sub missing {
    local ($missing) = @_;
    print "content-type: text/html\n\n";

    print "<HTML><head><TITLE>You missed something</TITLE></head>\n";
    print "<body>\n";
    &put_banner;    
    print "You forgot to fill in one of the fields. Please go back and make\n";
    print "sure that all required fields are filled in! $missing\n";
    print "</body></HTML>\n";
    exit;
    }

sub confirm {
    local ($updact) = @_;

    print "content-type: text/html\n\n";
    print "<html><head><title>$updact Confirmation</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\" >\n";
    &put_banner; 
    print "<CENTER><IMG SRC=\"$logo\" alt=\"$logoalt\"  border=0></CENTER>\n";
    print "<P><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";
    print "<p><h3>Please Enter your login name, e-mail and password in order to $updact</h3></p>\n";
    print "<form action=\"$cgiurl/eznewspg.pl\" method=POST>\n";
    print "<P><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";
    print "Login name:<br>\n";
    print "<input size=40 type=text name=\"login\"><br><br>\n";
    print "E-mail:<br>\n";
    print "<input size=40 type=text name=\"email\"><br><br>\n";
    print "Password:<br>\n";
    print "<input type=password size=40 name=\"password\"><br><br>\n";
    print "<input type=submit value=submit>\n";
    print "<input type=hidden name=\"action\" value=\"checkuser\">\n";
    print "<input type=hidden name=\"updact\" value=\"$updact\">\n";
    print "</FONT>\n";
    print "</form></body></html>\n";
    }

sub checkuser {
    open(FILE, "$data") || die "I can't open $data\n";  
    if($win95==0){flock (FILE, 1) or die "can't lock data file\n";}

    while(<FILE>) {
    chop;       
    @all = split(/\n/);

    foreach $line (@all) {
    ($loginname, $loginemail, $loginpassword, undef) = split(/&&/, $line);
    if($loginname eq "$login" && $loginemail eq "$email" && $loginpassword eq crypt($password,$gSalt)) {
        $match = 1;
        if($updact eq "edit") {
          &edit($login);
          }
        else {
          &delpage($login);
          }
        }
      }
    }

    close(FILE);

    if (! $match) {
        &denied;
        }

    # del entry from data
    if($updact eq "delete") {

        # Suck the index page, and write the new entry to it
        open(FILE, "$data") || die "I can't open that file $data\n";
        if($win95==0){flock (FILE, 1) or die "can't lock data file\n";}
            @lines = <FILE>;
            close(FILE);
            $sizelines = @lines;

        # Now, re-open the links file, and comment out the page to delete
        open(FILE, ">$data") || die "I can't open that file >$data\n";
        if($win95==0){flock (FILE,2) or die "can't lock index file for append\n";}
        chop;
                for ($a = 0; $a <= $sizelines; $a++) {
                $_ = $lines[$a];
                $w = $_;
                $w =~ s/\cM//g;
                $w =~ s/\n//g;
        ($loginname, $loginemail, $loginpassword) = split(/&&/, $w);
        if($loginname eq "$login" && $loginemail eq "$email" && $loginpassword eq crypt($password,$gSalt)) {
              # do nothing  (ie. don't write)
              } 
            else {
              if($w eq "") {
                # do nothing (skip)
                }
              else {
                print FILE "$w\n";
                }
              }
            }
        close(FILE);
        print "content-type: text/html\n\n";
        print "<html><head><title>$updact Confirmation</title></head>\n";
        print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\" >\n";
        &put_banner; 
        print "<CENTER><IMG SRC=\"$logo\" alt=\"$logoalt\" border=0></CENTER>\n";
        print "<P><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";
        print "<p>your page has been deleted";
        print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
        print "</form></body></html>\n";
      }
    }

sub edit {
    local ($pagename)= @_;
    # get the config file
    open(CFGFILE, "$basedir/$pagename/mynews.cfg") || die "I can't open $basedir/$pagename/mynews.cfg\n";
    if($win95==0){flock (CFGFILE, 1) or die "can't lock data file for edit\n";}
    $txrec=<CFGFILE>;
($usrname,$email,$sitename,$popupbgcolor,$retlink,$cfgpwd)=split('&&',$txrec);
    &build_edit_form;
    close(CFGFILE);
    }

sub delpage {
    local ($pagename) = @_;
    &deltree(0,"$basedir/$pagename");

    # Suck the index page, and store entries in array
    open(FILE, "$indexpage") || die "I can't open that file $indexpage\n";
    if($win95==0){flock (FILE, 1) or die "can't lock index file\n";}
        @lines = <FILE>;
        close(FILE);
        $sizelines = @lines;

    # Now, recreate the page but do not write the deleted page
    open(FILE, ">$indexpage") || die "I can't open that file >$indexpage\n";
    if($win95==0){flock (FILE, 2) or die "can't lock index file to delete entry\n";}
        for ($a = 0; $a <= $sizelines; $a++) {
        $_ = $lines[$a];
        if (/\/$pagename\/index.html/) {
          # do nothing  (ie. don't write)
          } 
        else {
          print FILE $_;
           }
        }
    close(FILE);

    # Suck the users page, and store entries in array
    open(FILE, "$data") || die "I can't open that file $data\n";
    if($win95==0){flock (FILE, 1) or die "can't lock $data\n";}
        @lines = <FILE>;
        close(FILE);
        $sizelines = @lines;

    # Now, recreate the page but do not write the deleted page
    open(FILE, ">$data") || die "I can't open that file >$data\n";
    if($win95==0){flock (FILE, 2) or die "can't lock users file to delete entry\n";}
        for ($a = 0; $a <= $sizelines; $a++) {
        $_ = $lines[$a];
        if (/pagename=$pagename/) {
          # do nothing  (ie. don't write)
          } 
        else {
          print FILE $_;
           }
        }
    close(FILE);
    }

sub deltree {
    local ($lvl, $dir) = @_;
    local @tnlist;
    opendir (TN, "$dir");
    rewinddir (TN);
    @tnlist =  grep(!/^\.\.?$/, readdir (TN));
    closedir (TN);
    foreach $tn (@tnlist) {
        if (-d "$dir/$tn") {
            $lvl++;
            &deltree($lvl,"$dir/$tn" );
            $lvl--;
            }
        else {
            $cnt=unlink("$dir/$tn");
#            print "<br>deleting $dir/$tn";
            }
        }
    rmdir ("$dir");
#    print "<br>removing $dir";
    }

sub build_edit_form {
    # To avoid any security risks. Take out the HTML tags added when HPM translated
    # the && to: <br><br>. They will be re-translated to: && Once the user updates
    # the page, the: && will be put back to: <br><br>

    # print the edit-page form

    print "content-type: text/html\n\n";
    print "<html><head><title>Edit Your Page</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\">\n";
    &put_banner; 
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
    print "<table width=75% cellspacing=2 cellpadding=2 border=0>\n";
    print "<tr><td width=100% align=left valign=top>\n";
    print "<p><font face=\"Arial, Geneva\"><h2>Edit Your NewsPage</h2></font></p>\n";
    print "<p>Below is a form with the contents\n";
    print "of the NewsPage you created. You can edit any part of your page</p>\n";
    print "<p></p>\n";
    print "<form action=\"$cgiurl/eznewspg.pl\" method=POST>\n";
    print "<input type=hidden name=\"action\" value=\"recreate\">\n";
    print "<input type=hidden name=\"login\" value=\"$login\">\n";
    print "Your name:<br>\n";
    print "<input type=text size=40 name=\"usrname\" value=\"$usrname\"><br><br>\n";
    print "Your e-mail:<br>\n";
    print "<input type=text size=40 name=\"email\" value=\"$email\"><br><br>\n";
    print "</td></tr></table>\n";
    &build_form_content;
    print "<P><input type=submit value=\"update page\">\n";
    print "</form>\n";
    print "</body></html>\n";
    }

sub build_form_content {
    print "<br><b>Title of your NewsPage:</b>&nbsp;(eg. Jean and Lee's NewsPage)";
    print "<br><input type=text size=40 name=\"sitename\" value=\"$sitename\"><br>\n";
    print "<br><b>Initial Background color of Popup Window:</b>&nbsp;(eg. teal, #ffcc00)";
    print "<br><input type=text size=40 name=\"popupbgcolor\" value=\"$popupbgcolor\"><br><br>\n";
    print "\n<p><b>Return Link (URL):</b>&nbsp;&nbsp;link here when user clicks Return<br>\n";
    print "<input type=text size=50 name=\"retlink\" value=\"$retlink\"><br><br>\n";
    print "<input type=hidden name=\"cfgpwd\" value=\"$cfgpwd\">\n";
    }

sub put_optvar  {
    local ($optvar, $id, $value)=@_;
    print "\n<OPTION VALUE=\"$value\"";
    if ($optvar eq $value) {print " SELECTED";}
    print ">$id";
    }
sub put_clropt  {
    local ($colorset, $id, $colors)=@_;
    print "\n<OPTION VALUE=\"$colors\"";
    if ($colorset eq $colors) {print " SELECTED";}
    print ">$id";
    }

sub prt_ckb {
    local ($var, $varname, $ckbdesc) = @_;
    print "\n<tr><td><INPUT TYPE=\"CHECKBOX\" NAME=\"$varname\" VALUE=\"1\"";
    if ($var eq "1") {print " CHECKED";} 
    print "></td>";
    print "<td>$ckbdesc</td></tr>";
    }

sub denied {
    local ($updact) = @_;
    print "content-type: text/html\n\n";
    print "<html><head><title>Permission Denied</title></head>\n";
    print "<body>\n";
    &put_banner; 
#    print "$loginname, $loginemail, $loginpassword";
#    print "<br>$login, $mail, $password";

    print "<p><h1>Permission Denied</h1></p>\n";
    print "You do not have permission to $updact\n";
    print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
    print "</body></html>\n";
    exit;
    }

sub error {
    local ($msg) = @_;
    print "content-type: text/html\n\n";
    print "<html><head><title>Error</title></head>\n";
    print "<body>";
    &put_banner;
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
    print "<p>$msg\n";
    print "Please go back and correct the error</p>\n";
    print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
    exit;
    }

sub put_banner {
    # do nothing
    }
sub showhtml {
    print "content-type: text/html\n\n";
    print "<html><head><title>show html</title></head>\n";
    print "<body>";
    print <<EOF;
<h3>HTML for your EZNEWSPG Scroller</h3>
cut and paste this code to your page, typically inside a cell of a table (ie. between 
&lt;TD&gt; and &lt;/TD&gt; tags)
    <pre>
&lt;!-- start of scroller html --&gt;
&lt;script language="JavaScript1.2" src="$baseurl/$login/scroller.js"&gt;&lt;/script&gt;
&lt;script language="JavaScript1.2" src="$baseurl/diff_function.js"&gt;&lt;/script&gt;

&lt;ilayer id="main" width=&{scrollerwidth}; height=&{scrollerheight}; 
bgColor=&{scrollerbgcolor}; background=&{scrollerbackground}; visibility=hide&gt;
&lt;layer id="first" left=0 top=1 width=&{scrollerwidth};&gt;
&lt;script language="JavaScript1.2"&gt;
if (document.layers)
document.write(messages[0])
&lt;/script&gt;
&lt;/layer&gt;
&lt;layer id="second" left=0 top=0 width=&{scrollerwidth}; visibility=hide&gt;
&lt;script language="JavaScript1.2"&gt;
if (document.layers)
document.write(messages[1])
&lt;/script&gt;
&lt;/layer&gt;
&lt;/ilayer&gt;
&lt;br&gt;&lt;center&gt;&lt;font size="-2"&gt;powered by &lt;a href="http://www.upoint.net/cgiscripts.updn"&gt;\@1&nbsp;newscroller&lt;/a&gt;
&lt;br&gt;generated by &lt;a href="http://mannyjuan.com"&gt;eznewspg&lt;/a&gt;&lt;/font&gt;&lt;/center&gt;
&lt;!-- end of scroller html --&gt;
    </pre>
EOF
print "</body></html>";
    exit;
    }
