#!/usr/bin/perl
# $|=1;
# 
# ezpoltkr.pl - Easy Poll Maker - by Manny Juan <manny@jps.net> 4/3/99
# http://www.mannyjuan.com/survey/
#
# 03/01/2000 - v1.20 added fields for expired survey and allow activate/deactivate survey
# 03/10/2000 - v1.30 changed link to cgi call instead of html to allow dynamic checking
#                    of dup check, expired date and active status
#
# this program was adapted from ezhomepg, ezguest, ezlinkpg, ezclad, ezrefpg
#
#####################################################################################
require 'date.pl';
$SIG{__DIE__} = \&Error_Msg;

sub Error_Msg {
    $msg = "@_";
    print "\ncontent-type: text/html\n\n";
    print "The following error occurred : $msg\n";
    exit;
}

# Get the input
    if ($ENV{'QUERY_STRING'} ne "") {
        $input = $ENV{'QUERY_STRING'};
        }
    else {
        # Get the input
        read(STDIN, $input, $ENV{'CONTENT_LENGTH'});
        }

    # split the input
    @pairs = split(/&/, $input);

    # split the name/value pairs
    foreach $pair (@pairs) {

    ($name, $value) = split(/=/, $pair);

    $name =~ tr/+/ /;
    $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $value =~ s/<([^>]|\n)*>//g;
    $FORM{$name} = $value;
    }
$userdir = $FORM{'userdir'};

$FORM{'pagename'} =~ s/[\x00-\x20<>\|;\(\)\$^\+!\^\[\]\?\"\'\`]//g;
$pagename = $FORM{'pagename'};
$textsource="$pagename.dat";
$logfile ="$pagename.log";

######################################################################################
# set variables HERE

$win95=0;
$cgi='pl';  # suffix for script - cgi or pl

# Set this to your base HTML directory. This is a PATH not a URL
$base_dir = "/home/htdocs/your.isp.com/website/$userdir";

# This is the URL where cgi scripts reside
$cgiurl = "http://www.isp.com/website/cgi-bin";

# This is your URL of where the new HTML pages will be kept - keep the trailing slash
$baseurl = "http://www.isp.com/website/$userdir/";

# This is a URL and dir for the images sub directory in the userpages directory.
# Create the images directory in the userpages directory. This is where
# you will upload your background images
$imageurl = $baseurl;

# This is the path for user pages. You don't really need to change this
# Just make sure to create a directory: userpages and chmod it 777
$page_dir = "$base_dir/";

# This is the index of all generated pages
# This file should be chmod to 777 and placed in the userpages directory
$indexpage = "$base_dir/index.html";

# This is the location of the data.txt file. This holds each user's
# login name and e-mail address for confirmation
$data = "$base_dir/data.txt";

#Site title

$title="Easy Poll Maker Mall";

# self explanatory variables for your site logo
$logo = "$imageurl/mjmall.jpg";
$logoalt = "Easy Poll Maker Mall";

# Location of the sendmail program
$sendmail = '/usr/sbin/sendmail';

# Your e-mail address here
$myemail = 'email@isp.com';

# That's it.

# DO NOT CHANGE ANYTHING BELOW THIS LINE
######################################################################################

    $remoteip= $ENV{'REMOTE_ADDR'};
    $basedate = &jday(1,1,2000);    
    $date=localtime(time);
    ($day, $month, $num, $time, $year) = split(/\s+/,$date);

    @dt=localtime(time);
    # sec min hour day month year dum1 dum2;
    $d=$dt[3];$m=$dt[4]+1;$y=$dt[5]+1900;
    $itemdate = &jday($m, $d, $y);  
    $y2h=($itemdate-$basedate)*24+$dt[2];  # no of hours from start of millenium;


    open(TEXTFILE,"<$base_dir/$textsource");
    $txrec=<TEXTFILE>;  
    chop($txrec);
    ($usrname, $email, $colorset, $gbparms, $surveytext, $scores)=split(/&&/,$txrec);
    ($survwidth, $chkdup, $maxhist, $period, $siteurl, $surveytitle, $activate, $expyear, $expmth, $expday)
     = split('~',$gbparms);
    close(TEXTFILE);

# catch the older surveys and put default expire date of jul 31 2000 and activate=1
    if($expyear eq "" && $expmth eq "" && $expday eq "") {
        $expyear="2000";$expmth="7";$expday="31";
        $activate="1";
        }
    $expbasedate = &jday($expmth, $expday, $expyear);  
    ($bkgdc, $textc, $linkc, $vlinkc) = split('~', $colorset);

#   find number of questions and build hash of answer counts and hash of correct answers
    @survey=split(/%%/,$surveytext);
    $score={};
    $acount={};
    $correct={};
    $qn=0;
    foreach $survey (@survey) {
        $qn++;
        $correct{$qn}=0;
        ($q,$alist)=split(/\|/,$survey,2);
        @alist=split(/\|/,$alist);
        $alistcount=@alist;
        $an=0;
        foreach $a (@alist) {
            $an++;
            if (substr($a,0,1) eq '*') {$a=substr($a,1);$correct{$qn}=$an}
            }
        $acount{$qn}=$an;
        }
    $qcount=$qn;

#   gather the scores
    $score={};
    $acount={};
    $correct={};
    $qn=0;
    @scores=split(/\|/,$scores);
    foreach $qscore (@scores) {
        $qn++;
        @ascores=split(/~/,$qscore);
        $an=0;
        foreach $ascore (@ascores) {
            $an++;
            $score{$qn,$an}=$ascore;
            }
        }

    $voted=0;
    if ($chkdup==1) {
        open(LOGFILE, "<$base_dir/$logfile");
        if($win95==0){flock (LOGFILE, 1) or die "can't lock $logfile for input\n";}
        @log=<LOGFILE>;
        close LOGFILE;
        $mlog=@log;

        foreach $logrec (@log) {
            ($iremote,$iy2h,$idate,$iscores)=split(/\,/,$logrec);
            if (($remoteip eq $iremote) and (($y2h-$iy2h)<$period)) {
                $voted=1;
                }
            }
        }

    if ($FORM{'action'} eq "Start") {
        &start_survey;
        exit;
        }
    if ($FORM{'action'} eq "View") {
        &view_results;
        exit;
        }
    if ($FORM{'action'} eq "Vote") {
        &check_expired;
        &check_inactive;
        if($chkdup==1) {&check_dup;}
        &update_survey;
        if($chkdup==1) {&update_log;}
        &view_results;
        exit;
        }
    print "Content-type: text/html\n\n";
    print "<html><body>";
    print "<H1>Incorrect Usage: please create survey first</H1>\n";
    print "</body></html>";
    exit;

sub start_survey {
    if ($colorset eq "") {$colorset='FFFFFF~333333~006699~999900';}
    ($bkgdc, $textc, $linkc, $vlinkc) = split('~', $colorset);

    @survey=split(/%%/,$surveytext);
    $surveycount=@survey;
    if ($surveycount==0) {&show_error("Survey is empty - no questions were entered!")};

    print "Content-type: text/html\n\n";
    print "<html><body>";
#   &put_banner;
    print "\n<!-- begin poll code -->";
    print "\n<form method=GET action=\"$cgiurl/ezpoltkr.$cgi\">";
    print "<center>";
    print "<table width=$survwidth border=1 cellpadding=4><tr><td align=center>";
    print "\n<table width=100% border=0 bgcolor=#$bkgdc><tr><td align=center bgcolor=#$linkc><font size=\"+1\" color=#$bkgdc><b>$surveytitle</b></font></td></tr>";

    $qn=0;
    foreach $survey (@survey) {
        $qn++;
        ($q,$alist)=split(/\|/,$survey,2);
        print "\n<tr><td bgcolor=#$vlinkc><font color=#$bkgdc>";
        print "<b>$q</b></font></td></tr>";
        @alist=split(/\|/,$alist);
        $alistcount=@alist;
        if ($alistcount <= 1) {
            print "\n<tr><td>Item $qn (\"$q\") should have more than one answer choices</td></tr>";
            exit;
            }
        else {
            $an=0;
            foreach $a (@alist) {
                $an++;
                if (substr($a,0,1) eq '*') {$a=substr($a,1)}
                print "\n<tr><td><input type=radio name=ans$qn value=$an><font color=#$textc>&nbsp;&nbsp;$a</font></td></tr>";
                }
            }
        }
    print "</table>";
    print "\n<input type=hidden name=\"userdir\" value=\"$userdir\">";
    print "\n<input type=hidden name=\"pagename\" value=\"$pagename\">";
    if ($activate ne "1") {
        print "<b>(Survey is Not Active)</b>";
        } 
    elsif ($voted==1) {
        print "<b>(You Have Already Voted)</b>";
        } 
    elsif ($itemdate > $expbasedate) {
        $expmthname=&monthname($expmth);
        print "<b>(Survey expired on $expmthname $expday, $expyear)</b>";
        }
    else {
        if ($expbasedate - $itemdate < 11) {                                 
            $expmthname=&monthname($expmth);
            print "<b>(Survey will expire on $expmthname $expday, $expyear)</b>";
            }
        print "\n<br><center><input type=submit name=\"action\" value=\"Vote\">";
        }
    print "\n<br><a href=\"$cgiurl/ezpoltkr.$cgi?action=View&userdir=$userdir&pagename=$pagename\">View Results</a>";
    print "\n<br>powered by <a href=http://www.mannyjuan.com/>ezpolmkr</a></font>";
    print "\n</center>";
    print "\n</td></tr></table>";
    print "\n</form>";
    print <<EOHTML;
<center>
<a href=\"$siteurl\">Return</a>
<br><A HREF=\"$baseurl\">Get Your Own Survey Page</A>
<br><a href=\"mailto:$email\">$usrname</a></font></center>
<center><font size=-1>
This page was generated by <b>ezpolmkr.$cgi</b> found at <a href=http://www.mannyjuan.com/>
manny juan's script page</a></font>\
</center>
EOHTML
;
    print "\n<!-- end poll code -->";
    print "\n</body></html>";
    }

sub update_survey {
    $qn=0;
    foreach $survey (@survey) {
        $qn++;
        $ansid="ans$qn";
        $ans=$FORM{"$ansid"};
        if($ans eq "") {$ans="0"};
        $score{$qn,$ans}++;
        }
#   convert score to string
    $qn=0;
    @qscore=();
    foreach $survey (@survey) {
        $qn++;
        ($q,$alist)=split(/\|/,$survey,2);
        @alist=split(/\|/,$alist);
        $alistcount=@alist;
        @ascore=();
        $an=0;
        foreach $a (@alist) {
            $an++;
            push (@ascore, $score{$qn,$an});
            }
        $ascore=join('~',@ascore);
        push (@qscore, $ascore);
        }
    $scores=join('|',@qscore);

    # Write data to a flat file.
    open(FILE, ">$page_dir$pagename\.dat") || die "I can't create that file >$page_dir$pagename\.dat\n";
    if($win95==0){flock (FILE, 2) or die "can't lock user data file\n";}
    print FILE "$usrname&&$email&&$colorset&&$gbparms&&$surveytext&&$scores\n";
    close(FILE);
    }

sub view_results {
    print "Content-type: text/html\n\n";
    print "<html><body>";
#   &print_banner;
    $j=0;

    print "\n<p><center><TABLE BORDER=1 cellpadding=4 width=64%>";
    print "<tr><td>";
    print "\n<TABLE BORDER=0 width=100% bgcolor=#$bkgdc>";
    print "\n<tr><td bgcolor=#$linkc align=center width=100% colspan=4><font color=#$bkgdc size=\"+1\"><b><center>$surveytitle</center></b></font></td></tr>";
    $qn=0;
    $correct{$qn}=0;
    foreach $survey (@survey) {
        $qn++;
        $correct{$qn}=0;
        ($q,$alist)=split(/\|/,$survey,2);
        @alist=split(/\|/,$alist);
        $alistcount=@alist;
        $ssize=0;
        $maxwidth=0;
        $an=0;
        foreach $a (@alist) {
            $an++;
            $count=$score{$qn,$an};
            $ssize=$ssize+$count;
            if($count > $maxwidth) {$maxwidth=$count;}
            if (substr($a,0,1) eq '*') {$a=substr($a,1);$correct{$qn}=$an;}
            }
        $an=0;
        print "\n<tr><td colspan=4 bgcolor=#$vlinkc align=center><font color=#$bkgdc><b><center>$q</center></b></font></td></tr>";
        foreach $a (@alist) {
            $an++;
            $count=$score{$qn,$an};
             if($ssize eq 0) {
                $pct=0;
             } else {   
                $pct=int(($count/$ssize)*100);
                }
             print "\n<TR>";
             print "\n<TD WIDTH=25% align=left><font color=#$textc>";
             # make answer bold if found
             if($an == $correct{$qn}) {print "<b>$a</b>"} else {print "$a"};
             print "</font></TD>";
             print "\n<TD WIDTH=8% align=right><font color=#$textc>$count</font></TD>";
             print "\n<TD WIDTH=8% align=right><font color=#$textc>$pct\%</font></TD>";
             if ($count > 0) {
                $wide=int (($count / $maxwidth ) * 100);
                $widerem=100-$wide;
                print "\n<TD><table width=100% border=0><tr><td width=$wide% bgcolor=#$linkc>&nbsp;</td>";
                print "<td width=$widerem% bgcolor=#$bkgdc>&nbsp;</td></tr></table>";
                print "</TD>\n";
               }
               else {
                print "<TD>&nbsp;</TD>\n";
               }
             print " </TR>\n";
           }
        }
    print "</td></tr>";
    print "</table>";
    print "</TABLE>";
    if ($activate ne "1") {print "<b>(Survey is Not Active)</b>";} 
    elsif ($voted==1) {
        print "<b>(You Have Already Voted)</b>";
        } 
    elsif ($itemdate > $expbasedate) {
        $expmthname=&monthname($expmth);
        print "<b>(Survey expired on $expmthname $expday, $expyear)</b>";}
    elsif ($expbasedate - $itemdate < 11) {
        $expmthname=&monthname($expmth);
        print "<b>(Survey will expire on $expmthname $expday, $expyear)</b>";}
    print "</center>\n";
    print <<EOHTML;
<center>
<br><a href=\"$siteurl\">Return</a>
<br><A HREF=\"$baseurl\">Get Your Own Survey Page</A>
<br><a href=\"mailto:$email\">$usrname</a></font></center>
<center><font size=-1>
This page was generated by <b>ezpolmkr.$cgi</b> found at <a href=http://www.mannyjuan.com/>
manny juan's script page</a></font>\
</center>
</body></html>
EOHTML
    print "</body></html>";
    }

sub check_expired {
    if($itemdate > $expbasedate) {
        print "Content-type: text/html\n\n";
        print "<html><body><title>Survey Has Expired</title>";
        print "<h1>Survey Has Expired</h1>";
        $expmthname=&monthname($expmth);
        print "Sorry, you cannot vote - the survey expired on $expmthname $expday, $expyear";
        &msg_trailer;
        exit;
        }
    }

sub check_inactive {
    if($activate ne "1") {
        print "Content-type: text/html\n\n";
        print "<html><body><title>Inactive</title>";
        print "<h1>Survey Is Not Active</h1>";
        print "Sorry, you cannot vote - the survey is inactive at this time";
        &msg_trailer;
        exit;
        }
    }

sub check_dup {
    open(LOGFILE, "<$base_dir/$logfile");
    if($win95==0){flock (LOGFILE, 1) or die "can't lock $logfile for input\n";}
    @log=<LOGFILE>;
    close LOGFILE;
    $mlog=@log;

    foreach $logrec (@log) {
        ($iremote,$iy2h,$idate,$iscores)=split(/\,/,$logrec);
        if (($remoteip eq $iremote) and (($y2h-$iy2h)<$period)) {
            print "Content-type: text/html\n\n";
            print "<html><body><title>Duplicate Error</title>";
            print "<h1>Duplicate Vote Detected</h1>";
            print "Sorry, your vote cannot be counted because you had already voted on $idate";
            &msg_trailer;
            exit;
            }
        }
    }

sub update_log {
#   rewrite new LOG
    open(LOGFILE, ">$base_dir/$logfile");
    if($win95==0){flock (LOGFILE, 2) or die "can't lock $logfile for output\n";}
    $nlog=0;
    print LOGFILE "$remoteip,$y2h,$m/$d/$y $time,$scores\n";
    while(($nlog<$maxhist-1) and ($nlog<$mlog)) {
        $logrec=@log[$nlog];
        print LOGFILE $logrec;
        $nlog++;
        }
    close LOGFILE;
    }

sub msg_trailer {
    print "<p>However, please feel free to ";
    print "<a href=\"$cgiurl/ezpoltkr.$cgi?action=View&userdir=$userdir&pagename=$pagename\">";
    print "view the results</a> of the survey.<hr>";
    print <<EOHTML;
<center>
<br><a href=\"$siteurl\">Return</a>
<br><A HREF=\"$baseurl\">Get Your Own Survey Page</A>
<br><a href=\"mailto:$email\">$usrname</a></font></center>
<center><font size=-1>
This page was generated by <b>ezpolmkr.$cgi</b> found at <a href=http://www.mannyjuan.com/>
manny juan's script page</a></font>\
</center>
</body></html>
EOHTML
    }
sub show_error {
    local ($errmsg) = @_;
    print "content-type: text/html\n\n";
    print "<html><head><title>Error Found!</title></head>\n";
    print "<body>\n";
#    &put_banner; 
    print "<p><h1>Error Found!</h1></p>\n";
    print "<h3>$errmsg</h3>\n";
    print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
    print "</body></html>\n";
    exit;
    }
sub print_banner {
    # do nothing
    }
