#!/usr/bin/perl
require 'date.pl';
# 
# ezpolmkr.pl - Easy Poll Maker - by Manny Juan <manny@jps.net> 4/3/99
# http://www.mannyjuan.com/survey/
#
# 03/01/2000 - v1.20 added fields for expired survey and allow activate/deactivate survey
# 03/10/2000 - v1.30 changed link to cgi call instead of html to allow dynamic checking
#                    of dup check, expired date and active status
#
# this program was adapted from ezhomepg, ezguest, ezlinkpg, ezclad, ezrefpg
#
#####################################################################################
$SIG{__DIE__} = \&Error_Msg;

sub Error_Msg {
    $msg = "@_";
    print "\ncontent-type: text/html\n\n";
    print "The following error occurred : $msg\n";
    exit;
}

# Get the input
read(STDIN, $input, $ENV{'CONTENT_LENGTH'});

    # split the input
    @pairs = split(/&/, $input);

    # split the name/value pairs
    foreach $pair (@pairs) {

    ($name, $value) = split(/=/, $pair);

    $name =~ tr/+/ /;
    $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $value =~ s/<([^>]|\n)*>//g;
    $FORM{$name} = $value;
    }
$userdir = $FORM{'userdir'};
$gtoday=localtime(time);
$d=$gtoday[3];
$m=$gtoday[4];
$y=$gtoday[5];
$m+=1;
$y+=1900;

######################################################################################
# set variables HERE

$win95=0;
$cgi='pl';  # suffix for script - cgi or pl

# Set this to your base HTML directory. This is a PATH not a URL
$base_dir = "/home/htdocs/your.isp.com/website/$userdir";

# This is the URL where cgi scripts reside
$cgiurl = "http://www.isp.com/website/cgi-bin";

# This is your URL of where the new HTML pages will be kept - keep the trailing slash
$baseurl = "http://www.isp.com/website/$userdir/";

# This is a URL and dir for the images sub directory in the userpages directory.
# Create the images directory in the userpages directory. This is where
# you will upload your background images
$imageurl = $baseurl;

# This is the path for user pages. You don't really need to change this
# Just make sure to create a directory: userpages and chmod it 777
$page_dir = "$base_dir/";

# This is the index of all generated pages
# This file should be chmod to 777 and placed in the userpages directory
$indexpage = "$base_dir/index.html";

# This is the location of the data.txt file. This holds each user's
# login name and e-mail address for confirmation   
# Note: YOU SHOULD RENAME THIS FILE TO SOMETHING ONLY YOU SHOULD KNOW!
$data = "$base_dir/data.txt";

#Site title

$title="ezpolmkr - Easy Poll Maker Mall";

# self explanatory variables for your site logo
$logo = "$imageurl" . "mjmall.jpg";
$logoalt = "Easy Poll Maker Mall";

# Location of the sendmail program
$sendmail = '/usr/sbin/sendmail';

# Your e-mail address here
$myemail = 'email@isp.com';

# That's it.

# DO NOT CHANGE ANYTHING BELOW THIS LINE
######################################################################################

# Lets do some translating first
$usrname = $FORM{'usrname'};
$login = $FORM{'login'};
$email = $FORM{'email'};
$pagename = $FORM{'pagename'};
$updact = $FORM{'updact'};
$colorset = $FORM{'colorset'};
$chkdup = $FORM{'chkdup'};
$maxhist = $FORM{'maxhist'};
$period = $FORM{'period'};
$rstcounts =$FORM{'rstcounts'};
$siteurl = $FORM{'siteurl'};
$survwidth = $FORM{'survwidth'};
$surveytitle = $FORM{'surveytitle'};
$surveytext = $FORM{'surveytext'};
$activate = $FORM{'activate'};
$expyear = $FORM{'expyear'};
$expmth = $FORM{'expmth'};
$expday = $FORM{'expday'};
$surveytext =~ s/\n//g;
$surveytext =~ s/\cM//g;

# catch the older surveys and put default expire date of jul 31 2000 and activate=1
if($expyear eq "" && $expmth eq "" && $expday eq "") {
    $expyear="2000";$expmth="7";$expday="31";
    $activate="1";
    }

# convert to julian date and back to ensure day is correct
$expjday = &jday($expmth,$expday,$expyear);
($expmth,$expday,$expyear,$weekday) = &jdate($expjday);

$gbparms="$survwidth~$chkdup~$maxhist~$period~$siteurl~$surveytitle~$activate~$expyear~$expmth~$expday";

# If the user tries to add more than one word in
# the page name field, this will put an underscore
# in the spaces to make it one word
$pagename =~ s/ /_/g;
$pagename =~ s/\W//g;

if ($FORM{'action'} eq "New Page") {
    &newpage;
    }
if ($FORM{'action'} eq "Create Page") {
    &create;
    }
if ($FORM{'action'} eq "Edit Page") {
    &confirm("edit");
    }
if ($FORM{'action'} eq "checkuser") {
    &checkuser;
    }
if ($FORM{'action'} eq "recreate") {
    &recreate;
    }
if ($FORM{'action'} eq "Delete Page") {
    &confirm("delete");
    }
    exit;

sub newpage {
    local($usrname, $email, $pagename, $colorset, $gbparms, $surveytext);

    ($usrname, $email, $pagename, $colorset, $gbparms, $surveytext, 
     $expyear, $expmth, $expday) = split(/&&/, "");

    $siteurl="http://";
    $scores="";
    $chkdup=0;
    $period=24;
    $maxhist=50;
    $survwidth=250;
    # compute expdate as 1 month from now
    $expday=$d;$expmth=1+$m;if($expmth>12){$expmth=1;$expyear=$expyear+1}

    # convert to julian date and back to ensure day is correct
    $expjday = &jday($expmth,$expday,$expyear);
    ($expmth,$expday,$expyear,$weekday) = &jdate($expjday);

    $surveytext="would you like a survey like this at your site?\n|yes\n|no\n%%";

    # To avoid any security risks. Take out the HTML tags added when HPM translated
    # the && to: <br><br>. They will be re-translated to: && Once the user updates
    # the page, the: && will be put back to: <br><br>

    # print the edit-page form

    print "content-type: text/html\n\n";
    print "<html><head><title>Create Your Own Survey Page</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\">\n";
    &put_banner;
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
    print "<table width=75% cellspacing=2 cellpadding=2 border=0>\n";
    print "<tr><td width=100% align=left valign=top>\n";
    print "<p><font face=\"Arial, Geneva\"><h2>Create Your Own Survey Page</h2></font></p>\n";
    print "<p>Below is an empty form for you to fill in. The next five fields (<b>bold</b>) are required.\n";
    print "You can edit any part of your page later</p>\n";
    print "<p></p>\n";
    print "<form action=\"$cgiurl/ezpolmkr.$cgi\" method=POST>\n";
    print "<input type=hidden name=\"userdir\" value=\"$userdir\">\n";
    print "<input type=hidden name=\"action\" value=\"Create Page\">\n";
    print "<b>Your name:</b><br>\n";
    print "<font size=\"-1\">(will appear in page as link to your email)</font><br>\n";
    print "<input type=text size=40 name=\"usrname\" value=\"$usrname\"><br><br>\n";
    print "<h3>(The next 3 fields will be used for editing)<h3>\n";
    print "<b>Login Id:</b>\n";
    print "<font size=\"-1\">(one word only you should know, used later for editing)</font><br>\n";
    print "<input type=text size=40 name=\"login\" value=\"$login\"><br><br>\n";
    print "<b>Your e-mail:</b>\n";
    print "<font size=\"-1\">(used for editing, will also appear in page)</font><br>\n";
    print "<input type=text size=40 name=\"email\" value=\"$email\"><br><br>\n";
    print "<b>Your page:</b>\n";
    print "<font size=\"-1\">(one word, will become the name of your html file)</font><br>\n";
    print "<input type=text size=40 name=\"pagename\" value=\"$pagename\"><br><br>\n";
    print "<b>Your Site's URL:</b>\n";
    print "<font size=\"-1\">(Destination URL when user clicks on Return</font><br>\n";
    print "<input type=text size=40 name=\"siteurl\" value=\"$siteurl\"><br><br>\n";
    print "<b>Title of Survey:</b>\n";
    print "<font size=\"-1\">(title of the survey)</font><br>\n";
    print "<input type=text size=40 name=\"surveytitle\" value=\"$surveytitle\"><br><br>\n";
    print "</td></tr></table>\n";

    &build_form_content($usrname, $email, $pagename, $colorset, $siteurl, $survwidth, $surveytitle, $surveytext);
    print "<P><input type=submit value=\"create page\">\n";
    print "</form>\n";
    print "</body></html>\n";
    }

sub create {

    # Now, lets do some error checking. Making sure they filled out each field
    # This is pretty low tech now. I'll improve it later
    &missing(missing_name) unless $usrname;
    &missing(missing_email) unless $email;
    &missing(missing_pagename) unless $pagename;

    # if they try to name their page "index" This will stop them
    if (uc($pagename) eq "INDEX") {
        print "content-type: text/html\n\n";
        print "<html><head><title>Error</title></head>\n";
        print "<body>";
        &put_banner;
        print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
        print "<p>You cannot name your page <b>index</b>\n";
        print "Please go back and re-name your page</p>\n";
        print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
        exit;
        }

    # if the user tries to name their page 
    # something that is already taken
    # this will HOPEFULLY stop them :)
    if (-e "$page_dir$pagename\.dat") {
        print "content-type: text/html\n\n";
        print "<html><head><title>Error</title></head>\n";
        print "<body>";
        &put_banner;
        print "<p>The page name: <b>$pagename</b>\n";
        print "is already taken.\n";
        print "Please go back and rename your page</p>\n";
        print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
        exit;
        }

    &chk_bad_maxhist;

    &validate_survey;

    &initialize_scores;
    &save_page_data;

    # Write the login name and email address to a separate file for confirmation
    # when they want to edit their page
    open (FILE, ">>$data") || die "I can't open >>$data\n";
    if($win95==0){flock (FILE, 2) or die "can't lock data file\n";}
    print FILE "$login&&$email&&$pagename\n";
    close(FILE);


    # Suck the index page, and write the new entry to it
    open(FILE, "$indexpage") || die "I can't open that file $indexpage\n";
    if($win95==0){flock (FILE, 1) or die "can't lock index file\n";}
    @lines = <FILE>;
    close(FILE);
    $sizelines = @lines;

    # Now, re-open the links file, and add the new link
    open(FILE, ">$indexpage") || die "I can't open that file >$indexpage\n";
    if($win95==0){flock (FILE, 2) or die "can't lock index file\n";}

    for ($a = 0; $a <= $sizelines; $a++) {

        $_ = $lines[$a];

        if (/<!--begin-->/) {

            print FILE "<!--begin-->\n";
            print FILE "<p><font face=\"Arial, Geneva\" size=4><a href=\"$cgiurl/ezpoltkr.$cgi?action=Start&userdir=$userdir&pagename=$pagename\">$surveytitle</a></font></p>\n";

        } else {
            print FILE $_;
            }
        }
    close(FILE);


    # Give the user a response
    print "content-type: text/html\n\n";
    print "<html><head><title>thanks</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\">\n";
    &put_banner;
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
    print "<BR><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";

    print "Your survey page has been created, and you will receive an e-mail confirming this!\n";
    print "Its full URL is: <a href=\"$cgiurl/ezpoltkr.$cgi?action=Start&userdir=$userdir&pagename=$pagename\">\n";
    print "$cgiurl/ezpoltkr.$cgi?action=Start&userdir=$userdir&pagename=$pagename</a>\n";
    print "<p>Thanks for your participation!<br><br>";
    print "Copy the HTML below and paste into your page:\n\n";
    print "<FONT SIZE=4 FACE=\"Courier New\">\n";
    print "<center><pre>\n";
    print "&lt;center&gt;Vote Now!&lt;br&gt;&lt;a href=\"$cgiurl/ezpoltkr.$cgi?action=Start&userdir=$userdir&pagename=$pagename\"&gt;$surveytitle&lt;/a&gt;&lt;/center&gt;\n";
    print "</pre></center>\n\n";
    print "</FONT>";
    print "It will look like this (try it - it works!):\n";
    print "<br><br><center>Vote Now!<br><a href=\"$cgiurl/ezpoltkr.$cgi?action=Start&userdir=$userdir&pagename=$pagename\">$surveytitle</a></center>\n";
    print "<p>Alternatively, you can go to the above URL and cut-n-paste from the generated HTML.";
    print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
    print "</body></html>\n";

    # create an empty log file
    open(LOGFILE, ">$base_dir/$pagename.log");
    if($win95==0){flock (LOGFILE, 2) or die "can't lock $logfile for output\n";}
    print LOGFILE "";
    close LOGFILE;

    # Send the user an e-mail confirming their page
    open (MAIL, "| $sendmail -t") || die "I can't open sendmail\n";
    print MAIL "To: $usrname <$email>\n";
    print MAIL "From: $myemail\n";
    print MAIL "Subject: Your new URL on the $title\n";
    print MAIL "Your page can be viewed at the URL below:\n";
    print MAIL "\n";
    print MAIL "$cgiurl/ezpoltkr.$cgi?action=Start&userdir=$userdir&pagename=$pagename\n";
    print MAIL "\nThank you for using the $title\n";
    print MAIL "\n\nThe Mall Manager - $myemail\n";
    close (MAIL);

    # Notify us when someone creates a page
    open (MAIL, "| $sendmail -t") || die "I can't open sendmail\n";
    print MAIL "To: $myemail\n";
    print MAIL "From: $usrname <$email>\n";
    print MAIL "Subject: $title New Page Report\n";
    print MAIL "$usrname created a new page:\n";
    print MAIL "$cgiurl/ezpoltkr.$cgi?action=Start&userdir=$userdir&pagename=$pagename\n";
    close(MAIL);

    }

sub recreate {
    &chk_bad_maxhist;

    &validate_survey;

    if ($rstcounts eq "1") {
        &initialize_scores;
        }
    else {
    #   re-read the data record again to get the scores
        open(FILE, "$page_dir$pagename\.dat") || die "I can't open $page_dir$pagename\.dat\n";
        if($win95==0){flock (FILE, 1) or die "can't lock $pagename\.dat file for edit\n";}
        $line=<FILE>;
        chop($line);
        ($xusrname, $xemail, $xcolorset, $xgbparms, $xsurveytext, $xscores) = split(/&&/, $line);
        $scores=$xscores;
        close(FILE);
        }

    &save_page_data;

    # Suck the index page, and write the new entry to it
    open(FILE, "$indexpage") || die "I can't open that file $indexpage\n";
    if($win95==0){flock (FILE, 1) or die "can't lock index file\n";}
        @lines = <FILE>;
        close(FILE);
        $sizelines = @lines;

    # Now, re-open the links file, and comment out the page to delete
    open(FILE, ">$indexpage") || die "I can't open that file >$indexpage\n";
    if($win95==0){flock (FILE, 2) or die "can't lock index file to delete entry\n";}

            for ($a = 0; $a <= $sizelines; $a++) {

            $_ = $lines[$a];

        if (/pagename=$pagename\b/) {
            print FILE "<p><font face=\"Arial, Geneva\" size=4><a href=\"$cgiurl/ezpoltkr.$cgi?action=Start&userdir=$userdir&pagename=$pagename\">$surveytitle</a></font></p>\n";
            } 
        else {
          print FILE $_;
           }
        }
    close(FILE);
    &ntfy_usr_edt;

    # Give the user a response
    print "content-type: text/html\n\n";
    print "<html><head><title>thanks</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\">\n";
    &put_banner;
    print "<CENTER><IMG SRC=\"$logo\" alt=\"$logoalt\" border=0></CENTER>\n";
    print "<P><BR><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";
    print "Your page has been revised, and you will receive an e-mail confirming this!\n";
    print "Its full URL is: <a href=\"$cgiurl/ezpoltkr.$cgi?action=Start&userdir=$userdir&pagename=$pagename\">\n";
    print "$cgiurl/ezpoltkr.$cgi?action=Start&userdir=$userdir&pagename=$pagename</a>\n";
    print "<p>Thanks for your participation!<br><br>";
    print "Copy the HTML below and paste into your page:\n\n";
    print "<FONT SIZE=4 FACE=\"Courier New\">\n";
    print "<center><pre>\n";
    print "&lt;center&gt;Vote Now!&lt;br&gt;&lt;a href=\"$cgiurl/ezpoltkr.$cgi?action=Start&userdir=$userdir&pagename=$pagename\"&gt;$surveytitle&lt;/a&gt;&lt;/center&gt;\n";
    print "</pre></center>\n\n";
    print "</FONT>";
    print "It will look like this (try it - it works!):\n";
    print "<br><br><center>Vote Now!<br><a href=\"$cgiurl/ezpoltkr.$cgi?action=Start&userdir=$userdir&pagename=$pagename\">$surveytitle</a></center>\n";
    print "<p>Alternatively, you can go to the above URL and cut-n-paste from the generated HTML.";
    print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
    print "</body></html>\n";
    }

sub ntfy_usr_edt {
    # Send the user a notice that their page has been re-done
    open (MAIL, "| $sendmail -t") || die "I can't open sendmail\n";
    print MAIL "To: $usrname <$email>\n";
    print MAIL "From: $myemail\n";
    print MAIL "Subject: Your Changes on the $title\n";
    print MAIL "Your revised page can be viewed at the URL below:\n";
    print MAIL "\n";
    print MAIL "$cgiurl/ezpoltkr.$cgi?action=Start&userdir=$userdir&pagename=$pagename\n";
    print MAIL "\nOnce again thank you for using the $title\n";
    print MAIL "\n\nThe Mall Manager\n";
    close (MAIL);
    }

sub chk_bad_maxhist {
    if ($maxhist !~ /^(\d){1,3}$/) {
        &input_error("invalid or unreasonable value for max history items (please enter 1 to 200)");
        exit;
        }
    if ($maxhist > 200) {
        &input_error("invalid or unreasonable value for max history items (please enter 1 to 200)");
        exit;
        }
    }
sub input_error {
    local ($errmsg) = @_;
    print "content-type: text/html\n\n";
    print "<html><head><title>Error</title></head>\n";
    print "<body>";
    &put_banner;
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
    print "<h1>Input Error!</h1><h3>$errmsg.</h3>\n";
    print "<p>Please go back and correct</p>\n";
    }

sub validate_survey {
    # validate the survey 
    @survey=split(/%%/,$surveytext);
    $surveycount=@survey;
    if ($surveycount==0) {&show_error("Survey is empty - no questions were entered!")};
    $qn=0;
    foreach $survey (@survey) {
        $qn++;
        ($q,$alist)=split(/\|/,$survey,2);
        if ($q eq "") {&show_error("Item $qn has missing question");}
        @alist=split(/\|/,$alist);
        $alistcount=@alist;
        if ($alistcount <= 1) {&show_error("Item $qn (\"$q\") should have more than one answer choices");}
        foreach $a (@alist) {
            if ($a eq "") {&show_error("Item $qn (\"$q\") cannot have a blank answer choice!");}
            }
        }
    }

sub initialize_scores {
    @survey=split(/%%/,$surveytext);
    @qscore=();
    foreach $survey (@survey) {
        ($q,$alist)=split(/\|/,$survey,2);
        @alist=split(/\|/,$alist);
        $alistcount=@alist;
        @ascore=();
        foreach $a (@alist) {
            push (@ascore, 0);
            if (substr($a,0,1) eq '*') {$a=substr($a,1)}
            }
        $ascore=join('~',@ascore);
        push (@qscore, $ascore);
        }
    $scores=join('|',@qscore);
    }

sub save_page_data {
    # Give the user a response
    # Write all of the input into a flat file.
    open(FILE, ">$page_dir$pagename\.dat") || die "I can't create that file >$page_dir$pagename\.dat\n";
    if($win95==0){flock (FILE, 2) or die "can't lock user data file\n";}
    print FILE "$usrname&&$email&&$colorset&&$gbparms&&$surveytext&&$scores\n";
    close(FILE);
#    chmod 0777, '$page_dir$pagename.dat';
    }

# Standard error message for any missing required fields
sub missing {
    local ($missing) = @_;
    print "content-type: text/html\n\n";

    print "<HTML><head><TITLE>You missed something</TITLE></head>\n";
    print "<body>\n";
    &put_banner;    
    print "You forgot to fill in one of the fields. Please go back and make\n";
    print "sure that all required fields are filled in! $missing\n";
    print "</body></HTML>\n";
    exit;
    }

sub confirm {
    local ($updact) = @_;

    print "content-type: text/html\n\n";
    print "<html><head><title>$updact Confirmation</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\" >\n";
    &put_banner; 
    print "<CENTER><IMG SRC=\"$logo\" alt=\"$logoalt\"  border=0></CENTER>\n";
    print "<P><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";
    print "<p><h3>Please Enter your login name, e-mail and name of your file to $updact</h3></p>\n";
    print "<form action=\"$cgiurl/ezpolmkr.$cgi\" method=POST>\n";
    print "<input type=hidden name=\"userdir\" value=\"$userdir\">\n";
    print "<P><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";
    print "Login name:<br>\n";
    print "<input size=40 type=text name=\"login\"><br><br>\n";
    print "E-mail:<br>\n";
    print "<input size=40 type=text name=\"email\"><br><br>\n";
    print "Name of your file:<br>\n";
    print "<input type=text size=40 name=\"pagename\"><br><br>\n";
    print "<input type=submit value=submit>\n";
    print "<input type=hidden name=\"action\" value=\"checkuser\">\n";
    print "<input type=hidden name=\"updact\" value=\"$updact\">\n";
    print "</FONT>\n";
    print "</form></body></html>\n";
    }

sub checkuser {
    open(FILE, "$data") || die "I can't open $data\n";  
    if($win95==0){flock (FILE, 1) or die "can't lock data file\n";}

    while(<FILE>) {
    chop;       
    @all = split(/\n/);

    foreach $line (@all) {
    ($loginname, $loginemail, $loginpagename) = split(/&&/, $line);
    if($loginname eq "$login" && $loginemail eq "$email" && $loginpagename eq "$pagename") {
        $match = 1;
        if($updact eq "edit") {
          &edit($loginpagename);
          }
        else {
          &delpage($loginpagename);
          }
        }
      }
    }

    close(FILE);

    if (! $match) {
        &error;
        }

    # del entry from data
    if($updact eq "delete") {

        # Suck the index page, and write the new entry to it
        open(FILE, "$data") || die "I can't open that file $data\n";
        if($win95==0){flock (FILE, 1) or die "can't lock data file\n";}
            @lines = <FILE>;
            close(FILE);
            $sizelines = @lines;

        # Now, re-open the links file, and comment out the page to delete
        open(FILE, ">$data") || die "I can't open that file >$data\n";
        if($win95==0){flock (FILE,2) or die "can't lock index file for append\n";}
        chop;
                for ($a = 0; $a <= $sizelines; $a++) {
                $_ = $lines[$a];
                $w = $_;
                $w =~ s/\cM//g;
                $w =~ s/\n//g;
        ($loginname, $loginemail, $loginpagename) = split(/&&/, $w);
        if($loginname eq "$login" && $loginemail eq "$email" && $loginpagename eq "$pagename") {
              # do nothing  (ie. don't write)
              } 
            else {
              if($w eq "") {
                # do nothing (skip)
                }
              else {
                print FILE "$w\n";
                }
              }
            }
        close(FILE);
        print "content-type: text/html\n\n";
        print "<html><head><title>$updact Confirmation</title></head>\n";
        print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\" >\n";
        &put_banner; 
        print "<CENTER><IMG SRC=\"$logo\" alt=\"$logoalt\" border=0></CENTER>\n";
        print "<P><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";
        print "<p>your page has been deleted";
        print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
        print "</form></body></html>\n";
      }
    }

sub edit {

    local ($editfile) = @_;
    
    open(FILE, "$page_dir$editfile\.dat") || die "I can't open $page_dir$editfile\.dat\n";
    if($win95==0){flock (FILE, 1) or die "can't lock data file for edit\n";}

    while(<FILE>) {
    chop;
    @datafile = split(/\n/);

    foreach $line (@datafile) {
        &build_edit_form($line);
            }
         }
    close(FILE);
    }

sub delpage {
    local ($editfile) = @_;
    $cnt=unlink "$page_dir$editfile\.dat";
    $cnt=unlink "$page_dir$editfile\.html";
    $cnt=unlink "$page_dir$editfile\.log";

    # Suck the index page, and write the new entry to it
    open(FILE, "$indexpage") || die "I can't open that file $indexpage\n";
    if($win95==0){flock (FILE, 1) or die "can't lock index file\n";}
        @lines = <FILE>;
        close(FILE);
        $sizelines = @lines;

    # Now, re-open the links file, and comment out the page to delete
    open(FILE, ">$indexpage") || die "I can't open that file >$indexpage\n";
    if($win95==0){flock (FILE, 2) or die "can't lock index file to delete entry\n";}

            for ($a = 0; $a <= $sizelines; $a++) {

            $_ = $lines[$a];

        if (/pagename=$pagename\b/) {
          # do nothing  (ie. don't write)
          } 
        else {
          print FILE $_;
           }
        }
    close(FILE);

    }

sub build_edit_form {
    local ($line) = @_;
#    local($usrname, $email, $colorset, $gbparms, $surveytext, $scores);

    ($usrname, $email, $colorset, $gbparms, $surveytext, $scores) = split(/&&/, $line);
    $surveytext=~s/%%/\n%%\n/g;
    $surveytext=~s/\|/\n\|/g;

    ($survwidth, $chkdup, $maxhist, $period, $siteurl, $surveytitle, $activate, $expyear, $expmth, $expday)
     = split('~',$gbparms);

    # To avoid any security risks. Take out the HTML tags added when HPM translated
    # the && to: <br><br>. They will be re-translated to: && Once the user updates
    # the page, the: && will be put back to: <br><br>

    # print the edit-page form

    print "content-type: text/html\n\n";
    print "<html><head><title>Edit Your Page</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\">\n";
    &put_banner; 
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
    print "<table width=75% cellspacing=2 cellpadding=2 border=0>\n";
    print "<tr><td width=100% align=left valign=top>\n";
    print "<p><font face=\"Arial, Geneva\"><h2>Edit Your Page</h2></font></p>\n";
    print "<p>Below is a form with the contents\n";
    print "of the survey page you created. You can edit any part of your page</p>\n";
    print "<p></p>\n";
    print "<form action=\"$cgiurl/ezpolmkr.$cgi\" method=POST>\n";
    print "<input type=hidden name=\"userdir\" value=\"$userdir\">\n";
    print "<input type=hidden name=\"action\" value=\"recreate\">\n";
    print "Your name:<br>\n";
    print "<input type=text size=40 name=\"usrname\" value=\"$usrname\"><br><br>\n";
    print "Your e-mail:<br>\n";
    print "<input type=text size=40 name=\"email\" value=\"$email\"><br><br>\n";
    print "Name of HTML file: <b>$pagename</b><br><br>\n";
    print "<input type=hidden name=\"pagename\" value=\"$pagename\">\n";
    print "Return URL:\n";
    print "<font size=\"-1\">(Destination URL when user clicks on Return)</font><br>\n";
    print "<input type=text size=40 name=\"siteurl\" value=\"$siteurl\"><br><br>\n";
    print "Title of Survey:\n";
    print "<font size=\"-1\">(Title of Survey)</font><br>\n";
    print "<input type=text size=40 name=\"surveytitle\" value=\"$surveytitle\"><br><br>\n";
    print "</td></tr></table>\n";

    &build_form_content($usrname, $email, $pagename, $colorset, $siteurl, $survwidth, $surveytitle, $surveytext);
    print "<p><INPUT TYPE=\"CHECKBOX\" NAME=\"rstcounts\" VALUE=\"1\" checked>&nbsp;<b>Reset Counts</b>";
    print "&nbsp;(IMPORTANT!!! uncheck this if no changes were made to the survey data)";
    print "<P><input type=submit value=\"update page\">\n";
    print "</form>\n";
    print "</body></html>\n";
    }

sub build_form_content {
    local ($usrname, $email, $pagename, $colorset, $siteurl, $survwidth, $surveytitle, $surveytext)=@_;
    print <<EOHTML;
<b>Survey:</b> use two percent signs (<b>%%</b>) between entries; start each
answer on a new line with a vertical bar (|) and mark the correct answer (if any) with an 
asterisk (*) - for example:
<pre>
Which of these colors do you like best?
|red
|yellow
|blue
%%
What color do you get when you mix blue and yellow?
|orange
|*green
|violet
%%
Do you have your own home page?
|yes
|no
</pre>
EOHTML
;
    print "<textarea cols=65 rows=24 wrap=on name=\"surveytext\">$surveytext</textarea><br><br>\n";
    print "<b>Select Color Scheme:</b>";
    print "<SELECT NAME=\"colorset\">";
    &put_optvar($colorset,'01','FFFFFF~333333~006699~999900');
    &put_optvar($colorset,'02','CCCCCC~000000~0000CC~660066');
    &put_optvar($colorset,'03','FFFF00~FF6600~FF0033~336633');
    &put_optvar($colorset,'04','CCCC66~330000~CC0000~003300');
    &put_optvar($colorset,'05','FFFF99~330000~CC0000~333333');
    &put_optvar($colorset,'06','99CCCC~000066~0000CC~003366');
    &put_optvar($colorset,'07','CC99FF~000000~FF0033~660066');
    &put_optvar($colorset,'08','CCFF99~666600~006699~003300');
    &put_optvar($colorset,'09','FFCC00~330000~CC0000~660066');
    &put_optvar($colorset,'10','00FF33~0000CC~FF0099~660066');
    &put_optvar($colorset,'11','006699~CCFFCC~FFFF00~00FFFF');
    &put_optvar($colorset,'12','330000~FF6666~FFCC00~CCFF99');
    &put_optvar($colorset,'13','003300~CCCC66~FFFFFF~FFFF00');
    &put_optvar($colorset,'14','333333~CCCCCC~FF6666~CCCC66');
    &put_optvar($colorset,'15','666600~FFFFFF~FFFF00~99CCFF');
    &put_optvar($colorset,'16','000000~99CCFF~FFFF00~CCCC66');
    &put_optvar($colorset,'17','333333~FFFFFF~99CCFF~CC99FF');
    &put_optvar($colorset,'18','CC0000~FFFFFF~FFFF00~00FFFF');
    print "\n</SELECT>";
    print "<br><img src=\"$baseurl" . "ezpalette.gif\"><br><br>\n";
    print "<b>Select Survey Width:</b>";
    print "<SELECT NAME=\"survwidth\">";
    for($i=0;$i<13;$i++) {
        $sw=200+50*$i;
        print "\n<option value=$sw";
        if($sw==$survwidth) {print " selected"}
        print ">$sw";
        }
    print "</select>&nbsp;(400 is about 4 inches)";
    print "<p><INPUT TYPE=\"CHECKBOX\" NAME=\"chkdup\" VALUE=\"1\"";
    if($chkdup==1) {
        print " checked";
        }
    print ">\n";
    print "<b>Check for Duplicate Vote</b>";
    print "<br><b>Max History Size:</b>";
    print "&nbsp;<input type=text size=5 name=\"maxhist\" value=\"$maxhist\">";
    print "\n&nbsp;(how many entries to keep in history for duplicate checking, 1-200)";
    print "\n<br><b>DupCheck Period:</b>";
    print "<SELECT NAME=\"period\">";
    print "\n<option value=1 ";
    if ($period==1) {print " selected"};print ">1 hour";
    print "\n<option value=24 ";
    if ($period==24) {print " selected"};print ">1 day";
    print "\n<option value=168 ";
    if ($period==168) {print " selected"};print ">1 week";
    print "\n<option value=720 ";
    if ($period==720) {print " selected"};print ">1 month";
    print "</select>&nbsp;(how far back to look for duplicate votes)";

    print "<br><br><b>Expire Date:</b>&nbsp;";
    print "<SELECT NAME=\"expmth\">";
    &put_optvar($expmth,'January','1');
    &put_optvar($expmth,'February','2');
    &put_optvar($expmth,'March','3');
    &put_optvar($expmth,'April','4');
    &put_optvar($expmth,'May','5');
    &put_optvar($expmth,'June','6');
    &put_optvar($expmth,'July','7');
    &put_optvar($expmth,'August','8');
    &put_optvar($expmth,'September','9');
    &put_optvar($expmth,'October','10');
    &put_optvar($expmth,'November','11');
    &put_optvar($expmth,'December','12');
    print "</select>";
    print "<SELECT NAME=\"expday\">";
    foreach $dv (1 .. 31) {
        &put_optvar($expday, $dv, $dv);
        }
    print "</select>";
    print "<SELECT NAME=\"expyear\">";
    foreach $dv (2000 .. 2005) {
        &put_optvar($expyear, $dv, $dv);
        }
    print "</select>";
    print "<p><INPUT TYPE=\"CHECKBOX\" NAME=\"activate\" VALUE=\"1\" checked>&nbsp;<b>Activate Survey?</b>";
    print "&nbsp;(turn ON to activate, turn OFF to deactivate)";

#    print "<table>";
#    &prt_ckb($survwidth, 'survwidth', 'allow referrer to enter name');
#    &prt_ckb($chkdup, 'chkdup', 'allow referrer to add extra message');
#    &prt_ckb($maxhist, 'maxhist', 'send note to referrer');
#    &prt_ckb($period, 'period', 'send note to owner');
#    print "</table>";
    }

sub put_optvar  {
    local ($optvar, $id, $value)=@_;
    print "\n<OPTION VALUE=\"$value\"";
    if ($optvar eq $value) {print " SELECTED";}
    print ">$id";
    }
sub prt_ckb {
    local ($var, $varname, $ckbdesc) = @_;
    print "\n<tr><td><INPUT TYPE=\"CHECKBOX\" NAME=\"$varname\" VALUE=\"1\"";
    if ($var eq "1") {print " CHECKED";} 
    print "></td>";
    print "<td>$ckbdesc</td></tr>";
    }
sub show_error {
    local ($errmsg) = @_;
    print "content-type: text/html\n\n";
    print "<html><head><title>Error Found!</title></head>\n";
    print "<body>\n";
    &put_banner; 
    print "<p><h1>Error Found!</h1></p>\n";
    print "<h3>$errmsg</h3>\n";
    print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
    print "</body></html>\n";
    exit;
    }
sub error {
    local ($updact) = @_;
    print "content-type: text/html\n\n";
    print "<html><head><title>Permission Denied</title></head>\n";
    print "<body>\n";
    &put_banner; 
    print "<p><h1>Permission Denied</h1></p>\n";
    print "You do not have permission to $updact\n";
    print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
    print "</body></html>\n";
    exit;
    }
sub put_banner {
    # do nothing
    }
sub put_HTML_banner {
    # do nothing
    }
