#!/usr/bin/perl
#
# Program: bpmember.cgi
# Author: Drummond Miles
# Email: info@gadnet.com
#
# Created: 29/12/98
# Last Modified: 12/09/99 - removed references to $cgipath for ease of cross-platform installation
# Copyright G.A.D.Miles 1998. All Rights Reserved
#
# Download script from http://www.gadnet.com/bplus
#
# This program is being distibuted as freeware. It can be freely downloaded and used.
# It may be modified as long as the copyright information remains intact.
#
# Any use of this program is entirely at the risk of the user. No liability will be
# accepted by the author.
#
# This code must not be sold, even in modified form, without the written permission
# of the author. This code must also not be distributed without the permission of the 
# author.

require "bpvars.cgi";
require "bpsubs.cgi";

print "Content-type: text/html\n\n";

read(STDIN,$indata,$ENV{'CONTENT_LENGTH'});
@indata = split(/&/,$indata);
foreach $i (0..$#indata)
{
    $indata[$i] =~ s/\+/ /g;
      ($key,$val) = split(/=/,$indata[$i],2);
    $key =~ s/%(..)/pack("c",hex($1))/ge;
    $val =~ s/%(..)/pack("c",hex($1))/ge;
    $indata{$key} .= "\0" if (defined($indata{$key}));
    $indata{$key} .= $val;
}
$qsdata=$ENV{'QUERY_STRING'};
@qsdata = split(/&/,$qsdata);
foreach $i (0..$#qsdata)
{
    $indata[$i] =~ s/\+/ /g;
      ($key,$val) = split(/=/,$qsdata[$i],2);
    $key =~ s/%(..)/pack("c",hex($1))/ge;
    $val =~ s/%(..)/pack("c",hex($1))/ge;
    $indata{$key} .= "\0" if (defined($indata{$key}));
    $indata{$key} .= $val;
}

$owner=$indata{'owner'};
require "bpgetcfg.cgi";

if ($indata{'showuser'})
{
    &showuser;
}
elsif ($indata{'updateuser'})
{
    &updateuser;
}
else
{
    &getid;
}

sub getid
{
    &header('Enter ID');
    print("<form method=POST action=$cgiurl/bpmember.cgi>\n");
    print("<input type=hidden name=owner value=$owner>\n");
    print("<input type=hidden name=showuser value=x>\n");
    print("<center><table BORDER WIDTH=75\%>\n");
    print("<tr><th ALIGN=CENTER BGCOLOR=\"#$textc\"><b><font face=verdana><font color=\"#$bkgdc\"><font size=+0>User Information:</font></font></font></b></th></tr>\n");
    print("<tr BGCOLOR=\"#$linkc\"><td><center><table><tr><td ALIGN=RIGHT><font size=-1 color=\"#$bkgdc\">User ID:</font></td>\n");
    print("<td><input type=text name=userid size=8 maxlength=8></td></tr>\n");
    print("<tr><td ALIGN=RIGHT><font size=-1 color=\"#$bkgdc\">Password:</font></td>\n");
    print("<td><input type=password name=userpass1 size=8 maxlength=8></td></tr>\n");
    print("</table></center></td></tr></table></center>\n");
    print("<br><br><center><input type=submit value=\"Enter\">\n");
    print("</form></center>\n");
    &footer;
}

sub showuser
{
    &header('Members Only');
    $error = 0;
    if (!$indata{'userid'})
    {
        $error = 1;
        print("<br><br><center><font size=+1><b>Error<br><br></font></b>\n");
        print("<b>You must enter a User ID<br></b>\n");
    }
    if (!$indata{'userpass1'})
    {
        if (!$error)
        {
            print("<br><br><center><font size=+1><b>Error<br><br></font></b>\n");
            $error = 1;
        }
        print("<b>You must enter a Password<br></b>\n");
    }
      if (!(-e "$bpdata/$indata{'userid'}.txt") && ($indata{'userid'}))
    {
        if (!$error)
        {
            print("<br><br><center><font size=+1><b>Error<br><br></font></b>\n");
            $error = 1;
        }
        print("<b>Invalid User ID<br></b>\n");
        print("(Note that User ID is case sensitive)<br>\n");
    }
    if ($error)
    {
        print ("<br><br><center>Use the \'Back\' button on your browser to correct your data</center>\n");
        return;
    }
    open (OLDUSER, "+<$bpdata/$indata{'userid'}.txt");
    $lockfail = &lock("OLDUSER");
    if ($lockfail)
    {
        &lockerror("$indata{'userid'}.txt");
    }
    @olduserlines = <OLDUSER>;
    close (OLDUSER);
    foreach $olduserlines (@olduserlines)
    {
        chop $olduserlines if ($olduserlines =~ /\n$/);
    }
    if (@olduserlines[8] ne $indata{'userpass1'})
    {
        print ("<br><br><center><font size=+1><b>Error<br><br></font></b>\n");
        print ("<b>Invalid Password<br></b>\n");
        print ("(Note that Password is case sensitive)<br>\n");
        print ("<br><br><center>Use the \'Back\' button on your browser to correct your data</center>\n");
        return;
    }
    $userid = $indata{'userid'};
    print "<br><center><font face=verdana><font size +2>User <b>$indata{'userid'}</b></font></font></center>\n";
    $earned = 0;
    if (@olduserlines[5] > 0)
    {
        $earned = int(@olduserlines[4] / @olduserlines[5]);
    }
    $pc = "N/A";
    if (@olduserlines[6] > 0)
    {
        $pc = (@olduserlines[7] * 100) / @olduserlines[6];
    }
    unless ($pc eq "N/A")
    {
        $pc =~ s/(.\d\d\d)\d*/$1/;
        $pc = $pc . "%";
    }
    print("<br><center><table BORDER WIDTH=50\%>\n");
    print("<tr><th ALIGN=CENTER BGCOLOR=\"#$textc\"><b><font face=verdana><font color=\"#$bkgdc\"><font size=+0>User Statistics:</font></font></font></b></th></tr>\n");
    print("<tr BGCOLOR=\"#$linkc\"><td><center><table><tr><td ALIGN=RIGHT><font size=-1 color=\"#$bkgdc\" >Banners Displayed on this Site:</td><td> <font color=\"#$bkgdc\">@olduserlines[4]</font></td></tr>\n");
    print("<tr><td ALIGN=RIGHT><font size=-1 color=\"#$bkgdc\">Credits Earned:</font></td><td><font color=\"#$bkgdc\">$earned</font></td></tr>\n");
    print("<tr><td ALIGN=RIGHT><font size=-1 color=\"#$bkgdc\">Credits Used:</td><td> <font color=\"#$bkgdc\">@olduserlines[6]</font></td></tr>\n");
    print("<tr><td ALIGN=RIGHT><font size=-1 color=\"#$bkgdc\">Click Thrus to your Site:</td><td> <font color=\"#$bkgdc\">@olduserlines[7]</font></td></tr>\n");
    print("<tr><td ALIGN=RIGHT><font size=-1 color=\"#$bkgdc\">Click Thru Percentage:</td><td> <font color=\"#$bkgdc\">$pc</font></td></tr>\n");
    print("</td></tr></table></table></center>\n");

    print("<form method=POST action=$cgiurl/bpmember.cgi>\n");
    print("<input type=hidden name=owner value=$owner>\n");
    print("<input type=hidden name=updateuser value=x>\n");
    print("<input type=hidden name=userid value=$userid>\n");
    print("<br><center><table BORDER WIDTH=75\%>\n");
    print("<tr><th ALIGN=CENTER BGCOLOR=\"#$textc\"><b><font face=verdana><font color=\"#$bkgdc\"><font size=+0>User Information:</font></font></font></b></th></tr>\n");
    print("<tr BGCOLOR=\"#$linkc\"><td><center><table><tr><td ALIGN=RIGHT><font size=-1 color=\"#$bkgdc\">Name:</font></td>\n");
    print("<td><input type=text name=username size=20 maxlength=30 value='@olduserlines[0]'></td></tr>\n");
    print("<tr><td ALIGN=RIGHT><font size=-1 color=\"#$bkgdc\">Email:</font></td>\n");
    print("<td><input type=text name=email size=30 maxlength=50 value=@olduserlines[1]></td></tr>\n");
    print("<tr><td ALIGN=RIGHT><font size=-1 color=\"#$bkgdc\">Site URL:</font></td>\n");
      print("<td><input type=text name=siteurl size=40 maxlength=60 value=@olduserlines[2]></td></tr>\n");
    print("<tr><td ALIGN=RIGHT><font size=-1 color=\"#$bkgdc\">Site Title:</font></td>\n");
    print("<td><input type=text name=sitetitle size=40 maxlength=60 value='@olduserlines[9]'></td></tr>\n");
    print("<tr><td ALIGN=RIGHT><font size=-1 color=\"#$bkgdc\">Banner URL:</font></td>\n");
    print("<td><input type=text size=40 name=urlbanner maxlength=60 value=@olduserlines[3]></td></tr></table>\n");
    print("</td></tr></table></center>\n");
    print("<br><br><center><input type=submit value=\"Update\">\n");
    print("</center></form>\n");
}

sub updateuser
{
    &header('Update User');
    $error = 0;
    if (!$indata{'username'})
    {
        $error = 1;
        print("<br><br><center><b><font size=+1>Error<br><br></font></b>\n");
        print("<b>You must enter your Name<br></b>\n");
    }
    if (!$indata{'email'})
    {
        if (!$error)
        {
            print("<br><br><center><b><font size=+1>Error<br><br></font></b>\n");
            $error = 1;
        }
        print("<b>You must enter your Email Address<br></b>\n");
    }
    if (!$indata{'siteurl'})
    {
        if (!$error)
        {
            print("<br><br><center><b><font size=+1>Error<br><br></font></b>\n");
            $error = 1;
        }
        print("<b>You must enter the URL of your site<br></b>\n");
    }
    if (!$indata{'sitetitle'})
    {
        if (!$error)
        {
            print("<br><br><b><center><font size=+1>Error<br><br></font></b>\n");
            $error = 1;
        }
        print("<b>You must enter the title of your site<br></b>\n");
    }
    if ($error)
    {
        print ("<br><br><center>Use the \'Back\' button on your browser to correct your data</center>\n");
        return;
    }
    open (OLDUSER, "+<$bpdata/$indata{'userid'}.txt");
    $lockfail = &lock("OLDUSER");
    if ($lockfail)
    {
        &lockerror("$bpdata/$indata{'userid'}.txt");
    }
    @olduserlines = <OLDUSER>;
    $olduserlines[0] = "$indata{'username'}\n";
    $olduserlines[1] = "$indata{'email'}\n";
    $olduserlines[2] = "$indata{'siteurl'}\n";
    $olduserlines[9] = "$indata{'sitetitle'}\n";
    $olduserlines[3] = "$indata{'urlbanner'}\n";
    $olduserlines[13] = "0\n";
    seek (OLDUSER,0,0);
    truncate (OLDUSER,0);
    foreach $olduserlines (@olduserlines)
    {
        chop $olduserlines if ($olduserlines =~ /\n$/);
        print OLDUSER "$olduserlines\n";
    }
    close (OLDUSER);
    $update = 1;
    print "<br><br><center><font face=verdana><font size +2>User <b>$indata{'userid'}</b> modified successfully</font></font></center>\n";
    print "<br><br><center>Please ensure that the following code is displayed on your page(s):</center>\n";
      &htmlcode($owner, $indata{'userid'});
    print "<br><br>You must replace BOTH occurences of <b><font color=\"#$vlinkc\">XX</font></b> with a number between 01 and 99.<br>\n";
    print "You must change both occurences of <b><font color=\"#$vlinkc\">XX</font></b> with the SAME number.<br>\n";
    print "If you past this code onto more than one page, then each occurence of the code should have a DIFFERENT value for <b><font color=\"#$vlinkc\">XX</font></b>. \n";
    print "In other words, if you place the code on two pages, BOTH occurences of <b><font color=\"#$vlinkc\">XX</font></b> could be 01 on the first page and 02 on the second page.\n";
}

