#!/usr/bin/perl
# 
# ezrefpg.pl - EZ Site Referral Page Generator - by Manny Juan <manny@jps.net> 12/2/99
# http://www.inet-images.com/manny/refpages/
#
# this program was adapted from ezhomepg.pl, ezguest.pl, ezlinkpg.pl
#
#####################################################################################
$SIG{__DIE__} = \&Error_Msg;

sub Error_Msg {
    $msg = "@_";
    print "\ncontent-type: text/html\n\n";
    print "The following error occurred : $msg\n";
    exit;
}

# Get the input
read(STDIN, $input, $ENV{'CONTENT_LENGTH'});

    # split the input
    @pairs = split(/&/, $input);

    # split the name/value pairs
    foreach $pair (@pairs) {

    ($name, $value) = split(/=/, $pair);

    $name =~ tr/+/ /;
    $name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $value =~ s/<([^>]|\n)*>//g;
    $FORM{$name} = $value;
    }
$userdir = $FORM{'userdir'};
@gtoday=localtime(time);
$d=$gtoday[3];
$m=$gtoday[4];
$y=$gtoday[5];
$m+=1;
if($y<50) {$y+=2000} else {$y+=1900};

$win95=0;

######################################################################################
#  DO NOT CHANGE ANYTHING ABOVE THIS LINE
# set variables HERE

$cgi='pl';  # suffix for script - cgi or pl

# Set this to your base HTML directory. This is a PATH not a URL
$base_dir = "/home/htdocs/your.isp.com/website/$userdir";

# this is the URL where cgi scripts reside
$cgiurl = "http://www.isp.com/website/cgi-bin";

# This is your URL of where the new HTML pages will be kept - keep the trailing slash
$baseurl = "http://www.isp.com/website/$userdir/";

# This is a URL and dir for the images sub directory (where the logo will reside)
$imageurl = $baseurl;

# This is the path for generated site referral pages. You don't really need to change this
$page_dir = "$base_dir/";

# This is the index of all generated pages
# This file should be chmod to 777 and placed in the referral pages directory
$indexpage = "$base_dir/index.html";

# This is the location of the data.txt file. This holds each user's
# login name and e-mail address for confirmation  
# (you may change this to a secret word you know as a primitive form of security)
$data = "$base_dir/data.txt";

#Site title
$title="EZRefpg - Site Referral Mall";

# self explanatory variables for your site logo
$logo = "$imageurl/mjmall.jpg";
$logoalt = "Site Referral Mall";

# Location of the sendmail program
$sendmail = '/usr/sbin/sendmail';

# Your e-mail address here - emailid of the webmaster who is offering this service - you! (duh)
$myemail = 'email@your.isp.com';

# That's it.

# DO NOT CHANGE ANYTHING BELOW THIS LINE
######################################################################################

# Lets do some translating first
$usrname = $FORM{'usrname'};
$login = $FORM{'login'};
$email = $FORM{'email'};
$pagename = $FORM{'pagename'};
$updact = $FORM{'updact'};
$colorset = $FORM{'colorset'};
$allowname = $FORM{'allowname'};
$allowextra = $FORM{'allowextra'};
$mailsender = $FORM{'mailsender'};
$mailowner = $FORM{'mailowner'};
$siteurl = $FORM{'siteurl'};
$sitetitle = $FORM{'sitetitle'};
$stdmsg = $FORM{'stdmsg'};

$gbparms="$allowname~$allowextra~$mailsender~$mailowner~$siteurl~$sitetitle~$stdmsg";

# If the user tries to add more than one word in
# the page name field, this will put an underscore
# in the spaces to make it one word
$pagename =~ s/ /_/g;

if ($FORM{'action'} eq "New Page") {
    &newpage;
    }
if ($FORM{'action'} eq "Create Page") {
    &create;
    }
if ($FORM{'action'} eq "Edit Page") {
    &confirm("edit");
    }
if ($FORM{'action'} eq "checkuser") {
    &checkuser;
    }
if ($FORM{'action'} eq "recreate") {
    &recreate;
    }
if ($FORM{'action'} eq "Delete Page") {
    &confirm("delete");
    }
if ($FORM{'action'} eq "showstats") {
    &show_stats;
    }
    exit;

sub newpage {
    local($usrname, $email, $pagename, $colorset, $gbparms);

    ($usrname, $email, $pagename, $colorset, $gbparms) = split(/&&/, "");

    ($allowname, $allowextra, $mailsender, $mailowner, $siteurl, $sitetitle, $stdmsg) 
    = split('~',$gbparms);

    $stdmsg="this is a cool site!";
    $siteurl="http://";

    # To avoid any security risks. Take out the HTML tags added when HPM translated
    # the && to: <br><br>. They will be re-translated to: && Once the user updates
    # the page, the: && will be put back to: <br><br>

    # print the edit-page form

    print "content-type: text/html\n\n";
    print "<html><head><title>Create Your Own Site Referral Page</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\">\n";
    &put_banner;
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
    print "<table width=75% cellspacing=2 cellpadding=2 border=0>\n";
    print "<tr><td width=100% align=left valign=top>\n";
    print "<p><font face=\"Arial, Geneva\"><h2>Create Your Own Site Referral Page</h2></font></p>\n";
    print "<p>Below is an empty form for you to fill in.\n";
    print "You can edit any part of your page later</p>\n";
    print "<p></p>\n";
    print "<form action=\"$cgiurl/ezrefpg.$cgi\" method=POST>\n";
    print "<input type=hidden name=\"userdir\" value=\"$userdir\">\n";
    print "<input type=hidden name=\"action\" value=\"Create Page\">\n";
    print "<b>Your name:</b><br>\n";
    print "<font size=\"-1\">(will appear in page as link to your email)</font><br>\n";
    print "<input type=text size=40 name=\"usrname\" value=\"$usrname\"><br><br>\n";
    print "<h3>(The next 3 fields will be used for editing)<h3>\n";
    print "<b>Login Id:</b>\n";
    print "<font size=\"-1\">(one word only you should know, used later for editing)</font><br>\n";
    print "<input type=text size=40 name=\"login\" value=\"$login\"><br><br>\n";
    print "<b>Your e-mail:</b>\n";
    print "<font size=\"-1\">(used for editing, will also appear in page)</font><br>\n";
    print "<input type=text size=40 name=\"email\" value=\"$email\"><br><br>\n";
    print "<b>Your page:</b>\n";
    print "<font size=\"-1\">(one word, will become the name of your html file)</font><br>\n";
    print "<input type=text size=40 name=\"pagename\" value=\"$pagename\"><br><br>\n";
    print "<b>Your Site's Title:</b>\n";
    print "<font size=\"-1\">(title of the site you wish to refer)</font><br>\n";
    print "<input type=text size=40 name=\"sitetitle\" value=\"$sitetitle\"><br><br>\n";
    print "<b>Your Site's URL:</b>\n";
    print "<font size=\"-1\">(URL of the site you wish to refer)</font><br>\n";
    print "<input type=text size=40 name=\"siteurl\" value=\"$siteurl\"><br><br>\n";
    print "</td></tr></table>\n";

    &build_form_content($usrname, $email, $pagename, $colorset, $siteurl, $sitetitle, $stdmsg);
    print "<P><input type=submit value=\"create page\">\n";
    print "</form>\n";
    print "</body></html>\n";
    }

sub create {

    # Now, lets do some error checking. Making sure they filled out each field
    # This is pretty low tech now. I'll improve it later
    &missing(missing_name) unless $usrname;
    &missing(missing_email) unless $email;
    &missing(missing_pagename) unless $pagename;
    if ($email !~ /^\w+(\.)*\w+\@(\w|\-)+\.\w+/) {
        &input_error("invalid email id - $email");
        exit;
        }
    if ($siteurl !~ /^(f|ht)tp:\/\/(\w|\-)+\.\w+/) {
        &input_error("invalid site URL - $siteurl");
        exit;
        }

    # if they try to name their page "index" This will stop them
    if (uc($pagename) eq "INDEX") {
        print "content-type: text/html\n\n";
        print "<html><head><title>Error</title></head>\n";
        print "<body>";
        &put_banner;
        print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
        print "<p>You cannot name your page <b>index</b>\n";
        print "Please go back and re-name your page</p>\n";
        print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
        exit;
        }

    # if the user tries to name their page 
    # something that is already taken
    # this will HOPEFULLY stop them :)
    # This block was written by Norm
    if (-e "$page_dir$pagename\.html") {
        print "content-type: text/html\n\n";
        print "<html><head><title>Error</title></head>\n";
        print "<body>";
        &put_banner;
        print "<p>The page name: <b>$pagename</b>\n";
        print "is already taken.\n";
        print "Please go back and rename your page</p>\n";
        print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
        exit;
        }

    #now, lets create our new html page
    &buildpage_top($colorset, $gbparms);
    &buildpage_bot;
    &save_page_data;

    # Write the login name and email address to a separate file for confirmation
    # when they want to edit their page
    open (FILE, ">>$data") || die "I can't open >>$data\n";
    if($win95==0){flock (FILE, 2) or die "can't lock data file\n";}
    print FILE "$login&&$email&&$pagename\n";
    close(FILE);

    # create the log file
    open (LOG, ">$page_dir$pagename.log");
    print LOG "DATE SENDER RECIPIENT\n";
    close (LOG);

    # create the count file
    open(RFNFILE, ">$page_dir$pagename.rfn") || die "I can't create that file >$page_dir$pagename.rfn\n";
    if($win95==0){flock (RFNFILE, 2) or die "can't lock rfn file\n";}
    # put last-reset last-refer count
    print RFNFILE "$m/$d/$y $m/$d/$y 0\n";
    close(RFNFILE);

    # Suck the index page, and write the new entry to it
    open(FILE, "$indexpage") || die "I can't open that file $indexpage\n";
    if($win95==0){flock (FILE, 1) or die "can't lock index file\n";}
    @lines = <FILE>;
    close(FILE);
    $sizelines = @lines;

    # Now, re-open the index page, and add the new link
    open(FILE, ">$indexpage") || die "I can't open that file >$indexpage\n";
    if($win95==0){flock (FILE, 2) or die "can't lock index file\n";}

    for ($a = 0; $a <= $sizelines; $a++) {

        $_ = $lines[$a];

        if (/<!--begin-->/) {

            print FILE "<!--begin-->\n";
            print FILE "<p><font face=\"Arial, Geneva\" size=4><a href=\"$baseurl$pagename.html\">$sitetitle</a></font></p>\n";

        } else {
            print FILE $_;
            }
        }
    close(FILE);


    # Give the user a response
    print "content-type: text/html\n\n";
    print "<html><head><title>Thanks for using EZRefpg</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\">\n";
    &put_banner;
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
    print "<BR><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";

    print "Your site referral page has been created, and you will receive an e-mail confirming this!\n";
    print "Its URL is: <a href=\"$baseurl$pagename\.html\">\n";
    print "$baseurl$pagename\.html</a>\n";
    print "Remember to press Reload.\n";
    print "Thanks for your participation!<br><br>";
    print "Copy the HTML below somewhere in your referred page so visitors can recommend ";
    print "it to their friends by clicking on the link:\n\n";
    print "<FONT SIZE=4 FACE=\"Courier New\">\n";
    print "<center><pre>\n";
    print "&lt;center&gt;&lt;a href=\"$baseurl$pagename\.html\"&gt;Recommend This Page!&lt;/a&gt;&lt;/center&gt;\n";
    print "</pre></center>\n\n";
    print "</FONT>";
    print "It will look like this (try it - it works!):\n";
    print "<br><br><center><a href=\"$baseurl$pagename\.html\">Recommend This Page!</a></center>\n";
    print "<br><br>EZRefpg keeps track of the count and a log of referrals to your site.";
    print " To access these statistics and to view the HTML for the link, ";
    print "edit your site referral page from the ";
    print "<a href=\"$baseurl\">index</a> and click on ViewStats.";
    print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
    print "</body></html>\n";


    # Send the user an e-mail confirming their page
    open (MAIL, "| $sendmail -t") || die "I can't open sendmail\n";
    print MAIL "To: $usrname <$email>\n";
    print MAIL "From: $myemail\n";
    print MAIL "Subject: Your new URL on the $title\n";
    print MAIL "Your page can be viewed at the URL below:\n\n";
    print MAIL "$baseurl$pagename\.html\n\n";
    print MAIL "Copy this HTML code to the page you wish to refer\n\n";
    print MAIL "\<center\>\<a href=\"$baseurl$pagename\.html\"\>\n";
    print MAIL "Recommend This Page!\</a\>\</center\>\n\n";
    print MAIL "Thank you for using the $title\n\n";
    print MAIL "The Mall Manager - $myemail\n";
    close (MAIL);

    # Notify us when someone creates a page
    open (MAIL, "| $sendmail -t") || die "I can't open sendmail\n";
    print MAIL "To: $myemail\n";
    print MAIL "From: $usrname <$email>\n";
    print MAIL "Subject: $title New Page Report\n";
    print MAIL "$usrname created a new page:\n";
    print MAIL "$baseurl$pagename\.html\n";
    close(MAIL);

    }

sub recreate {
    if ($siteurl !~ /^(f|ht)tp:\/\/(\w|\-)+\.\w+/) {
        &input_error("invalid site URL - $siteurl");
        }

    #now, lets create our new html page
    # Suck the guestbook page
    open(FILE, "$page_dir$pagename.html") || die "I can't open that file page_dir$pagename.html\n";
    if($win95==0){flock (FILE, 1) or die "can't lock data file\n";}
    @lines = <FILE>;
    close(FILE);
    $sizelines = @lines;

    &buildpage_top($colorset, $gbparms);

    # rewrite the older entries, start from marker until end
    $sw=0;
    for ($a = 0; $a <= $sizelines; $a++) {
        $_ = $lines[$a];
        if(/<!--begin-->/) {$sw=1;}
        if ($sw==1) {
            print HTML "$_"; 
            }
        }
    &save_page_data;

    &ntfy_usr_edt;

    # Give the user a response
    print "content-type: text/html\n\n";
    print "<html><head><title>Thanks for using EZRefpg</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\">\n";
    &put_banner;
    print "<CENTER><IMG SRC=\"$logo\" alt=\"$logoalt\" border=0></CENTER>\n";
    print "<P><BR><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";
    print "Your page has been revised, and you will receive an e-mail confirming this!\n";
    print "Your URL is: <a href=\"$baseurl$pagename\.html\">\n";
    print "$baseurl$pagename\.html</a>\n";
    print "Remember to press Reload.\n";
    print "Thanks for your participation!<br><br>";
    print "Copy the HTML below somewhere in your referred page so visitors can recommend ";
    print "it to their friends by clicking on the link:\n\n";
    print "<FONT SIZE=4 FACE=\"Courier New\">\n";
    print "<center><pre>\n";
    print "&lt;center&gt;&lt;a href=\"$baseurl$pagename\.html\"&gt;Recommend This Page!&lt;/a&gt;&lt;/center&gt;\n";
    print "</pre></center>\n\n";
    print "</FONT>";
    print "It will look like this (try it - it works!):\n";
    print "<br><br><center><a href=\"$baseurl$pagename\.html\">Recommend This Page!</a></center>\n";
    print "<br><br>EZRefpg keeps track of the count and a log of referrals to your site.";
    print " To access these statistics and to view the HTML for the link, ";
    print "edit your site referral page from the ";
    print "<a href=\"$baseurl\">index</a> and click on ViewStats.";
    print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
    print "</body></html>\n";
    }

sub ntfy_usr_edt {
    # Send the user a notice that their page has been re-done
    open (MAIL, "| $sendmail -t") || die "I can't open sendmail\n";
    print MAIL "To: $usrname <$email>\n";
    print MAIL "From: $myemail\n";
    print MAIL "Subject: Your Changes on the $title\n";
    print MAIL "Your revised page can be viewed at the URL below:\n";
    print MAIL "\n";
    print MAIL "$baseurl$pagename\.html\n";
    print MAIL "\nOnce again thank you for using the $title\n";
    print MAIL "\n\nThe Mall Manager\n";
    close (MAIL);
    }

sub input_error {
    local ($errmsg) = @_;
    print "content-type: text/html\n\n";
    print "<html><head><title>Error</title></head>\n";
    print "<body>";
    &put_banner;
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
    print "<h1>Input Error!</h1><h3>$errmsg</h3>\n";
    print "<p>Please go back and correct</p></body></html>\n";
    }

sub buildpage_top {
    local ($colorset, $gbparms) = @_;
    if ($colorset eq "") {$colorset='FFFFFF~333333~006699~999900';}
    ($bkgdc, $textc, $linkc, $vlinkc) = split('~', $colorset);

    ($allowname, $allowextra, $mailsender, $mailowner, $siteurl, $sitetitle, $stdmsg) 
    = split('~',$gbparms);

    open(HTML, ">$page_dir$pagename\.html") || die "I can't create that file >$page_dir$pagename\.html\n";
    if($win95==0){flock (HTML, 2) or die "can't lock html file\n";}

    print HTML <<EOHTML;
<html><head><title>EZREFPG - Easy Site Referral Page</title></head>
<body bgcolor=\"#$bkgdc\" TEXT=\"#$textc\" link=\"#$linkc\" vlink=\"#$vlinkc\">
<!-- banner -->
<FORM ACTION=\"$cgiurl/ezrefadd.$cgi\" METHOD=\"POST\">
<CENTER><TABLE BORDER=1><FONT FACE=\"arial,helvetica\" COLOR=$vlinkc><TR><B>Tell Your Friends About My Site!</B></FONT>
EOHTML
    if ($allowname eq "1") { print HTML <<EOHTML;
<TD BGCOLOR=$linkc><FONT FACE=\"arial,helvetica\" COLOR=$bkgdc><B>Your Name</B></FONT></TD><TD><INPUT TYPE=\"text\" name=\"sndname\" SIZE=30 VALUE=\"$sndname\"></TD></TR><TR>
EOHTML
    }
    print HTML <<EOHTML;
<TD BGCOLOR=$linkc><FONT FACE=\"arial,helvetica\" COLOR=$bkgdc><B>Your E-mail</B></FONT></TD><TD><INPUT TYPE=\"text\" name=\"sndemail\" SIZE=30 VALUE=\"$sndemail\"></TD></TR><TR>
<TD BGCOLOR=$linkc><FONT FACE=\"arial,helvetica\" COLOR=$bkgdc><B>Your Friend's E-mail</B></FONT></TD><TD><INPUT TYPE=\"text\" name=\"rcpemail\" SIZE=30 VALUE=\"$rcpemail\"></TD></TR><TR>
EOHTML
    if ($allowextra eq "1") { print HTML <<EOHTML;
<TD BGCOLOR=$linkc><FONT FACE=\"arial,helvetica\" COLOR=$bkgdc><B>Your Message (Optional)</B></FONT></TD><TD><INPUT TYPE=\"text\" name=\"message\" SIZE=30 MAXLENGTH=$maxlength VALUE=\"$message\"></TD></TR>
EOHTML
    }
    print HTML <<EOHTML;
</TABLE>
<INPUT TYPE=\"submit\" VALUE=\"Send Mail!\"></CENTER>
<input type="hidden" name="colorset" value="$colorset">
<input type="hidden" name="email" value="$email">
<input type="hidden" name="usrname" value="$usrname">
<input type="hidden" name="userdir" value="$userdir">
<input type="hidden" name="pagename" value="$pagename">
<input type="hidden" name="allowname" value="$allowname">
<input type="hidden" name="allowextra" value="$allowextra">
<input type="hidden" name="mailsender" value="$mailsender">
<input type="hidden" name="mailowner" value="$mailowner">
<input type="hidden" name="siteurl" value="$siteurl">
<input type="hidden" name="sitetitle" value="$sitetitle">
<input type="hidden" name="stdmsg" value="$stdmsg">
<input type="hidden" name="maxlength" value="40">
</FORM>
<a href=\"$siteurl\">Return to site</a>
EOHTML

    }

sub buildpage_bot {
    print HTML "<!--begin-->\n";
    print HTML "<!--end-->\n";
    print HTML "<center><a href=\"mailto:$email\">$usrname</a></font></center>\n";
    print HTML "<center><font size=-1>";
    print HTML "This page was generated by <b>ezrefpg.$cgi</b> found at ";
    print HTML "<a href=http://www.inet-images.com/manny/>manny juan's script page</a></font>\n";
    print HTML "</center>\n";
    print HTML "</body></html>\n";
    close(HTML);
    }

sub save_page_data {
    # Write all of the input into a flat file.
    open(FILE, ">$page_dir$pagename\.dat") || die "I can't create that file >$page_dir$pagename\.dat\n";
    if($win95==0){flock (FILE, 2) or die "can't lock user data file\n";}
    print FILE "$usrname&&$email&&$pagename&&$colorset&&$gbparms\n";
    close(FILE);

    }

# Standard error message for any missing required fields
sub missing {
    local ($missing) = @_;
    print "content-type: text/html\n\n";

    print "<HTML><head><TITLE>Missing Field Error</TITLE></head>\n";
    print "<body>\n";
    &put_banner;    
    print "You forgot to fill in one of the fields. Please go back and make\n";
    print "sure that all required fields are filled in! $missing\n";
    print "</body></HTML>\n";
    exit;
    }

sub confirm {
    local ($updact) = @_;

    print "content-type: text/html\n\n";
    print "<html><head><title>$updact Confirmation</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\" >\n";
    &put_banner; 
    print "<CENTER><IMG SRC=\"$logo\" alt=\"$logoalt\"  border=0></CENTER>\n";
    print "<P><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";
    print "<p><h3>Please Enter your login name, e-mail and name of your file to $updact</h3></p>\n";
    print "<form action=\"$cgiurl/ezrefpg.$cgi\" method=POST>\n";
    print "<input type=hidden name=\"userdir\" value=\"$userdir\">\n";
    print "<P><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";
    print "Login name:<br>\n";
    print "<input size=40 type=text name=\"login\"><br><br>\n";
    print "E-mail:<br>\n";
    print "<input size=40 type=text name=\"email\"><br><br>\n";
    print "Name of your file:<br>\n";
    print "<input type=text size=40 name=\"pagename\"><br><br>\n";
    print "<input type=submit value=submit>\n";
    print "<input type=hidden name=\"action\" value=\"checkuser\">\n";
    print "<input type=hidden name=\"updact\" value=\"$updact\">\n";
    print "</FONT>\n";
    print "</form></body></html>\n";
    }

sub checkuser {
    open(FILE, "$data") || die "I can't open $data\n";  
    if($win95==0){flock (FILE, 1) or die "can't lock data file\n";}

    while(<FILE>) {
    chop;       
    @all = split(/\n/);

    foreach $line (@all) {
    ($loginname, $loginemail, $loginpagename) = split(/&&/, $line);
    if($loginname eq "$login" && $loginemail eq "$email" && $loginpagename eq "$pagename") {
        $match = 1;
        if($updact eq "edit") {
          &edit($loginpagename);
          }
        else {
          &delpage($loginpagename);
          }
        }
      }
    }

    close(FILE);

    if (! $match) {
        &error;
        }

    # del entry from data
    if($updact eq "delete") {

        # Suck the index page, and write the new entry to it
        open(FILE, "$data") || die "I can't open that file $data\n";
        if($win95==0){flock (FILE, 1) or die "can't lock data file\n";}
            @lines = <FILE>;
            close(FILE);
            $sizelines = @lines;

        # Now, re-open the links file, and comment out the page to delete
        open(FILE, ">$data") || die "I can't open that file >$data\n";
        if($win95==0){flock (FILE,2) or die "can't lock index file for append\n";}
        chop;
                for ($a = 0; $a <= $sizelines; $a++) {
                $_ = $lines[$a];
                $w = $_;
                $w =~ s/\cM//g;
                $w =~ s/\n//g;
        ($loginname, $loginemail, $loginpagename) = split(/&&/, $w);
        if($loginname eq "$login" && $loginemail eq "$email" && $loginpagename eq "$pagename") {
              # do nothing  (ie. don't write)
              } 
            else {
              if($w eq "") {
                # do nothing (skip)
                }
              else {
                print FILE "$w\n";
                }
              }
            }
        close(FILE);
        print "content-type: text/html\n\n";
        print "<html><head><title>$updact Confirmation</title></head>\n";
        print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\" >\n";
        &put_banner; 
        print "<CENTER><IMG SRC=\"$logo\" alt=\"$logoalt\" border=0></CENTER>\n";
        print "<P><BR><FONT SIZE=4 FACE=\"COMIC SANS MS,ARIAL\">\n";
        print "<p>your page has been deleted";
        print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
        print "</form></body></html>\n";
      }
    }

sub edit {

    local ($editfile) = @_;
    
    open(FILE, "$page_dir$editfile\.dat") || die "I can't open $page_dir$editfile\.dat\n";
    if($win95==0){flock (FILE, 1) or die "can't lock data file for edit\n";}

    while(<FILE>) {
    chop;
    @datafile = split(/\n/);

    foreach $line (@datafile) {
        &build_edit_form($line);
            }
         }
    close(FILE);
    }

sub delpage {
    local ($editfile) = @_;
    $cnt=unlink "$page_dir$editfile\.rfn";
    $cnt=unlink "$page_dir$editfile\.dat";
    $cnt=unlink "$page_dir$editfile\.log";
    $cnt=unlink "$page_dir$editfile\.html";

    # Suck the index page, and write the new entry to it
    open(FILE, "$indexpage") || die "I can't open that file $indexpage\n";
    if($win95==0){flock (FILE, 1) or die "can't lock index file\n";}
        @lines = <FILE>;
        close(FILE);
        $sizelines = @lines;

    # Now, re-open the links file, and comment out the page to delete
    open(FILE, ">$indexpage") || die "I can't open that file >$indexpage\n";
    if($win95==0){flock (FILE, 2) or die "can't lock index file to delete entry\n";}

            for ($a = 0; $a <= $sizelines; $a++) {

            $_ = $lines[$a];

        if (/$pagename.html/) {
          # do nothing  (ie. don't write)
          } 
        else {
          print FILE $_;
           }
        }
    close(FILE);

    }

sub build_edit_form {
    local ($line) = @_;
    local($usrname, $email,  $pagename, $colorset, $gbparms);

    ($usrname, $email, $pagename, $colorset, $gbparms) = split(/&&/, $line);

    ($allowname, $allowextra, $mailsender, $mailowner, $siteurl, $sitetitle, $stdmsg)
     = split('~',$gbparms);

    # To avoid any security risks. Take out the HTML tags added when HPM translated
    # the && to: <br><br>. They will be re-translated to: && Once the user updates
    # the page, the: && will be put back to: <br><br>

    # print the edit-page form

    print "content-type: text/html\n\n";
    print "<html><head><title>Edit Your Page</title></head>\n";
    print "<body bgcolor=\"#ffffff\" TEXT=\"#000000\" link=\"#008000\" vlink=\"#800040\">\n";
    &put_banner; 
    print "<center><img src=\"$logo\" alt=\"$logoalt\" border=0></center><p>\n";
    print "<table width=75% cellspacing=2 cellpadding=2 border=0>\n";
    print "<tr><td width=100% align=left valign=top>\n";
    print "<p><font face=\"Arial, Geneva\"><h2>Edit Your Page</h2></font></p>\n";
    print "<p>Below is a form with the contents\n";
    print "of the site referral page you created. You can edit any part of your page</p>\n";
    print "<p></p>\n";
    print "<form action=\"$cgiurl/ezrefpg.$cgi\" method=POST>\n";
    print "<input type=hidden name=\"userdir\" value=\"$userdir\">\n";
    print "<input type=hidden name=\"action\" value=\"recreate\">\n";
    print "Your name:<br>\n";
    print "<input type=text size=40 name=\"usrname\" value=\"$usrname\"><br><br>\n";
    print "Your e-mail:<br>\n";
    print "<input type=text size=40 name=\"email\" value=\"$email\"><br><br>\n";
    print "Name of HTML file: <b>$pagename</b><br>\n";
    print "<input type=hidden name=\"pagename\" value=\"$pagename\">\n";
    print "Your Site's Title: <b>$sitetitle</b><br><br>\n";
    print "<input type=hidden name=\"sitetitle\" value=\"$sitetitle\">\n";
    print "Your Site's URL:\n";
    print "<font size=\"-1\">(URL of the site you wish to refer- eg. http://...)</font><br>\n";
    print "<input type=text size=40 name=\"siteurl\" value=\"$siteurl\"><br><br>\n";
    print "</td></tr></table>\n";

    &build_form_content($usrname, $email, $pagename, $colorset, $siteurl, $sitetitle, $stdmsg);
    print "<P><input type=submit value=\"update page\">\n";
    print "</form>\n";
    print "<hr><form action=\"$cgiurl/ezrefpg.$cgi\" method=POST>\n";
    print "<p><font face=\"Arial, Geneva\"><h2>View Stats and HTML</h2></font></p>\n";
    print "Press this button to view referral counts and referral log and to view the HTML for the link.\n";
    print "<input type=hidden name=\"userdir\" value=\"$userdir\">\n";
    print "<input type=hidden name=\"pagename\" value=\"$pagename\">\n";
    print "<input type=hidden name=\"siteurl\" value=\"$siteurl\">\n";
    print "<input type=hidden name=\"sitetitle\" value=\"$sitetitle\">\n";
    print "<input type=hidden name=\"action\" value=\"showstats\">\n";
    print "<P><input type=submit value=\"view stats\">\n";
    print "</form>\n";
    print "</body></html>\n";
    }

sub build_form_content {
    local ($usrname, $email, $pagename, $colorset, $siteurl, $sitetitle, $stdmsg)=@_;

    print "Message that will be sent to the Recipient:<br>\n";
    print "<input type=text size=40 name=\"stdmsg\" value=\"$stdmsg\"><br><br>\n ";
    print "<b>Select Preset Colors:</b>";
    print "<SELECT NAME=\"colorset\">";
    &put_clropt($colorset,'01','FFFFFF~333333~006699~999900');
    &put_clropt($colorset,'02','CCCCCC~000000~0000CC~660066');
    &put_clropt($colorset,'03','FFFF00~FF6600~FF0033~336633');
    &put_clropt($colorset,'04','CCCC66~330000~CC0000~003300');
    &put_clropt($colorset,'05','FFFF99~330000~CC0000~333333');
    &put_clropt($colorset,'06','99CCCC~000066~0000CC~003366');
    &put_clropt($colorset,'07','CC99FF~000000~FF0033~660066');
    &put_clropt($colorset,'08','CCFF99~666600~006699~003300');
    &put_clropt($colorset,'09','FFCC00~330000~CC0000~660066');
    &put_clropt($colorset,'10','00FF33~0000CC~FF0099~660066');
    &put_clropt($colorset,'11','006699~CCFFCC~FFFF00~00FFFF');
    &put_clropt($colorset,'12','330000~FF6666~FFCC00~CCFF99');
    &put_clropt($colorset,'13','003300~CCCC66~FFFFFF~FFFF00');
    &put_clropt($colorset,'14','333333~CCCCCC~FF6666~CCCC66');
    &put_clropt($colorset,'15','666600~FFFFFF~FFFF00~99CCFF');
    &put_clropt($colorset,'16','000000~99CCFF~FFFF00~CCCC66');
    &put_clropt($colorset,'17','333333~FFFFFF~99CCFF~CC99FF');
    &put_clropt($colorset,'18','CC0000~FFFFFF~FFFF00~00FFFF');
    print "\n</SELECT>";
    print "<br><img src=\"$baseurl/ezpalette.gif\"><br><br>\n";
    print "<table>";
    &prt_ckb($allowname, 'allowname', 'allow referrer to enter name');
    &prt_ckb($allowextra, 'allowextra', 'allow referrer to add extra message');
    &prt_ckb($mailsender, 'mailsender', 'send note to referrer');
    &prt_ckb($mailowner, 'mailowner', 'send note to owner');
    print "</table>";
    }

sub put_clropt  {
    local ($colorset, $id, $colors)=@_;
    print "\n<OPTION VALUE=\"$colors\"";
    if ($colorset eq $colors) {print " SELECTED";}
    print ">$id";
    }

sub prt_ckb {
    local ($var, $varname, $ckbdesc) = @_;
    print "\n<tr><td><INPUT TYPE=\"CHECKBOX\" NAME=\"$varname\" VALUE=\"1\"";
    if ($var eq "1") {print " CHECKED";} 
    print "></td>";
    print "<td>$ckbdesc</td></tr>";
    }

sub show_stats {
# Open the data file to read the number of the last post
    open (ADNFILE, "$page_dir$pagename.rfn");
    $rfnrec = <ADNFILE>;
    ($begmdy, $lstmdy, $refno) = split(' ',$rfnrec);
    close (ADNFILE);

    print "content-type: text/html\n\n";
    print "<html><head><title>EZRefpg Stats</title></head>\n";
    print "<body>\n";
    &put_banner; 
    print "\n<h1>Stats for $sitetitle</h1>\n";
    print "<p>Since $begmdy, there have been $refno referrals to this site.";
    print " The last referral was made on $lstmdy.\n";
    print "<hr><font size=\"-1\">(these statistics will be reset when someone";
    print " refers this page after this month).</font>\n";
    open(FILE, "$page_dir$pagename.log") || die "I can't open $page_dir$pagename.log\n";  
    if($win95==0){flock (FILE, 1) or die "can't lock data file\n";}

    print "<p><table border=\"1\">";    
    while(<FILE>) {
        chop;       
        @log = split(/\n/);

        foreach $line (@log) {
            ($refdate, $sndemail, $rcpemail) = split(/ /, $line);
            print "<tr><td>$refdate</td><td>$sndemail</td><td>$rcpemail</td></tr>\n";
            }
        }
    close(FILE);
    print "</table>";   
    print "<hr><h1>HTML Code</h1>";
    print "Copy this HTML code to the page you wish to refer";
    print "<FONT SIZE=4 FACE=\"Courier New\">\n";
    print "<dir><pre>\n";
    print "&lt;center&gt;&lt;a href=\"$baseurl$pagename\.html\"&gt;\n";
    print "Recommend This Page!&lt;/a&gt;&lt;/center&gt;\n";
    print "</pre></dir>\n\n";
    print "</FONT>";

    print "\n<br><a href=\"$siteurl\">Return to site</a>";
    }

sub error {
    local ($updact) = @_;
    print "content-type: text/html\n\n";
    print "<html><head><title>Permission Denied</title></head>\n";
    print "<body>\n";
    &put_banner; 
    print "<p><h1>Permission Denied</h1></p>\n";
    print "You do not have permission to $updact\n";
    print "<p>(Return to <a href=\"$baseurl\">User Pages</a>)\n";
    print "</body></html>\n";
    exit;
    }

sub put_banner {
    print "<!-- banner -->";
    }
