#!/usr/bin/perl -w
#############################################################################
# setup.pl - eases NeoMail configuration.                                   #
# Copyright (C) 2000 Ernie Miller                                           #
#                                                                           #
# This program is free software; you can redistribute it and/or             #
# modify it under the terms of the GNU General Public License               #
# as published by the Free Software Foundation; either version 2            #
# of the License, or (at your option) any later version.                    #
#                                                                           #
# This program is distributed in the hope that it will be useful,           #
# but WITHOUT ANY WARRANTY; without even the implied warranty of            #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
# GNU General Public License for more details.                              #
#                                                                           #
# You should have received a copy of the GNU General Public License         #
# along with this program; if not, write to the Free Software Foundation,   #
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.           #
#############################################################################

use strict;

unless ($< == 0) {
   print "You must be root to run this script.\n";
   exit 1;
}

print <<EndOfMessage
**********************************
****** COMPATIBILITY CHECKS ******
**********************************

IF ANY OF THESE CHECKS FAIL, INSTALLATION WILL NOT CONTINUE.
PLEASE INSTALL THE APPROPRIATE DBM LIBRARY OR MODULE AND TRY AGAIN.

Checking for installation of Berkely DB or GNU DB capability...
EndOfMessage
;
BEGIN { @AnyDBM_File::ISA = qw(DB_File GDBM_File) }
require AnyDBM_File;
print "Looks OK.\n";

print "Checking for up-to-date CGI.pm...\n";
require CGI;

unless ($CGI::VERSION >= 2.72) {
   die "Your CGI.pm is outdated.  You have version $CGI::VERSION, while NeoMail
requires at least 2.72.\n";
}
print "Looks OK.\n";

print "Checking for MD5.pm...\n";
require MD5;
print "Looks OK.\n\n";

my $input;

print "Hit <ENTER> to continue.";
$input = <STDIN>;

my $mailgroup = "mail";
my $httpduser;
my $cgibin;
my $documentroot;

foreach my $guess (qw(/usr/local/apache/conf/httpd.conf
                      /usr/local/etc/apache/httpd.conf
                      /usr/local/etc/apache/apache.conf
                      /var/www/conf/httpd.conf
                      /etc/apache/conf/httpd.conf
                      /etc/httpd/conf/httpd.conf
                      /etc/httpd/httpd.conf)) {
   if ( -f $guess ) {
      open (HTTPDCONF, $guess) or warn "Insufficient priveleges to open $guess for reading.\n";
      while (<HTTPDCONF>) {
         if (/^\s*User\s+"?([-\w]+)"?\s*$/) {
            $httpduser = $1;
         }
         if (/^\s*ScriptAlias\s+[^\s]+\s+(.+)\s*$/) {
            $cgibin = $1;
            $cgibin =~ s/\"//g;
         }
         if (/^\s*DocumentRoot\s+([^\s]+)\s*$/) {
            $documentroot = $1;
            $documentroot =~ s/\"//g;
         }
      }
      close(HTTPDCONF);
   }
}
$httpduser ||= 'Undetermined';
$cgibin ||= '/home/httpd/cgi-bin/';
$documentroot ||= '/home/httpd/html/';

my $domainname;
my $uname = `uname`;
if ($uname =~ /Linux/i) {
   $domainname = `hostname -f`;
   chomp ($domainname);
} else {
   $domainname = `hostname`;
   chomp ($domainname);
}

my $sendmail;

foreach my $guess (qw(/var/lib/sendmail
                      /usr/lib/sendmail /usr/sbin/sendmail
                      /usr/libexec/sendmail /usr/libexec/sendmail/sendmail)) {
   if ( -x $guess ) {
      $sendmail = $guess;
   }
}
$sendmail ||= 'Undetermined';

my $passwdfile;

foreach my $guess (qw(/etc/master.passwd /etc/shadow /etc/passwd)) {
   if ( -e $guess ) {
      open (PASSWD, $guess) or warn "Insufficient priveleges to open $guess for reading.\n";
      my $line = <PASSWD>;
      if (length((split(/:/, $line))[1]) > 3) {
         $passwdfile = $guess;
      }
   }
}
$passwdfile ||= 'Undetermined';

my $neomaildir = '/var/neomail';

my $timeoffset = '-0500';

my $sessiontimeout = '30';

my $numberofheaders = '20';

my $maxabooksize = '50';

my $folderquota = '0';

my $attlimit = '1';

my $defaultlanguage = 'en';

my $mailspooldir;

foreach my $guess (qw(/usr/spool/mail /var/spool/mail /var/mail)) {
   if ( -d $guess ) {
      $mailspooldir = $guess;
   }
}
$mailspooldir ||= 'Undetermined';

my $scripturl = "/cgi-bin/neomail.pl";

my $prefsurl = "/cgi-bin/neomail-prefs.pl";

my $homedirspools = 'no';

my $hashedmailspools = 'no';

my $homedirspoolname = 'Mailbox';

my $bg_url = '/neomail-bg.gif';

my $logo_url = '/neomail.gif';

my $image_url = '/images/';

my $needsuidroot = 'no';

my $homedirfolders = 'no';

print <<EndOfMessage


NEOMAIL SETUP
=============
Welcome to the NeoMail install script!  This script will prompt you for some
basic information about your desired setup, then install NeoMail according to
your specifications.  To accept the default value for any question, simply hit
Enter at the prompt. Don't forget to run feedback.pl once you've installed 
NeoMail and have some opinions to share!

EndOfMessage
;

my $suidperlfound='no';
my $suidperlperms='no';
foreach my $guess (qw(/usr/bin/suidperl
                      /usr/local/bin/suidperl)) {
   if ( -f $guess ) {
      $suidperlfound = $guess;
   }
   if ( -o $guess && -u $guess ) {
      $suidperlperms = $guess;
   }
}
if ( $suidperlfound eq 'no' ) {
   print <<EndOfMessage

WARNING
=======
WARNING: I couldn't find suidperl on your system. NeoMail won't function
properly without suidperl installed.

Hit <ENTER> to continue.
EndOfMessage
;
   $input = <STDIN>;
} elsif ( $suidperlperms eq 'no' ) {
   $suidperlperms = `ls -la $suidperlfound`;
   print <<EndOfMessage

WARNING
=======
WARNING: I found suidperl on your system, but its permissions seem to be
incorrect!  NeoMail may behave unexpectedly until this is corrected.  Suidperl
should be owned by root and suid.  Here is a listing of suidperl's current
permissions on your system:

$suidperlperms
EndOfMessage
;
   print "Would you like to automatically correct this? y/n [n]: ";
   chomp($input = <STDIN>);

   if ($input =~ /^y/i) {
      print "Changing permissions...";
      chown (oct(0), oct(0), $suidperlfound);
      chmod (oct(4755), $suidperlfound);
      print "Done!\n";
   }
}

print <<EndOfMessage

NEOMAIL DIRECTORY
=================
Please supply the directory you want NeoMail to store its file in.  Leave off
the trailing slash.  This directory will be auto-created for you if it doesn't
exist.

EndOfMessage
;

print "[$neomaildir]: ";
chomp($input = <STDIN>);

if ($input) {
   $neomaildir = $input;
}

print <<EndOfMessage

DEFAULT LANGUAGE
================
What language would you like to be NeoMail's default language?

   en == English               cn == Chinese (GB2312)
   cz == Czech                 de == German (Deutsch)
   dk == Danish                es == Spanish (Espanol)
   fi == Finnish               fr == French (Francais)
   hu == Hungarian             it == Italian (Italiano)
   ko == Korean                nl == Dutch (Nederlands)
   no == Norwegian (Norsk)     pl == Polish
   pt == Portuguese            ro == Romanian
   ru == Russian               se == Swedish
   si == Slovene               sk == Slovak
   tw == Chinese (Big5)

EndOfMessage
;
print "[$defaultlanguage]: ";

chomp($input = <STDIN>);

if ($input) {
   $defaultlanguage = $input;
}

print <<EndOfMessage

MAIL SPOOL GROUP ID
===================
What is the group id that your mail spools allow writing by? On most servers,
this is the group called "mail," but your machine may differ.  If your mail
spools aren't all under a common group, or aren't group writable, type 'suid'
here and NeoMail will be installed suid root.

EndOfMessage
;
print "[$mailgroup] group/suid: ";

chomp($input = <STDIN>);

if ($input) {
   if ($input eq 'suid') {
      $mailgroup = 'neomail';
      $needsuidroot = 'yes';
      die ("You need to create a neomail group because you plan to run suid.  Please, create this group, then re-run setup.\n") unless (getgrnam("neomail"));
   } else {
      $mailgroup = $input;
   }
}

print <<EndOfMessage

DOMAIN NAME
===========
What domain name would you like appended to all outgoing messages?  You can
provide a list of domains separated by spaces here to give users a choice.  Put
the default choice first.

EndOfMessage
;
print "[$domainname]: ";

chomp($input = <STDIN>);

if ($input) {
   $domainname = $input;
}

print <<EndOfMessage

SENDMAIL
========
Please supply the location of your sendmail binary.  The default, if supplied,
is the autodetected location.  NOTE: If you're using an alternate MTA, such as
postfix or exim, you should still reference the sendmail compatibility binary
that these MTAs provide, not the exim or postfix binary itself!

EndOfMessage
;
print "[$sendmail]: ";

chomp($input = <STDIN>);

if ($input) {
   $sendmail = $input;
}

print <<EndOfMessage

PASSWORD FILE
=============
Please supply the location of the file containing your encrypted passwords.
The default, if supplied, is the autodetected location.  Note that if you'd
prefer to authenticate users from a different password file than the system
password file, you can specify it here and limit user access to a subset of
your system users, or allow access to users whose system accounts have their
password locked out.  Great for you security-conscious types out there. :)

EndOfMessage
;
print "[$passwdfile]: ";

chomp($input = <STDIN>);

if ($input) {
   $passwdfile = $input;
}

my $logfile = $neomaildir . "/neomail.log";
print <<EndOfMessage

NEOMAIL LOGFILE
===============
If you give a filename here, NeoMail will log some important events to this
file.  Among these are successful and unsuccessful login attempts, as well as
expired sessions, and cleanup of old sessions.  This information can be very
useful in debugging NeoMail, and keeping tabs on your users.  Remember to keep
an eye on the logfile's size though!  If you'd like to disable logging, type
'n' here.

EndOfMessage
;
print "filename/n [$logfile]: ";
 
chomp($input = <STDIN>);
 
if ($input) {
   if ($input =~ /^n/i) {
      $logfile='no';
   } else {
      $logfile = $input;
   }
}

print <<EndOfMessage

TIME OFFSET
===========
What is the time offset in relation to GMT in your region? The default is an
example of the offset for EST (GMT -0500).  If your region supports Daylight
Savings Time, put the standard timezone in.  NeoMail will auto-adjust for DST.

EndOfMessage
;
print "[$timeoffset]: ";

chomp($input = <STDIN>);

if ($input) {
   $timeoffset = $input;
}

print <<EndOfMessage

SESSION TIMEOUT
===============
How many minutes would you like NeoMail to wait before timing out inactive
sessions?  Keep in mind that if too short a time is chosen, users typing long
messages may get timed out as inactive.

EndOfMessage
;
print "[$sessiontimeout]: ";

chomp($input = <STDIN>);

if ($input) {
   $sessiontimeout = $input;
}

print <<EndOfMessage

NUMBER OF HEADERS
=================
How many message headers would you like to display per page?  Keep this number
reasonable to provide better usability for low-bandwidth users.

EndOfMessage
;
print "[$numberofheaders]: ";

chomp($input = <STDIN>);

if ($input) {
   $numberofheaders = $input;
}

print <<EndOfMessage

MAXIMUM ADDRESS BOOK SIZE
=========================
How many kilobytes per user would you like to allocate for address books?
Users who exceed this limit will be unable to add additional addresses until
they free up some space.

EndOfMessage
;
print "[$maxabooksize]: ";

chomp($input = <STDIN>);

if ($input) {
   $maxabooksize = $input;
}

print <<EndOfMessage

FOLDER QUOTA
============
Once a user's saved mail spools (not including their INBOX, which, if managed,
will have to be managed with system quotas) meet or exceed this size (in KB),
no future messages will be able to be sent to any folder other than TRASH,
where they will be immediately wiped out.  This does NOT prevent the operation
taking the user over this limit from completing, it simply inhibits further
saving of messages until the user's disk usage by folders is brought down to
below this amount again.  The default is 0, disabling this feature.

EndOfMessage
;
print "[$folderquota]: ";

chomp($input = <STDIN>);

if ($input ne '') {
   $folderquota = $input;
}

print <<EndOfMessage

ATTACHMENT SIZE LIMIT
=====================
This is the limit on the size of attachments (in MB).  Large attachments can
significantly drain a server's resources during the encoding process.  Note
that this affects outgoing attachment size only, and will not prevent users
from receiving messages with large attachments.  That's up to you in your
sendmail configuration. :)  Set this to 0 to disable the limit (not
recommended).

EndOfMessage
;
print "[$attlimit]: ";

chomp($input = <STDIN>);

if ($input ne '') {
   $attlimit = $input;
}

print <<EndOfMessage

SCRIPT LOCATION
===============
Where will the script reside on your web server? We need the location relative
to ServerRoot here.  A likely possibility has been provided below.

EndOfMessage
;
print "[$scripturl]: ";

chomp($input = <STDIN>);

if ($input) {
   $scripturl = $input;
}

print <<EndOfMessage

PREFS LOCATION
==============
Where will the NeoMail preferences script reside on your web server? We need
the location relative to ServerRoot here.  A likely possibility has been
provided below.

EndOfMessage
;
print "[$prefsurl]: ";

chomp($input = <STDIN>);

if ($input) {
   $prefsurl = $input;
}

print <<EndOfMessage

CGI-BIN LOCATION
================
What is the full path to your system's cgi-bin directory?  The NeoMail scripts
will be installed here.  We've placed our best guess below, but if you run into
trouble, double-check it.

EndOfMessage
;
print "[$cgibin]: ";

chomp($input = <STDIN>);

if ($input) {
   $cgibin = $input;
}

print <<EndOfMessage

DOCUMENTROOT LOCATION
=====================
What is the full path to your system's DocumentRoot?  The NeoMail logos will be
installed here and buttons under the images/ subdirectory.  We've placed our
best guess below, but if you run into trouble, double-check it.

EndOfMessage
;
print "[$documentroot]: ";

chomp($input = <STDIN>);

if ($input) {
   $documentroot = $input;
}

print <<EndOfMessage

PINE COMPATIBILITY
==================
Would you like to store user folders in the ~user/mail directory, and use the
PINE conventions for trash and sent-mail folders?  This option will cause
NeoMail to install setuid root.

EndOfMessage
;
print "y/n [n]: ";

chomp($input = <STDIN>);

if ($input =~ /^y/i) {
   $homedirfolders = 'yes';
   $mailgroup = 'neomail';
   $needsuidroot = 'yes';
   die ("You need to create a neomail group because this feature requires you to run suid.  Please, create this group, then re-run setup.\n") unless (getgrnam("neomail"));
}

print <<EndOfMessage

QMAIL SUPPORT
=============
Do you use the qmail MTA?  Answer yes here only if you know you're using qmail
using qmail and you use the "Mailbox in home directory" feature.  This is
STRICTLY for ./Mailbox delivery method -- NeoMail does not (yet) support
./Maildir!

EndOfMessage
;
print "y/n [n]: ";

chomp($input = <STDIN>);

if ($input =~ /^y/i) {
   $homedirspools = 'yes';
   $mailgroup = 'neomail';
   $needsuidroot = 'yes';
   die ("You need to create a neomail group because this feature requires you to run suid.  Please, create this group, then re-run setup.\n") unless (getgrnam("neomail"));
}

if ($homedirspools eq 'yes') {
   print <<EndOfMessage

QMAIL SUPPORT: MAILBOX
======================
What filename are the user mailboxes stored under in the users' home
directories?

EndOfMessage
;
   print "[$homedirspoolname]: ";

   chomp($input = <STDIN>);

   if ($input) {
      $homedirspoolname = $input;
   }
} else {
   print <<EndOfMessage

MAIL SPOOL
==========
Where are your user mail spool files located?  The default is our best guess.

EndOfMessage
;
   print "[$mailspooldir]: ";

   chomp($input = <STDIN>);

   if ($input) {
      $mailspooldir = $input;
   }
   print <<EndOfMessage

HASHED MAIL SPOOLS
==================
Do you use hashed mail spools?  Answer yes here if your mail spools are
arranged like /var/spool/mail/u/s/username.  If unsure, say no.

EndOfMessage
;
   print "y/n [n]: ";

   chomp($input = <STDIN>);

   if ($input =~ /^y/i) {
      $hashedmailspools = 'yes';
   }
}

print <<EndOfMessage

BACKGROUND IMAGE
================
Please supply the location (relative to DocumentRoot) of an image you'd like to
use as a background for NeoMail pages.  The images defaulted to from here on
are included in the NeoMail distribution, and will be copied to the necessary
directories, but you can always choose different ones and copy them manually.

EndOfMessage
;
print "[$bg_url]: ";

chomp($input = <STDIN>);

if ($input) {
   $bg_url = $input;
}

print <<EndOfMessage

LOGO IMAGE
==========
Please supply the location of a logo you'd like displayed at the top of NeoMail
pages, relative to DocumentRoot.

EndOfMessage
;
print "[$logo_url]: ";

chomp($input = <STDIN>);

if ($input) {
   $logo_url = $input;
}

print <<EndOfMessage

DIRECTORY FOR IMAGES
====================
Where would you like to store the button images on your web server?  This
location is relative to DocumentRoot.  Setup will copy them here for you.

EndOfMessage
;
print "[$image_url]: ";

chomp ($input = <STDIN>);

if ($input) {
   $image_url = $input;
}

print "\n\nReady to install.  Hit <ENTER> to continue.";
$input = <STDIN>;

my $neomailfile = '';
my $prefsfile = '';
my $conffile = '';

print "\nReading templates...\n";

open (TEMPLATE, "neomail.template") or die "Can't open neomail.template!\n";
while (<TEMPLATE>) {
   $neomailfile .= $_;
}
close(TEMPLATE);

open (TEMPLATE, "neomail-prefs.template") or die "Can't open neomail-prefs.template!\n";
while (<TEMPLATE>) {
   $prefsfile .= $_;
}
close(TEMPLATE);

open (TEMPLATE, "neomail.conf.template") or die "Can't open neomail.conf.template!\n";
while (<TEMPLATE>) {
   $conffile .= $_;
}
close(TEMPLATE);

print "Performing substitutions...\n";

$conffile =~ s/\@\@\@DOMAINNAME\@\@\@/$domainname/sg;
$conffile =~ s/\@\@\@DEFAULTLANGUAGE\@\@\@/$defaultlanguage/sg;
$conffile =~ s/\@\@\@SENDMAIL\@\@\@/$sendmail/sg;
$conffile =~ s/\@\@\@PASSWDFILE\@\@\@/$passwdfile/sg;
$conffile =~ s/\@\@\@LOGFILE\@\@\@/$logfile/sg;
$conffile =~ s/\@\@\@SESSIONTIMEOUT\@\@\@/$sessiontimeout/sg;
$conffile =~ s/\@\@\@TIMEOFFSET\@\@\@/$timeoffset/sg;
$conffile =~ s/\@\@\@NEOMAILDIR\@\@\@/$neomaildir/sg;
$conffile =~ s/\@\@\@NUMBEROFHEADERS\@\@\@/$numberofheaders/sg;
$conffile =~ s/\@\@\@MAILSPOOLDIR\@\@\@/$mailspooldir/sg;
$conffile =~ s/\@\@\@HASHEDMAILSPOOLS\@\@\@/$hashedmailspools/sg;
$conffile =~ s/\@\@\@SCRIPTURL\@\@\@/$scripturl/sg;
$conffile =~ s/\@\@\@MAXABOOKSIZE\@\@\@/$maxabooksize/sg;
$conffile =~ s/\@\@\@FOLDERQUOTA\@\@\@/$folderquota/sg;
$conffile =~ s/\@\@\@ATTLIMIT\@\@\@/$attlimit/sg;
$conffile =~ s/\@\@\@PREFSURL\@\@\@/$prefsurl/sg;
$conffile =~ s/\@\@\@HOMEDIRFOLDERS\@\@\@/$homedirfolders/sg;
$conffile =~ s/\@\@\@HOMEDIRSPOOLS\@\@\@/$homedirspools/sg;
$conffile =~ s/\@\@\@HOMEDIRSPOOLNAME\@\@\@/$homedirspoolname/sg;
$conffile =~ s/\@\@\@BG_URL\@\@\@/$bg_url/sg;
$conffile =~ s/\@\@\@LOGO_URL\@\@\@/$logo_url/sg;
$conffile =~ s/\@\@\@IMAGE_URL\@\@\@/$image_url/sg;

$neomailfile =~ s/\@\@\@NEOMAILDIR\@\@\@/$neomaildir/sg;
$prefsfile =~ s/\@\@\@NEOMAILDIR\@\@\@/$neomaildir/sg;

print "Writing neomail.pl...";

open(NEOMAIL,">neomail.pl") or die "Can't open neomail.pl for writing!";
print NEOMAIL $neomailfile;
close(NEOMAIL);

print "Writing neomail-prefs.pl...";

open(NEOMAILPREFS,">neomail-prefs.pl") or die "Can't open neomail-prefs.pl for writing!";
print NEOMAILPREFS $prefsfile;
close(NEOMAILPREFS);

print "Writing neomail.conf...";

open(CONF,">neomail.conf") or die "Can't open neomail.conf for writing!";
print CONF $conffile;
close(CONF);


unless ( -d $neomaildir ) {
   print "Creating $neomaildir...\n";
   mkdir ($neomaildir, oct(770));
   chown (oct(0), (getgrnam($mailgroup))[2], "$neomaildir");
   chmod (oct(770), "$neomaildir");
}
unless ( -d "$neomaildir/users" ) {
   print "Creating $neomaildir/users...\n";
   mkdir ("$neomaildir/users", oct(750));
}
unless ( -d "$neomaildir/styles" ) {
   print "Creating $neomaildir/styles...\n";
   mkdir ("$neomaildir/styles", oct(750));
}
unless ( -d "$neomaildir/templates" ) {
   print "Creating $neomaildir/templates...\n";
   mkdir ("$neomaildir/templates", oct(750));
}
unless ( -d "$neomaildir/lang" ) {
   print "Creating $neomaildir/lang...\n";
   mkdir ("$neomaildir/lang", oct(750));
}
unless ( -d "$documentroot$image_url" ) {
   print "Creating $documentroot$image_url...\n";
   mkdir ("$documentroot$image_url", oct(755));
}
unless ( -e "$neomaildir/neomail.log" ) {
   print "Creating $neomaildir/neomail.log...\n";
   open (LOGFILE,">$neomaildir/neomail.log");
   close (LOGFILE);
}

print "\n\nINSTALLING NEOMAIL...\n";
print "Copying style files to $neomaildir/styles...\n";
system("cp styles/* $neomaildir/styles/");
print "Copying templates to $neomaildir/templates...\n";
system("cp -R templates/* $neomaildir/templates");
print "Copying translations to $neomaildir/lang...\n";
system("cp lang/* $neomaildir/lang/");
print "Copying neomail.conf to $neomaildir/neomail.conf...\n";
system("cp neomail.conf $neomaildir/");
chown (oct(0), (getgrnam($mailgroup))[2], "$neomaildir/neomail.conf");
chmod (oct(750), "$neomaildir/neomail.conf");
print "Setting permissions using chown -Rh and chmod -R...\n";
system("chown root:$mailgroup $neomaildir");
system("chown root:$mailgroup $neomaildir/neomail.conf");
system("chown root:$mailgroup $neomaildir/neomail.log");
system("chown -Rh root:$mailgroup $neomaildir/users");
system("chown -Rh root:$mailgroup $neomaildir/lang");
system("chown -Rh root:$mailgroup $neomaildir/styles");
system("chown -Rh root:$mailgroup $neomaildir/templates");
system("chmod 770 $neomaildir");
system("chmod 660 $neomaildir/neomail.log");
system("chmod -R 770 $neomaildir/users");
system("chmod -R 750 $neomaildir/lang");
system("chmod -R 750 $neomaildir/styles");
system("chmod -R 750 $neomaildir/templates");
print "Copying checklogin.pl to $neomaildir/checklogin.pl...\n";
system("cp checklogin.pl $neomaildir/");
print "Copying neomail.pl to $cgibin/neomail.pl...\n";
system("cp neomail.pl $cgibin/");
print "Copying neomail-prefs.pl to $cgibin/neomail-prefs.pl...\n";
system("cp neomail-prefs.pl $cgibin/");
print "Copying NeoMail logos to $documentroot/...\n";
system("cp neomail*.gif $documentroot/");
print "Copying NeoMail images to $documentroot$image_url...\n";
system("cp images/*.gif $documentroot$image_url");

print "Setting permissions...";
chown (oct(0), (getgrnam($mailgroup))[2], "$cgibin/neomail.pl");
chown (oct(0), (getgrnam($mailgroup))[2], "$cgibin/neomail-prefs.pl");
chown (oct(0), oct(0), "$neomaildir/checklogin.pl");
if ($needsuidroot eq 'yes') {
   print "\nFYI: NeoMail is being installed suid root due to one or more options\n";
   print "that were selected during setup.\n";
   chmod (oct(4755), "$cgibin/neomail.pl");
   chmod (oct(4755), "$cgibin/neomail-prefs.pl");
   chmod (oct(755), "$neomaildir/checklogin.pl");
} else {
   chmod (oct(2755), "$cgibin/neomail.pl");
   chmod (oct(2755), "$cgibin/neomail-prefs.pl");
   chmod (oct(4755), "$neomaildir/checklogin.pl");
}

print <<EndOfMessage
Done!

Make a note of the HTTPD user id, which is:

	$httpduser

You'll need it next.
Finish the installation by following the steps outlined in FINAL STEPS, in the
INSTALL text file in this directory.

If you're part of a company/organization and you decide to stick with NeoMail
as your webmail solution, see http://neomail.sourceforge.net/testimonials.html
for information on how to get the word out.
EndOfMessage
;
