#!/usr/local/bin/perl

# CommPort:/htdocs/signup.cgi 
#
# Signup form.  Includes unique UN/PW assignment.


# The contents of this file are subject to the CommPort Public License 
# Version 1.00 (the "License"); you may not use this file except in
# compliance with the License. You may obtain a copy of the License at  
# (URL:http://www.tc.ca/commport/license.html).
#
# Software distributed under the License is distributed on an "AS IS" 
# basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
# the License for the specific language governing rights and limitations 
# under the License.  
#
# The Original Code is ${CPHOME}/htdocs/signup.cgi
#
# The Initial Developer of the Original Code is Telecommunities
# Canada, Inc.  Portions created by Telecommunities Canada, Inc. are
# Copyright (C) 1999-2000 by Telecommunities Canada, Inc.
# All Rights Reserved.
#
# Modifications or contributions of Larger Works should be sent to
# (mailto:commport@tc.ca) for consideration towards inclusion 
# into the root public codebase.
# 
# Contributor(s): Chris Halsall, Ian White, 
#                 Gary and Mae Shearman.
#                 Industry Canada's Community Access Program.


# Changelog:
#
# 1999.08.02 - CH  - Added this copyright/changelog section.

use CGI;
use DBI;

require "../common/common.pl";

$Method = $ENV{'REQUEST_METHOD'};
$PathInfo = $ENV{'PATH_INFO'};

$Query = new CGI;

if ($Method eq "POST") {
   $UN = $Query->param("UN");
   $PW1 = $Query->param("PW1");
   $PW2 = $Query->param("PW2");
   $EMail = $Query->param("EMail");
   $FName = $Query->param("FName");
   $LName = $Query->param("LName");
   $Addr = $Query->param("Addr");
   $City = $Query->param("City");
   $Prov = $Query->param("Prov");
   $PCode = $Query->param("PCode");
   $Country = $Query->param("Country");

   $ReqStr = $ErrStr = "";

# Check for missing required fields.

   if ($UN eq "") {
      $ReqStr .= ", Username"; }
   if ($EMail eq "") {
      $ReqStr .= ", Email address"; }
   if ($FName eq "") {
      $ReqStr .= ", First Name"; }
   if ($LName eq "") {
      $ReqStr .= ", Last Name"; }


   if (!($EMail =~ /^([^\@]+)\@([\w-_\.]+\.[\w-_]+)$/)) {
      $ErrStr .= ", EMail address doesn't appear valid.";
   }

# Check for other errors.

   if ($UN =~ /[^\w]/) {
      $ErrStr .= ", Username must be letters, numbers and \"_\" only";
   }
   if ($PW1 ne $PW2) {
      $ErrStr .= ", Password and Confirmation do not match";
   } else {
      if (length($PW1) < 3) {
         $ErrStr .= ", Password must be 3 characters or longer";
      }
   }

# Merge required errors into main errors.

   if ($ReqStr ne "") {
      $ReqStr =~ s/^, //;
      $ErrStr .= ", ${ReqStr} required";
   }
   $ErrStr =~ s/^, //;


   if ($ErrStr eq "") {

      $Results = &DoInsert;

      if ($Results == 0) {
         print $Query->redirect("http://${CP_RootURL}${CP_URLPath}/");
         exit;
      } elsif ($Results == 1) {
         $ErrStr = "Username already in use.  Please choose another.";
      } else {
         $ErrStr = "Insert unsuccessful - ${Results}.";
      }
   } else {
      $ErrStr .= ".";
   }
}


print $Query->header;

print <<HTML;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"
"http://www.w3.org/TR/REC-html40/loose.dtd">
<html><head><title>${CP_Name}</title></head><body bgcolor="white">
<center><h2>${CP_Name} Sign Up</h2></center>
<form action="/signup.cgi" method="post">
<table border=0 width="100%" bgcolor="#FFE0E0" cellspacing=0>
<tr><td bgcolor="#EEEEFF">
<table border=0 width="100%">
HTML

if ($ErrStr ne "") {
print "<tr><th align=\"right\" valign=\"top\" width=\"10%\">"
."<font color=\"red\">Error:</font></th>"
."<th align=\"left\"><font color=\"red\">${ErrStr}</font></th></tr>";
}

print <<HTML;
<tr><th align="right" width="10%">Username</th>
<td><input type="text" name="UN" value="${UN}"> <font color="red">*</font></td>
</tr>

<tr><th align="right">Password</th>
<td><input type="password" name="PW1" value="${PW1}"> <font color="red">*</font></td>
</tr>

<tr><th align="right">Confirmation</th>
<td><input type="password" name="PW2" value="${PW2}"> <font color="red">*</font></td>
</tr>

<tr><th align="right">E-Mail</th>
<td><input type="text" name="EMail" value="${EMail}"> <font color="red">*</font></td>
</tr>

<tr><th align="right">First Name:</th>
<td><input type="text" name="FName" value="${FName}"> <font color="red">*</font></td>
</tr>

<tr><th align="right">Last Name:</th>
<td><input type="text" name="LName" value="${LName}"> <font color="red">*</font></td>
</tr>

<tr><th align="right">Address:</th>
<td><input type="text" name="Addr" value="${Addr}"></td>
</tr>

<tr><th align="right">City:</th>
<td><input type="text" name="City" value="${City}"></td>
</tr>

<tr><th align="right">Province/State:</th>
<td><input type="text" name="Prov" value="${Prov}"></td>
</tr>

<tr><th align="right">Postal Code/Zip:</th>
<td><input type="text" name="PCode" value="${PCode}"></td>
</tr>

<tr><th align="right">Country:</th>
<td><input type="text" name="Country" value="${Country}"></td>
</tr>

<tr><th></th>
<td><input type="submit" value="Sign Up">
<font color="red">*</font> = Required Field</td></tr>
</table>
</td><th valign="top">
If you've already signed up,
please<p><font size="+2"><a href="${CP_URLPath}/">Log In</a></font><p>now.</th>
</tr>
</table>
</form>
HTML

&RenderFooter;

exit;

sub DoInsert {
   local ($cmd,$PWC,$Salt);

   &OpenDB;

   if (! $dbh) {
      return 2;
   }

   &LockUsers;

   $cmd = "select id from User where un=\"${UN}\"";

   $sth = $dbh->prepare($cmd);
   $rv = $sth->execute or die "can't execute the query: $sth->errstr\n";
   @rec = $sth->fetchrow_array;
   $sth->finish;

   if (defined($rec[0])) {
      &UnLockUsers;
      $dbh->disconnect;
      return 1;
   }

   $Salt = sprintf("%02d", $$%100);
   $PWC = crypt($PW1, $Salt);

   $cmd = "insert into User (un,pw,email,fname,lname,address,community,prov,postal,country,Joined) values "
."(\"${UN}\",\"${PWC}\",\"${EMail}\",\"${FName}\",\"${LName}\",\"${Addr}\",\"${City}\",\"${Prov}\",\"${PCode}\",\"${Country}\",now())";

   $sth = $dbh->do($cmd) || &DumpError($sth->errstr);

   &BuildPWFile;
   &UnLockUsers;

   $cmd = "select id from User where un=\"${UN}\"";

   $sth = $dbh->prepare($cmd);
   $rv = $sth->execute or die "can't execute the query: $sth->errstr\n";
   @rec = $sth->fetchrow_array;
   $sth->finish;

   if (!defined($rec[0])) {
      # This would be a fairly serious error.
      return 1;
   }
   $User_ID = $rec[0];

   $cmd = "select ID_Channel,SortPri,DisplayState,LMR from Panel where ID_User=1";
   $sth = $dbh->prepare($cmd);
   $rv = $sth->execute or die "can't execute the query: $sth->errstr\n";
   while (@rec = $sth->fetchrow_array) {
      last if ($rec[0] == 0);

      $putcmd = "insert into Panel (ID_User,ID_Channel,SortPri,DisplayState,LMR) values (${User_ID},${rec[0]},${rec[1]},${rec[2]},${rec[3]})";

#print "<h3>$putcmd</h3>\n";
      $sth2 = $dbh->do($putcmd) || &DumpError($sth2->errstr);
   }

   return 0;
}

