#!/usr/local/bin/perl

# CommPort:/htdocs/rss.cgi
#
# Presents external access to RSS form of channels.


# The contents of this file are subject to the CommPort Public License 
# Version 1.00 (the "License"); you may not use this file except in
# compliance with the License. You may obtain a copy of the License at  
# (URL:http://www.tc.ca/commport/license.html).
#
# Software distributed under the License is distributed on an "AS IS" 
# basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
# the License for the specific language governing rights and limitations 
# under the License.  
#
# The Original Code is ${CPHOME}/htdocs/rss.cgi
#
# The Initial Developer of the Original Code is Telecommunities
# Canada, Inc.  Portions created by Telecommunities Canada, Inc. are
# Copyright (C) 1999-2000 by Telecommunities Canada, Inc.
# All Rights Reserved.
#
# Modifications or contributions of Larger Works should be sent to
# (mailto:commport@tc.ca) for consideration towards inclusion 
# into the root public codebase.
# 
# Contributor(s): Chris Halsall, Ian White, 
#                 Gary and Mae Shearman.
#                 Industry Canada's Community Access Program.


# Changelog:
#
# 1999.09.20 - CH  - Created this file.

use CGI;
use DBI;

require "../common/common.pl";

$Query = new CGI;

$Method = $ENV{'REQUEST_METHOD'};
$PathInfo = $ENV{'PATH_INFO'};
$QueryString = $ENV{'QUERY_STRING'};
$User = $ENV{'REMOTE_USER'};

$ID = 0+ $QueryString;
&DoSelect;

print $Query->header('text/plain');

if (!$Access) {
   print "<!-- Error: Channel is private. -->\n";
   return;
}

if ($Channel_Type > 0) {

   $FetchedFile = "${FETCH_PATH}/${ID}.raw";

   &IncludeFile($FetchedFile);

} else {

print <<HTML;
<?xml version="1.0"?>
<!DOCTYPE rss PUBLIC "-//Netscape Communications//DTD RSS 0.91//EN" "http://my.netscape.com/publish/formats/rss-0.91.dtd">
<rss version="0.91">
  <channel>
HTML

print <<HTML;
    <title>${Name}</title>
    <link>${URL}</link>
    <language>en-us</language>
    <description>${Descript}</description>
    <copyright>Copyright 1999, ${Author}.  All rights reserved.</copyright>
HTML

   $Img = "";
   if ($I_L ne "") {
      $Img = "http://${CP_RootURL}${I_L}";
   } else {
      $Img = $I_S;
   }

   if ($Img ne "") {
print <<HTML;
    <image>
      <title>${Name}</title>
      <url>${Img}</url>
      <description>${Descript}</description>
      <link>${URL}</link>
    </image>
HTML
   }
   print "\n";


   $S_Str = "Title asc";
   if ($Sorting == 1) { $S_Str = "Last_Alt asc"; }
   elsif ($Sorting == 2) { $S_Str = "Last_Alt desc"; }

   $cmd = "select ID,Title,URL from Item"
." where ID_Channel=${ID} order by $S_Str";

$sth = $dbh->prepare($cmd);
$rv = $sth->execute or die "can't execute the query: $sth->errstr\n";

$Cnt=0;
while (@rec = $sth->fetchrow_array) {
 print ""
."    <item>\n"
."      <title>$rec[1]</title>\n"
."      <link>$rec[2]</link>\n"
."    </item>\n\n";
}

print "  </channel>\n</rss>\n";
}

exit;


sub DoSelect {
   local ($cmd);

   &OpenDB;

   $cmd = "select ID_User,Name,URL,Descript,Public,Sorting"
.",Type,Img_Src,Img_URL,Img_Text,Img_Mode,Img_W,Img_H,Img_Local"
.",fname,lname"
." from Channel,User"
." where ID_User=User.ID AND Channel.ID=${ID}"
;

#print STDERR "$cmd";

   $sth = $dbh->prepare($cmd);
   $rv = $sth->execute or die "can't execute the query: $sth->errstr\n";
   @Channel = $sth->fetchrow_array;
   $sth->finish;

   $Name = $Channel[1];
   $URL = $Channel[2];
   $Descript = $Channel[3];
   $Access = $Channel[4];
   $Sorting = $Channel[5];
   $Channel_Type = $Channel[6];
   $I_S = $Channel[7];
   $I_U = $Channel[8];
   $I_T = $Channel[9];
   $I_M = $Channel[10];
   $I_W = $Channel[11];
   $I_H = $Channel[12];
   $I_L = $Channel[13];
   $Author = $Channel[14] . " " . $Channel[15];


   return 0;
}

