#!/usr/local/bin/perl

# Commport:/htdocs/cp/p_view.cgi
#
# Presents view of channel, with options to add to custom portal.


# The contents of this file are subject to the CommPort Public License 
# Version 1.00 (the "License"); you may not use this file except in
# compliance with the License. You may obtain a copy of the License at  
# (URL:http://www.tc.ca/commport/license.html).
#
# Software distributed under the License is distributed on an "AS IS" 
# basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
# the License for the specific language governing rights and limitations 
# under the License.  
#
# The Original Code is ${CPHOME}/htdocs/cp/p_view.cgi
#
# The Initial Developer of the Original Code is Telecommunities
# Canada, Inc.  Portions created by Telecommunities Canada, Inc. are
# Copyright (C) 1999-2000 by Telecommunities Canada, Inc.
# All Rights Reserved.
#
# Modifications or contributions of Larger Works should be sent to
# (mailto:commport@tc.ca) for consideration towards inclusion 
# into the root public codebase.
# 
# Contributor(s): Chris Halsall, Ian White, 
#                 Gary and Mae Shearman.
#                 Industry Canada's Community Access Program.


# Changelog:
#
# 1999.08.02 - CH  - Added this copyright/changelog section.
# 1999.09.22 - CH  - Tweaked for uploaded image handling.
# 1999.09.25 - CH  - Finally tracked down the sort order bug.

use CGI;
use DBI;

require "../../common/common.pl";

$Query = new CGI;

$Method = $ENV{'REQUEST_METHOD'};
$PathInfo = $ENV{'PATH_INFO'};
$QueryString = $ENV{'QUERY_STRING'};
$User = $ENV{'REMOTE_USER'};

&GetUserInfo;

if ($Method eq "POST") {
   $ID = $Query->param("ID");
   $Where = $Query->param("Where");
   $LMR = $Query->param("LMR");

   $Results = &DoInsert;
 
   print $Query->redirect("http://${CP_RootURL}${CP_URLPath}/");

} else {

$ID = $QueryString;
&DoSelect;

print $Query->header;
&RenderHeader("Add Channel",0);

print <<HTML;
<br>
<table border=0 width="100%" cellspacing=0>
<tr><td width="33%" valign="top">
<!--  -->
HTML

&RenderPanel(${Name},${URL},0,${ID},0,${Channel_Type},$I_S,$I_U,$I_T,$I_M,$I_W,$I_H,0,$I_L);

print <<HTML;
<!--   -->
</td>
HTML

print <<HTML;
<th valign="top" width="67%">
<br>${Descript}
</th>
</tr>
</table>
HTML



print <<HTML;

<br>
<form action="${CP_URLPath}/p_view.cgi" method="post">
<table border=0 width="100%" bgcolor="#FFE0E0" cellspacing=0>
<tr><td bgcolor="#EEEEFF">
<table border=0 width="100%">

<b>$LangStr{"PVIE001"}</b> <i>${Name}</i>
<p>
$LangStr{"PVIE002"} 
<select name="Where">
<option value="1">$LangStr{"PVIE101"}
<option value="2">$LangStr{"PVIE102"}
<option value="3">$LangStr{"PVIE103"}
<option value="4">$LangStr{"PVIE104"}
<option value="5">$LangStr{"PVIE105"}
<option value="6">$LangStr{"PVIE106"}
<option value="7">$LangStr{"PVIE107"}
<option value="8">$LangStr{"PVIE108"}
<option value="9">$LangStr{"PVIE109"}
<option value="10">$LangStr{"PVIE110"}
<option value="11">$LangStr{"PVIE111"}
<option value="12">$LangStr{"PVIE112"}
<option value="13">$LangStr{"PVIE113"}
<option value="14">$LangStr{"PVIE114"}
<option value="15">$LangStr{"PVIE115"}
<option value="16">$LangStr{"PVIE116"}
<option value="17">$LangStr{"PVIE117"}
<option value="18">$LangStr{"PVIE118"}
<option value="19">$LangStr{"PVIE119"}
<option value="20">$LangStr{"PVIE120"}
</select>$LangStr{"PVIE003"}
<select name="LMR">
<option value="1">$LangStr{"PVIE004"}
<option value="2">$LangStr{"PVIE005"}
<option value="3">$LangStr{"PVIE006"}
</select> $LangStr{"PVIE007"}
<input type="hidden" name="ID" value="${ID}">
<p>
<input type="submit" value="$LangStr{"PVIE008"}
">
</td></tr>
</table>
</td><th valign="top">
<br>
$User
<p>
</th>
</tr>
</table>
</form>
HTML
}

exit;

sub DoInsert {
   local ($cmd);

   &OpenDB;

   $cmd = "select max(SortPri) from Panel"
." where ID_User=${User_ID} and LMR=\"${LMR}\"";

   $sth = $dbh->prepare($cmd);
   $rv = $sth->execute or die "can't execute the query: $sth->errstr\n";
   @Panels = $sth->fetchrow_array;
   $sth->finish;

   if ($Where > $Panels[0]+1) {
      $Where= $Panels[0]+1;
   }

   $cmd = "update Panel set SortPri=SortPri+1"
." where ID_User=${User_ID} AND SortPri>=${Where} AND LMR=${LMR}";

   $sth = $dbh->do($cmd) || &DumpError($sth->errstr);

   $cmd = "insert into Panel (ID_User,ID_Channel,SortPri,LMR) values "
."(\"${User_ID}\",\"${ID}\",\"${Where}\",\"${LMR}\")";

   $sth = $dbh->do($cmd) || &DumpError($sth->errstr);

   return 0;
}


sub DoSelect {
   local ($cmd);

   &OpenDB;

   $cmd = "select ID_User,Name,URL,Descript,Public,Type"
.",Img_Src,Img_URL,Img_Text,Img_Mode,Img_W,Img_H,Img_Local"
." from Channel"
." where ID=${ID}"
;

   $sth = $dbh->prepare($cmd);
   $rv = $sth->execute or die "can't execute the query: $sth->errstr\n";
   @Channel = $sth->fetchrow_array;
   $sth->finish;

   if ($Channel[0] != $User_ID && $Channel[4] == 0) {
      return 1;
   }

   $Name = $Channel[1];
   $URL = $Channel[2];
   $Descript = $Channel[3];
   $Access = $Channel[4];
   $Channel_Type = $Channel[5];
   $I_S = $Channel[6];
   $I_U = $Channel[7];
   $I_T = $Channel[8];
   $I_M = $Channel[9];
   $I_W = $Channel[10];
   $I_H = $Channel[11];
   $I_L = $Channel[12];

   return 0;
}

