#!/usr/local/bin/perl

# Commport:/htdocs/cp/i_edit.cgi
#
# Allows addition or editing of an item in a channel.


# The contents of this file are subject to the CommPort Public License 
# Version 1.00 (the "License"); you may not use this file except in
# compliance with the License. You may obtain a copy of the License at  
# (URL:http://www.tc.ca/commport/license.html).
#
# Software distributed under the License is distributed on an "AS IS" 
# basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
# the License for the specific language governing rights and limitations 
# under the License.  
#
# The Original Code is ${CPHOME}/htdocs/cp/i_edit.cgi
#
# The Initial Developer of the Original Code is Telecommunities
# Canada, Inc.  Portions created by Telecommunities Canada, Inc. are
# Copyright (C) 1999-2000 by Telecommunities Canada, Inc.
# All Rights Reserved.
#
# Modifications or contributions of Larger Works should be sent to
# (mailto:commport@tc.ca) for consideration towards inclusion 
# into the root public codebase.
# 
# Contributor(s): Chris Halsall, Ian White, 
#                 Gary and Mae Shearman.
#                 Industry Canada's Community Access Program.


# Changelog:
#
# 1999.08.03 - CH  - Added URL syntax check, demanding "http://.../".
# 1999.08.02 - CH  - Added this copyright/changelog section.

use CGI;
use DBI;

require "../../common/common.pl";

$Query = new CGI;

$Method = $ENV{'REQUEST_METHOD'};
$PathInfo = $ENV{'PATH_INFO'};
$QueryString = $ENV{'QUERY_STRING'};
$User = $ENV{'REMOTE_USER'};

&GetUserInfo;

if ($Method eq "POST") {
   $ID = $Query->param("ID");
   $Channel_ID = $Query->param("Channel_ID");
   $Title = $Query->param("Title");
   $URL = $Query->param("URL");
   $Delete = $Query->param("Delete");

   if ($Delete ne "") {
      $Results = &DoDelete;
      print $Query->redirect("http://${CP_RootURL}${CP_URLPath}/c_view.cgi?${Channel_ID}");
      exit;
   }

   $ReqStr = $ErrStr = "";

# Check for missing required fields.

   if ($Title eq "") {
      $ReqStr .= ", Title"; }
   if ($URL eq "") {
      $ReqStr .= ", URL"; }

# Check for other errors.

   if ($URL ne "") {
      if (!($URL =~ /^[^:]+:\/\/[^\.]+\.[^\\]+\//)) {
         $ErrStr .= ", URL not valid - must include http://server/";
      }
   }
 

# Merge required errors into main errors.

   if ($ReqStr ne "") {
      $ReqStr =~ s/^, //;
      $ErrStr .= ", ${ReqStr} required";
   }
   $ErrStr =~ s/^, //;

   if ($ErrStr eq "") {

      if ($ID == 0) {
      $Results = &DoInsert;
      } else {
      $Results = &DoUpdate;
      }

      if ($Results == 0) {
         print $Query->redirect("http://${CP_RootURL}${CP_URLPath}/c_view.cgi?${Channel_ID}");
         exit;
      } elsif ($Results == 1) {
         $ErrStr = "Username already in use.  Please choose another.";
      } else {
         $ErrStr = "Insert unsuccessful - ${Results}.";
      }
   } else {
      $ErrStr .= ".";
   }
} else {
   ($ID,$Channel_ID) = split(/\//,$QueryString);
   &DoSelect;
}

print $Query->header;
&RenderHeader("$QueryString",0);

if ($ID > 0) {
$Sub_Button = $LangStr{"IEDT005"};
} else {
$Sub_Button = $LangStr{"IEDT004"};
}

print <<HTML;
<form action="${CP_URLPath}/i_edit.cgi" method="post">
<table border=0 width="100%" bgcolor="#FFE0E0" cellspacing=0>
<tr><td bgcolor="#EEEEFF">
<table border=0 width="100%">
HTML

if ($ErrStr ne "") {
print "<tr><th align=\"right\" valign=\"top\" width=\"10%\">"
."<font color=\"red\">Error:</font></th>"
."<th align=\"left\"><font color=\"red\">${ErrStr}</font></th></tr>";
}

print <<HTML;
<tr><th align="right" width="10%">$LangStr{"IEDT000"}</th>
<td><input type="text" name="Title" value="${Title}" size=30 maxlength=50>
</td></tr>

<tr><th align="right">$LangStr{"IEDT001"}</th>
<td><input type="text" name="URL" value="${URL}" size=50 maxlength=120> 
<input type="hidden" name="ID" value="${ID}">
<input type="hidden" name="Channel_ID" value="${Channel_ID}">
</td></tr>
HTML

if ($ID > 0) {
print <<HTML;
<tr><th align="right">$LangStr{"IEDT002"}</th>
<td><input type="checkbox" name="Delete"> $LangStr{"IEDT003"}
</td></tr>
HTML
}

print <<HTML;
<tr><th></th>
<td><input type="submit" value="${Sub_Button}">

</table>
</td>
</tr>

</table>
</form>

HTML

sub DoInsert {
   local ($cmd);

   &OpenDB;

   $cmd = "insert into Item (ID_Channel,Title,URL) values "
."(\"${Channel_ID}\",\"${Title}\",\"${URL}\")";

   $sth = $dbh->do($cmd) || &DumpError($sth->errstr);

   return 0;
}

sub DoUpdate {
   local ($cmd);

   &OpenDB;

   $cmd = "update Item SET"
." Title=\"${Title}\""
.",URL=\"${URL}\""
." where ID=${ID} AND ID_Channel=${Channel_ID}"
;

   $sth = $dbh->do($cmd) || &DumpError($sth->errstr);

   return 0;
}

sub DoDelete {
   local ($cmd,$sth);

   &OpenDB;

   $cmd = "delete from Item"
." where ID=${ID}";
   $sth = $dbh->do($cmd) || &DumpError($sth->errstr);

   return 0;
}

sub DoSelect {
   local ($cmd);

   &OpenDB;

   $cmd = "select ID_Channel,Title,URL from Item"
." where ID=${ID}"
;

   $sth = $dbh->prepare($cmd);
   $rv = $sth->execute or die "can't execute the query: $sth->errstr\n";
   @Item = $sth->fetchrow_array;
   $sth->finish;

   if ($Item[0] != $Channel_ID) {
      return 1;
   }

   $Title = $Item[1];
   $URL = $Item[2];

   return 0;
}

