#!/usr/local/bin/perl

# Commport:/htdocs/cp/c_view.cgi
#
# Presents view of custom channel.


# The contents of this file are subject to the CommPort Public License 
# Version 1.00 (the "License"); you may not use this file except in
# compliance with the License. You may obtain a copy of the License at  
# (URL:http://www.tc.ca/commport/license.html).
#
# Software distributed under the License is distributed on an "AS IS" 
# basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
# the License for the specific language governing rights and limitations 
# under the License.  
#
# The Original Code is ${CPHOME}/htdocs/cp/c_view.cgi
#
# The Initial Developer of the Original Code is Telecommunities
# Canada, Inc.  Portions created by Telecommunities Canada, Inc. are
# Copyright (C) 1999-2000 by Telecommunities Canada, Inc.
# All Rights Reserved.
#
# Modifications or contributions of Larger Works should be sent to
# (mailto:commport@tc.ca) for consideration towards inclusion 
# into the root public codebase.
# 
# Contributor(s): Chris Halsall, Ian White, 
#                 Gary and Mae Shearman.
#                 Industry Canada's Community Access Program.


# Changelog:
#
# 1999.08.02 - CH  - Added this copyright/changelog section.

use CGI;
use DBI;

require "../../common/common.pl";

$Query = new CGI;

$Method = $ENV{'REQUEST_METHOD'};
$PathInfo = $ENV{'PATH_INFO'};
$QueryString = $ENV{'QUERY_STRING'};
$User = $ENV{'REMOTE_USER'};

&GetUserInfo;

$ID = 0 + $QueryString;
&DoSelect;

if ($Access) {
$AccessStr = "Available to other Users";
$RSS_URL = "<a href=\"http://${CP_RootURL}/rss.cgi?${ID}\">http://${CP_RootURL}/rss.cgi?${ID}</a>";
} else {
$AccessStr = "Private Only";
$RSS_URL = "N/A";
}

print $Query->header;
&RenderHeader("Channel View - ${Name}",0);

print <<HTML;
<br>
<table border=0 width="100%" bgcolor="#FFE0E0" cellspacing=0>
<tr><td bgcolor="#EEEEFF" width="85%">
<table border=0 width="100%">

<tr><th align="right" width="10%">$LangStr{"CEDT001"}:</th>
<td>${Name}
</td></tr>

<tr><th align="right">$LangStr{"CEDT002"}:</th>
<td><a href="${URL}">${URL}
</td></tr>

<tr><th align="right" valign="top">$LangStr{"CEDT003"}:</th>
<td>${Descript}
</td></tr>

<tr><th align="right">$LangStr{"CEDT004"}:</th>
<td>${AccessStr}
</td></tr>

<tr><th align="right">$LangStr{"CVIE000"}:</th>
<td>${RSS_URL}
</td></tr>

</table>
</td><th valign="top">
<br><a href="c_edit.cgi?${ID}">$LangStr{"CVIE001"}</a>
<p>
<a href="c_image.cgi?${ID}">$LangStr{"CVIE002"}</a>
<p>
</th>
</tr>
</table>
HTML

print <<HTML;
<br>
<table border=0 width="100%" cellspacing=0>
<tr><td width="33%" valign="top">
<!--   -->
HTML

print STDERR "$I_M -- $I_L\n";

&RenderPanel(${Name},${URL},0,${ID},-1,${Channel_Type}
,$I_S,$I_U,$I_T,$I_M,$I_W,$I_H,0,$I_L);

print <<HTML;
<!--   -->
</td>
HTML

print <<HTML;
<th valign="top" width="67%">
<br>${Descript}
</th>
HTML

if ($Channel_Type == 0) {
print <<HTML;
<th valign="top" width="15%" bgcolor="white">
<br><a href="i_edit.cgi?0/${ID}">$LangStr{"CVIE003"}</a><br>&nbsp;
</th>
HTML
}

print "</tr></table>";

if (0) {
print <<HTML;
<br>
<table border=0 width="100%" bgcolor="#FFE0E0" cellspacing=0>
<tr><td bgcolor="#EEEEFF" width="85%">
<table border=0 width="100%">
<b>Items:</b>
<ul>
HTML

   $S_Str = "Title asc";
   if ($Sorting == 1) { $S_Str = "Last_Alt asc"; }
   elsif ($Sorting == 2) { $S_Str = "Last_Alt desc"; }

   $cmd = "select ID,Title,URL from Item"
." where ID_Channel=${ID} order by $S_Str"
;

$sth = $dbh->prepare($cmd);
$rv = $sth->execute or die "can't execute the query: $sth->errstr\n";

$Cnt=0;
while (@rec = $sth->fetchrow_array) {
# print "<a href=\"i_edit.cgi?${rec[0]}/${ID}\"><li>$rec[1]</a><br>"
#."&nbsp;&nbsp;<a href=\"${rec[2]}\">$rec[2]</a><p>\n";
 print 
"<li><a href=\"i_edit.cgi?${rec[0]}/${ID}\">".$LangStr{"CVIE004"}."</a>: "
."<a href=\"${rec[2]}\">$rec[1]</a>\n";
   $Cnt=1;
}

if (!$Cnt) {
 print "<li>No items in this channel.";
}

print <<HTML;
</ul></table>
</td>
<th valign="top" width="15%">
<br><a href="i_edit.cgi?0/${ID}">Add Item</a><br>&nbsp;
</th>
</tr>
</table>
HTML
}

sub DoInsert {
   local ($cmd);

   &OpenDB;

   $cmd = "insert into Channel (ID_User,Name,URL,Descript,Public) values "
."(\"${User_ID}\",\"${Name}\",\"${URL}\",\"${Descript}\",\"${Access})";

   $sth = $dbh->do($cmd) || &DumpError($sth->errstr);

   return 0;
}

sub DoUpdate {
   local ($cmd);

   &OpenDB;

   $cmd = "update Channel SET"
." Name=\"${Name}\""
.",URL=\"${URL}\""
.",Descript=\"${Descript}\""
.",Public=\"${Access}\""
." where ID=${ID} AND ID_User=${User_ID}"
;

   $sth = $dbh->do($cmd) || &DumpError($sth->errstr);

   return 0;
}

sub DoSelect {
   local ($cmd);

   &OpenDB;

   $cmd = "select ID_User,Name,URL,Descript,Public,Sorting"
.",Type,Img_Src,Img_URL,Img_Text,Img_Mode,Img_W,Img_H,Img_Local from Channel"
." where ID=${ID}"
;

   $sth = $dbh->prepare($cmd);
   $rv = $sth->execute or die "can't execute the query: $sth->errstr\n";
   @Channel = $sth->fetchrow_array;
   $sth->finish;

   if ($Channel[0] != $User_ID && $User_Priv < $Admin_Moderator) {
      return 1;
   }

   $Name = $Channel[1];
   $URL = $Channel[2];
   $Descript = $Channel[3];
   $Access = $Channel[4];
   $Sorting = $Channel[5];
   $Channel_Type = $Channel[6];
   $I_S = $Channel[7];
   $I_U = $Channel[8];
   $I_T = $Channel[9];
   $I_M = $Channel[10];
   $I_W = $Channel[11];
   $I_H = $Channel[12];
   $I_L = $Channel[13];


   return 0;
}

