#!/usr/local/bin/perl

# CommPort:/htdocs/cp/c_rss_list.cgi
#
# Provides a list of all externally accessable raw RSS channels.


# The contents of this file are subject to the CommPort Public License 
# Version 1.00 (the "License"); you may not use this file except in
# compliance with the License. You may obtain a copy of the License at  
# (URL:http://www.tc.ca/commport/license.html).
#
# Software distributed under the License is distributed on an "AS IS" 
# basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
# the License for the specific language governing rights and limitations 
# under the License.  
#
# The Original Code is ${CPHOME}/htdocs/cp/c_rss_list.cgi
#
# The Initial Developer of the Original Code is Telecommunities
# Canada, Inc.  Portions created by Telecommunities Canada, Inc. are
# Copyright (C) 1999-2000 by Telecommunities Canada, Inc.
# All Rights Reserved.
#
# Modifications or contributions of Larger Works should be sent to
# (mailto:commport@tc.ca) for consideration towards inclusion 
# into the root public codebase.
# 
# Contributor(s): Chris Halsall, Ian White, 
#                 Gary and Mae Shearman.
#                 Industry Canada's Community Access Program.


# Changelog:
# 
# 2000.04.16 - CH  - Added this copyright/changelog section. 


use CGI;
use DBI;

require "../../common/common.pl";

$Method = $ENV{'REQUEST_METHOD'};
$PathInfo = $ENV{'PATH_INFO'};
$User = $ENV{'REMOTE_USER'};
$QStr = $ENV{'QUERY_STRING'};

$Query = new CGI;

&GetUserInfo;

print $Query->header;
&RenderHeader("All Channels",0);

if ($QStr) {
   if ($QStr =~ /Owner/) {
      $QStr = "lname,fname";
   } elsif ($QStr =~ /Type/) {
      $QStr = "type,name";
   } elsif ($QStr =~ /Fetched/) {
      $QStr = "fetched desc";
   } elsif ($QStr =~ /Resp/) {
      $QStr = "F_Resp desc";
   }
   $Order = "order by ${QStr}";
} else {
   $Order = "order by name";
}

$cmd = "select Channel.ID,fname,lname,Name,Type,Img_Src,Img_W,Img_H"
.",User.ID,F_Resp,Img_Mode,Img_Cache,Img_Cached,Img_Local"
.",if(Type>0,F_Last,0) as Fetched,now()"
." from User,Channel"
." where ID_User=User.ID and Public=1 ${Order}";

$sth = $dbh->prepare($cmd);
$rv = $sth->execute or die "can't execute the query: $sth->errstr\n";

print <<HTML;
<h2>List of all Current (public) Channels</h2>
<table border=1 width="100%" cellspacing=0>
<tr bgcolor="#FFFF00">
<th colspan=2><a href="channels.cgi?Type">Type</a></th>
<th><a href="channels.cgi?Name">Name</a></th>
<th>RSS Export</th>
<th><a href="channels.cgi?Owner">Owner</a></th>
<th><a href="channels.cgi?Resp">Resp</a></th>
<th><a href="channels.cgi?Fetched">Fetched</a></th>
</tr>
HTML


while (@rec = $sth->fetchrow_array) {
if ($rec[5] ne "" || $rec[13] ne "") {
if ($rec[13] ne "") {
  $ImgLnk = $rec[13];
} else {
  $ImgLnk = $rec[5];
}
$ImgStr = "<a href=\"${ImgLnk}\">${rec[6]} x ${rec[7]}</a>";
$Img_Mode = $rec[10];
$Img_Cache = $rec[11];

if ($Img_Mode == 0) { $ImgCache = "Remote" ;
} elsif ($Img_Mode == 1) { $ImgCache = "Ignored";
} elsif ($Img_Mode == 2) { $ImgCache = "Uploaded";
} elsif ($Img_Mode >= 3) {
if ($Img_Cache <= 1) { $ImgCache = "Once";
} elsif ($Img_Cache == 2) { $ImgCache = "Every";
} elsif ($Img_Cache == 3) { $ImgCache = "Daily";
} else { print STDERR "c_edit.cgi -- Bad Img state - $Img_Mode - $Img_Cache\n"; }
} else { print STDERR "c_edit.cgi -- Bad Img state - $Img_Mode - Img_Cache\n"; }

} else {
$ImgCache = "N/A";
$ImgStr = "&nbsp;";
}
if ($rec[4] >0) { $Type="Extern"; $FL=$rec[14]; } else 
{ $Type="Local"; $FL="&nbsp;"; }

$RDF_S = "<a href=\"/rss.cgi?${rec[0]}\">";
$RDF_E = "</a>";

print <<HTML;
<tr>
<td>${RDF_S}${Type}${RDF_E}</td>
<td align="right">${RDF_S}${rec[4]}${RDF_E}</td>
<td><a href=\"${CP_URLPath}/p_view.cgi?${rec[0]}\">$rec[3]</a></td>
<td>${RDF_S}/rss.cgi?${rec[0]}${RDF_E}</td>
<td><a href="${CP_URLPath}/admin/user.cgi?$rec[8]">$rec[2], $rec[1]</a></td>
<td align="right">${rec[9]}</td>
<td align="right" nowrap>${FL}</td>
HTML

$IsNow = $rec[15];
}

print <<HTML;
</table>
<p>
Notes:
<ul>
<li> Response is <b>0</b> for success and <b>111</b> for no items found (including an image). 
<li> <b>404</b>, <b>500</b>, etc. are the normal (but undesirable) 
HTTP response codes.

<li> Fetched column may be UTC.  Now is currently <b>${IsNow}</b>.

</ul>
HTML
