#!/usr/local/bin/perl

# Commport:/htdocs/cp/c_image.cgi
#
# Lets you set up an image for a channel.


# The contents of this file are subject to the CommPort Public License 
# Version 1.00 (the "License"); you may not use this file except in
# compliance with the License. You may obtain a copy of the License at  
# (URL:http://www.tc.ca/commport/license.html).
#
# Software distributed under the License is distributed on an "AS IS" 
# basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
# the License for the specific language governing rights and limitations 
# under the License.  
#
# The Original Code is ${CPHOME}/htdocs/cp/c_image.cgi
#
# The Initial Developer of the Original Code is Telecommunities
# Canada, Inc.  Portions created by Telecommunities Canada, Inc. are
# Copyright (C) 1999-2000 by Telecommunities Canada, Inc.
# All Rights Reserved.
#
# Modifications or contributions of Larger Works should be sent to
# (mailto:commport@tc.ca) for consideration towards inclusion 
# into the root public codebase.
# 
# Contributor(s): Chris Halsall, Ian White, 
#                 Gary and Mae Shearman.
#                 Industry Canada's Community Access Program.


# Changelog:
#
# 1999.09.20 - CH  - Created this file.


use CGI;
use DBI;

require "../../common/common.pl";
require "../../common/images.pl";

$Query = new CGI;

$Method = $ENV{'REQUEST_METHOD'};
$PathInfo = $ENV{'PATH_INFO'};
$QueryString = $ENV{'QUERY_STRING'};
$User = $ENV{'REMOTE_USER'};

&GetUserInfo;

if ($Method eq "POST") {
   $ID = $Query->param("ID");
   $Image = $Query->param("Image");

   if ($ID > 0) {
   $TooBig = 0;
   $TotalSize = 0;
   $TFile = "${UIMG_PATH}/tmp_${$}.img";

#print STDERR "TFile: $TFile\n";

   open(OUT,">${TFile}");

   while($bytesread = read($Image,$buffer,1024)){
#	print STDERR "Writing $bytesread bytes.\n";
      print OUT $buffer || die "can't write file $!";
      $TotalSize += $bytesread;

      if ($TotalSize > 20000) {
         $To0Big = 1;
      }
  }
  close(OUT);

  $W_Limit = 100; $H_Limit=40;

  if ($TotalSize > 0) {
     if ($TooBig) {
        $ErrStr = "Image File too big.";
     } else {

        ($IT,$W,$H) = ImageTypeAndSize(${TFile});

#print STDERR "$IT ($W x $H)\n";

        if ($IT eq "") {
           $ErrStr = "Image type not known.";
        } elsif ($W > $W_Limit || $H > $H_Limit) {
        } else {
           rename($TFile,"${UIMG_PATH}/${ID}.${IT}");

           &DoUpdate($W,$H,$IT);
           print $Query->redirect("http://${CP_RootURL}${CP_URLPath}/c_view.cgi?${ID}");
     exit;

        }
     }
  } else {
     $ErrStr = "Error writing file.";
  }
  } else {
     $ErrStr = "ID == 0!";
  }
} else {
   $ID = $QueryString;
   &DoSelect;
}

print $Query->header;
&RenderHeader("$QueryString",0);

#print "<h1>Cat == ${Cat}</h1>";

if ($ID > 0) {
$Sub_Button = "Upload Image";
}

print <<HTML;
<form method="post" action="${CP_URLPath}/c_image.cgi" ENCTYPE="multipart/form-data">
<table border=0 width="100%" bgcolor="#FFE0E0" cellspacing=0>
<tr><td bgcolor="#EEEEFF">
<table border=0 width="100%">
HTML

if ($ErrStr ne "") {
print "<tr><th align=\"right\" valign=\"top\" width=\"10%\">"
."<font color=\"red\">Error:</font></th>"
."<th align=\"left\"><font color=\"red\">${ErrStr}</font></th></tr>";
}

print <<HTML;
<tr><th align="right">Channel Name</th>
<td>${Name}
</td></tr>
HTML

if ($Img_Src ne "" || $Img_Local ne "") {
if ($Img_Local ne "") {
print <<HTML;
<tr><th align="right">Current Image</th>
<td><img src="${Img_Local}" width=${Img_W} height=${Img_H}>
HTML

if ($Img_Mode == 2) { print "(Uploaded Image)"; };
if ($Img_Mode >= 3) { print "(Locally Cached)"; };

print "</td></tr>";

} else {
print <<HTML;
<tr><th align="right">Current Image</th>
<td><img src="${Img_Src}" width=${Img_W} height=${Img_H}> (Remote)
</td></tr>
HTML
}
}

if ($Img_Mode == 2) {
print <<HTML;
<tr><th align="right">Remove</th>
<td><input type="checkbox" name="Remove" value="${ID}"> Uploaded Image.
</td></tr>
HTML

}

print <<HTML;
<tr><th align="right">Image</th>
<td><input type="file" name="Image" value="${URL}" size=40 maxlength=100>
<input type="hidden" name="ID" value="${ID}">
</td></tr>

<tr><th></th>
<td><input type="submit" value="${Sub_Button}">

</table>
</td>
</tr>

</table>
</form>
HTML


sub DoUpdate {
   local ($W,$H,$IT) = @_;
   local ($cmd,$sth);

   &OpenDB;

   $cmd = "update Channel SET"
." Img_Mode=2"
.",Img_W=\"${W}\""
.",Img_H=\"${H}\""
.",Img_Local=\"${CP_UIMGPath}/${ID}.${IT}\""
." where ID=${ID}";

print STDERR "$cmd\n";

   $sth = $dbh->do($cmd) || &DumpError($sth->errstr);

   return 0;
}

sub DoDelete {
   local ($cmd,$sth);

   &OpenDB;

   $cmd = "delete from Item"
." where ID_Channel=${ID}";
#   $sth = $dbh->do($cmd) || &DumpError($sth->errstr);

   $cmd = "delete from Product"
." where ID=${ID}";
   $sth = $dbh->do($cmd) || &DumpError($sth->errstr);

   return 0;
}

sub DoSelect {
   local ($cmd);
   local (@rec);

   if ($ID eq "") {
      return 0
   }
   $cmd = "select Name,Descript,Img_Src,Img_Mode,Img_W,Img_H"
.",Img_Cache,Img_Local,Img_Cached"
." from Channel"
." where ID=${ID}"
;

   $sth = $dbh->prepare($cmd);
   $rv = $sth->execute or die "can't execute the query: $sth->errstr\n";
   @rec = $sth->fetchrow_array;
   $sth->finish;

   $Name = $rec[0];
   $Descript = $rec[1];
   $Img_Src = $rec[2];
   $Img_Mode = $rec[3];
   $Img_W = $rec[4];
   $Img_H = $rec[5];
   $Img_Cache = $rec[6];
   $Img_Local = $rec[7];
   $Img_Cached = $rec[8];

   return 0;
}

